/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.io.orc.BitFieldReader;
import org.apache.hadoop.hive.ql.io.orc.BooleanColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.DateColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DecimalColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DirectDecompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.DoubleColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DynamicByteArray;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.IntegerColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.IntegerReader;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthByteReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerReaderV2;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;
import org.apache.hadoop.hive.ql.io.orc.StreamName;
import org.apache.hadoop.hive.ql.io.orc.StringColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.TimestampColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.spark_project.guava.collect.ComparisonChain;

class RecordReaderImpl
implements RecordReader {
    private static final Log LOG = LogFactory.getLog(RecordReaderImpl.class);
    private static final boolean isLogTraceEnabled = LOG.isTraceEnabled();
    private final FSDataInputStream file;
    private final long firstRow;
    private final List<StripeInformation> stripes = new ArrayList<StripeInformation>();
    private OrcProto.StripeFooter stripeFooter;
    private final long totalRowCount;
    private final CompressionCodec codec;
    private final List<OrcProto.Type> types;
    private final int bufferSize;
    private final boolean[] included;
    private final long rowIndexStride;
    private long rowInStripe = 0L;
    private int currentStripe = -1;
    private long rowBaseInStripe = 0L;
    private long rowCountInStripe = 0L;
    private final Map<StreamName, InStream> streams = new HashMap<StreamName, InStream>();
    List<BufferChunk> bufferChunks = new ArrayList<BufferChunk>(0);
    private final TreeReader reader;
    private final OrcProto.RowIndex[] indexes;
    private final SearchArgument sarg;
    private final List<PredicateLeaf> sargLeaves;
    private final int[] filterColumns;
    private boolean[] includedRowGroups = null;
    private final Configuration conf;
    private final ByteBufferAllocatorPool pool = new ByteBufferAllocatorPool();
    private final HadoopShims.ZeroCopyReaderShim zcr;
    private static final int BYTE_STREAM_POSITIONS = 1;
    private static final int RUN_LENGTH_BYTE_POSITIONS = 2;
    private static final int BITFIELD_POSITIONS = 3;
    private static final int RUN_LENGTH_INT_POSITIONS = 2;
    static final int WORST_UNCOMPRESSED_SLOP = 4098;

    static int findColumns(String[] columnNames, String columnName, int rootColumn) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnName.equals(columnNames[i])) continue;
            return i + rootColumn;
        }
        return -1;
    }

    static int[] mapSargColumns(List<PredicateLeaf> sargLeaves, String[] columnNames, int rootColumn) {
        int[] result = new int[sargLeaves.size()];
        Arrays.fill(result, -1);
        for (int i = 0; i < result.length; ++i) {
            String colName = sargLeaves.get(i).getColumnName();
            result[i] = RecordReaderImpl.findColumns(columnNames, colName, rootColumn);
        }
        return result;
    }

    RecordReaderImpl(List<StripeInformation> stripes, FileSystem fileSystem, Path path, Reader.Options options, List<OrcProto.Type> types, CompressionCodec codec, int bufferSize, long strideRate, Configuration conf) throws IOException {
        this.file = fileSystem.open(path);
        this.codec = codec;
        this.types = types;
        this.bufferSize = bufferSize;
        this.included = options.getInclude();
        this.conf = conf;
        this.sarg = options.getSearchArgument();
        if (this.sarg != null) {
            this.sargLeaves = this.sarg.getLeaves();
            this.filterColumns = RecordReaderImpl.mapSargColumns(this.sargLeaves, options.getColumnNames(), 0);
        } else {
            this.sargLeaves = null;
            this.filterColumns = null;
        }
        long rows = 0L;
        long skippedRows = 0L;
        long offset = options.getOffset();
        long maxOffset = options.getMaxOffset();
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                skippedRows += stripe.getNumberOfRows();
                continue;
            }
            if (stripeStart >= maxOffset) continue;
            this.stripes.add(stripe);
            rows += stripe.getNumberOfRows();
        }
        boolean zeroCopy = conf != null && HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ORC_ZEROCOPY);
        this.zcr = zeroCopy && (codec == null || codec instanceof DirectDecompressionCodec && ((DirectDecompressionCodec)codec).isAvailable()) ? ShimLoader.getHadoopShims().getZeroCopyReader(this.file, (HadoopShims.ByteBufferPoolShim)this.pool) : null;
        this.firstRow = skippedRows;
        this.totalRowCount = rows;
        this.reader = RecordReaderImpl.createTreeReader(path, 0, types, this.included, conf);
        this.indexes = new OrcProto.RowIndex[types.size()];
        this.rowIndexStride = strideRate;
        this.advanceToNextRow(0L);
    }

    private static TreeReader createTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included, Configuration conf) throws IOException {
        OrcProto.Type type = types.get(columnId);
        switch (type.getKind()) {
            case BOOLEAN: {
                return new BooleanTreeReader(path, columnId, conf);
            }
            case BYTE: {
                return new ByteTreeReader(path, columnId, conf);
            }
            case DOUBLE: {
                return new DoubleTreeReader(path, columnId, conf);
            }
            case FLOAT: {
                return new FloatTreeReader(path, columnId, conf);
            }
            case SHORT: {
                return new ShortTreeReader(path, columnId, conf);
            }
            case INT: {
                return new IntTreeReader(path, columnId, conf);
            }
            case LONG: {
                return new LongTreeReader(path, columnId, conf);
            }
            case STRING: {
                return new StringTreeReader(path, columnId, conf);
            }
            case CHAR: {
                if (!type.hasMaximumLength()) {
                    throw new IllegalArgumentException("ORC char type has no length specified");
                }
                return new CharTreeReader(path, columnId, type.getMaximumLength(), conf);
            }
            case VARCHAR: {
                if (!type.hasMaximumLength()) {
                    throw new IllegalArgumentException("ORC varchar type has no length specified");
                }
                return new VarcharTreeReader(path, columnId, type.getMaximumLength(), conf);
            }
            case BINARY: {
                return new BinaryTreeReader(path, columnId, conf);
            }
            case TIMESTAMP: {
                return new TimestampTreeReader(path, columnId, conf);
            }
            case DATE: {
                return new DateTreeReader(path, columnId, conf);
            }
            case DECIMAL: {
                int precision = type.hasPrecision() ? type.getPrecision() : 38;
                int scale = type.hasScale() ? type.getScale() : 18;
                return new DecimalTreeReader(path, columnId, precision, scale, conf);
            }
            case STRUCT: {
                return new StructTreeReader(path, columnId, types, included, conf);
            }
            case LIST: {
                return new ListTreeReader(path, columnId, types, included, conf);
            }
            case MAP: {
                return new MapTreeReader(path, columnId, types, included, conf);
            }
            case UNION: {
                return new UnionTreeReader(path, columnId, types, included, conf);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type.getKind()));
    }

    OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
        long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
        int tailLength = (int)stripe.getFooterLength();
        ByteBuffer tailBuf = ByteBuffer.allocate(tailLength);
        this.file.seek(offset);
        this.file.readFully(tailBuf.array(), tailBuf.arrayOffset(), tailLength);
        return OrcProto.StripeFooter.parseFrom(InStream.create("footer", new ByteBuffer[]{tailBuf}, new long[]{0L}, tailLength, this.codec, this.bufferSize));
    }

    static <T> Location compareToRange(Comparable<T> point, T min, T max) {
        int minCompare = point.compareTo(min);
        if (minCompare < 0) {
            return Location.BEFORE;
        }
        if (minCompare == 0) {
            return Location.MIN;
        }
        int maxCompare = point.compareTo(max);
        if (maxCompare > 0) {
            return Location.AFTER;
        }
        if (maxCompare == 0) {
            return Location.MAX;
        }
        return Location.MIDDLE;
    }

    static Object getMax(ColumnStatistics index) {
        if (index instanceof IntegerColumnStatistics) {
            return ((IntegerColumnStatistics)index).getMaximum();
        }
        if (index instanceof DoubleColumnStatistics) {
            return ((DoubleColumnStatistics)index).getMaximum();
        }
        if (index instanceof StringColumnStatistics) {
            return ((StringColumnStatistics)index).getMaximum();
        }
        if (index instanceof DateColumnStatistics) {
            return ((DateColumnStatistics)index).getMaximum();
        }
        if (index instanceof DecimalColumnStatistics) {
            return ((DecimalColumnStatistics)index).getMaximum();
        }
        if (index instanceof TimestampColumnStatistics) {
            return ((TimestampColumnStatistics)index).getMaximum();
        }
        if (index instanceof BooleanColumnStatistics) {
            if (((BooleanColumnStatistics)index).getTrueCount() != 0L) {
                return "true";
            }
            return "false";
        }
        return null;
    }

    static Object getMin(ColumnStatistics index) {
        if (index instanceof IntegerColumnStatistics) {
            return ((IntegerColumnStatistics)index).getMinimum();
        }
        if (index instanceof DoubleColumnStatistics) {
            return ((DoubleColumnStatistics)index).getMinimum();
        }
        if (index instanceof StringColumnStatistics) {
            return ((StringColumnStatistics)index).getMinimum();
        }
        if (index instanceof DateColumnStatistics) {
            return ((DateColumnStatistics)index).getMinimum();
        }
        if (index instanceof DecimalColumnStatistics) {
            return ((DecimalColumnStatistics)index).getMinimum();
        }
        if (index instanceof TimestampColumnStatistics) {
            return ((TimestampColumnStatistics)index).getMinimum();
        }
        if (index instanceof BooleanColumnStatistics) {
            if (((BooleanColumnStatistics)index).getFalseCount() != 0L) {
                return "false";
            }
            return "true";
        }
        return null;
    }

    static SearchArgument.TruthValue evaluatePredicate(OrcProto.ColumnStatistics statsProto, PredicateLeaf predicate) {
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize(statsProto);
        Object minValue = RecordReaderImpl.getMin(cs);
        Object maxValue = RecordReaderImpl.getMax(cs);
        return RecordReaderImpl.evaluatePredicateRange(predicate, minValue, maxValue, cs.hasNull());
    }

    static SearchArgument.TruthValue evaluatePredicate(ColumnStatistics stats, PredicateLeaf predicate) {
        Object minValue = RecordReaderImpl.getMin(stats);
        Object maxValue = RecordReaderImpl.getMax(stats);
        return RecordReaderImpl.evaluatePredicateRange(predicate, minValue, maxValue, stats.hasNull());
    }

    static SearchArgument.TruthValue evaluatePredicateRange(PredicateLeaf predicate, Object min, Object max, boolean hasNull) {
        if (min == null) {
            if (predicate.getOperator() == PredicateLeaf.Operator.IS_NULL) {
                return SearchArgument.TruthValue.YES;
            }
            return SearchArgument.TruthValue.NULL;
        }
        try {
            Object baseObj = predicate.getLiteral(PredicateLeaf.FileFormat.ORC);
            Object minValue = RecordReaderImpl.getConvertedStatsObj(min, baseObj);
            Object maxValue = RecordReaderImpl.getConvertedStatsObj(max, baseObj);
            Object predObj = RecordReaderImpl.getBaseObjectForComparison(baseObj, minValue);
            switch (predicate.getOperator()) {
                case NULL_SAFE_EQUALS: {
                    Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                    if (loc == Location.BEFORE || loc == Location.AFTER) {
                        return SearchArgument.TruthValue.NO;
                    }
                    return SearchArgument.TruthValue.YES_NO;
                }
                case EQUALS: {
                    Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                    if (minValue.equals(maxValue) && loc == Location.MIN) {
                        return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                    }
                    if (loc == Location.BEFORE || loc == Location.AFTER) {
                        return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                    }
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                case LESS_THAN: {
                    Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                    if (loc == Location.AFTER) {
                        return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                    }
                    if (loc == Location.BEFORE || loc == Location.MIN) {
                        return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                    }
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                case LESS_THAN_EQUALS: {
                    Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                    if (loc == Location.AFTER || loc == Location.MAX) {
                        return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                    }
                    if (loc == Location.BEFORE) {
                        return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                    }
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                case IN: {
                    if (minValue.equals(maxValue)) {
                        for (Object arg : predicate.getLiteralList(PredicateLeaf.FileFormat.ORC)) {
                            predObj = RecordReaderImpl.getBaseObjectForComparison(arg, minValue);
                            Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                            if (loc != Location.MIN) continue;
                            return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                        }
                        return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                    }
                    for (Object arg : predicate.getLiteralList(PredicateLeaf.FileFormat.ORC)) {
                        predObj = RecordReaderImpl.getBaseObjectForComparison(arg, minValue);
                        Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                        if (loc != Location.MIN && loc != Location.MIDDLE && loc != Location.MAX) continue;
                        return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                    }
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                case BETWEEN: {
                    List args = predicate.getLiteralList(PredicateLeaf.FileFormat.ORC);
                    Object predObj1 = RecordReaderImpl.getBaseObjectForComparison(args.get(0), minValue);
                    Location loc = RecordReaderImpl.compareToRange((Comparable)predObj1, minValue, maxValue);
                    if (loc == Location.BEFORE || loc == Location.MIN) {
                        Object predObj2 = RecordReaderImpl.getBaseObjectForComparison(args.get(1), minValue);
                        Location loc2 = RecordReaderImpl.compareToRange((Comparable)predObj2, minValue, maxValue);
                        if (loc2 == Location.AFTER || loc2 == Location.MAX) {
                            return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                        }
                        if (loc2 == Location.BEFORE) {
                            return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                        }
                        return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                    }
                    if (loc == Location.AFTER) {
                        return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                    }
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                case IS_NULL: {
                    return hasNull ? SearchArgument.TruthValue.YES_NO : SearchArgument.TruthValue.NO;
                }
            }
            return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
        }
        catch (NumberFormatException nfe) {
            return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
        }
    }

    private static Object getBaseObjectForComparison(Object predObj, Object statsObj) {
        if (predObj != null) {
            if (predObj instanceof ExprNodeConstantDesc) {
                predObj = ((ExprNodeConstantDesc)predObj).getValue();
            }
            if (statsObj instanceof Long) {
                if (predObj instanceof Double) {
                    return ((Double)predObj).longValue();
                }
                if (predObj instanceof HiveDecimal) {
                    return ((HiveDecimal)predObj).longValue();
                }
                if (predObj instanceof String) {
                    return Long.valueOf(predObj.toString());
                }
            } else if (statsObj instanceof Double) {
                if (predObj instanceof Long) {
                    return ((Long)predObj).doubleValue();
                }
                if (predObj instanceof HiveDecimal) {
                    return ((HiveDecimal)predObj).doubleValue();
                }
                if (predObj instanceof String) {
                    return Double.valueOf(predObj.toString());
                }
            } else {
                if (statsObj instanceof String) {
                    return predObj.toString();
                }
                if (statsObj instanceof HiveDecimal) {
                    if (predObj instanceof Long) {
                        return HiveDecimal.create((Long)predObj);
                    }
                    if (predObj instanceof Double) {
                        return HiveDecimal.create(predObj.toString());
                    }
                    if (predObj instanceof String) {
                        return HiveDecimal.create(predObj.toString());
                    }
                    if (predObj instanceof BigDecimal) {
                        return HiveDecimal.create((BigDecimal)predObj);
                    }
                }
            }
        }
        return predObj;
    }

    private static Object getConvertedStatsObj(Object statsObj, Object predObj) {
        if (predObj instanceof DateWritable && !(statsObj instanceof DateWritable) || statsObj instanceof DateWritable && !(predObj instanceof DateWritable)) {
            return StringUtils.stripEnd((String)statsObj.toString(), null);
        }
        if (statsObj instanceof String) {
            return StringUtils.stripEnd((String)statsObj.toString(), null);
        }
        return statsObj;
    }

    private boolean[] pickRowGroups() throws IOException {
        if (this.sarg == null || this.rowIndexStride == 0L) {
            return null;
        }
        this.readRowIndex(this.currentStripe);
        long rowsInStripe = this.stripes.get(this.currentStripe).getNumberOfRows();
        int groupsInStripe = (int)((rowsInStripe + this.rowIndexStride - 1L) / this.rowIndexStride);
        boolean[] result = new boolean[groupsInStripe];
        SearchArgument.TruthValue[] leafValues = new SearchArgument.TruthValue[this.sargLeaves.size()];
        for (int rowGroup = 0; rowGroup < result.length; ++rowGroup) {
            for (int pred = 0; pred < leafValues.length; ++pred) {
                if (this.filterColumns[pred] != -1) {
                    OrcProto.ColumnStatistics stats = this.indexes[this.filterColumns[pred]].getEntry(rowGroup).getStatistics();
                    leafValues[pred] = RecordReaderImpl.evaluatePredicate(stats, this.sargLeaves.get(pred));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Stats = " + stats));
                    LOG.debug((Object)("Setting " + this.sargLeaves.get(pred) + " to " + leafValues[pred]));
                    continue;
                }
                leafValues[pred] = SearchArgument.TruthValue.YES_NO_NULL;
            }
            result[rowGroup] = this.sarg.evaluate(leafValues).isNeeded();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Row group " + this.rowIndexStride * (long)rowGroup + " to " + (this.rowIndexStride * (long)(rowGroup + 1) - 1L) + " is " + (result[rowGroup] ? "" : "not ") + "included."));
        }
        for (boolean b : result) {
            if (b) continue;
            return result;
        }
        return null;
    }

    private void clearStreams() throws IOException {
        for (InStream is : this.streams.values()) {
            is.close();
        }
        if (this.bufferChunks != null) {
            if (this.zcr != null) {
                for (BufferChunk bufChunk : this.bufferChunks) {
                    this.zcr.releaseBuffer(bufChunk.chunk);
                }
            }
            this.bufferChunks.clear();
        }
        this.streams.clear();
    }

    private void readStripe() throws IOException {
        int i;
        StripeInformation stripe = this.stripes.get(this.currentStripe);
        this.stripeFooter = this.readStripeFooter(stripe);
        this.clearStreams();
        this.rowCountInStripe = stripe.getNumberOfRows();
        this.rowInStripe = 0L;
        this.rowBaseInStripe = 0L;
        for (i = 0; i < this.currentStripe; ++i) {
            this.rowBaseInStripe += this.stripes.get(i).getNumberOfRows();
        }
        for (i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = null;
        }
        this.includedRowGroups = this.pickRowGroups();
        if (this.includedRowGroups != null) {
            while (this.rowInStripe < this.rowCountInStripe && !this.includedRowGroups[(int)(this.rowInStripe / this.rowIndexStride)]) {
                this.rowInStripe = Math.min(this.rowCountInStripe, this.rowInStripe + this.rowIndexStride);
            }
        }
        if (this.rowInStripe < this.rowCountInStripe) {
            if (this.included == null && this.includedRowGroups == null) {
                this.readAllDataStreams(stripe);
            } else {
                this.readPartialDataStreams(stripe);
            }
            this.reader.startStripe(this.streams, this.stripeFooter.getColumnsList());
            if (this.rowInStripe != 0L) {
                this.seekToRowEntry((int)(this.rowInStripe / this.rowIndexStride));
            }
        }
    }

    private void readAllDataStreams(StripeInformation stripe) throws IOException {
        long start = stripe.getIndexLength();
        long end = start + stripe.getDataLength();
        DiskRange[] ranges = new DiskRange[]{new DiskRange(start, end)};
        this.bufferChunks = this.readDiskRanges(this.file, stripe.getOffset(), Arrays.asList(ranges));
        List<OrcProto.Stream> streamDescriptions = this.stripeFooter.getStreamsList();
        RecordReaderImpl.createStreams(streamDescriptions, this.bufferChunks, null, this.codec, this.bufferSize, this.streams);
    }

    static int getIndexPosition(OrcProto.ColumnEncoding.Kind encoding, OrcProto.Type.Kind type, OrcProto.Stream.Kind stream, boolean isCompressed, boolean hasNulls) {
        if (stream == OrcProto.Stream.Kind.PRESENT) {
            return 0;
        }
        int compressionValue = isCompressed ? 1 : 0;
        int base = hasNulls ? 3 + compressionValue : 0;
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case DOUBLE: 
            case FLOAT: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: 
            case STRUCT: 
            case LIST: 
            case MAP: 
            case UNION: {
                return base;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (encoding == OrcProto.ColumnEncoding.Kind.DICTIONARY || encoding == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                    return base;
                }
                if (stream == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case BINARY: {
                if (stream == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case DECIMAL: {
                if (stream == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case TIMESTAMP: {
                if (stream == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 2 + compressionValue;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    static boolean isDictionary(OrcProto.Stream.Kind kind, OrcProto.ColumnEncoding encoding) {
        OrcProto.ColumnEncoding.Kind encodingKind = encoding.getKind();
        return kind == OrcProto.Stream.Kind.DICTIONARY_DATA || kind == OrcProto.Stream.Kind.LENGTH && (encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY || encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2);
    }

    static List<DiskRange> planReadPartialDataStreams(List<OrcProto.Stream> streamList, OrcProto.RowIndex[] indexes, boolean[] includedColumns, boolean[] includedRowGroups, boolean isCompressed, List<OrcProto.ColumnEncoding> encodings, List<OrcProto.Type> types, int compressionSize) {
        ArrayList<DiskRange> result = new ArrayList<DiskRange>();
        long offset = 0L;
        boolean[] hasNull = new boolean[types.size()];
        for (OrcProto.Stream stream : streamList) {
            if (!stream.hasKind() || stream.getKind() != OrcProto.Stream.Kind.PRESENT) continue;
            hasNull[stream.getColumn()] = true;
        }
        for (OrcProto.Stream stream : streamList) {
            long length = stream.getLength();
            int column = stream.getColumn();
            OrcProto.Stream.Kind streamKind = stream.getKind();
            if (stream.hasKind() && StreamName.getArea(streamKind) == StreamName.Area.DATA && includedColumns[column]) {
                if (includedRowGroups == null || RecordReaderImpl.isDictionary(streamKind, encodings.get(column))) {
                    result.add(new DiskRange(offset, offset + length));
                } else {
                    for (int group = 0; group < includedRowGroups.length; ++group) {
                        if (!includedRowGroups[group]) continue;
                        int posn = RecordReaderImpl.getIndexPosition(encodings.get(column).getKind(), types.get(column).getKind(), stream.getKind(), isCompressed, hasNull[column]);
                        long start = indexes[column].getEntry(group).getPositions(posn);
                        long nextGroupOffset = group < includedRowGroups.length - 1 ? indexes[column].getEntry(group + 1).getPositions(posn) : length;
                        long slop = isCompressed ? (long)(2 * (3 + compressionSize)) : 4098L;
                        long end = group == includedRowGroups.length - 1 ? length : Math.min(length, nextGroupOffset + slop);
                        result.add(new DiskRange(offset + start, offset + end));
                    }
                }
            }
            offset += length;
        }
        return result;
    }

    static void mergeDiskRanges(List<DiskRange> ranges) {
        DiskRange prev = null;
        for (int i = 0; i < ranges.size(); ++i) {
            DiskRange current = ranges.get(i);
            if (prev != null && RecordReaderImpl.overlap(prev.offset, prev.end, current.offset, current.end)) {
                prev.offset = Math.min(prev.offset, current.offset);
                prev.end = Math.max(prev.end, current.end);
                ranges.remove(i);
                --i;
                continue;
            }
            prev = current;
        }
    }

    List<BufferChunk> readDiskRanges(FSDataInputStream file, long base, List<DiskRange> ranges) throws IOException {
        ArrayList<BufferChunk> result = new ArrayList<BufferChunk>(ranges.size());
        for (DiskRange range : ranges) {
            int len = (int)(range.end - range.offset);
            long off = range.offset;
            file.seek(base + off);
            if (this.zcr != null) {
                while (len > 0) {
                    ByteBuffer partial = this.zcr.readBuffer(len, false);
                    result.add(new BufferChunk(partial, off));
                    int read = partial.remaining();
                    len -= read;
                    off += (long)read;
                }
                continue;
            }
            byte[] buffer = new byte[len];
            file.readFully(buffer, 0, buffer.length);
            result.add(new BufferChunk(ByteBuffer.wrap(buffer), range.offset));
        }
        return result;
    }

    static boolean overlap(long leftA, long rightA, long leftB, long rightB) {
        if (leftA <= leftB) {
            return rightA >= leftB;
        }
        return rightB >= leftA;
    }

    static String stringifyDiskRanges(List<DiskRange> ranges) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < ranges.size(); ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(ranges.get(i).toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    static void createStreams(List<OrcProto.Stream> streamDescriptions, List<BufferChunk> ranges, boolean[] includeColumn, CompressionCodec codec, int bufferSize, Map<StreamName, InStream> streams) throws IOException {
        long offset = 0L;
        for (OrcProto.Stream streamDesc : streamDescriptions) {
            int column = streamDesc.getColumn();
            if ((includeColumn == null || includeColumn[column]) && streamDesc.hasKind() && StreamName.getArea(streamDesc.getKind()) == StreamName.Area.DATA) {
                long length = streamDesc.getLength();
                int first = -1;
                int last = -2;
                for (int i = 0; i < ranges.size(); ++i) {
                    BufferChunk range = ranges.get(i);
                    if (!RecordReaderImpl.overlap(offset, offset + length, range.offset, range.end)) continue;
                    if (first == -1) {
                        first = i;
                    }
                    last = i;
                }
                ByteBuffer[] buffers = new ByteBuffer[last - first + 1];
                long[] offsets = new long[last - first + 1];
                for (int i = 0; i < buffers.length; ++i) {
                    BufferChunk range = ranges.get(i + first);
                    long start = Math.max(range.offset, offset);
                    long end = Math.min(range.end, offset + length);
                    buffers[i] = range.chunk.slice();
                    assert (range.chunk.position() == 0);
                    if (offset > range.offset) {
                        buffers[i].position((int)(offset - range.offset));
                        buffers[i].limit((int)(end - range.offset));
                        offsets[i] = 0L;
                        continue;
                    }
                    buffers[i].position(0);
                    buffers[i].limit((int)(end - range.offset));
                    offsets[i] = range.offset - offset;
                }
                StreamName name = new StreamName(column, streamDesc.getKind());
                streams.put(name, InStream.create(name.toString(), buffers, offsets, length, codec, bufferSize));
            }
            offset += streamDesc.getLength();
        }
    }

    private void readPartialDataStreams(StripeInformation stripe) throws IOException {
        List<OrcProto.Stream> streamList = this.stripeFooter.getStreamsList();
        List<DiskRange> chunks = RecordReaderImpl.planReadPartialDataStreams(streamList, this.indexes, this.included, this.includedRowGroups, this.codec != null, this.stripeFooter.getColumnsList(), this.types, this.bufferSize);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("chunks = " + RecordReaderImpl.stringifyDiskRanges(chunks)));
        }
        RecordReaderImpl.mergeDiskRanges(chunks);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("merge = " + RecordReaderImpl.stringifyDiskRanges(chunks)));
        }
        this.bufferChunks = this.readDiskRanges(this.file, stripe.getOffset(), chunks);
        RecordReaderImpl.createStreams(streamList, this.bufferChunks, this.included, this.codec, this.bufferSize, this.streams);
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.rowInStripe < this.rowCountInStripe;
    }

    private void advanceStripe() throws IOException {
        this.rowInStripe = this.rowCountInStripe;
        while (this.rowInStripe >= this.rowCountInStripe && this.currentStripe < this.stripes.size() - 1) {
            ++this.currentStripe;
            this.readStripe();
        }
    }

    private void advanceToNextRow(long nextRow) throws IOException {
        int rowGroup;
        long nextRowInStripe = nextRow - this.rowBaseInStripe;
        if (this.rowIndexStride != 0L && this.includedRowGroups != null && nextRowInStripe < this.rowCountInStripe && !this.includedRowGroups[rowGroup = (int)(nextRowInStripe / this.rowIndexStride)]) {
            while (rowGroup < this.includedRowGroups.length && !this.includedRowGroups[rowGroup]) {
                ++rowGroup;
            }
            if (rowGroup >= this.includedRowGroups.length) {
                this.advanceStripe();
                return;
            }
            nextRowInStripe = Math.min(this.rowCountInStripe, (long)rowGroup * this.rowIndexStride);
        }
        if (nextRowInStripe < this.rowCountInStripe) {
            if (nextRowInStripe != this.rowInStripe) {
                if (this.rowIndexStride != 0L) {
                    rowGroup = (int)(nextRowInStripe / this.rowIndexStride);
                    this.seekToRowEntry(rowGroup);
                    this.reader.skipRows(nextRowInStripe - (long)rowGroup * this.rowIndexStride);
                } else {
                    this.reader.skipRows(nextRowInStripe - this.rowInStripe);
                }
                this.rowInStripe = nextRowInStripe;
            }
        } else {
            this.advanceStripe();
        }
    }

    @Override
    public Object next(Object previous) throws IOException {
        Object result = this.reader.next(previous);
        ++this.rowInStripe;
        this.advanceToNextRow(this.rowInStripe + this.rowBaseInStripe);
        if (isLogTraceEnabled) {
            LOG.trace((Object)("row from " + this.reader.path));
            LOG.trace((Object)("orc row = " + result));
        }
        return result;
    }

    @Override
    public VectorizedRowBatch nextBatch(VectorizedRowBatch previous) throws IOException {
        VectorizedRowBatch result = null;
        if (this.rowInStripe >= this.rowCountInStripe) {
            ++this.currentStripe;
            this.readStripe();
        }
        long batchSize = 0L;
        if (this.rowIndexStride != 0L && this.includedRowGroups != null && this.rowInStripe < this.rowCountInStripe) {
            int endRowGroup;
            int startRowGroup = (int)(this.rowInStripe / this.rowIndexStride);
            if (!this.includedRowGroups[startRowGroup]) {
                while (startRowGroup < this.includedRowGroups.length && !this.includedRowGroups[startRowGroup]) {
                    ++startRowGroup;
                }
            }
            for (endRowGroup = startRowGroup; endRowGroup < this.includedRowGroups.length && this.includedRowGroups[endRowGroup]; ++endRowGroup) {
            }
            long markerPosition = (long)endRowGroup * this.rowIndexStride < this.rowCountInStripe ? (long)endRowGroup * this.rowIndexStride : this.rowCountInStripe;
            batchSize = Math.min(1024L, markerPosition - this.rowInStripe);
            if (LOG.isDebugEnabled() && batchSize < 1024L) {
                LOG.debug((Object)("markerPosition: " + markerPosition + " batchSize: " + batchSize));
            }
        } else {
            batchSize = Math.min(1024L, this.rowCountInStripe - this.rowInStripe);
        }
        this.rowInStripe += batchSize;
        if (previous == null) {
            ColumnVector[] cols = (ColumnVector[])this.reader.nextVector(null, (int)batchSize);
            result = new VectorizedRowBatch(cols.length);
            result.cols = cols;
        } else {
            result = previous;
            result.selectedInUse = false;
            this.reader.nextVector(result.cols, (int)batchSize);
        }
        result.size = (int)batchSize;
        this.advanceToNextRow(this.rowInStripe + this.rowBaseInStripe);
        return result;
    }

    @Override
    public void close() throws IOException {
        this.clearStreams();
        this.pool.clear();
        this.file.close();
    }

    @Override
    public long getRowNumber() {
        return this.rowInStripe + this.rowBaseInStripe + this.firstRow;
    }

    @Override
    public float getProgress() {
        return ((float)this.rowBaseInStripe + (float)this.rowInStripe) / (float)this.totalRowCount;
    }

    private int findStripe(long rowNumber) {
        for (int i = 0; i < this.stripes.size(); ++i) {
            StripeInformation stripe = this.stripes.get(i);
            if (stripe.getNumberOfRows() > rowNumber) {
                return i;
            }
            rowNumber -= stripe.getNumberOfRows();
        }
        throw new IllegalArgumentException("Seek after the end of reader range");
    }

    OrcProto.RowIndex[] readRowIndex(int stripeIndex) throws IOException {
        OrcProto.RowIndex[] indexes;
        OrcProto.StripeFooter stripeFooter;
        long offset = this.stripes.get(stripeIndex).getOffset();
        if (stripeIndex == this.currentStripe) {
            stripeFooter = this.stripeFooter;
            indexes = this.indexes;
        } else {
            stripeFooter = this.readStripeFooter(this.stripes.get(stripeIndex));
            indexes = new OrcProto.RowIndex[this.indexes.length];
        }
        for (OrcProto.Stream stream : stripeFooter.getStreamsList()) {
            if (stream.hasKind() && stream.getKind() == OrcProto.Stream.Kind.ROW_INDEX) {
                int col = stream.getColumn();
                if ((this.included == null || this.included[col]) && indexes[col] == null) {
                    byte[] buffer = new byte[(int)stream.getLength()];
                    this.file.seek(offset);
                    this.file.readFully(buffer);
                    indexes[col] = OrcProto.RowIndex.parseFrom(InStream.create("index", new ByteBuffer[]{ByteBuffer.wrap(buffer)}, new long[]{0L}, stream.getLength(), this.codec, this.bufferSize));
                }
            }
            offset += stream.getLength();
        }
        return indexes;
    }

    private void seekToRowEntry(int rowEntry) throws IOException {
        PositionProvider[] index = new PositionProvider[this.indexes.length];
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == null) continue;
            index[i] = new PositionProviderImpl(this.indexes[i].getEntry(rowEntry));
        }
        this.reader.seek(index);
    }

    @Override
    public void seekToRow(long rowNumber) throws IOException {
        if (rowNumber < 0L) {
            throw new IllegalArgumentException("Seek to a negative row number " + rowNumber);
        }
        if (rowNumber < this.firstRow) {
            throw new IllegalArgumentException("Seek before reader range " + rowNumber);
        }
        int rightStripe = this.findStripe(rowNumber -= this.firstRow);
        if (rightStripe != this.currentStripe) {
            this.currentStripe = rightStripe;
            this.readStripe();
        }
        this.readRowIndex(this.currentStripe);
        this.advanceToNextRow(rowNumber);
    }

    static class BufferChunk {
        final ByteBuffer chunk;
        final long offset;
        final long end;

        BufferChunk(ByteBuffer chunk, long offset) {
            this.offset = offset;
            this.chunk = chunk;
            this.end = offset + (long)chunk.remaining();
        }

        public final String toString() {
            return "range start: " + this.offset + " size: " + this.chunk.remaining() + " type: " + (this.chunk.isDirect() ? "direct" : "array-backed");
        }
    }

    static class DiskRange {
        long offset;
        long end;

        DiskRange(long offset, long end) {
            this.offset = offset;
            this.end = end;
            if (end < offset) {
                throw new IllegalArgumentException("invalid range " + this);
            }
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            DiskRange otherR = (DiskRange)other;
            return otherR.offset == this.offset && otherR.end == this.end;
        }

        public String toString() {
            return "range start: " + this.offset + " end: " + this.end;
        }
    }

    static enum Location {
        BEFORE,
        MIN,
        MIDDLE,
        MAX,
        AFTER;

    }

    private static class MapTreeReader
    extends TreeReader {
        private final TreeReader keyReader;
        private final TreeReader valueReader;
        private IntegerReader lengths = null;

        MapTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included, Configuration conf) throws IOException {
            super(path, columnId, conf);
            OrcProto.Type type = types.get(columnId);
            int keyColumn = type.getSubtypes(0);
            int valueColumn = type.getSubtypes(1);
            this.keyReader = included == null || included[keyColumn] ? RecordReaderImpl.createTreeReader(path, keyColumn, types, included, conf) : null;
            this.valueReader = included == null || included[valueColumn] ? RecordReaderImpl.createTreeReader(path, valueColumn, types, included, conf) : null;
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.keyReader.seek(index);
            this.valueReader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            LinkedHashMap<Object, Object> result = null;
            if (this.valuePresent) {
                result = previous == null ? new LinkedHashMap<Object, Object>() : (LinkedHashMap<Object, Object>)previous;
                result.clear();
                int length = (int)this.lengths.next();
                for (int i = 0; i < length; ++i) {
                    result.put(this.keyReader.next(null), this.valueReader.next(null));
                }
            }
            return result;
        }

        @Override
        Object nextVector(Object previous, long batchSize) throws IOException {
            throw new UnsupportedOperationException("NextVector is not supported operation for Map type");
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.lengths = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
            if (this.keyReader != null) {
                this.keyReader.startStripe(streams, encodings);
            }
            if (this.valueReader != null) {
                this.valueReader.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.keyReader.skipRows(childSkip);
            this.valueReader.skipRows(childSkip);
        }
    }

    private static class ListTreeReader
    extends TreeReader {
        private final TreeReader elementReader;
        private IntegerReader lengths = null;

        ListTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included, Configuration conf) throws IOException {
            super(path, columnId, conf);
            OrcProto.Type type = types.get(columnId);
            this.elementReader = RecordReaderImpl.createTreeReader(path, type.getSubtypes(0), types, included, conf);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.elementReader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ArrayList<Object> result = null;
            if (this.valuePresent) {
                int i;
                result = previous == null ? new ArrayList<Object>() : (ArrayList<Object>)previous;
                int prevLength = result.size();
                int length = (int)this.lengths.next();
                for (i = prevLength; i < length; ++i) {
                    result.add(null);
                }
                for (i = 0; i < length; ++i) {
                    result.set(i, this.elementReader.next(i < prevLength ? result.get(i) : null));
                }
                for (i = prevLength - 1; i >= length; --i) {
                    result.remove(i);
                }
            }
            return result;
        }

        @Override
        Object nextVector(Object previous, long batchSize) throws IOException {
            throw new UnsupportedOperationException("NextVector is not supported operation for List type");
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.lengths = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
            if (this.elementReader != null) {
                this.elementReader.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.elementReader.skipRows(childSkip);
        }
    }

    private static class UnionTreeReader
    extends TreeReader {
        private final TreeReader[] fields;
        private RunLengthByteReader tags;

        UnionTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included, Configuration conf) throws IOException {
            super(path, columnId, conf);
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getSubtypesCount();
            this.fields = new TreeReader[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                int subtype = type.getSubtypes(i);
                if (included != null && !included[subtype]) continue;
                this.fields[i] = RecordReaderImpl.createTreeReader(path, subtype, types, included, conf);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.tags.seek(index[this.columnId]);
            for (TreeReader kid : this.fields) {
                kid.seek(index);
            }
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            OrcUnion result = null;
            if (this.valuePresent) {
                result = previous == null ? new OrcUnion() : (OrcUnion)previous;
                byte tag = this.tags.next();
                Object previousVal = result.getObject();
                result.set(tag, this.fields[tag].next(tag == result.getTag() ? previousVal : null));
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            throw new UnsupportedOperationException("NextVector is not supported operation for Union type");
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.tags = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long[] counts = new long[this.fields.length];
            int i = 0;
            while ((long)i < items) {
                byte by = this.tags.next();
                counts[by] = counts[by] + 1L;
                ++i;
            }
            for (i = 0; i < counts.length; ++i) {
                this.fields[i].skipRows(counts[i]);
            }
        }
    }

    private static class StructTreeReader
    extends TreeReader {
        private final TreeReader[] fields;
        private final String[] fieldNames;

        StructTreeReader(Path path, int columnId, List<OrcProto.Type> types, boolean[] included, Configuration conf) throws IOException {
            super(path, columnId, conf);
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getFieldNamesCount();
            this.fields = new TreeReader[fieldCount];
            this.fieldNames = new String[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                int subtype = type.getSubtypes(i);
                if (included == null || included[subtype]) {
                    this.fields[i] = RecordReaderImpl.createTreeReader(path, subtype, types, included, conf);
                }
                this.fieldNames[i] = type.getFieldNames(i);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            for (TreeReader kid : this.fields) {
                if (kid == null) continue;
                kid.seek(index);
            }
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            OrcStruct result = null;
            if (this.valuePresent) {
                if (previous == null) {
                    result = new OrcStruct(this.fields.length);
                } else {
                    result = (OrcStruct)previous;
                    if (result.getNumFields() != this.fields.length) {
                        result.setNumFields(this.fields.length);
                    }
                }
                for (int i = 0; i < this.fields.length; ++i) {
                    if (this.fields[i] == null) continue;
                    result.setFieldValue(i, this.fields[i].next(result.getFieldValue(i)));
                }
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            ColumnVector[] result = null;
            result = previousVector == null ? new ColumnVector[this.fields.length] : (ColumnVector[])previousVector;
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] == null) continue;
                if (result[i] == null) {
                    result[i] = (ColumnVector)this.fields[i].nextVector(null, batchSize);
                    continue;
                }
                this.fields[i].nextVector(result[i], batchSize);
            }
            return result;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.skipRows(items);
            }
        }
    }

    private static class VarcharTreeReader
    extends StringTreeReader {
        int maxLength;

        VarcharTreeReader(Path path, int columnId, int maxLength, Configuration conf) {
            super(path, columnId, conf);
            this.maxLength = maxLength;
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveVarcharWritable result = null;
            result = previous == null ? new HiveVarcharWritable() : (HiveVarcharWritable)previous;
            Object textVal = super.next(result.getTextValue());
            if (textVal == null) {
                return null;
            }
            result.enforceMaxLength(this.maxLength);
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result;
            block7: {
                block6: {
                    int adjustedDownLen;
                    result = (BytesColumnVector)super.nextVector(previousVector, batchSize);
                    if (!result.isRepeating) break block6;
                    if (!result.noNulls && result.isNull[0] || (adjustedDownLen = StringExpr.truncate(result.vector[0], result.start[0], result.length[0], this.maxLength)) >= result.length[0]) break block7;
                    result.setRef(0, result.vector[0], result.start[0], adjustedDownLen);
                    break block7;
                }
                if (result.noNulls) {
                    int i = 0;
                    while ((long)i < batchSize) {
                        int adjustedDownLen = StringExpr.truncate(result.vector[i], result.start[i], result.length[i], this.maxLength);
                        if (adjustedDownLen < result.length[i]) {
                            result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while ((long)i < batchSize) {
                        int adjustedDownLen;
                        if (!result.isNull[i] && (adjustedDownLen = StringExpr.truncate(result.vector[i], result.start[i], result.length[i], this.maxLength)) < result.length[i]) {
                            result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                        }
                        ++i;
                    }
                }
            }
            return result;
        }
    }

    private static class CharTreeReader
    extends StringTreeReader {
        int maxLength;

        CharTreeReader(Path path, int columnId, int maxLength, Configuration conf) {
            super(path, columnId, conf);
            this.maxLength = maxLength;
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveCharWritable result = null;
            result = previous == null ? new HiveCharWritable() : (HiveCharWritable)previous;
            Object textVal = super.next(result.getTextValue());
            if (textVal == null) {
                return null;
            }
            result.enforceMaxLength(this.maxLength);
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result;
            block7: {
                block6: {
                    int adjustedDownLen;
                    result = (BytesColumnVector)super.nextVector(previousVector, batchSize);
                    if (!result.isRepeating) break block6;
                    if (!result.noNulls && result.isNull[0] || (adjustedDownLen = StringExpr.rightTrimAndTruncate(result.vector[0], result.start[0], result.length[0], this.maxLength)) >= result.length[0]) break block7;
                    result.setRef(0, result.vector[0], result.start[0], adjustedDownLen);
                    break block7;
                }
                if (result.noNulls) {
                    int i = 0;
                    while ((long)i < batchSize) {
                        int adjustedDownLen = StringExpr.rightTrimAndTruncate(result.vector[i], result.start[i], result.length[i], this.maxLength);
                        if (adjustedDownLen < result.length[i]) {
                            result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while ((long)i < batchSize) {
                        int adjustedDownLen;
                        if (!result.isNull[i] && (adjustedDownLen = StringExpr.rightTrimAndTruncate(result.vector[i], result.start[i], result.length[i], this.maxLength)) < result.length[i]) {
                            result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                        }
                        ++i;
                    }
                }
            }
            return result;
        }
    }

    private static class StringDictionaryTreeReader
    extends TreeReader {
        private DynamicByteArray dictionaryBuffer;
        private int[] dictionaryOffsets;
        private IntegerReader reader;
        private byte[] dictionaryBufferInBytesCache = null;
        private final LongColumnVector scratchlcv = new LongColumnVector();

        StringDictionaryTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DICTIONARY && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            int dictionarySize = encodings.get(this.columnId).getDictionarySize();
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DICTIONARY_DATA);
            InStream in = streams.get(name);
            if (in != null) {
                if (in.available() > 0) {
                    this.dictionaryBuffer = new DynamicByteArray(64, in.available());
                    this.dictionaryBuffer.readAll(in);
                    this.dictionaryBufferInBytesCache = null;
                }
                in.close();
            } else {
                this.dictionaryBuffer = null;
            }
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH);
            in = streams.get(name);
            if (in != null) {
                IntegerReader lenReader = this.createIntegerReader(encodings.get(this.columnId).getKind(), in, false);
                int offset = 0;
                if (this.dictionaryOffsets == null || this.dictionaryOffsets.length < dictionarySize + 1) {
                    this.dictionaryOffsets = new int[dictionarySize + 1];
                }
                for (int i = 0; i < dictionarySize; ++i) {
                    this.dictionaryOffsets[i] = offset;
                    offset += (int)lenReader.next();
                }
                this.dictionaryOffsets[dictionarySize] = offset;
                in.close();
            }
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Text result = null;
            if (this.valuePresent) {
                int entry = (int)this.reader.next();
                result = previous == null ? new Text() : (Text)previous;
                int offset = this.dictionaryOffsets[entry];
                int length = this.getDictionaryEntryLength(entry, offset);
                if (this.dictionaryBuffer != null) {
                    this.dictionaryBuffer.setText(result, offset, length);
                } else {
                    result.clear();
                }
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result = null;
            int offset = 0;
            int length = 0;
            result = previousVector == null ? new BytesColumnVector() : (BytesColumnVector)previousVector;
            super.nextVector(result, batchSize);
            if (this.dictionaryBuffer != null) {
                if (this.dictionaryBufferInBytesCache == null) {
                    this.dictionaryBufferInBytesCache = this.dictionaryBuffer.get();
                }
                this.scratchlcv.isNull = result.isNull;
                this.reader.nextVector(this.scratchlcv, batchSize);
                if (!this.scratchlcv.isRepeating) {
                    int i = 0;
                    while ((long)i < batchSize) {
                        if (!this.scratchlcv.isNull[i]) {
                            offset = this.dictionaryOffsets[(int)this.scratchlcv.vector[i]];
                            length = this.getDictionaryEntryLength((int)this.scratchlcv.vector[i], offset);
                            result.setRef(i, this.dictionaryBufferInBytesCache, offset, length);
                        } else {
                            result.setRef(i, this.dictionaryBufferInBytesCache, 0, 0);
                        }
                        ++i;
                    }
                } else {
                    offset = this.dictionaryOffsets[(int)this.scratchlcv.vector[0]];
                    length = this.getDictionaryEntryLength((int)this.scratchlcv.vector[0], offset);
                    result.setRef(0, this.dictionaryBufferInBytesCache, offset, length);
                }
                result.isRepeating = this.scratchlcv.isRepeating;
            } else {
                result.isRepeating = true;
                result.noNulls = false;
                result.isNull[0] = true;
                result.setRef(0, "".getBytes(), 0, 0);
            }
            return result;
        }

        int getDictionaryEntryLength(int entry, int offset) {
            int length = 0;
            length = entry < this.dictionaryOffsets.length - 1 ? this.dictionaryOffsets[entry + 1] - offset : this.dictionaryBuffer.size() - offset;
            return length;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class StringDirectTreeReader
    extends TreeReader {
        private InStream stream;
        private IntegerReader lengths;
        private final LongColumnVector scratchlcv = new LongColumnVector();

        StringDirectTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
            this.lengths = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
            this.lengths.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Text result = null;
            if (this.valuePresent) {
                result = previous == null ? new Text() : (Text)previous;
                int len = (int)this.lengths.next();
                int offset = 0;
                byte[] bytes = new byte[len];
                while (len > 0) {
                    int written = this.stream.read(bytes, offset, len);
                    if (written < 0) {
                        throw new EOFException("Can't finish byte read from " + this.stream);
                    }
                    len -= written;
                    offset += written;
                }
                result.set(bytes);
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result = null;
            result = previousVector == null ? new BytesColumnVector() : (BytesColumnVector)previousVector;
            super.nextVector(result, batchSize);
            BytesColumnVectorUtil.readOrcByteArrays(this.stream, this.lengths, this.scratchlcv, result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long lengthToSkip = 0L;
            int i = 0;
            while ((long)i < items) {
                lengthToSkip += this.lengths.next();
                ++i;
            }
            this.stream.skip(lengthToSkip);
        }
    }

    private static class BytesColumnVectorUtil {
        private BytesColumnVectorUtil() {
        }

        private static byte[] commonReadByteArrays(InStream stream, IntegerReader lengths, LongColumnVector scratchlcv, BytesColumnVector result, long batchSize) throws IOException {
            scratchlcv.isNull = result.isNull;
            lengths.nextVector(scratchlcv, batchSize);
            int totalLength = 0;
            if (!scratchlcv.isRepeating) {
                int i = 0;
                while ((long)i < batchSize) {
                    if (!scratchlcv.isNull[i]) {
                        totalLength += (int)scratchlcv.vector[i];
                    }
                    ++i;
                }
            } else if (!scratchlcv.isNull[0]) {
                totalLength = (int)(batchSize * scratchlcv.vector[0]);
            }
            byte[] allBytes = new byte[totalLength];
            int offset = 0;
            int len = totalLength;
            while (len > 0) {
                int bytesRead = stream.read(allBytes, offset, len);
                if (bytesRead < 0) {
                    throw new EOFException("Can't finish byte read from " + stream);
                }
                len -= bytesRead;
                offset += bytesRead;
            }
            return allBytes;
        }

        public static void readOrcByteArrays(InStream stream, IntegerReader lengths, LongColumnVector scratchlcv, BytesColumnVector result, long batchSize) throws IOException {
            byte[] allBytes = BytesColumnVectorUtil.commonReadByteArrays(stream, lengths, scratchlcv, result, batchSize);
            result.isRepeating = false;
            int offset = 0;
            if (!scratchlcv.isRepeating) {
                int i = 0;
                while ((long)i < batchSize) {
                    if (!scratchlcv.isNull[i]) {
                        result.setRef(i, allBytes, offset, (int)scratchlcv.vector[i]);
                        offset = (int)((long)offset + scratchlcv.vector[i]);
                    } else {
                        result.setRef(i, allBytes, 0, 0);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < batchSize) {
                    if (!scratchlcv.isNull[i]) {
                        result.setRef(i, allBytes, offset, (int)scratchlcv.vector[0]);
                        offset = (int)((long)offset + scratchlcv.vector[0]);
                    } else {
                        result.setRef(i, allBytes, 0, 0);
                    }
                    ++i;
                }
            }
        }
    }

    private static class StringTreeReader
    extends TreeReader {
        private TreeReader reader;

        StringTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            this.reader.checkEncoding(encoding);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            switch (encodings.get(this.columnId).getKind()) {
                case DIRECT_V2: 
                case DIRECT: {
                    this.reader = new StringDirectTreeReader(this.path, this.columnId, this.conf);
                    break;
                }
                case DICTIONARY_V2: 
                case DICTIONARY: {
                    this.reader = new StringDictionaryTreeReader(this.path, this.columnId, this.conf);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)encodings.get(this.columnId).getKind()));
                }
            }
            this.reader.startStripe(streams, encodings);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.reader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            return this.reader.next(previous);
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            return this.reader.nextVector(previousVector, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skipRows(items);
        }
    }

    private static class DecimalTreeReader
    extends TreeReader {
        private InStream valueStream;
        private IntegerReader scaleStream = null;
        private LongColumnVector scratchScaleVector = new LongColumnVector(1024);
        private final int precision;
        private final int scale;

        DecimalTreeReader(Path path, int columnId, int precision, int scale, Configuration conf) {
            super(path, columnId, conf);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.valueStream = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA));
            this.scaleStream = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.valueStream.seek(index[this.columnId]);
            this.scaleStream.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            HiveDecimalWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
                result.set(HiveDecimal.create(SerializationUtils.readBigInteger(this.valueStream), (int)this.scaleStream.next()));
                return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)result, (int)this.precision, (int)this.scale);
            }
            return null;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            DecimalColumnVector result = null;
            result = previousVector == null ? new DecimalColumnVector(this.precision, this.scale) : (DecimalColumnVector)previousVector;
            boolean[] scratchIsNull = this.scratchScaleVector.isNull;
            super.nextVector(result, batchSize);
            if (result.isRepeating) {
                if (!result.isNull[0]) {
                    BigInteger bInt = SerializationUtils.readBigInteger(this.valueStream);
                    short scaleInData = (short)this.scaleStream.next();
                    HiveDecimal dec = HiveDecimal.create(bInt, scaleInData);
                    dec = HiveDecimalUtils.enforcePrecisionScale((HiveDecimal)dec, (int)this.precision, (int)this.scale);
                    result.set(0, dec);
                }
            } else {
                this.scratchScaleVector.isNull = result.isNull;
                this.scaleStream.nextVector(this.scratchScaleVector, batchSize);
                int i = 0;
                while ((long)i < batchSize) {
                    if (!result.isNull[i]) {
                        BigInteger bInt = SerializationUtils.readBigInteger(this.valueStream);
                        short scaleInData = (short)this.scratchScaleVector.vector[i];
                        HiveDecimal dec = HiveDecimal.create(bInt, scaleInData);
                        dec = HiveDecimalUtils.enforcePrecisionScale((HiveDecimal)dec, (int)this.precision, (int)this.scale);
                        result.set(i, dec);
                    }
                    ++i;
                }
            }
            this.scratchScaleVector.isNull = scratchIsNull;
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                SerializationUtils.readBigInteger(this.valueStream);
                ++i;
            }
            this.scaleStream.skip(items);
        }
    }

    private static class DateTreeReader
    extends TreeReader {
        private IntegerReader reader = null;

        DateTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            DateWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new DateWritable() : (DateWritable)previous;
                result.set((int)this.reader.next());
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = null;
            result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class TimestampTreeReader
    extends TreeReader {
        private IntegerReader data = null;
        private IntegerReader nanos = null;
        private final LongColumnVector nanoVector = new LongColumnVector();

        TimestampTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.data = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), true);
            this.nanos = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.data.seek(index[this.columnId]);
            this.nanos.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            TimestampWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new TimestampWritable() : (TimestampWritable)previous;
                Timestamp ts = new Timestamp(0L);
                long millis = (this.data.next() + WriterImpl.BASE_TIMESTAMP) * 1000L;
                int newNanos = TimestampTreeReader.parseNanos(this.nanos.next());
                millis = millis >= 0L ? (millis += (long)(newNanos / 1000000)) : (millis -= (long)(newNanos / 1000000));
                ts.setTime(millis);
                ts.setNanos(newNanos);
                result.set(ts);
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = null;
            result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            result.reset();
            Object obj = null;
            int i = 0;
            while ((long)i < batchSize) {
                if ((obj = this.next(obj)) == null) {
                    result.noNulls = false;
                    result.isNull[i] = true;
                } else {
                    TimestampWritable writable = (TimestampWritable)obj;
                    Timestamp timestamp = writable.getTimestamp();
                    result.vector[i] = TimestampUtils.getTimeNanoSec(timestamp);
                }
                ++i;
            }
            return result;
        }

        private static int parseNanos(long serialized) {
            int zeros = 7 & (int)serialized;
            int result = (int)(serialized >>> 3);
            if (zeros != 0) {
                for (int i = 0; i <= zeros; ++i) {
                    result *= 10;
                }
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            this.data.skip(items);
            this.nanos.skip(items);
        }
    }

    private static class BinaryTreeReader
    extends TreeReader {
        protected InStream stream;
        protected IntegerReader lengths = null;
        protected final LongColumnVector scratchlcv = new LongColumnVector();

        BinaryTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
            this.lengths = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
            this.lengths.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            BytesWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new BytesWritable() : (BytesWritable)previous;
                int len = (int)this.lengths.next();
                result.setSize(len);
                int offset = 0;
                while (len > 0) {
                    int written = this.stream.read(result.getBytes(), offset, len);
                    if (written < 0) {
                        throw new EOFException("Can't finish byte read from " + this.stream);
                    }
                    len -= written;
                    offset += written;
                }
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result = null;
            result = previousVector == null ? new BytesColumnVector() : (BytesColumnVector)previousVector;
            super.nextVector(result, batchSize);
            BytesColumnVectorUtil.readOrcByteArrays(this.stream, this.lengths, this.scratchlcv, result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long lengthToSkip = 0L;
            int i = 0;
            while ((long)i < items) {
                lengthToSkip += this.lengths.next();
                ++i;
            }
            this.stream.skip(lengthToSkip);
        }
    }

    private static class DoubleTreeReader
    extends TreeReader {
        private InStream stream;
        private final SerializationUtils utils = new SerializationUtils();

        DoubleTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            DoubleWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new DoubleWritable() : (DoubleWritable)previous;
                result.set(this.utils.readDouble(this.stream));
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            DoubleColumnVector result = null;
            result = previousVector == null ? new DoubleColumnVector() : (DoubleColumnVector)previousVector;
            super.nextVector(result, batchSize);
            int i = 0;
            while ((long)i < batchSize) {
                result.vector[i] = !result.isNull[i] ? this.utils.readDouble(this.stream) : Double.NaN;
                ++i;
            }
            result.isRepeating = true;
            i = 0;
            while ((long)i < batchSize - 1L && result.isRepeating) {
                if (result.vector[i] != result.vector[i + 1]) {
                    result.isRepeating = false;
                }
                ++i;
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            this.stream.skip(items * 8L);
        }
    }

    private static class FloatTreeReader
    extends TreeReader {
        private InStream stream;
        private final SerializationUtils utils = new SerializationUtils();

        FloatTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            FloatWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new FloatWritable() : (FloatWritable)previous;
                result.set(this.utils.readFloat(this.stream));
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            DoubleColumnVector result = null;
            result = previousVector == null ? new DoubleColumnVector() : (DoubleColumnVector)previousVector;
            super.nextVector(result, batchSize);
            int i = 0;
            while ((long)i < batchSize) {
                result.vector[i] = !result.isNull[i] ? (double)this.utils.readFloat(this.stream) : Double.NaN;
                ++i;
            }
            result.isRepeating = true;
            i = 0;
            while ((long)i < batchSize - 1L && result.isRepeating) {
                if (result.vector[i] != result.vector[i + 1]) {
                    result.isRepeating = false;
                }
                ++i;
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                this.utils.readFloat(this.stream);
                ++i;
            }
        }
    }

    private static class LongTreeReader
    extends TreeReader {
        private IntegerReader reader = null;

        LongTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            LongWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new LongWritable() : (LongWritable)previous;
                result.set(this.reader.next());
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = null;
            result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class IntTreeReader
    extends TreeReader {
        private IntegerReader reader = null;

        IntTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            IntWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new IntWritable() : (IntWritable)previous;
                result.set((int)this.reader.next());
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = null;
            result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class ShortTreeReader
    extends TreeReader {
        private IntegerReader reader = null;

        ShortTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(encodings.get(this.columnId).getKind(), streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ShortWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new ShortWritable() : (ShortWritable)previous;
                result.set((short)this.reader.next());
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = null;
            result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class ByteTreeReader
    extends TreeReader {
        private RunLengthByteReader reader = null;

        ByteTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.reader = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ByteWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new ByteWritable() : (ByteWritable)previous;
                result.set(this.reader.next());
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = null;
            result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class BooleanTreeReader
    extends TreeReader {
        private BitFieldReader reader = null;

        BooleanTreeReader(Path path, int columnId, Configuration conf) {
            super(path, columnId, conf);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.reader = new BitFieldReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), 1);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            BooleanWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new BooleanWritable() : (BooleanWritable)previous;
                result.set(this.reader.next() == 1);
            }
            return result;
        }

        @Override
        Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = null;
            result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }
    }

    private static abstract class TreeReader {
        protected final Path path;
        protected final int columnId;
        private BitFieldReader present = null;
        protected boolean valuePresent = false;
        protected final Configuration conf;

        TreeReader(Path path, int columnId, Configuration conf) {
            this.path = path;
            this.columnId = columnId;
            this.conf = conf;
        }

        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId + " of " + this.path);
            }
        }

        IntegerReader createIntegerReader(OrcProto.ColumnEncoding.Kind kind, InStream in, boolean signed) throws IOException {
            switch (kind) {
                case DIRECT_V2: 
                case DICTIONARY_V2: {
                    return new RunLengthIntegerReaderV2(in, signed, this.conf);
                }
                case DIRECT: 
                case DICTIONARY: {
                    return new RunLengthIntegerReader(in, signed);
                }
            }
            throw new IllegalArgumentException("Unknown encoding " + (Object)((Object)kind));
        }

        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encoding) throws IOException {
            this.checkEncoding(encoding.get(this.columnId));
            InStream in = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.PRESENT));
            if (in == null) {
                this.present = null;
                this.valuePresent = true;
            } else {
                this.present = new BitFieldReader(in, 1);
            }
        }

        void seek(PositionProvider[] index) throws IOException {
            if (this.present != null) {
                this.present.seek(index[this.columnId]);
            }
        }

        protected long countNonNulls(long rows) throws IOException {
            if (this.present != null) {
                long result = 0L;
                for (long c = 0L; c < rows; ++c) {
                    if (this.present.next() != 1) continue;
                    ++result;
                }
                return result;
            }
            return rows;
        }

        abstract void skipRows(long var1) throws IOException;

        Object next(Object previous) throws IOException {
            if (this.present != null) {
                this.valuePresent = this.present.next() == 1;
            }
            return previous;
        }

        Object nextVector(Object previousVector, long batchSize) throws IOException {
            ColumnVector result = (ColumnVector)previousVector;
            if (this.present != null) {
                result.noNulls = true;
                int i = 0;
                while ((long)i < batchSize) {
                    boolean bl = result.isNull[i] = this.present.next() != 1;
                    if (result.noNulls && result.isNull[i]) {
                        result.noNulls = false;
                    }
                    ++i;
                }
            } else {
                result.noNulls = true;
                int i = 0;
                while ((long)i < batchSize) {
                    result.isNull[i] = false;
                    ++i;
                }
            }
            return previousVector;
        }
    }

    private static final class PositionProviderImpl
    implements PositionProvider {
        private final OrcProto.RowIndexEntry entry;
        private int index = 0;

        PositionProviderImpl(OrcProto.RowIndexEntry entry) {
            this.entry = entry;
        }

        @Override
        public long getNext() {
            return this.entry.getPositions(this.index++);
        }
    }

    public static final class ByteBufferAllocatorPool
    implements HadoopShims.ByteBufferPoolShim {
        private final TreeMap<Key, ByteBuffer> buffers = new TreeMap();
        private final TreeMap<Key, ByteBuffer> directBuffers = new TreeMap();
        private long currentGeneration = 0L;

        private final TreeMap<Key, ByteBuffer> getBufferTree(boolean direct) {
            return direct ? this.directBuffers : this.buffers;
        }

        public void clear() {
            this.buffers.clear();
            this.directBuffers.clear();
        }

        public ByteBuffer getBuffer(boolean direct, int length) {
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(direct);
            Map.Entry<Key, ByteBuffer> entry = tree.ceilingEntry(new Key(length, 0L));
            if (entry == null) {
                return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
            }
            tree.remove(entry.getKey());
            return entry.getValue();
        }

        public void putBuffer(ByteBuffer buffer) {
            Key key;
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(buffer.isDirect());
            while (tree.containsKey(key = new Key(buffer.capacity(), this.currentGeneration++))) {
            }
            tree.put(key, buffer);
        }

        private static final class Key
        implements Comparable<Key> {
            private final int capacity;
            private final long insertionGeneration;

            Key(int capacity, long insertionGeneration) {
                this.capacity = capacity;
                this.insertionGeneration = insertionGeneration;
            }

            @Override
            public int compareTo(Key other) {
                return ComparisonChain.start().compare(this.capacity, other.capacity).compare(this.insertionGeneration, other.insertionGeneration).result();
            }

            public boolean equals(Object rhs) {
                if (rhs == null) {
                    return false;
                }
                try {
                    Key o = (Key)rhs;
                    return this.compareTo(o) == 0;
                }
                catch (ClassCastException e) {
                    return false;
                }
            }

            public int hashCode() {
                return new HashCodeBuilder().append(this.capacity).append(this.insertionGeneration).toHashCode();
            }
        }
    }
}

