/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.util.List;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;

public abstract class FilterPredicateLeafBuilder {
    public FilterPredicate buildPredicate(PredicateLeaf.Operator op, List<Object> literals, String columnName) throws Exception {
        FilterPredicate result = null;
        switch (op) {
            case IN: {
                for (Object literal : literals) {
                    if (result == null) {
                        result = this.buildPredict(PredicateLeaf.Operator.EQUALS, literal, columnName);
                        continue;
                    }
                    result = FilterApi.or((FilterPredicate)result, (FilterPredicate)this.buildPredict(PredicateLeaf.Operator.EQUALS, literal, columnName));
                }
                return result;
            }
            case BETWEEN: {
                if (literals.size() != 2) {
                    throw new RuntimeException("Not able to build 'between' operation filter with " + literals + " which needs two literals");
                }
                Object min = literals.get(0);
                Object max = literals.get(1);
                FilterPredicate lt = FilterApi.not((FilterPredicate)this.buildPredict(PredicateLeaf.Operator.LESS_THAN, min, columnName));
                FilterPredicate gt = this.buildPredict(PredicateLeaf.Operator.LESS_THAN_EQUALS, max, columnName);
                result = FilterApi.and((FilterPredicate)gt, (FilterPredicate)lt);
                return result;
            }
        }
        throw new RuntimeException("Unknown PredicateLeaf Operator type: " + op);
    }

    public abstract FilterPredicate buildPredict(PredicateLeaf.Operator var1, Object var2, String var3) throws Exception;
}

