/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.convert.DataWritableRecordConverter;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.util.StringUtils;
import parquet.hadoop.api.ReadSupport;
import parquet.io.api.RecordMaterializer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.Types;

public class DataWritableReadSupport
extends ReadSupport<ArrayWritable> {
    public static final String HIVE_TABLE_AS_PARQUET_SCHEMA = "HIVE_TABLE_SCHEMA";
    public static final String PARQUET_COLUMN_INDEX_ACCESS = "parquet.column.index.access";

    private static List<String> getColumnNames(String columns) {
        return (List)VirtualColumn.removeVirtualColumns(StringUtils.getStringCollection((String)columns));
    }

    private static List<TypeInfo> getColumnTypes(String types) {
        return TypeInfoUtils.getTypeInfosFromTypeString((String)types);
    }

    private static Type getFieldTypeIgnoreCase(GroupType groupType, String fieldName) {
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(fieldName)) continue;
            return type;
        }
        return null;
    }

    private static List<Type> getProjectedGroupFields(GroupType schema, List<String> colNames, List<TypeInfo> colTypes) {
        ArrayList<Type> schemaTypes = new ArrayList<Type>();
        ListIterator<String> columnIterator = colNames.listIterator();
        while (columnIterator.hasNext()) {
            TypeInfo colType = colTypes.get(columnIterator.nextIndex());
            String colName = columnIterator.next();
            Type fieldType = DataWritableReadSupport.getFieldTypeIgnoreCase(schema, colName);
            if (fieldType != null) {
                if (colType.getCategory() == ObjectInspector.Category.STRUCT) {
                    if (fieldType.isPrimitive()) {
                        throw new IllegalStateException("Invalid schema data type, found: PRIMITIVE, expected: STRUCT");
                    }
                    GroupType groupFieldType = fieldType.asGroupType();
                    List<Type> groupFields = DataWritableReadSupport.getProjectedGroupFields(groupFieldType, ((StructTypeInfo)colType).getAllStructFieldNames(), ((StructTypeInfo)colType).getAllStructFieldTypeInfos());
                    Type[] typesArray = groupFields.toArray(new Type[0]);
                    schemaTypes.add((Type)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)groupFieldType.getRepetition()).addFields(typesArray)).named(fieldType.getName()));
                    continue;
                }
                schemaTypes.add(fieldType);
                continue;
            }
            schemaTypes.add((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named(colName));
        }
        return schemaTypes;
    }

    private static MessageType getSchemaByName(MessageType schema, List<String> colNames, List<TypeInfo> colTypes) {
        List<Type> projectedFields = DataWritableReadSupport.getProjectedGroupFields((GroupType)schema, colNames, colTypes);
        Type[] typesArray = projectedFields.toArray(new Type[0]);
        return (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(typesArray)).named(schema.getName());
    }

    private static MessageType getSchemaByIndex(MessageType schema, List<String> colNames, List<Integer> colIndexes) {
        ArrayList<Object> schemaTypes = new ArrayList<Object>();
        for (Integer i : colIndexes) {
            if (i >= colNames.size()) continue;
            if (i < schema.getFieldCount()) {
                schemaTypes.add(schema.getType(i.intValue()));
                continue;
            }
            schemaTypes.add(Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("_mask_" + colNames.get(i)));
        }
        return new MessageType(schema.getName(), schemaTypes);
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String columnNames = configuration.get("columns");
        HashMap<String, String> contextMetadata = new HashMap<String, String>();
        boolean indexAccess = configuration.getBoolean(PARQUET_COLUMN_INDEX_ACCESS, false);
        if (columnNames != null) {
            MessageType tableSchema;
            List<String> columnNamesList = DataWritableReadSupport.getColumnNames(columnNames);
            if (indexAccess) {
                ArrayList<Integer> indexSequence = new ArrayList<Integer>();
                for (int i = 0; i < columnNamesList.size(); ++i) {
                    indexSequence.add(i);
                }
                tableSchema = DataWritableReadSupport.getSchemaByIndex(fileSchema, columnNamesList, indexSequence);
            } else {
                String columnTypes = configuration.get("columns.types");
                List<TypeInfo> columnTypesList = DataWritableReadSupport.getColumnTypes(columnTypes);
                tableSchema = DataWritableReadSupport.getSchemaByName(fileSchema, columnNamesList, columnTypesList);
            }
            contextMetadata.put(HIVE_TABLE_AS_PARQUET_SCHEMA, tableSchema.toString());
            List indexColumnsWanted = ColumnProjectionUtils.getReadColumnIDs((Configuration)configuration);
            MessageType requestedSchemaByUser = DataWritableReadSupport.getSchemaByIndex(tableSchema, columnNamesList, indexColumnsWanted);
            return new ReadSupport.ReadContext(requestedSchemaByUser, contextMetadata);
        }
        contextMetadata.put(HIVE_TABLE_AS_PARQUET_SCHEMA, fileSchema.toString());
        return new ReadSupport.ReadContext(fileSchema, contextMetadata);
    }

    public RecordMaterializer<ArrayWritable> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        Map metadata = readContext.getReadSupportMetadata();
        if (metadata == null) {
            throw new IllegalStateException("ReadContext not initialized properly. Don't know the Hive Schema.");
        }
        String key = HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION.varname;
        if (!metadata.containsKey(key)) {
            metadata.put(key, String.valueOf(HiveConf.getBoolVar(configuration, HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION)));
        }
        return new DataWritableRecordConverter((GroupType)readContext.getRequestedSchema(), metadata);
    }
}

