/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.io.parquet.FilterPredicateLeafBuilder;
import org.apache.hadoop.hive.ql.io.parquet.LeafFilterFactory;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.schema.MessageType;
import parquet.schema.Type;

public class ParquetFilterPredicateConverter {
    private static final Log LOG = LogFactory.getLog(ParquetFilterPredicateConverter.class);

    public static FilterPredicate toFilterPredicate(SearchArgument sarg, MessageType schema) {
        HashSet<String> columns = null;
        if (schema != null) {
            columns = new HashSet<String>();
            for (Type field : schema.getFields()) {
                columns.add(field.getName());
            }
        }
        return ParquetFilterPredicateConverter.translate(sarg.getExpression(), sarg.getLeaves(), columns, schema);
    }

    private static FilterPredicate translate(ExpressionTree root, List<PredicateLeaf> leaves, Set<String> columns, MessageType schema) {
        FilterPredicate p = null;
        switch (root.getOperator()) {
            case OR: {
                for (ExpressionTree child : root.getChildren()) {
                    if (p == null) {
                        p = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                        continue;
                    }
                    FilterPredicate right = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                    if (right == null) continue;
                    p = FilterApi.or((FilterPredicate)p, (FilterPredicate)right);
                }
                return p;
            }
            case AND: {
                for (ExpressionTree child : root.getChildren()) {
                    if (p == null) {
                        p = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                        continue;
                    }
                    FilterPredicate right = ParquetFilterPredicateConverter.translate(child, leaves, columns, schema);
                    if (right == null) continue;
                    p = FilterApi.and((FilterPredicate)p, (FilterPredicate)right);
                }
                return p;
            }
            case NOT: {
                FilterPredicate op = ParquetFilterPredicateConverter.translate((ExpressionTree)root.getChildren().get(0), leaves, columns, schema);
                if (op != null) {
                    return FilterApi.not((FilterPredicate)op);
                }
                return null;
            }
            case LEAF: {
                PredicateLeaf leaf = leaves.get(root.getLeaf());
                if (columns.contains(leaf.getColumnName())) {
                    Type parquetType = schema.getType(leaf.getColumnName());
                    return ParquetFilterPredicateConverter.buildFilterPredicateFromPredicateLeaf(leaf, parquetType);
                }
                return null;
            }
            case CONSTANT: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown operator: " + root.getOperator());
    }

    private static FilterPredicate buildFilterPredicateFromPredicateLeaf(PredicateLeaf leaf, Type parquetType) {
        LeafFilterFactory leafFilterFactory = new LeafFilterFactory();
        try {
            FilterPredicateLeafBuilder builder = leafFilterFactory.getLeafFilterBuilderByType(leaf.getType(), parquetType);
            if (builder == null) {
                return null;
            }
            if (ParquetFilterPredicateConverter.isMultiLiteralsOperator(leaf.getOperator())) {
                return builder.buildPredicate(leaf.getOperator(), leaf.getLiteralList(PredicateLeaf.FileFormat.PARQUET), leaf.getColumnName());
            }
            return builder.buildPredict(leaf.getOperator(), leaf.getLiteral(PredicateLeaf.FileFormat.PARQUET), leaf.getColumnName());
        }
        catch (Exception e) {
            LOG.error((Object)("fail to build predicate filter leaf with errors" + e), (Throwable)e);
            return null;
        }
    }

    private static boolean isMultiLiteralsOperator(PredicateLeaf.Operator op) {
        return op == PredicateLeaf.Operator.IN || op == PredicateLeaf.Operator.BETWEEN;
    }
}

