/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionTask;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.CheckJDOException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPrunerUtils;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.CreateTableAutomaticGrant;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.spark_project.guava.collect.ImmutableMap;
import org.spark_project.guava.collect.Sets;

public class Hive {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.metadata.Hive");
    private HiveConf conf = null;
    private IMetaStoreClient metaStoreClient;
    private UserGroupInformation owner;
    private final Map<String, Long> metaCallTimeMap = new HashMap<String, Long>();
    private static ThreadLocal<Hive> hiveDB = new ThreadLocal<Hive>(){

        @Override
        protected synchronized Hive initialValue() {
            return null;
        }

        @Override
        public synchronized void remove() {
            if (this.get() != null) {
                ((Hive)this.get()).close();
            }
            super.remove();
        }
    };
    private static final AtomicInteger didRegisterAllFuncs = new AtomicInteger(0);
    private static final int REG_FUNCS_NO = 0;
    private static final int REG_FUNCS_DONE = 2;
    private static final int REG_FUNCS_PENDING = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAllFunctionsOnce() {
        AtomicInteger atomicInteger;
        boolean breakLoop = false;
        block24: while (!breakLoop) {
            int val = didRegisterAllFuncs.get();
            switch (val) {
                case 0: {
                    if (!didRegisterAllFuncs.compareAndSet(val, 1)) continue block24;
                    breakLoop = true;
                    continue block24;
                }
                case 1: {
                    atomicInteger = didRegisterAllFuncs;
                    synchronized (atomicInteger) {
                        try {
                            didRegisterAllFuncs.wait(100L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
            throw new AssertionError(val);
        }
        try {
            this.reloadFunctions();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to register all functions.", (Throwable)e);
        }
        finally {
            boolean result = didRegisterAllFuncs.compareAndSet(1, 2);
            assert (result);
            atomicInteger = didRegisterAllFuncs;
            synchronized (atomicInteger) {
                didRegisterAllFuncs.notifyAll();
            }
        }
    }

    public void reloadFunctions() throws HiveException {
        for (Function function : this.getAllFunctions()) {
            String functionName = function.getFunctionName();
            try {
                LOG.info((Object)("Registering function " + functionName + " " + function.getClassName()));
                FunctionRegistry.registerPermanentFunction(FunctionUtils.qualifyFunctionName(functionName, function.getDbName()), function.getClassName(), false, FunctionTask.toFunctionResource(function.getResourceUris()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to register persistent function " + functionName + ":" + function.getClassName() + ". Ignore and continue."));
            }
        }
    }

    public static Hive get(Configuration c, Class<?> clazz) throws HiveException {
        return Hive.get(c instanceof HiveConf ? (HiveConf)c : new HiveConf(c, clazz));
    }

    public static Hive get(HiveConf c) throws HiveException {
        Hive db = hiveDB.get();
        if (db == null || !db.isCurrentUserOwner() || db.metaStoreClient != null && !db.metaStoreClient.isCompatibleWith(c)) {
            return Hive.get(c, true);
        }
        db.conf = c;
        return db;
    }

    public static Hive get(HiveConf c, boolean needsRefresh) throws HiveException {
        Hive db = hiveDB.get();
        if (db == null || needsRefresh || !db.isCurrentUserOwner()) {
            if (db != null) {
                LOG.debug((Object)("Creating new db. db = " + db + ", needsRefresh = " + needsRefresh + ", db.isCurrentUserOwner = " + db.isCurrentUserOwner()));
            }
            Hive.closeCurrent();
            c.set("fs.scheme.class", "dfs");
            Hive newdb = new Hive(c);
            hiveDB.set(newdb);
            return newdb;
        }
        db.conf = c;
        return db;
    }

    public static Hive get() throws HiveException {
        Hive db = hiveDB.get();
        if (db != null && !db.isCurrentUserOwner()) {
            LOG.debug((Object)("Creating new db. db.isCurrentUserOwner = " + db.isCurrentUserOwner()));
            db.close();
            db = null;
        }
        if (db == null) {
            SessionState session = SessionState.get();
            db = new Hive(session == null ? new HiveConf(Hive.class) : session.getConf());
            hiveDB.set(db);
        }
        return db;
    }

    public static void set(Hive hive) {
        hiveDB.set(hive);
    }

    public static void closeCurrent() {
        hiveDB.remove();
    }

    private Hive(HiveConf c) throws HiveException {
        this.conf = c;
        this.registerAllFunctionsOnce();
    }

    private boolean isCurrentUserOwner() throws HiveException {
        try {
            return this.owner == null || this.owner.equals((Object)UserGroupInformation.getCurrentUser());
        }
        catch (IOException e) {
            throw new HiveException("Error getting current user: " + e.getMessage(), e);
        }
    }

    private void close() {
        LOG.debug((Object)"Closing current thread's connection to Hive Metastore.");
        if (this.metaStoreClient != null) {
            this.metaStoreClient.close();
            this.metaStoreClient = null;
        }
        if (this.owner != null) {
            this.owner = null;
        }
    }

    public void createDatabase(Database db, boolean ifNotExist) throws AlreadyExistsException, HiveException {
        try {
            this.getMSC().createDatabase(db);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExist) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createDatabase(Database db) throws AlreadyExistsException, HiveException {
        this.createDatabase(db, false);
    }

    public void dropDatabase(String name) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropDatabase(name, deleteData, ignoreUnknownDb, cascade);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, -1, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, bucketCount, bucketCols, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols, Map<String, String> parameters) throws HiveException {
        if (columns == null) {
            throw new HiveException("columns not specified for table " + tableName);
        }
        Table tbl = this.newTable(tableName);
        tbl.setInputFormatClass(fileInputFormat.getName());
        tbl.setOutputFormatClass(fileOutputFormat.getName());
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "default");
            tbl.getCols().add(field);
        }
        if (partCols != null) {
            for (String partCol : partCols) {
                FieldSchema part = new FieldSchema();
                part.setName(partCol);
                part.setType("string");
                tbl.getPartCols().add(part);
            }
        }
        tbl.setSerializationLib(LazySimpleSerDe.class.getName());
        tbl.setNumBuckets(bucketCount);
        tbl.setBucketCols(bucketCols);
        if (parameters != null) {
            tbl.setParamters(parameters);
        }
        this.createTable(tbl);
    }

    public void alterTable(String tblName, Table newTbl) throws InvalidOperationException, HiveException {
        this.alterTable(tblName, newTbl, false);
    }

    public void alterTable(String tblName, Table newTbl, boolean cascade) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        try {
            if (newTbl.getParameters() != null) {
                newTbl.getParameters().remove("transient_lastDdlTime");
            }
            newTbl.checkValidity();
            this.getMSC().alter_table(names[0], names[1], newTbl.getTTable(), cascade);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), e);
        }
    }

    public void alterIndex(String baseTableName, String indexName, Index newIdx) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(baseTableName);
        this.alterIndex(names[0], names[1], indexName, newIdx);
    }

    public void alterIndex(String dbName, String baseTblName, String idxName, Index newIdx) throws InvalidOperationException, HiveException {
        try {
            this.getMSC().alter_index(dbName, baseTblName, idxName, newIdx);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter index. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter index. " + e.getMessage(), e);
        }
    }

    public void alterPartition(String tblName, Partition newPart) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        this.alterPartition(names[0], names[1], newPart);
    }

    public void alterPartition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, HiveException {
        try {
            if (newPart.getParameters() != null) {
                newPart.getParameters().remove("transient_lastDdlTime");
            }
            newPart.checkValidity();
            this.getMSC().alter_partition(dbName, tblName, newPart.getTPartition());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
    }

    public void alterPartitions(String tblName, List<Partition> newParts) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> newTParts = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        try {
            for (Partition tmpPart : newParts) {
                if (tmpPart.getParameters() != null) {
                    tmpPart.getParameters().remove("transient_lastDdlTime");
                }
                newTParts.add(tmpPart.getTPartition());
            }
            this.getMSC().alter_partitions(names[0], names[1], newTParts);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
    }

    public void renamePartition(Table tbl, Map<String, String> oldPartSpec, Partition newPart) throws HiveException {
        try {
            LinkedHashMap<String, String> newPartSpec = newPart.getSpec();
            if (oldPartSpec.keySet().size() != tbl.getPartCols().size() || newPartSpec.keySet().size() != tbl.getPartCols().size()) {
                throw new HiveException("Unable to rename partition to the same name: number of partition cols don't match. ");
            }
            if (!oldPartSpec.keySet().equals(newPartSpec.keySet())) {
                throw new HiveException("Unable to rename partition to the same name: old and new partition cols don't match. ");
            }
            ArrayList<String> pvals = new ArrayList<String>();
            for (FieldSchema field : tbl.getPartCols()) {
                String val = oldPartSpec.get(field.getName());
                if (val == null || val.length() == 0) {
                    throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
                }
                if (val == null) continue;
                pvals.add(val);
            }
            this.getMSC().renamePartition(tbl.getDbName(), tbl.getTableName(), pvals, newPart.getTPartition());
        }
        catch (InvalidOperationException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
    }

    public void alterDatabase(String dbName, Database db) throws HiveException {
        try {
            this.getMSC().alterDatabase(dbName, db);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Database " + dbName + " does not exists.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), e);
        }
    }

    public void createTable(Table tbl) throws HiveException {
        this.createTable(tbl, false);
    }

    public void createTable(Table tbl, boolean ifNotExists) throws HiveException {
        try {
            CreateTableAutomaticGrant grants;
            if (tbl.getDbName() == null || "".equals(tbl.getDbName().trim())) {
                tbl.setDbName(SessionState.get().getCurrentDatabase());
            }
            if (tbl.getCols().size() == 0 || tbl.getSd().getColsSize() == 0) {
                tbl.setFields(MetaStoreUtils.getFieldsFromDeserializer((String)tbl.getTableName(), (Deserializer)tbl.getDeserializer()));
            }
            tbl.checkValidity();
            if (tbl.getParameters() != null) {
                tbl.getParameters().remove("transient_lastDdlTime");
            }
            org.apache.hadoop.hive.metastore.api.Table tTbl = tbl.getTTable();
            PrincipalPrivilegeSet principalPrivs = new PrincipalPrivilegeSet();
            SessionState ss = SessionState.get();
            if (ss != null && (grants = ss.getCreateTableGrants()) != null) {
                principalPrivs.setUserPrivileges(grants.getUserGrants());
                principalPrivs.setGroupPrivileges(grants.getGroupGrants());
                principalPrivs.setRolePrivileges(grants.getRoleGrants());
                tTbl.setPrivileges(principalPrivs);
            }
            this.getMSC().createTable(tTbl);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createIndex(String tableName, String indexName, String indexHandlerClass, List<String> indexedCols, String indexTblName, boolean deferredRebuild, String inputFormat, String outputFormat, String serde, String storageHandler, String location, Map<String, String> idxProps, Map<String, String> tblProps, Map<String, String> serdeProps, String collItemDelim, String fieldDelim, String fieldEscape, String lineDelim, String mapKeyDelim, String indexComment) throws HiveException {
        try {
            String tdname = Utilities.getDatabaseName(tableName);
            String idname = Utilities.getDatabaseName(indexTblName);
            if (!idname.equals(tdname)) {
                throw new HiveException("Index on different database (" + idname + ") from base table (" + tdname + ") is not supported.");
            }
            Index old_index = null;
            try {
                old_index = this.getIndex(tableName, indexName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (old_index != null) {
                throw new HiveException("Index " + indexName + " already exists on table " + tableName);
            }
            org.apache.hadoop.hive.metastore.api.Table baseTbl = this.getTable(tableName).getTTable();
            if (baseTbl.getTableType() == TableType.VIRTUAL_VIEW.toString()) {
                throw new HiveException("tableName=" + tableName + " is a VIRTUAL VIEW. Index on VIRTUAL VIEW is not supported.");
            }
            if (baseTbl.isTemporary()) {
                throw new HiveException("tableName=" + tableName + " is a TEMPORARY TABLE. Index on TEMPORARY TABLE is not supported.");
            }
            org.apache.hadoop.hive.metastore.api.Table temp = null;
            try {
                temp = this.getTable(indexTblName).getTTable();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (temp != null) {
                throw new HiveException("Table name " + indexTblName + " already exists. Choose another name.");
            }
            SerDeInfo serdeInfo = new SerDeInfo();
            serdeInfo.setName(indexTblName);
            if (serde != null) {
                serdeInfo.setSerializationLib(serde);
            } else if (storageHandler == null) {
                serdeInfo.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                HiveStorageHandler sh = HiveUtils.getStorageHandler(this.getConf(), storageHandler);
                String serDeClassName = sh.getSerDeClass().getName();
                serdeInfo.setSerializationLib(serDeClassName);
            }
            serdeInfo.setParameters(new HashMap());
            if (fieldDelim != null) {
                serdeInfo.getParameters().put("field.delim", fieldDelim);
                serdeInfo.getParameters().put("serialization.format", fieldDelim);
            }
            if (fieldEscape != null) {
                serdeInfo.getParameters().put("escape.delim", fieldEscape);
            }
            if (collItemDelim != null) {
                serdeInfo.getParameters().put("colelction.delim", collItemDelim);
            }
            if (mapKeyDelim != null) {
                serdeInfo.getParameters().put("mapkey.delim", mapKeyDelim);
            }
            if (lineDelim != null) {
                serdeInfo.getParameters().put("line.delim", lineDelim);
            }
            if (serdeProps != null) {
                for (Map.Entry<String, String> m : serdeProps.entrySet()) {
                    serdeInfo.getParameters().put(m.getKey(), m.getValue());
                }
            }
            ArrayList<FieldSchema> indexTblCols = new ArrayList<FieldSchema>();
            ArrayList<Order> sortCols = new ArrayList<Order>();
            int k = 0;
            Table metaBaseTbl = new Table(baseTbl);
            for (int i = 0; i < metaBaseTbl.getCols().size(); ++i) {
                FieldSchema col = metaBaseTbl.getCols().get(i);
                if (!indexedCols.contains(col.getName())) continue;
                indexTblCols.add(col);
                sortCols.add(new Order(col.getName(), 1));
                ++k;
            }
            if (k != indexedCols.size()) {
                throw new RuntimeException("Check the index columns, they should appear in the table being indexed.");
            }
            int time = (int)(System.currentTimeMillis() / 1000L);
            org.apache.hadoop.hive.metastore.api.Table tt = null;
            HiveIndexHandler indexHandler = HiveUtils.getIndexHandler(this.getConf(), indexHandlerClass);
            String itname = Utilities.getTableName(indexTblName);
            if (indexHandler.usesIndexTable()) {
                CreateTableAutomaticGrant grants;
                SessionState ss;
                tt = new Table(idname, itname).getTTable();
                List partKeys = baseTbl.getPartitionKeys();
                tt.setPartitionKeys(partKeys);
                tt.setTableType(TableType.INDEX_TABLE.toString());
                if (tblProps != null) {
                    for (Map.Entry<String, String> prop : tblProps.entrySet()) {
                        tt.putToParameters(prop.getKey(), prop.getValue());
                    }
                }
                if ((ss = SessionState.get()) != null && (grants = ss.getCreateTableGrants()) != null) {
                    PrincipalPrivilegeSet principalPrivs = new PrincipalPrivilegeSet();
                    principalPrivs.setUserPrivileges(grants.getUserGrants());
                    principalPrivs.setGroupPrivileges(grants.getGroupGrants());
                    principalPrivs.setRolePrivileges(grants.getRoleGrants());
                    tt.setPrivileges(principalPrivs);
                }
            }
            if (!deferredRebuild) {
                throw new RuntimeException("Please specify deferred rebuild using \" WITH DEFERRED REBUILD \".");
            }
            StorageDescriptor indexSd = new StorageDescriptor(indexTblCols, location, inputFormat, outputFormat, false, -1, serdeInfo, null, sortCols, null);
            String ttname = Utilities.getTableName(tableName);
            Index indexDesc = new Index(indexName, indexHandlerClass, tdname, ttname, time, time, itname, indexSd, new HashMap(), deferredRebuild);
            if (indexComment != null) {
                indexDesc.getParameters().put("comment", indexComment);
            }
            if (idxProps != null) {
                indexDesc.getParameters().putAll(idxProps);
            }
            indexHandler.analyzeIndexDefinition(baseTbl, indexDesc, tt);
            this.getMSC().createIndex(indexDesc, tt);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public Index getIndex(String baseTableName, String indexName) throws HiveException {
        String[] names = Utilities.getDbTableName(baseTableName);
        return this.getIndex(names[0], names[1], indexName);
    }

    public Index getIndex(String dbName, String baseTableName, String indexName) throws HiveException {
        try {
            return this.getMSC().getIndex(dbName, baseTableName, indexName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean dropIndex(String baseTableName, String index_name, boolean throwException, boolean deleteData) throws HiveException {
        String[] names = Utilities.getDbTableName(baseTableName);
        return this.dropIndex(names[0], names[1], index_name, throwException, deleteData);
    }

    public boolean dropIndex(String db_name, String tbl_name, String index_name, boolean throwException, boolean deleteData) throws HiveException {
        try {
            return this.getMSC().dropIndex(db_name, tbl_name, index_name, deleteData);
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                throw new HiveException("Index " + index_name + " doesn't exist. ", e);
            }
            return false;
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public void dropTable(String tableName, boolean ifPurge) throws HiveException {
        String[] names = Utilities.getDbTableName(tableName);
        this.dropTable(names[0], names[1], true, true, ifPurge);
    }

    public void dropTable(String tableName) throws HiveException {
        this.dropTable(tableName, false);
    }

    public void dropTable(String dbName, String tableName) throws HiveException {
        this.dropTable(dbName, tableName, true, true, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws HiveException {
        this.dropTable(dbName, tableName, deleteData, ignoreUnknownTab, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws HiveException {
        try {
            this.getMSC().dropTable(dbName, tableName, deleteData, ignoreUnknownTab, ifPurge);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Table getTable(String tableName) throws HiveException {
        return this.getTable(tableName, true);
    }

    public Table getTable(String tableName, boolean throwException) throws HiveException {
        String[] names = Utilities.getDbTableName(tableName);
        return this.getTable(names[0], names[1], throwException);
    }

    public Table getTable(String dbName, String tableName) throws HiveException {
        if (tableName.contains(".")) {
            String[] names = Utilities.getDbTableName(tableName);
            return this.getTable(names[0], names[1], true);
        }
        return this.getTable(dbName, tableName, true);
    }

    public Table getTable(String dbName, String tableName, boolean throwException) throws HiveException {
        if (tableName == null || tableName.equals("")) {
            throw new HiveException("empty table creation??");
        }
        org.apache.hadoop.hive.metastore.api.Table tTable = null;
        try {
            tTable = this.getMSC().getTable(dbName, tableName);
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                LOG.error((Object)("Table " + tableName + " not found: " + e.getMessage()));
                throw new InvalidTableException(tableName);
            }
            return null;
        }
        catch (Exception e) {
            throw new HiveException("Unable to fetch table " + tableName + ". " + e.getMessage(), e);
        }
        if (!TableType.VIRTUAL_VIEW.toString().equals(tTable.getTableType())) {
            char[] b;
            Map parameters = tTable.getSd().getParameters();
            String sf = (String)parameters.get("serialization.format");
            if (sf != null && (b = sf.toCharArray()).length == 1 && b[0] < '\n') {
                parameters.put("serialization.format", Integer.toString(b[0]));
            }
            if (MetadataTypedColumnsetSerDe.class.getName().equals(tTable.getSd().getSerdeInfo().getSerializationLib()) && tTable.getSd().getColsSize() > 0 && ((FieldSchema)tTable.getSd().getCols().get(0)).getType().indexOf(60) == -1) {
                tTable.getSd().getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            }
        }
        return new Table(tTable);
    }

    public List<String> getAllTables() throws HiveException {
        return this.getAllTables(SessionState.get().getCurrentDatabase());
    }

    public List<String> getAllTables(String dbName) throws HiveException {
        return this.getTablesByPattern(dbName, ".*");
    }

    public List<String> getTablesByPattern(String tablePattern) throws HiveException {
        return this.getTablesByPattern(SessionState.get().getCurrentDatabase(), tablePattern);
    }

    public List<String> getTablesByPattern(String dbName, String tablePattern) throws HiveException {
        try {
            return this.getMSC().getTables(dbName, tablePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getTablesForDb(String database, String tablePattern) throws HiveException {
        try {
            return this.getMSC().getTables(database, tablePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllDatabases() throws HiveException {
        try {
            return this.getMSC().getAllDatabases();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getDatabasesByPattern(String databasePattern) throws HiveException {
        try {
            return this.getMSC().getDatabases(databasePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantPrivileges(PrivilegeBag privileges) throws HiveException {
        try {
            return this.getMSC().grant_privileges(privileges);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_privileges(privileges, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean databaseExists(String dbName) throws HiveException {
        return this.getDatabase(dbName) != null;
    }

    public Database getDatabase(String dbName) throws HiveException {
        try {
            return this.getMSC().getDatabase(dbName);
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public Database getDatabaseCurrent() throws HiveException {
        String currentDb = SessionState.get().getCurrentDatabase();
        return this.getDatabase(currentDb);
    }

    public void loadPartition(Path loadPath, String tableName, Map<String, String> partSpec, boolean replace, boolean holdDDLTime, boolean inheritTableSpecs, boolean isSkewedStoreAsSubdir, boolean isSrcLocal, boolean isAcid) throws HiveException {
        Table tbl = this.getTable(tableName);
        this.loadPartition(loadPath, tbl, partSpec, replace, holdDDLTime, inheritTableSpecs, isSkewedStoreAsSubdir, isSrcLocal, isAcid);
    }

    public Partition loadPartition(Path loadPath, Table tbl, Map<String, String> partSpec, boolean replace, boolean holdDDLTime, boolean inheritTableSpecs, boolean isSkewedStoreAsSubdir, boolean isSrcLocal, boolean isAcid) throws HiveException {
        Path tblDataLocationPath = tbl.getDataLocation();
        Partition newTPart = null;
        try {
            Partition oldPart = this.getPartition(tbl, partSpec, false);
            Path oldPartPath = null;
            if (oldPart != null) {
                oldPartPath = oldPart.getDataLocation();
            }
            Path newPartPath = null;
            if (inheritTableSpecs) {
                FileSystem loadPathFS;
                FileSystem oldPartPathFS;
                Path partPath = new Path(tbl.getDataLocation(), Warehouse.makePartPath(partSpec));
                newPartPath = new Path(tblDataLocationPath.toUri().getScheme(), tblDataLocationPath.toUri().getAuthority(), partPath.toUri().getPath());
                if (oldPart != null && FileUtils.equalsFileSystem(oldPartPathFS = oldPartPath.getFileSystem((Configuration)this.getConf()), loadPathFS = loadPath.getFileSystem((Configuration)this.getConf()))) {
                    newPartPath = oldPartPath;
                }
            } else {
                newPartPath = oldPartPath;
            }
            if (replace) {
                Hive.replaceFiles(tbl.getPath(), loadPath, newPartPath, oldPartPath, this.getConf(), isSrcLocal);
            } else {
                FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)this.conf);
                Hive.copyFiles(this.conf, loadPath, newPartPath, fs, isSrcLocal, isAcid);
            }
            boolean forceCreate = !holdDDLTime;
            newTPart = this.getPartition(tbl, partSpec, forceCreate, newPartPath.toString(), inheritTableSpecs);
            if (!holdDDLTime && isSkewedStoreAsSubdir) {
                org.apache.hadoop.hive.metastore.api.Partition newCreatedTpart = newTPart.getTPartition();
                SkewedInfo skewedInfo = newCreatedTpart.getSd().getSkewedInfo();
                Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(newPartPath, skewedInfo);
                skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
                newCreatedTpart.getSd().setSkewedInfo(skewedInfo);
                this.alterPartition(tbl.getDbName(), tbl.getTableName(), new Partition(tbl, newCreatedTpart));
                newTPart = this.getPartition(tbl, partSpec, true, newPartPath.toString(), inheritTableSpecs);
                return new Partition(tbl, newCreatedTpart);
            }
        }
        catch (IOException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (MetaException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (InvalidOperationException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return newTPart;
    }

    private void walkDirTree(FileStatus fSta, FileSystem fSys, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) throws IOException {
        if (!fSta.isDir()) {
            this.constructOneLBLocationMap(fSta, skewedColValueLocationMaps, newPartPath, skewedInfo);
            return;
        }
        FileStatus[] children = fSys.listStatus(fSta.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        if (children != null) {
            for (FileStatus child : children) {
                this.walkDirTree(child, fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
            }
        }
    }

    private void constructOneLBLocationMap(FileStatus fSta, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) {
        String[] dirNames;
        Path lbdPath = fSta.getPath().getParent();
        ArrayList<String> skewedValue = new ArrayList<String>();
        String lbDirName = FileUtils.unescapePathName(lbdPath.toString());
        String partDirName = FileUtils.unescapePathName(newPartPath.toString());
        String lbDirSuffix = lbDirName.replace(partDirName, "");
        for (String dirName : dirNames = lbDirSuffix.split("/")) {
            String[] kv;
            if (dirName == null || dirName.length() <= 0 || dirName.equalsIgnoreCase(ListBucketingPrunerUtils.HIVE_LIST_BUCKETING_DEFAULT_DIR_NAME) || (kv = dirName.split("=")).length != 2) continue;
            skewedValue.add(kv[1]);
        }
        if (skewedValue.size() > 0 && skewedValue.size() == skewedInfo.getSkewedColNames().size() && !skewedColValueLocationMaps.containsKey(skewedValue)) {
            skewedColValueLocationMaps.put(skewedValue, lbdPath.toString());
        }
    }

    private Map<List<String>, String> constructListBucketingLocationMap(Path newPartPath, SkewedInfo skewedInfo) throws IOException, FileNotFoundException {
        HashMap<List<String>, String> skewedColValueLocationMaps = new HashMap<List<String>, String>();
        FileSystem fSys = newPartPath.getFileSystem((Configuration)this.conf);
        this.walkDirTree(fSys.getFileStatus(newPartPath), fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
        return skewedColValueLocationMaps;
    }

    public Map<Map<String, String>, Partition> loadDynamicPartitions(Path loadPath, String tableName, Map<String, String> partSpec, boolean replace, int numDP, boolean holdDDLTime, boolean listBucketingEnabled, boolean isAcid) throws HiveException {
        HashSet<Path> validPartitions = new HashSet<Path>();
        try {
            FileStatus[] leafStatus;
            LinkedHashMap<Map<String, String>, Partition> partitionsMap = new LinkedHashMap<Map<String, String>, Partition>();
            FileSystem fs = loadPath.getFileSystem((Configuration)this.conf);
            for (FileStatus s : leafStatus = HiveStatsUtils.getFileStatusRecurse(loadPath, numDP + 1, fs)) {
                if (s.isDir() && !this.conf.getBoolVar(HiveConf.ConfVars.HIVE_HADOOP_SUPPORTS_SUBDIRECTORIES)) {
                    LOG.info((Object)("NOT moving empty directory: " + s.getPath()));
                    continue;
                }
                try {
                    this.validatePartitionNameCharacters(Warehouse.getPartValuesFromPartName((String)s.getPath().getParent().toString()));
                }
                catch (MetaException e) {
                    throw new HiveException(e);
                }
                validPartitions.add(s.getPath().getParent());
            }
            if (validPartitions.size() == 0) {
                LOG.warn((Object)"No partition is generated by dynamic partitioning");
            }
            if (validPartitions.size() > this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS)) {
                throw new HiveException("Number of dynamic partitions created is " + validPartitions.size() + ", which is more than " + this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS) + ". To solve this try to set " + HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS.varname + " to at least " + validPartitions.size() + '.');
            }
            Table tbl = this.getTable(tableName);
            for (Path partPath : validPartitions) {
                assert (fs.getFileStatus(partPath).isDir()) : "partitions " + partPath + " is not a directory !";
                LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(partSpec);
                Warehouse.makeSpecFromName(fullPartSpec, (Path)partPath);
                Partition newPartition = this.loadPartition(partPath, tbl, fullPartSpec, replace, holdDDLTime, true, listBucketingEnabled, false, isAcid);
                partitionsMap.put(fullPartSpec, newPartition);
                LOG.info((Object)("New loading path = " + partPath + " with partSpec " + fullPartSpec));
            }
            return partitionsMap;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    public void loadTable(Path loadPath, String tableName, boolean replace, boolean holdDDLTime, boolean isSrcLocal, boolean isSkewedStoreAsSubdir, boolean isAcid) throws HiveException {
        Table tbl = this.getTable(tableName);
        HiveConf sessionConf = SessionState.getSessionConf();
        if (replace) {
            Path tableDest = tbl.getPath();
            Hive.replaceFiles(tableDest, loadPath, tableDest, tableDest, sessionConf, isSrcLocal);
        } else {
            try {
                FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)sessionConf);
                Hive.copyFiles(sessionConf, loadPath, tbl.getPath(), fs, isSrcLocal, isAcid);
            }
            catch (IOException e) {
                throw new HiveException("addFiles: filesystem error in check phase", e);
            }
            tbl.getParameters().put("STATS_GENERATED_VIA_STATS_TASK", "true");
        }
        try {
            if (isSkewedStoreAsSubdir) {
                SkewedInfo skewedInfo = tbl.getSkewedInfo();
                Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(tbl.getPath(), skewedInfo);
                skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
            }
        }
        catch (IOException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        if (!holdDDLTime) {
            try {
                this.alterTable(tableName, tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
        }
    }

    public Partition createPartition(Table tbl, Map<String, String> partSpec) throws HiveException {
        try {
            return new Partition(tbl, this.getMSC().add_partition(Partition.createMetaPartitionObject(tbl, partSpec, null)));
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public List<Partition> createPartitions(AddPartitionDesc addPartitionDesc) throws HiveException {
        Table tbl = this.getTable(addPartitionDesc.getDbName(), addPartitionDesc.getTableName());
        int size = addPartitionDesc.getPartitionCount();
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> in = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>(size);
        for (int i = 0; i < size; ++i) {
            in.add(this.convertAddSpecToMetaPartition(tbl, addPartitionDesc.getPartition(i)));
        }
        ArrayList<Partition> out = new ArrayList<Partition>();
        try {
            for (org.apache.hadoop.hive.metastore.api.Partition outPart : this.getMSC().add_partitions(in, addPartitionDesc.isIfNotExists(), true)) {
                out.add(new Partition(tbl, outPart));
            }
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return out;
    }

    private org.apache.hadoop.hive.metastore.api.Partition convertAddSpecToMetaPartition(Table tbl, AddPartitionDesc.OnePartitionDesc addSpec) throws HiveException {
        Path location;
        Path path = location = addSpec.getLocation() != null ? new Path(tbl.getPath(), addSpec.getLocation()) : null;
        if (location != null && !Utilities.isDefaultNameNode(this.conf)) {
            location = new Path(Utilities.getQualifiedPath(this.conf, location));
        }
        org.apache.hadoop.hive.metastore.api.Partition part = Partition.createMetaPartitionObject(tbl, addSpec.getPartSpec(), location);
        if (addSpec.getPartParams() != null) {
            part.setParameters(addSpec.getPartParams());
        }
        if (addSpec.getInputFormat() != null) {
            part.getSd().setInputFormat(addSpec.getInputFormat());
        }
        if (addSpec.getOutputFormat() != null) {
            part.getSd().setOutputFormat(addSpec.getOutputFormat());
        }
        if (addSpec.getNumBuckets() != -1) {
            part.getSd().setNumBuckets(addSpec.getNumBuckets());
        }
        if (addSpec.getCols() != null) {
            part.getSd().setCols(addSpec.getCols());
        }
        if (addSpec.getSerializationLib() != null) {
            part.getSd().getSerdeInfo().setSerializationLib(addSpec.getSerializationLib());
        }
        if (addSpec.getSerdeParams() != null) {
            part.getSd().getSerdeInfo().setParameters(addSpec.getSerdeParams());
        }
        if (addSpec.getBucketCols() != null) {
            part.getSd().setBucketCols(addSpec.getBucketCols());
        }
        if (addSpec.getSortCols() != null) {
            part.getSd().setSortCols(addSpec.getSortCols());
        }
        return part;
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate) throws HiveException {
        return this.getPartition(tbl, partSpec, forceCreate, null, true);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate, String partPath, boolean inheritTableSpecs) throws HiveException {
        tbl.validatePartColumnNames(partSpec, true);
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING) || val != null && val.length() == 0) {
                throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
            }
            if (val == null) continue;
            pvals.add(val);
        }
        org.apache.hadoop.hive.metastore.api.Partition tpart = null;
        try {
            tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, this.getUserName(), this.getGroupNames());
        }
        catch (NoSuchObjectException nsoe) {
            tpart = null;
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        try {
            if (forceCreate) {
                if (tpart == null) {
                    LOG.debug((Object)("creating partition for table " + tbl.getTableName() + " with partition spec : " + partSpec));
                    try {
                        tpart = this.getMSC().appendPartition(tbl.getDbName(), tbl.getTableName(), pvals);
                    }
                    catch (AlreadyExistsException aee) {
                        LOG.debug((Object)"Caught already exists exception, trying to alter partition instead");
                        tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, this.getUserName(), this.getGroupNames());
                        this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                    }
                    catch (Exception e) {
                        if (CheckJDOException.isJDODataStoreException(e)) {
                            LOG.debug((Object)"Caught JDO exception, trying to alter partition instead");
                            tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, this.getUserName(), this.getGroupNames());
                            if (tpart == null) {
                                throw e;
                            }
                            this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                        }
                        throw e;
                    }
                } else {
                    this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                }
            }
            if (tpart == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return new Partition(tbl, tpart);
    }

    private void alterPartitionSpec(Table tbl, Map<String, String> partSpec, org.apache.hadoop.hive.metastore.api.Partition tpart, boolean inheritTableSpecs, String partPath) throws HiveException, InvalidOperationException {
        LOG.debug((Object)("altering partition for table " + tbl.getTableName() + " with partition spec : " + partSpec));
        if (inheritTableSpecs) {
            tpart.getSd().setOutputFormat(tbl.getTTable().getSd().getOutputFormat());
            tpart.getSd().setInputFormat(tbl.getTTable().getSd().getInputFormat());
            tpart.getSd().getSerdeInfo().setSerializationLib(tbl.getSerializationLib());
            tpart.getSd().getSerdeInfo().setParameters(tbl.getTTable().getSd().getSerdeInfo().getParameters());
            tpart.getSd().setBucketCols(tbl.getBucketCols());
            tpart.getSd().setNumBuckets(tbl.getNumBuckets());
            tpart.getSd().setSortCols(tbl.getSortCols());
        }
        if (partPath == null || partPath.trim().equals("")) {
            throw new HiveException("new partition path should not be null or empty.");
        }
        tpart.getSd().setLocation(partPath);
        tpart.getParameters().put("STATS_GENERATED_VIA_STATS_TASK", "true");
        String fullName = tbl.getTableName();
        if (!StringUtils.isEmpty((String)tbl.getDbName())) {
            fullName = tbl.getDbName() + "." + tbl.getTableName();
        }
        this.alterPartition(fullName, new Partition(tbl, tpart));
    }

    public boolean dropPartition(String tblName, List<String> part_vals, boolean deleteData) throws HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        return this.dropPartition(names[0], names[1], part_vals, deleteData);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws HiveException {
        return this.dropPartition(db_name, tbl_name, part_vals, PartitionDropOptions.instance().deleteData(deleteData));
    }

    public boolean dropPartition(String dbName, String tableName, List<String> partVals, PartitionDropOptions options) throws HiveException {
        try {
            return this.getMSC().dropPartition(dbName, tableName, partVals, options);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public List<Partition> dropPartitions(String tblName, List<DropTableDesc.PartSpec> partSpecs, boolean deleteData, boolean ignoreProtection, boolean ifExists) throws HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        return this.dropPartitions(names[0], names[1], partSpecs, deleteData, ignoreProtection, ifExists);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<DropTableDesc.PartSpec> partSpecs, boolean deleteData, boolean ignoreProtection, boolean ifExists) throws HiveException {
        return this.dropPartitions(dbName, tblName, partSpecs, PartitionDropOptions.instance().deleteData(deleteData).ignoreProtection(ignoreProtection).ifExists(ifExists));
    }

    public List<Partition> dropPartitions(String tblName, List<DropTableDesc.PartSpec> partSpecs, PartitionDropOptions dropOptions) throws HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        return this.dropPartitions(names[0], names[1], partSpecs, dropOptions);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<DropTableDesc.PartSpec> partSpecs, PartitionDropOptions dropOptions) throws HiveException {
        try {
            Table tbl = this.getTable(dbName, tblName);
            ArrayList<ObjectPair<Integer, byte[]>> partExprs = new ArrayList<ObjectPair<Integer, byte[]>>(partSpecs.size());
            for (DropTableDesc.PartSpec partSpec : partSpecs) {
                partExprs.add(new ObjectPair<Integer, byte[]>(partSpec.getPrefixLength(), Utilities.serializeExpressionToKryo(partSpec.getPartSpec())));
            }
            List tParts = this.getMSC().dropPartitions(dbName, tblName, partExprs, dropOptions);
            return Hive.convertFromMetastore(tbl, tParts, null);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public List<String> getPartitionNames(String tblName, short max) throws HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        return this.getPartitionNames(names[0], names[1], max);
    }

    public List<String> getPartitionNames(String dbName, String tblName, short max) throws HiveException {
        List names = null;
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, max);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<String> getPartitionNames(String dbName, String tblName, Map<String, String> partSpec, short max) throws HiveException {
        List names = null;
        Table t = this.getTable(dbName, tblName);
        List pvals = MetaStoreUtils.getPvals(t.getPartCols(), partSpec);
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, pvals, max);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<Partition> getPartitions(Table tbl) throws HiveException {
        if (tbl.isPartitioned()) {
            List tParts;
            try {
                tParts = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), (short)-1, this.getUserName(), this.getGroupNames());
            }
            catch (Exception e) {
                LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                throw new HiveException(e);
            }
            ArrayList<Partition> parts = new ArrayList<Partition>(tParts.size());
            for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                parts.add(new Partition(tbl, tpart));
            }
            return parts;
        }
        Partition part = new Partition(tbl);
        ArrayList<Partition> parts = new ArrayList<Partition>(1);
        parts.add(part);
        return parts;
    }

    public Set<Partition> getAllPartitionsOf(Table tbl) throws HiveException {
        List tParts;
        if (!tbl.isPartitioned()) {
            return Sets.newHashSet((Object[])new Partition[]{new Partition(tbl)});
        }
        try {
            tParts = this.getMSC().listPartitions(tbl.getDbName(), tbl.getTableName(), (short)-1);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        LinkedHashSet<Partition> parts = new LinkedHashSet<Partition>(tParts.size());
        for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
            parts.add(new Partition(tbl, tpart));
        }
        return parts;
    }

    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec, short limit) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List partialPvals = MetaStoreUtils.getPvals(tbl.getPartCols(), partialPartSpec);
        List partitions = null;
        try {
            partitions = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), partialPvals, limit, this.getUserName(), this.getGroupNames());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        ArrayList<Partition> qlPartitions = new ArrayList<Partition>();
        for (org.apache.hadoop.hive.metastore.api.Partition p : partitions) {
            qlPartitions.add(new Partition(tbl, p));
        }
        return qlPartitions;
    }

    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        return this.getPartitions(tbl, partialPartSpec, (short)-1);
    }

    public List<Partition> getPartitionsByNames(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List<String> names = this.getPartitionNames(tbl.getDbName(), tbl.getTableName(), partialPartSpec, (short)-1);
        List<Partition> partitions = this.getPartitionsByNames(tbl, names);
        return partitions;
    }

    public List<Partition> getPartitionsByNames(Table tbl, List<String> partNames) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>(partNames.size());
        int batchSize = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
        int nParts = partNames.size();
        int nBatches = nParts / batchSize;
        try {
            List tParts;
            for (int i = 0; i < nBatches; ++i) {
                List tParts2 = this.getMSC().getPartitionsByNames(tbl.getDbName(), tbl.getTableName(), partNames.subList(i * batchSize, (i + 1) * batchSize));
                if (tParts2 == null) continue;
                for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts2) {
                    partitions.add(new Partition(tbl, tpart));
                }
            }
            if (nParts > nBatches * batchSize && (tParts = this.getMSC().getPartitionsByNames(tbl.getDbName(), tbl.getTableName(), partNames.subList(nBatches * batchSize, nParts))) != null) {
                for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                    partitions.add(new Partition(tbl, tpart));
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return partitions;
    }

    public List<Partition> getPartitionsByFilter(Table tbl, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List tParts = this.getMSC().listPartitionsByFilter(tbl.getDbName(), tbl.getTableName(), filter, (short)-1);
        return Hive.convertFromMetastore(tbl, tParts, null);
    }

    private static List<Partition> convertFromMetastore(Table tbl, List<org.apache.hadoop.hive.metastore.api.Partition> src, List<Partition> dest) throws HiveException {
        if (src == null) {
            return dest;
        }
        if (dest == null) {
            dest = new ArrayList<Partition>(src.size());
        }
        for (org.apache.hadoop.hive.metastore.api.Partition tPart : src) {
            dest.add(new Partition(tbl, tPart));
        }
        return dest;
    }

    public boolean getPartitionsByExpr(Table tbl, ExprNodeGenericFuncDesc expr, HiveConf conf, List<Partition> result) throws HiveException, TException {
        assert (result != null);
        byte[] exprBytes = Utilities.serializeExpressionToKryo(expr);
        String defaultPartitionName = HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> msParts = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        boolean hasUnknownParts = this.getMSC().listPartitionsByExpr(tbl.getDbName(), tbl.getTableName(), exprBytes, defaultPartitionName, (short)-1, msParts);
        Hive.convertFromMetastore(tbl, msParts, result);
        return hasUnknownParts;
    }

    public void validatePartitionNameCharacters(List<String> partVals) throws HiveException {
        try {
            this.getMSC().validatePartitionNameCharacters(partVals);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void createRole(String roleName, String ownerName) throws HiveException {
        try {
            this.getMSC().create_role(new Role(roleName, -1, ownerName));
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropRole(String roleName) throws HiveException {
        try {
            this.getMSC().drop_role(roleName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllRoleNames() throws HiveException {
        try {
            return this.getMSC().listRoleNames();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<RolePrincipalGrant> getRoleGrantInfoForPrincipal(String principalName, PrincipalType principalType) throws HiveException {
        try {
            GetRoleGrantsForPrincipalRequest req = new GetRoleGrantsForPrincipalRequest(principalName, principalType);
            GetRoleGrantsForPrincipalResponse resp = this.getMSC().get_role_grants_for_principal(req);
            return resp.getPrincipalGrants();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantRole(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().grant_role(roleName, userName, principalType, grantor, grantorType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokeRole(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_role(roleName, userName, principalType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<Role> listRoles(String userName, PrincipalType principalType) throws HiveException {
        try {
            return this.getMSC().list_roles(userName, principalType);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectType objectType, String db_name, String table_name, List<String> part_values, String column_name, String user_name, List<String> group_names) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, db_name, table_name, part_values, column_name);
            return this.getMSC().get_privilege_set(hiveObj, user_name, group_names);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<HiveObjectPrivilege> showPrivilegeGrant(HiveObjectType objectType, String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String columnName) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, dbName, tableName, partValues, columnName);
            return this.getMSC().list_privileges(principalName, principalType, hiveObj);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private static List<List<Path[]>> checkPaths(HiveConf conf, FileSystem fs, FileStatus[] srcs, FileSystem srcFs, Path destf, boolean replace) throws HiveException {
        ArrayList<List<Path[]>> result = new ArrayList<List<Path[]>>();
        try {
            FileStatus destStatus;
            FileStatus fileStatus = destStatus = !replace && fs.exists(destf) ? fs.getFileStatus(destf) : null;
            if (destStatus != null && !destStatus.isDir()) {
                throw new HiveException("checkPaths: destination " + destf + " should be a directory");
            }
            for (FileStatus src : srcs) {
                Object[] items;
                if (src.isDir()) {
                    items = srcFs.listStatus(src.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                    Arrays.sort(items);
                } else {
                    items = new FileStatus[]{src};
                }
                ArrayList<Path[]> srcToDest = new ArrayList<Path[]>();
                for (Object item : items) {
                    String filetype;
                    Path itemSource = item.getPath();
                    if (Utilities.isTempPath((FileStatus)item)) {
                        srcFs.delete(itemSource, true);
                        continue;
                    }
                    if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_HADOOP_SUPPORTS_SUBDIRECTORIES) && !HiveConf.getVar(conf, HiveConf.ConfVars.STAGINGDIR).equals(itemSource.getName()) && item.isDir()) {
                        throw new HiveException("checkPaths: " + src.getPath() + " has nested directory " + itemSource);
                    }
                    String name = itemSource.getName();
                    int index = name.lastIndexOf(46);
                    if (index >= 0) {
                        filetype = name.substring(index);
                        name = name.substring(0, index);
                    } else {
                        filetype = "";
                    }
                    Path itemDest = new Path(destf, itemSource.getName());
                    if (!replace) {
                        int counter = 1;
                        while (fs.exists(itemDest) || Hive.destExists(result, itemDest)) {
                            itemDest = new Path(destf, name + "_copy_" + counter + filetype);
                            ++counter;
                        }
                    }
                    srcToDest.add(new Path[]{itemSource, itemDest});
                }
                result.add(srcToDest);
            }
        }
        catch (IOException e) {
            throw new HiveException("checkPaths: filesystem error in check phase. " + e.getMessage(), e);
        }
        return result;
    }

    private static boolean destExists(List<List<Path[]>> result, Path proposed) {
        for (List<Path[]> sdpairs : result) {
            for (Path[] sdpair : sdpairs) {
                if (!sdpair[1].equals((Object)proposed)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSubDir(Path srcf, Path destf, FileSystem srcFs, FileSystem destFs, boolean isSrcLocal) {
        if (srcf == null) {
            LOG.debug((Object)"The source path is null for isSubDir method.");
            return false;
        }
        String fullF1 = Hive.getQualifiedPathWithoutSchemeAndAuthority(srcf, srcFs);
        String fullF2 = Hive.getQualifiedPathWithoutSchemeAndAuthority(destf, destFs);
        boolean isInTest = HiveConf.getBoolVar(srcFs.getConf(), HiveConf.ConfVars.HIVE_IN_TEST);
        LOG.debug((Object)("The source path is " + fullF1 + " and the destination path is " + fullF2));
        if (isInTest) {
            return fullF1.startsWith(fullF2);
        }
        String schemaSrcf = srcf.toUri().getScheme();
        String schemaDestf = destf.toUri().getScheme();
        if (schemaDestf == null && isSrcLocal) {
            LOG.debug((Object)"The source file is in the local while the dest not.");
            return false;
        }
        if (schemaSrcf != null && schemaDestf != null && !schemaSrcf.equals(schemaDestf)) {
            LOG.debug((Object)("The source path's schema is " + schemaSrcf + " and the destination path's schema is " + schemaDestf + "."));
            return false;
        }
        LOG.debug((Object)("The source path is " + fullF1 + " and the destination path is " + fullF2));
        return fullF1.startsWith(fullF2);
    }

    private static String getQualifiedPathWithoutSchemeAndAuthority(Path srcf, FileSystem fs) {
        Path currentWorkingDir = fs.getWorkingDirectory();
        Path path = srcf.makeQualified(srcf.toUri(), currentWorkingDir);
        return ShimLoader.getHadoopShims().getPathWithoutSchemeAndAuthority(path).toString();
    }

    public static boolean moveFile(HiveConf conf, Path srcf, Path destf, boolean replace, boolean isSrcLocal) throws HiveException {
        FileSystem srcFs;
        FileSystem destFs;
        boolean success = false;
        try {
            destFs = destf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new HiveException(e.getMessage(), e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new HiveException(e.getMessage(), e);
        }
        boolean inheritPerms = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
        HadoopShims shims = ShimLoader.getHadoopShims();
        HadoopShims.HdfsFileStatus destStatus = null;
        boolean destIsSubDir = Hive.isSubDir(srcf, destf, srcFs, destFs, isSrcLocal);
        try {
            block22: {
                if (inheritPerms || replace) {
                    try {
                        destStatus = shims.getFullFileStatus((Configuration)conf, destFs, destf.getParent());
                        if (replace && !destIsSubDir) {
                            LOG.debug((Object)("The path " + destf.toString() + " is deleted"));
                            destFs.delete(destf, true);
                        }
                    }
                    catch (FileNotFoundException ignore) {
                        if (!inheritPerms) break block22;
                        destStatus = shims.getFullFileStatus((Configuration)conf, destFs, destf.getParent());
                    }
                }
            }
            if (isSrcLocal) {
                destFs.copyFromLocalFile(srcf, destf);
                success = true;
            } else if (Hive.needToCopy(srcf, destf, srcFs, destFs)) {
                LOG.info((Object)("Copying source " + srcf + " to " + destf + " because HDFS encryption zones are different."));
                success = FileUtils.copy(srcf.getFileSystem((Configuration)conf), srcf, destf.getFileSystem((Configuration)conf), destf, true, replace, conf);
            } else if (destIsSubDir) {
                FileStatus[] srcs = destFs.listStatus(srcf, FileUtils.HIDDEN_FILES_PATH_FILTER);
                if (srcs.length == 0) {
                    success = true;
                }
                for (FileStatus status : srcs) {
                    Path destFile = destFs.isDirectory(destf) ? new Path(destf, status.getPath().getName()) : destf;
                    if (destFs.exists(destFile) && !destFs.delete(destFile, true)) {
                        throw new HiveException(String.format("File to replace could not be deleted: %s", destFile));
                    }
                    if (destFs.rename(status.getPath(), destFile)) continue;
                    throw new HiveException("Unable to move source " + status.getPath() + " to destination " + destf);
                }
                success = true;
            } else {
                success = destFs.rename(srcf, destf);
            }
            LOG.info((Object)((replace ? "Replacing src:" : "Renaming src: ") + srcf.toString() + ", dest: " + destf.toString() + ", Status:" + success));
        }
        catch (IOException ioe) {
            throw new HiveException("Unable to move source " + srcf + " to destination " + destf, ioe);
        }
        if (success && inheritPerms) {
            try {
                ShimLoader.getHadoopShims().setFullFileStatus((Configuration)conf, destStatus, destFs, destf);
            }
            catch (IOException e) {
                LOG.warn((Object)("Error setting permission of file " + destf + ": " + e.getMessage()), (Throwable)e);
            }
        }
        return success;
    }

    protected static boolean needToCopy(Path srcf, Path destf, FileSystem srcFs, FileSystem destFs) throws HiveException, IOException {
        if (!srcFs.getClass().equals(destFs.getClass())) {
            return true;
        }
        HadoopShims.HdfsEncryptionShim hdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim();
        return hdfsEncryptionShim != null && (hdfsEncryptionShim.isPathEncrypted(srcf) || hdfsEncryptionShim.isPathEncrypted(destf)) && !hdfsEncryptionShim.arePathsOnSameEncryptionZone(srcf, destf);
    }

    protected static void copyFiles(HiveConf conf, Path srcf, Path destf, FileSystem fs, boolean isSrcLocal, boolean isAcid) throws HiveException {
        FileStatus[] srcs;
        FileSystem srcFs;
        boolean inheritPerms = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
        try {
            if (!fs.exists(destf)) {
                FileUtils.mkdir(fs, destf, inheritPerms, conf);
            }
        }
        catch (IOException e) {
            throw new HiveException("copyFiles: error while checking/creating destination directory!!!", e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
            srcs = srcFs.globStatus(srcf);
        }
        catch (IOException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException("addFiles: filesystem error in check phase. " + e.getMessage(), e);
        }
        if (srcs == null) {
            LOG.info((Object)("No sources specified to move: " + srcf));
            return;
        }
        if (isAcid) {
            Hive.moveAcidFiles(srcFs, srcs, destf);
        } else {
            List<List<Path[]>> result = Hive.checkPaths(conf, fs, srcs, srcFs, destf, false);
            try {
                for (List<Path[]> sdpairs : result) {
                    for (Path[] sdpair : sdpairs) {
                        if (Hive.moveFile(conf, sdpair[0], sdpair[1], false, isSrcLocal)) continue;
                        throw new IOException("Cannot move " + sdpair[0] + " to " + sdpair[1]);
                    }
                }
            }
            catch (IOException e) {
                throw new HiveException("copyFiles: error while moving files!!! " + e.getMessage(), e);
            }
        }
    }

    private static void moveAcidFiles(FileSystem fs, FileStatus[] stats, Path dst) throws HiveException {
        HashSet<Path> createdDeltaDirs = new HashSet<Path>();
        for (FileStatus stat : stats) {
            Path srcPath = stat.getPath();
            LOG.debug((Object)("Acid move Looking for original buckets in " + srcPath));
            FileStatus[] origBucketStats = null;
            try {
                origBucketStats = fs.listStatus(srcPath, AcidUtils.originalBucketFilter);
            }
            catch (IOException e) {
                String msg = "Unable to look for bucket files in src path " + srcPath.toUri().toString();
                LOG.error((Object)msg);
                throw new HiveException(msg, e);
            }
            LOG.debug((Object)("Acid move found " + origBucketStats.length + " original buckets"));
            for (FileStatus origBucketStat : origBucketStats) {
                Path origBucketPath = origBucketStat.getPath();
                LOG.debug((Object)("Acid move looking for delta files in bucket " + origBucketPath));
                FileStatus[] deltaStats = null;
                try {
                    deltaStats = fs.listStatus(origBucketPath, AcidUtils.deltaFileFilter);
                }
                catch (IOException e) {
                    throw new HiveException("Unable to look for delta files in original bucket " + origBucketPath.toUri().toString(), e);
                }
                LOG.debug((Object)("Acid move found " + deltaStats.length + " delta files"));
                for (FileStatus deltaStat : deltaStats) {
                    Path deltaPath = deltaStat.getPath();
                    Path deltaDest = new Path(dst, deltaPath.getName());
                    try {
                        if (!createdDeltaDirs.contains(deltaDest)) {
                            try {
                                fs.mkdirs(deltaDest);
                                createdDeltaDirs.add(deltaDest);
                            }
                            catch (IOException swallowIt) {
                                LOG.info((Object)("Unable to create delta directory " + deltaDest + ", assuming it already exists: " + swallowIt.getMessage()));
                            }
                        }
                        FileStatus[] bucketStats = fs.listStatus(deltaPath, AcidUtils.bucketFileFilter);
                        LOG.debug((Object)("Acid move found " + bucketStats.length + " bucket files"));
                        for (FileStatus bucketStat : bucketStats) {
                            Path bucketSrc = bucketStat.getPath();
                            Path bucketDest = new Path(deltaDest, bucketSrc.getName());
                            LOG.info((Object)("Moving bucket " + bucketSrc.toUri().toString() + " to " + bucketDest.toUri().toString()));
                            fs.rename(bucketSrc, bucketDest);
                        }
                    }
                    catch (IOException e) {
                        throw new HiveException("Error moving acid files " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected static void replaceFiles(Path tablePath, Path srcf, Path destf, Path oldPath, HiveConf conf, boolean isSrcLocal) throws HiveException {
        try {
            boolean destfExist;
            FileStatus[] srcs;
            FileSystem srcFs;
            FileSystem destFs = destf.getFileSystem((Configuration)conf);
            boolean inheritPerms = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
            try {
                srcFs = srcf.getFileSystem((Configuration)conf);
                srcs = srcFs.globStatus(srcf);
            }
            catch (IOException e) {
                throw new HiveException("Getting globStatus " + srcf.toString(), e);
            }
            if (srcs == null) {
                LOG.info((Object)("No sources specified to move: " + srcf));
                return;
            }
            List<List<Path[]>> result = Hive.checkPaths(conf, destFs, srcs, srcFs, destf, true);
            if (oldPath != null) {
                boolean oldPathDeleted = false;
                boolean isOldPathUnderDestf = false;
                try {
                    FileSystem fs2 = oldPath.getFileSystem((Configuration)conf);
                    if (fs2.exists(oldPath) && (isOldPathUnderDestf = FileUtils.isSubDir(oldPath, destf, fs2))) {
                        oldPathDeleted = FileUtils.trashFilesUnderDir(fs2, oldPath, conf);
                    }
                }
                catch (IOException e) {
                    if (isOldPathUnderDestf) {
                        throw new HiveException("Directory " + oldPath.toString() + " could not be cleaned up.", e);
                    }
                    LOG.warn((Object)("Directory " + oldPath.toString() + " cannot be cleaned: " + e), (Throwable)e);
                }
                if (isOldPathUnderDestf && !oldPathDeleted) {
                    throw new HiveException("Destination directory " + destf + " has not be cleaned up.");
                }
            }
            if (!(destfExist = FileUtils.mkdir(destFs, destf, true, conf))) {
                throw new IOException("Directory " + destf.toString() + " does not exist and could not be created.");
            }
            for (List<Path[]> sdpairs : result) {
                for (Path[] sdpair : sdpairs) {
                    if (Hive.moveFile(conf, sdpair[0], sdpair[1], true, isSrcLocal)) continue;
                    throw new IOException("Error moving: " + sdpair[0] + " into: " + sdpair[1]);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public static boolean isHadoop1() {
        return ShimLoader.getMajorVersion().startsWith("0.20");
    }

    public void exchangeTablePartitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws HiveException {
        try {
            this.getMSC().exchange_partition(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
        }
        catch (Exception ex) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            throw new HiveException(ex);
        }
    }

    private IMetaStoreClient createMetaStoreClient() throws MetaException {
        HiveMetaHookLoader hookLoader = new HiveMetaHookLoader(){

            public HiveMetaHook getHook(org.apache.hadoop.hive.metastore.api.Table tbl) throws MetaException {
                try {
                    if (tbl == null) {
                        return null;
                    }
                    HiveStorageHandler storageHandler = HiveUtils.getStorageHandler(Hive.this.conf, (String)tbl.getParameters().get("storage_handler"));
                    if (storageHandler == null) {
                        return null;
                    }
                    return storageHandler.getMetaHook();
                }
                catch (HiveException ex) {
                    LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
                    throw new MetaException("Failed to load storage handler:  " + ex.getMessage());
                }
            }
        };
        return RetryingMetaStoreClient.getProxy((HiveConf)this.conf, (HiveMetaHookLoader)hookLoader, this.metaCallTimeMap, (String)SessionHiveMetaStoreClient.class.getName());
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized IMetaStoreClient getMSC() throws MetaException {
        if (this.metaStoreClient == null) {
            try {
                this.owner = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                String msg = "Error getting current user: " + e.getMessage();
                LOG.error((Object)msg, (Throwable)e);
                throw new MetaException(msg + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            this.metaStoreClient = this.createMetaStoreClient();
            String metaStoreUris = this.conf.getVar(HiveConf.ConfVars.METASTOREURIS);
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)metaStoreUris)) {
                this.metaStoreClient = HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)this.metaStoreClient);
            }
        }
        return this.metaStoreClient;
    }

    private String getUserName() {
        return SessionState.getUserFromAuthenticator();
    }

    private List<String> getGroupNames() {
        SessionState ss = SessionState.get();
        if (ss != null && ss.getAuthenticator() != null) {
            return ss.getAuthenticator().getGroupNames();
        }
        return null;
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String name, Deserializer serde) throws HiveException {
        try {
            return MetaStoreUtils.getFieldsFromDeserializer((String)name, (Deserializer)serde);
        }
        catch (SerDeException e) {
            throw new HiveException("Error in getting fields from serde. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Error in getting fields from serde." + e.getMessage(), e);
        }
    }

    public List<Index> getIndexes(String dbName, String tblName, short max) throws HiveException {
        List indexes = null;
        try {
            indexes = this.getMSC().listIndexes(dbName, tblName, max);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return indexes;
    }

    public boolean updateTableColumnStatistics(ColumnStatistics statsObj) throws HiveException {
        try {
            return this.getMSC().updateTableColumnStatistics(statsObj);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj) throws HiveException {
        try {
            return this.getMSC().updatePartitionColumnStatistics(statsObj);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws HiveException {
        try {
            return this.getMSC().setPartitionColumnStatistics(request);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws HiveException {
        try {
            return this.getMSC().getTableColumnStatistics(dbName, tableName, colNames);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames) throws HiveException {
        try {
            return this.getMSC().getPartitionColumnStatistics(dbName, tableName, partNames, colNames);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) {
        try {
            return this.getMSC().getAggrColStatsFor(dbName, tblName, colNames, partName);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws HiveException {
        try {
            return this.getMSC().deleteTableColumnStatistics(dbName, tableName, colName);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws HiveException {
        try {
            return this.getMSC().deletePartitionColumnStatistics(dbName, tableName, partName, colName);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public Table newTable(String tableName) throws HiveException {
        String[] names = Utilities.getDbTableName(tableName);
        return new Table(names[0], names[1]);
    }

    public String getDelegationToken(String owner, String renewer) throws HiveException {
        try {
            return this.getMSC().getDelegationToken(owner, renewer);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void cancelDelegationToken(String tokenStrForm) throws HiveException {
        try {
            this.getMSC().cancelDelegationToken(tokenStrForm);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void compact(String dbname, String tableName, String partName, String compactType) throws HiveException {
        try {
            CompactionType cr = null;
            if ("major".equals(compactType)) {
                cr = CompactionType.MAJOR;
            } else if ("minor".equals(compactType)) {
                cr = CompactionType.MINOR;
            } else {
                throw new RuntimeException("Unknown compaction type " + compactType);
            }
            this.getMSC().compact(dbname, tableName, partName, cr);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public ShowCompactResponse showCompactions() throws HiveException {
        try {
            return this.getMSC().showCompactions();
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public GetOpenTxnsInfoResponse showTransactions() throws HiveException {
        try {
            return this.getMSC().showTxns();
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void createFunction(Function func) throws HiveException {
        try {
            this.getMSC().createFunction(func);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void alterFunction(String dbName, String funcName, Function newFunction) throws HiveException {
        try {
            this.getMSC().alterFunction(dbName, funcName, newFunction);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void dropFunction(String dbName, String funcName) throws HiveException {
        try {
            this.getMSC().dropFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public Function getFunction(String dbName, String funcName) throws HiveException {
        try {
            return this.getMSC().getFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public List<Function> getAllFunctions() throws HiveException {
        try {
            List functions = this.getMSC().getAllFunctions().getFunctions();
            return functions == null ? new ArrayList() : functions;
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public List<String> getFunctions(String dbName, String pattern) throws HiveException {
        try {
            return this.getMSC().getFunctions(dbName, pattern);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void setMetaConf(String propName, String propValue) throws HiveException {
        try {
            this.getMSC().setMetaConf(propName, propValue);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public String getMetaConf(String propName) throws HiveException {
        try {
            return this.getMSC().getMetaConf(propName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void clearMetaCallTiming() {
        this.metaCallTimeMap.clear();
    }

    public ImmutableMap<String, Long> dumpAndClearMetaCallTiming(String phase) {
        boolean phaseInfoLogged = false;
        if (LOG.isDebugEnabled()) {
            phaseInfoLogged = this.logDumpPhase(phase);
            LOG.debug((Object)("Total time spent in each metastore function (ms): " + this.metaCallTimeMap));
        }
        if (LOG.isInfoEnabled()) {
            for (Map.Entry<String, Long> callTime : this.metaCallTimeMap.entrySet()) {
                if (callTime.getValue() <= 1000L) continue;
                if (!phaseInfoLogged) {
                    phaseInfoLogged = this.logDumpPhase(phase);
                }
                LOG.info((Object)("Total time spent in this metastore function was greater than 1000ms : " + callTime));
            }
        }
        ImmutableMap result = ImmutableMap.copyOf(this.metaCallTimeMap);
        this.metaCallTimeMap.clear();
        return result;
    }

    private boolean logDumpPhase(String phase) {
        LOG.info((Object)("Dumping metastore api call timing information for : " + phase + " phase"));
        return true;
    }
}

