/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;

public class ColumnPrunerProcCtx
implements NodeProcessorCtx {
    private final ParseContext pctx;
    private final Map<Operator<? extends OperatorDesc>, List<String>> prunedColLists;
    private final Map<CommonJoinOperator, Map<Byte, List<String>>> joinPrunedColLists;
    private final Map<UnionOperator, List<Integer>> unionPrunedColLists;

    public ColumnPrunerProcCtx(ParseContext pctx) {
        this.pctx = pctx;
        this.prunedColLists = new HashMap<Operator<? extends OperatorDesc>, List<String>>();
        this.joinPrunedColLists = new HashMap<CommonJoinOperator, Map<Byte, List<String>>>();
        this.unionPrunedColLists = new HashMap<UnionOperator, List<Integer>>();
    }

    public ParseContext getParseContext() {
        return this.pctx;
    }

    public Map<CommonJoinOperator, Map<Byte, List<String>>> getJoinPrunedColLists() {
        return this.joinPrunedColLists;
    }

    public Map<UnionOperator, List<Integer>> getUnionPrunedColLists() {
        return this.unionPrunedColLists;
    }

    public List<String> getPrunedColList(Operator<? extends OperatorDesc> op) {
        return this.prunedColLists.get(op);
    }

    public Map<Operator<? extends OperatorDesc>, List<String>> getPrunedColLists() {
        return this.prunedColLists;
    }

    public List<String> genColLists(Operator<? extends OperatorDesc> curOp) throws SemanticException {
        if (curOp.getChildOperators() == null) {
            return null;
        }
        List<String> colList = null;
        for (Operator<OperatorDesc> child : curOp.getChildOperators()) {
            List<String> prunList = null;
            if (child instanceof CommonJoinOperator) {
                int tag = child.getParentOperators().indexOf(curOp);
                prunList = this.joinPrunedColLists.get(child).get((byte)tag);
            } else if (child instanceof UnionOperator) {
                List<Integer> positions = this.unionPrunedColLists.get(child);
                if (positions != null) {
                    prunList = new ArrayList<String>();
                    RowSchema oldRS = curOp.getSchema();
                    for (Integer pos : positions) {
                        ColumnInfo colInfo = oldRS.getSignature().get(pos);
                        prunList.add(colInfo.getInternalName());
                    }
                }
            } else {
                prunList = this.prunedColLists.get(child);
            }
            if (prunList == null) continue;
            if (colList == null) {
                colList = new ArrayList<String>(prunList);
                continue;
            }
            colList = Utilities.mergeUniqElems(colList, prunList);
        }
        return colList;
    }

    public List<String> genColLists(Operator<? extends OperatorDesc> curOp, Operator<? extends OperatorDesc> child) throws SemanticException {
        if (curOp.getChildOperators() == null) {
            return null;
        }
        if (child instanceof CommonJoinOperator) {
            int tag = child.getParentOperators().indexOf(curOp);
            return this.joinPrunedColLists.get(child).get((byte)tag);
        }
        if (child instanceof UnionOperator) {
            List<Integer> positions = this.unionPrunedColLists.get(child);
            ArrayList<String> prunList = new ArrayList<String>();
            if (positions != null && positions.size() > 0) {
                RowSchema oldRS = curOp.getSchema();
                for (Integer pos : positions) {
                    ColumnInfo colInfo = oldRS.getSignature().get(pos);
                    prunList.add(colInfo.getInternalName());
                }
            }
            return prunList;
        }
        return this.prunedColLists.get(child);
    }

    public List<String> getColsFromSelectExpr(SelectOperator op) {
        List<String> cols = new ArrayList<String>();
        SelectDesc conf = (SelectDesc)op.getConf();
        if (conf.isSelStarNoCompute()) {
            for (ColumnInfo colInfo : op.getSchema().getSignature()) {
                cols.add(colInfo.getInternalName());
            }
        } else {
            List<ExprNodeDesc> exprList = conf.getColList();
            for (ExprNodeDesc expr : exprList) {
                cols = Utilities.mergeUniqElems(cols, expr.getCols());
            }
        }
        return cols;
    }

    public List<String> getSelectColsFromChildren(SelectOperator op, List<String> colList) {
        List<String> cols = new ArrayList<String>();
        SelectDesc conf = (SelectDesc)op.getConf();
        if (colList != null && conf.isSelStarNoCompute()) {
            cols.addAll(colList);
            return cols;
        }
        List<ExprNodeDesc> selectExprs = conf.getColList();
        List<String> outputColumnNames = conf.getOutputColumnNames();
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            if (colList != null && !colList.contains(outputColumnNames.get(i))) continue;
            ExprNodeDesc expr = selectExprs.get(i);
            cols = Utilities.mergeUniqElems(cols, expr.getCols());
        }
        return cols;
    }

    public List<String> getSelectColsFromLVJoin(RowSchema rs, List<String> colList) throws SemanticException {
        ArrayList<String> columns = new ArrayList<String>();
        for (String col : colList) {
            if (rs.getColumnInfo(col) == null) continue;
            columns.add(col);
        }
        return columns;
    }

    public void handleFilterUnionChildren(Operator<? extends OperatorDesc> curOp) throws SemanticException {
        if (curOp.getChildOperators() == null || !(curOp instanceof FilterOperator)) {
            return;
        }
        List<String> parentPrunList = this.prunedColLists.get(curOp);
        if (parentPrunList == null || parentPrunList.size() == 0) {
            return;
        }
        FilterOperator filOp = (FilterOperator)curOp;
        List<String> prunList = null;
        Object childToParentIndex = null;
        for (Operator<OperatorDesc> child : curOp.getChildOperators()) {
            if (!(child instanceof UnionOperator) || (prunList = this.genColLists(curOp, child)) == null || prunList.size() == 0 || parentPrunList.size() == prunList.size()) continue;
            ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
            ArrayList<String> outputColNames = new ArrayList<String>();
            HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
            ArrayList<ColumnInfo> outputRS = new ArrayList<ColumnInfo>();
            for (ColumnInfo colInfo : child.getSchema().getSignature()) {
                if (!prunList.contains(colInfo.getInternalName())) continue;
                ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
                exprs.add(colDesc);
                outputColNames.add(colInfo.getInternalName());
                ColumnInfo newCol = new ColumnInfo(colInfo.getInternalName(), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
                newCol.setAlias(colInfo.getAlias());
                outputRS.add(newCol);
                colExprMap.put(colInfo.getInternalName(), colDesc);
            }
            SelectDesc select = new SelectDesc(exprs, outputColNames, false);
            curOp.removeChild(child);
            SelectOperator sel = (SelectOperator)OperatorFactory.getAndMakeChild(select, new RowSchema(outputRS), curOp);
            OperatorFactory.makeChild(sel, child);
            sel.setColumnExprMap(colExprMap);
        }
    }
}

