/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.thrift.TException;
import org.spark_project.guava.collect.Lists;

public class StatsOptimizer
implements Transform {
    private static final Log Log = LogFactory.getLog(StatsOptimizer.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        if (pctx.getFetchTask() != null || !pctx.getQB().getIsQuery() || pctx.getQB().isAnalyzeRewrite() || pctx.getQB().isCTAS() || pctx.getLoadFileWork().size() > 1 || !pctx.getLoadTableWork().isEmpty()) {
            return pctx;
        }
        String TS = TableScanOperator.getOperatorName() + "%";
        String GBY = GroupByOperator.getOperatorName() + "%";
        String RS = ReduceSinkOperator.getOperatorName() + "%";
        String SEL = SelectOperator.getOperatorName() + "%";
        String FS = FileSinkOperator.getOperatorName() + "%";
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TS + SEL + GBY + RS + GBY + SEL + FS), new MetaDataProcessor(pctx));
        opRules.put(new RuleRegExp("R2", TS + SEL + GBY + RS + GBY + FS), new MetaDataProcessor(pctx));
        StatsOptimizerProcContext soProcCtx = new StatsOptimizerProcContext();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, soProcCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class MetaDataProcessor
    implements NodeProcessor {
        private final ParseContext pctx;

        public MetaDataProcessor(ParseContext pctx) {
            this.pctx = pctx;
        }

        private StatType getType(String origType) {
            if (serdeConstants.IntegralTypes.contains(origType)) {
                return StatType.Integeral;
            }
            if (origType.equals("double") || origType.equals("float")) {
                return StatType.Double;
            }
            if (origType.equals("binary")) {
                return StatType.Binary;
            }
            if (origType.equals("boolean")) {
                return StatType.Boolean;
            }
            if (origType.equals("string")) {
                return StatType.String;
            }
            return StatType.Unsupported;
        }

        private Long getNullcountFor(StatType type, ColumnStatisticsData statData) {
            switch (type) {
                case Integeral: {
                    return statData.getLongStats().getNumNulls();
                }
                case Double: {
                    return statData.getDoubleStats().getNumNulls();
                }
                case String: {
                    return statData.getStringStats().getNumNulls();
                }
                case Boolean: {
                    return statData.getBooleanStats().getNumNulls();
                }
                case Binary: {
                    return statData.getBinaryStats().getNumNulls();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            StatsOptimizerProcContext soProcCtx = (StatsOptimizerProcContext)procCtx;
            if (soProcCtx.stopProcess) {
                return null;
            }
            boolean isOptimized = false;
            try {
                FileSinkOperator fsOp;
                TableScanOperator tsOp = (TableScanOperator)stack.get(0);
                if (tsOp.getParentOperators() != null && tsOp.getParentOperators().size() > 0) {
                    Object var8_9 = null;
                    return var8_9;
                }
                SelectOperator selOp = (SelectOperator)((ArrayList)tsOp.getChildren()).get(0);
                for (ExprNodeDesc desc : ((SelectDesc)selOp.getConf()).getColList()) {
                    if (desc instanceof ExprNodeColumnDesc || desc instanceof ExprNodeConstantDesc) continue;
                    Object var11_13 = null;
                    return var11_13;
                }
                Map<String, ExprNodeDesc> exprMap = selOp.getColumnExprMap();
                GroupByOperator gbyOp = (GroupByOperator)((ArrayList)selOp.getChildren()).get(0);
                ReduceSinkOperator rsOp = (ReduceSinkOperator)((ArrayList)gbyOp.getChildren()).get(0);
                if (((ReduceSinkDesc)rsOp.getConf()).getDistinctColumnIndices().size() > 0) {
                    Object var12_15 = null;
                    return var12_15;
                }
                SelectOperator last = rsOp.getChildOperators().get(0);
                if (last.getChildOperators().get(0) instanceof SelectOperator) {
                    last = selOp = (SelectOperator)rsOp.getChildOperators().get(0).getChildOperators().get(0);
                    if (((SelectDesc)selOp.getConf()).getColList().size() != ((GroupByDesc)gbyOp.getConf()).getAggregators().size()) {
                        Object var13_17 = null;
                        return var13_17;
                    }
                    for (ExprNodeDesc desc : ((SelectDesc)selOp.getConf()).getColList()) {
                        if (desc instanceof ExprNodeColumnDesc) continue;
                        Object var15_20 = null;
                        return var15_20;
                    }
                }
                if ((fsOp = (FileSinkOperator)((ArrayList)last.getChildren()).get(0)).getChildOperators() != null && fsOp.getChildOperators().size() > 0) {
                    ExprNodeDesc desc;
                    desc = null;
                    return desc;
                }
                Table tbl = ((TableScanDesc)tsOp.getConf()).getTableMetadata();
                ArrayList<Comparable<HiveDecimal>> oneRow = new ArrayList<Comparable<HiveDecimal>>();
                ArrayList<AbstractPrimitiveJavaObjectInspector> ois = new ArrayList<AbstractPrimitiveJavaObjectInspector>();
                Hive hive = Hive.get(this.pctx.getConf());
                for (AggregationDesc aggr : ((GroupByDesc)gbyOp.getConf()).getAggregators()) {
                    DoubleColumnStatsData dstats;
                    Iterator<List<ColumnStatisticsObj>> i$;
                    long curVal;
                    LongColumnStatsData lstats;
                    Set<Partition> parts;
                    StatType type;
                    String colName;
                    ExprNodeColumnDesc colDesc;
                    Long nullCnt;
                    ColumnStatisticsData statData;
                    Collection<List<ColumnStatisticsObj>> result;
                    Set<Partition> parts2;
                    Object var25_31;
                    StatType type2;
                    String constant;
                    if (aggr.getDistinct()) {
                        Object var20_26 = null;
                        return var20_26;
                    }
                    GenericUDAFResolver udaf = FunctionRegistry.getGenericUDAFResolver(aggr.getGenericUDAFName());
                    if (udaf instanceof GenericUDAFSum) {
                        ExprNodeDesc desc = aggr.getParameters().get(0);
                        if (desc instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)desc).getValue().toString();
                        } else if (desc instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)desc).getColumn()) instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)exprMap.get(((ExprNodeColumnDesc)desc).getColumn())).getValue().toString();
                        } else {
                            Object var23_29 = null;
                            return var23_29;
                        }
                        Long rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                        if (rowCnt == null) {
                            Object var24_30 = null;
                            return var24_30;
                        }
                        oneRow.add(HiveDecimal.create(constant).multiply(HiveDecimal.create(rowCnt)));
                        ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DECIMAL));
                        continue;
                    }
                    if (udaf instanceof GenericUDAFCount) {
                        Long rowCnt = 0L;
                        if (aggr.getParameters().isEmpty() || aggr.getParameters().get(0) instanceof ExprNodeConstantDesc || aggr.getParameters().get(0) instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn()) instanceof ExprNodeConstantDesc) {
                            rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                            if (rowCnt == null) {
                                constant = null;
                                return constant;
                            }
                        } else {
                            ExprNodeColumnDesc desc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                            String colName2 = desc.getColumn();
                            type2 = this.getType(desc.getTypeString());
                            if (!tbl.isPartitioned()) {
                                if (!StatsSetupConst.areStatsUptoDate(tbl.getParameters())) {
                                    Log.debug((Object)("Stats for table : " + tbl.getTableName() + " are not upto date."));
                                    var25_31 = null;
                                    return var25_31;
                                }
                                rowCnt = Long.parseLong(tbl.getProperty("numRows"));
                                if (rowCnt < 1L) {
                                    Log.debug((Object)("Table doesn't have upto date stats " + tbl.getTableName()));
                                    var25_31 = null;
                                    return var25_31;
                                }
                                List stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), (List)Lists.newArrayList((Object[])new String[]{colName2}));
                                if (stats.isEmpty()) {
                                    Log.debug((Object)("No stats for " + tbl.getTableName() + " column " + colName2));
                                    Object var26_32 = null;
                                    return var26_32;
                                }
                                Long nullCnt2 = this.getNullcountFor(type2, ((ColumnStatisticsObj)stats.get(0)).getStatsData());
                                if (null == nullCnt2) {
                                    Log.debug((Object)("Unsupported type: " + desc.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName2));
                                    Object var27_33 = null;
                                    return var27_33;
                                }
                                rowCnt = rowCnt - nullCnt2;
                            } else {
                                parts2 = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                                for (Partition part : parts2) {
                                    if (!StatsSetupConst.areStatsUptoDate(part.getParameters())) {
                                        Log.debug((Object)("Stats for part : " + part.getSpec() + " are not upto date."));
                                        Object var28_34 = null;
                                        return var28_34;
                                    }
                                    Long partRowCnt = Long.parseLong(part.getParameters().get("numRows"));
                                    if (partRowCnt < 1L) {
                                        Log.debug((Object)("Partition doesn't have upto date stats " + part.getSpec()));
                                        Object var29_35 = null;
                                        return var29_35;
                                    }
                                    rowCnt = rowCnt + partRowCnt;
                                }
                                result = this.verifyAndGetPartStats(hive, tbl, colName2, parts2);
                                if (result == null) {
                                    Partition part;
                                    part = null;
                                    return part;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        Object var30_36 = null;
                                        return var30_36;
                                    }
                                    nullCnt = this.getNullcountFor(type2, statData);
                                    if (nullCnt == null) {
                                        Log.debug((Object)("Unsupported type: " + desc.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName2));
                                        Object var31_40 = null;
                                        return var31_40;
                                    }
                                    rowCnt = rowCnt - nullCnt;
                                }
                            }
                        }
                        oneRow.add(rowCnt);
                        ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG));
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMax) {
                        DoubleColumnStatsData dstats2;
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = colDesc.getColumn();
                        type = this.getType(colDesc.getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsSetupConst.areStatsUptoDate(tbl.getParameters())) {
                                Log.debug((Object)("Stats for table : " + tbl.getTableName() + " are not upto date."));
                                type2 = null;
                                return type2;
                            }
                            List stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), (List)Lists.newArrayList((Object[])new String[]{colName}));
                            if (stats.isEmpty()) {
                                Log.debug((Object)("No stats for " + tbl.getTableName() + " column " + colName));
                                parts2 = null;
                                return parts2;
                            }
                            ColumnStatisticsData statData2 = ((ColumnStatisticsObj)stats.get(0)).getStatsData();
                            switch (type) {
                                case Integeral: {
                                    LongColumnStatsData lstats2 = statData2.getLongStats();
                                    oneRow.add(lstats2.isSetHighValue() ? Long.valueOf(lstats2.getHighValue()) : null);
                                    ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG));
                                    break;
                                }
                                case Double: {
                                    dstats2 = statData2.getDoubleStats();
                                    oneRow.add(dstats2.isSetHighValue() ? Double.valueOf(dstats2.getHighValue()) : null);
                                    ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE));
                                    break;
                                }
                                default: {
                                    List<ColumnStatisticsObj> statObj;
                                    Log.debug((Object)("Unsupported type: " + colDesc.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName));
                                    statObj = null;
                                    return statObj;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        switch (type) {
                            case Integeral: {
                                Number maxVal = null;
                                result = this.verifyAndGetPartStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    dstats2 = null;
                                    return dstats2;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        nullCnt = null;
                                        return nullCnt;
                                    }
                                    lstats = statData.getLongStats();
                                    if (!lstats.isSetHighValue()) continue;
                                    curVal = lstats.getHighValue();
                                    maxVal = maxVal == null ? curVal : Math.max(maxVal, curVal);
                                }
                                oneRow.add((Comparable<HiveDecimal>)((Object)maxVal));
                                ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG));
                                break;
                            }
                            case Double: {
                                Number maxVal = null;
                                result = this.verifyAndGetPartStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    i$ = null;
                                    return i$;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        lstats = null;
                                        return lstats;
                                    }
                                    dstats = statData.getDoubleStats();
                                    if (!dstats.isSetHighValue()) continue;
                                    double curVal2 = statData.getDoubleStats().getHighValue();
                                    maxVal = maxVal == null ? curVal2 : Math.max((Double)maxVal, curVal2);
                                }
                                oneRow.add((Comparable<HiveDecimal>)((Object)maxVal));
                                ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE));
                                break;
                            }
                            default: {
                                Log.debug((Object)("Unsupported type: " + colDesc.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName));
                                Number maxVal = null;
                                return maxVal;
                            }
                        }
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMin) {
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = colDesc.getColumn();
                        type = this.getType(colDesc.getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsSetupConst.areStatsUptoDate(tbl.getParameters())) {
                                Log.debug((Object)("Stats for table : " + tbl.getTableName() + " are not upto date."));
                                parts = null;
                                return parts;
                            }
                            ColumnStatisticsData statData3 = ((ColumnStatisticsObj)hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), (List)Lists.newArrayList((Object[])new String[]{colName})).get(0)).getStatsData();
                            switch (type) {
                                case Integeral: {
                                    LongColumnStatsData lstats3 = statData3.getLongStats();
                                    oneRow.add(lstats3.isSetLowValue() ? Long.valueOf(lstats3.getLowValue()) : null);
                                    ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG));
                                    break;
                                }
                                case Double: {
                                    DoubleColumnStatsData dstats3 = statData3.getDoubleStats();
                                    oneRow.add(dstats3.isSetLowValue() ? Double.valueOf(dstats3.getLowValue()) : null);
                                    ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE));
                                    break;
                                }
                                default: {
                                    Log.debug((Object)("Unsupported type: " + colDesc.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName));
                                    i$ = null;
                                    return i$;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        switch (type) {
                            case Integeral: {
                                Number minVal = null;
                                result = this.verifyAndGetPartStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    i$ = null;
                                    return i$;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        dstats = null;
                                        return dstats;
                                    }
                                    lstats = statData.getLongStats();
                                    if (!lstats.isSetLowValue()) continue;
                                    curVal = lstats.getLowValue();
                                    minVal = minVal == null ? curVal : Math.min(minVal, curVal);
                                }
                                oneRow.add((Comparable<HiveDecimal>)((Object)minVal));
                                ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG));
                                break;
                            }
                            case Double: {
                                Number minVal = null;
                                result = this.verifyAndGetPartStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    i$ = null;
                                    return i$;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        lstats = null;
                                        return lstats;
                                    }
                                    dstats = statData.getDoubleStats();
                                    if (!dstats.isSetLowValue()) continue;
                                    double curVal3 = statData.getDoubleStats().getLowValue();
                                    minVal = minVal == null ? curVal3 : Math.min((Double)minVal, curVal3);
                                }
                                oneRow.add((Comparable<HiveDecimal>)((Object)minVal));
                                ois.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE));
                                break;
                            }
                            default: {
                                Log.debug((Object)("Unsupported type: " + colDesc.getTypeString() + " encountered in " + "metadata optimizer for column : " + colName));
                                var25_31 = null;
                                return var25_31;
                            }
                        }
                        continue;
                    }
                    Log.debug((Object)("Unsupported aggregation for metadata optimizer: " + aggr.getGenericUDAFName()));
                    colDesc = null;
                    return colDesc;
                }
                ArrayList<List<Object>> allRows = new ArrayList<List<Object>>();
                allRows.add(oneRow);
                ArrayList<String> colNames = new ArrayList<String>();
                for (ColumnInfo colInfo : gbyOp.getSchema().getSignature()) {
                    colNames.add(colInfo.getInternalName());
                }
                FetchWork fWork = null;
                FetchTask fTask = this.pctx.getFetchTask();
                if (fTask != null) {
                    fWork = (FetchWork)fTask.getWork();
                    fWork.getRowsComputedUsingStats().addAll(allRows);
                } else {
                    StandardStructObjectInspector sOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, ois);
                    fWork = new FetchWork(allRows, (StructObjectInspector)sOI);
                    fTask = (FetchTask)TaskFactory.get(fWork, this.pctx.getConf(), new Task[0]);
                    this.pctx.setFetchTask(fTask);
                }
                fWork.setLimit(fWork.getRowsComputedUsingStats().size());
                isOptimized = true;
                Object var22_28 = null;
                return var22_28;
            }
            catch (Exception e) {
                Log.debug((Object)"Failed to optimize using metadata optimizer", (Throwable)e);
                Object var8_10 = null;
                return var8_10;
            }
            finally {
                if (!isOptimized) {
                    soProcCtx.stopProcess = true;
                    this.pctx.setFetchTask(null);
                }
            }
        }

        private ColumnStatisticsData validateSingleColStat(List<ColumnStatisticsObj> statObj) {
            if (statObj.size() > 1) {
                Log.error((Object)"More than one stat for a single column!");
                return null;
            }
            if (statObj.isEmpty()) {
                Log.debug((Object)"No stats for some partition and column");
                return null;
            }
            return statObj.get(0).getStatsData();
        }

        private Collection<List<ColumnStatisticsObj>> verifyAndGetPartStats(Hive hive, Table tbl, String colName, Set<Partition> parts) throws TException {
            ArrayList<String> partNames = new ArrayList<String>(parts.size());
            for (Partition part : parts) {
                if (!StatsSetupConst.areStatsUptoDate(part.getParameters())) {
                    Log.debug((Object)("Stats for part : " + part.getSpec() + " are not upto date."));
                    return null;
                }
                partNames.add(part.getName());
            }
            Map result = hive.getMSC().getPartitionColumnStatistics(tbl.getDbName(), tbl.getTableName(), partNames, (List)Lists.newArrayList((Object[])new String[]{colName}));
            if (result.size() != parts.size()) {
                Log.debug((Object)("Received " + result.size() + " stats for " + parts.size() + " partitions"));
                return null;
            }
            return result.values();
        }

        private Long getRowCnt(ParseContext pCtx, TableScanOperator tsOp, Table tbl) throws HiveException {
            Long rowCnt = 0L;
            if (tbl.isPartitioned()) {
                for (Partition part : this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions()) {
                    long partRowCnt = Long.parseLong(part.getParameters().get("numRows"));
                    if (partRowCnt < 1L) {
                        Log.debug((Object)("Partition doesn't have upto date stats " + part.getSpec()));
                        return null;
                    }
                    rowCnt = rowCnt + partRowCnt;
                }
            } else {
                rowCnt = Long.parseLong(tbl.getProperty("numRows"));
                if (rowCnt < 1L) {
                    Log.debug((Object)("Table doesn't have upto date stats " + tbl.getTableName()));
                    rowCnt = null;
                }
            }
            return rowCnt;
        }

        static enum StatType {
            Integeral,
            Double,
            String,
            Boolean,
            Binary,
            Unsupported;

        }
    }

    private static class StatsOptimizerProcContext
    implements NodeProcessorCtx {
        boolean stopProcess = false;

        private StatsOptimizerProcContext() {
        }
    }
}

