/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.spark_project.guava.collect.ImmutableList;

public class HiveProject
extends Project
implements HiveRelNode {
    public static final RelFactories.ProjectFactory DEFAULT_PROJECT_FACTORY = new HiveProjectFactoryImpl();
    private final List<Integer> virtualCols;

    public HiveProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<? extends RexNode> exps, RelDataType rowType, int flags) {
        super(cluster, traitSet, child, exps, rowType, flags);
        this.virtualCols = ImmutableList.copyOf(HiveCalciteUtil.getVirtualCols(exps));
    }

    public static HiveProject create(RelNode child, List<? extends RexNode> exps, List<String> fieldNames) throws CalciteSemanticException {
        RelOptCluster cluster = child.getCluster();
        if (fieldNames != null && !Util.isDistinct(fieldNames)) {
            String msg = "Select list contains multiple expressions with the same name." + fieldNames;
            throw new CalciteSemanticException(msg);
        }
        RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)cluster.getTypeFactory(), exps, fieldNames);
        return HiveProject.create(cluster, child, exps, rowType, Collections.emptyList());
    }

    public static HiveProject create(RelOptCluster cluster, RelNode child, List<? extends RexNode> exps, RelDataType rowType, List<RelCollation> collationList) {
        RelTraitSet traitSet = TraitsUtil.getDefaultTraitSet(cluster);
        return new HiveProject(cluster, traitSet, child, exps, rowType, 1);
    }

    public static HiveProject create(RelOptCluster cluster, RelNode child, List<? extends RexNode> exps, RelDataType rowType, RelTraitSet traitSet, List<RelCollation> collationList) {
        return new HiveProject(cluster, traitSet, child, exps, rowType, 1);
    }

    public static RelNode projectMapping(RelNode rel, Mapping mapping, List<String> fieldNames) throws CalciteSemanticException {
        assert (mapping.getMappingType().isSingleSource());
        assert (mapping.getMappingType().isMandatorySource());
        if (mapping.isIdentity()) {
            return rel;
        }
        ArrayList<String> outputNameList = new ArrayList<String>();
        ArrayList<RexInputRef> outputProjList = new ArrayList<RexInputRef>();
        List fields = rel.getRowType().getFieldList();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            int source = mapping.getSource(i);
            RelDataTypeField sourceField = (RelDataTypeField)fields.get(source);
            outputNameList.add(fieldNames == null || fieldNames.size() <= i || fieldNames.get(i) == null ? sourceField.getName() : fieldNames.get(i));
            outputProjList.add(rexBuilder.makeInputRef(rel, source));
        }
        return HiveProject.create(rel, outputProjList, outputNameList);
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
        assert (traitSet.containsIfApplicable((RelTrait)HiveRelNode.CONVENTION));
        return new HiveProject(this.getCluster(), traitSet, input, exps, rowType, this.getFlags());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return HiveCost.FACTORY.makeZeroCost();
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public List<Integer> getVirtualCols() {
        return this.virtualCols;
    }

    private static class HiveProjectFactoryImpl
    implements RelFactories.ProjectFactory {
        private HiveProjectFactoryImpl() {
        }

        public RelNode createProject(RelNode child, List<? extends RexNode> childExprs, List<String> fieldNames) {
            RelOptCluster cluster = child.getCluster();
            RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)cluster.getTypeFactory(), childExprs, fieldNames);
            HiveProject project = HiveProject.create(cluster, child, childExprs, rowType, child.getTraitSet(), Collections.emptyList());
            return project;
        }
    }
}

