/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.spark_project.guava.base.Function;
import org.spark_project.guava.collect.ImmutableMap;
import org.spark_project.guava.collect.Lists;

public class TypeConverter {
    private static final Map<String, SqlFunctionConverter.HiveToken> calciteToHiveTypeNameMap;

    public static RelDataType getType(RelOptCluster cluster, List<ColumnInfo> cInfoLst) throws CalciteSemanticException {
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
        LinkedList<RelDataType> fieldTypes = new LinkedList<RelDataType>();
        LinkedList<String> fieldNames = new LinkedList<String>();
        for (ColumnInfo ci : cInfoLst) {
            fieldTypes.add(TypeConverter.convert(ci.getType(), dtFactory));
            fieldNames.add(ci.getInternalName());
        }
        return dtFactory.createStructType(fieldTypes, fieldNames);
    }

    public static RelDataType getType(RelOptCluster cluster, RowResolver rr, List<String> neededCols) throws CalciteSemanticException {
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
        RowSchema rs = rr.getRowSchema();
        LinkedList<RelDataType> fieldTypes = new LinkedList<RelDataType>();
        LinkedList<String> fieldNames = new LinkedList<String>();
        for (ColumnInfo ci : rs.getSignature()) {
            if (neededCols != null && !neededCols.contains(ci.getInternalName())) continue;
            fieldTypes.add(TypeConverter.convert(ci.getType(), dtFactory));
            fieldNames.add(ci.getInternalName());
        }
        return dtFactory.createStructType(fieldTypes, fieldNames);
    }

    public static RelDataType convert(TypeInfo type, RelDataTypeFactory dtFactory) throws CalciteSemanticException {
        RelDataType convertedType = null;
        switch (type.getCategory()) {
            case PRIMITIVE: {
                convertedType = TypeConverter.convert((PrimitiveTypeInfo)type, dtFactory);
                break;
            }
            case LIST: {
                convertedType = TypeConverter.convert((ListTypeInfo)type, dtFactory);
                break;
            }
            case MAP: {
                convertedType = TypeConverter.convert((MapTypeInfo)type, dtFactory);
                break;
            }
            case STRUCT: {
                convertedType = TypeConverter.convert((StructTypeInfo)type, dtFactory);
                break;
            }
            case UNION: {
                convertedType = TypeConverter.convert((UnionTypeInfo)type, dtFactory);
            }
        }
        return convertedType;
    }

    public static RelDataType convert(PrimitiveTypeInfo type, RelDataTypeFactory dtFactory) {
        RelDataType convertedType = null;
        switch (type.getPrimitiveCategory()) {
            case VOID: {
                convertedType = dtFactory.createSqlType(SqlTypeName.NULL);
                break;
            }
            case BOOLEAN: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BOOLEAN);
                break;
            }
            case BYTE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.TINYINT);
                break;
            }
            case SHORT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.SMALLINT);
                break;
            }
            case INT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.INTEGER);
                break;
            }
            case LONG: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BIGINT);
                break;
            }
            case FLOAT: {
                convertedType = dtFactory.createSqlType(SqlTypeName.FLOAT);
                break;
            }
            case DOUBLE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.DOUBLE);
                break;
            }
            case STRING: {
                convertedType = dtFactory.createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE);
                break;
            }
            case DATE: {
                convertedType = dtFactory.createSqlType(SqlTypeName.DATE);
                break;
            }
            case TIMESTAMP: {
                convertedType = dtFactory.createSqlType(SqlTypeName.TIMESTAMP);
                break;
            }
            case BINARY: {
                convertedType = dtFactory.createSqlType(SqlTypeName.BINARY);
                break;
            }
            case DECIMAL: {
                DecimalTypeInfo dtInf = (DecimalTypeInfo)type;
                convertedType = dtFactory.createSqlType(SqlTypeName.DECIMAL, dtInf.precision(), dtInf.scale());
                break;
            }
            case VARCHAR: {
                convertedType = dtFactory.createSqlType(SqlTypeName.VARCHAR, ((BaseCharTypeInfo)type).getLength());
                break;
            }
            case CHAR: {
                convertedType = dtFactory.createSqlType(SqlTypeName.CHAR, ((BaseCharTypeInfo)type).getLength());
                break;
            }
            case UNKNOWN: {
                convertedType = dtFactory.createSqlType(SqlTypeName.OTHER);
            }
        }
        if (null == convertedType) {
            throw new RuntimeException("Unsupported Type : " + type.getTypeName());
        }
        return dtFactory.createTypeWithNullability(convertedType, true);
    }

    public static RelDataType convert(ListTypeInfo lstType, RelDataTypeFactory dtFactory) throws CalciteSemanticException {
        RelDataType elemType = TypeConverter.convert(lstType.getListElementTypeInfo(), dtFactory);
        return dtFactory.createArrayType(elemType, -1L);
    }

    public static RelDataType convert(MapTypeInfo mapType, RelDataTypeFactory dtFactory) throws CalciteSemanticException {
        RelDataType keyType = TypeConverter.convert(mapType.getMapKeyTypeInfo(), dtFactory);
        RelDataType valueType = TypeConverter.convert(mapType.getMapValueTypeInfo(), dtFactory);
        return dtFactory.createMapType(keyType, valueType);
    }

    public static RelDataType convert(StructTypeInfo structType, RelDataTypeFactory dtFactory) throws CalciteSemanticException {
        ArrayList<RelDataType> fTypes = new ArrayList<RelDataType>(structType.getAllStructFieldTypeInfos().size());
        for (TypeInfo ti : structType.getAllStructFieldTypeInfos()) {
            fTypes.add(TypeConverter.convert(ti, dtFactory));
        }
        return dtFactory.createStructType(fTypes, (List)structType.getAllStructFieldNames());
    }

    public static RelDataType convert(UnionTypeInfo unionType, RelDataTypeFactory dtFactory) throws CalciteSemanticException {
        throw new CalciteSemanticException("Union type is not supported");
    }

    public static TypeInfo convert(RelDataType rType) {
        if (rType.isStruct()) {
            return TypeConverter.convertStructType(rType);
        }
        if (rType.getComponentType() != null) {
            return TypeConverter.convertListType(rType);
        }
        if (rType.getKeyType() != null) {
            return TypeConverter.convertMapType(rType);
        }
        return TypeConverter.convertPrimtiveType(rType);
    }

    public static TypeInfo convertStructType(RelDataType rType) {
        List fTypes = Lists.transform((List)rType.getFieldList(), (Function)new Function<RelDataTypeField, TypeInfo>(){

            public TypeInfo apply(RelDataTypeField f) {
                return TypeConverter.convert(f.getType());
            }
        });
        List fNames = Lists.transform((List)rType.getFieldList(), (Function)new Function<RelDataTypeField, String>(){

            public String apply(RelDataTypeField f) {
                return f.getName();
            }
        });
        return TypeInfoFactory.getStructTypeInfo((List)fNames, (List)fTypes);
    }

    public static TypeInfo convertMapType(RelDataType rType) {
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeConverter.convert(rType.getKeyType()), (TypeInfo)TypeConverter.convert(rType.getValueType()));
    }

    public static TypeInfo convertListType(RelDataType rType) {
        return TypeInfoFactory.getListTypeInfo((TypeInfo)TypeConverter.convert(rType.getComponentType()));
    }

    public static TypeInfo convertPrimtiveType(RelDataType rType) {
        switch (rType.getSqlTypeName()) {
            case BOOLEAN: {
                return TypeInfoFactory.booleanTypeInfo;
            }
            case TINYINT: {
                return TypeInfoFactory.byteTypeInfo;
            }
            case SMALLINT: {
                return TypeInfoFactory.shortTypeInfo;
            }
            case INTEGER: {
                return TypeInfoFactory.intTypeInfo;
            }
            case BIGINT: {
                return TypeInfoFactory.longTypeInfo;
            }
            case FLOAT: {
                return TypeInfoFactory.floatTypeInfo;
            }
            case DOUBLE: {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case DATE: {
                return TypeInfoFactory.dateTypeInfo;
            }
            case TIMESTAMP: {
                return TypeInfoFactory.timestampTypeInfo;
            }
            case BINARY: {
                return TypeInfoFactory.binaryTypeInfo;
            }
            case DECIMAL: {
                return TypeInfoFactory.getDecimalTypeInfo((int)rType.getPrecision(), (int)rType.getScale());
            }
            case VARCHAR: {
                if (rType.getPrecision() == Integer.MAX_VALUE) {
                    return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
                }
                return TypeInfoFactory.getVarcharTypeInfo((int)rType.getPrecision());
            }
            case CHAR: {
                return TypeInfoFactory.getCharTypeInfo((int)rType.getPrecision());
            }
        }
        return TypeInfoFactory.voidTypeInfo;
    }

    public static SqlFunctionConverter.HiveToken hiveToken(RelDataType calciteType) {
        SqlFunctionConverter.HiveToken ht = null;
        switch (calciteType.getSqlTypeName()) {
            case CHAR: {
                ht = new SqlFunctionConverter.HiveToken(636, "TOK_CHAR", String.valueOf(calciteType.getPrecision()));
                break;
            }
            case VARCHAR: {
                if (calciteType.getPrecision() == Integer.MAX_VALUE) {
                    ht = new SqlFunctionConverter.HiveToken(832, "TOK_STRING", String.valueOf(calciteType.getPrecision()));
                    break;
                }
                ht = new SqlFunctionConverter.HiveToken(895, "TOK_VARCHAR", String.valueOf(calciteType.getPrecision()));
                break;
            }
            case DECIMAL: {
                ht = new SqlFunctionConverter.HiveToken(660, "TOK_DECIMAL", String.valueOf(calciteType.getPrecision()), String.valueOf(calciteType.getScale()));
                break;
            }
            default: {
                ht = calciteToHiveTypeNameMap.get(calciteType.getSqlTypeName().getName());
            }
        }
        return ht;
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)SqlTypeName.BOOLEAN.getName(), (Object)new SqlFunctionConverter.HiveToken(634, "TOK_BOOLEAN", new String[0]));
        b.put((Object)SqlTypeName.TINYINT.getName(), (Object)new SqlFunctionConverter.HiveToken(878, "TOK_TINYINT", new String[0]));
        b.put((Object)SqlTypeName.SMALLINT.getName(), (Object)new SqlFunctionConverter.HiveToken(827, "TOK_SMALLINT", new String[0]));
        b.put((Object)SqlTypeName.INTEGER.getName(), (Object)new SqlFunctionConverter.HiveToken(715, "TOK_INT", new String[0]));
        b.put((Object)SqlTypeName.BIGINT.getName(), (Object)new SqlFunctionConverter.HiveToken(632, "TOK_BIGINT", new String[0]));
        b.put((Object)SqlTypeName.FLOAT.getName(), (Object)new SqlFunctionConverter.HiveToken(686, "TOK_FLOAT", new String[0]));
        b.put((Object)SqlTypeName.DOUBLE.getName(), (Object)new SqlFunctionConverter.HiveToken(670, "TOK_DOUBLE", new String[0]));
        b.put((Object)SqlTypeName.DATE.getName(), (Object)new SqlFunctionConverter.HiveToken(655, "TOK_DATE", new String[0]));
        b.put((Object)SqlTypeName.TIMESTAMP.getName(), (Object)new SqlFunctionConverter.HiveToken(876, "TOK_TIMESTAMP", new String[0]));
        b.put((Object)SqlTypeName.BINARY.getName(), (Object)new SqlFunctionConverter.HiveToken(633, "TOK_BINARY", new String[0]));
        calciteToHiveTypeNameMap = b.build();
    }
}

