/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getType()));
        switch (tree.getType()) {
            case 679: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 680: {
                return new ExplainSQRewriteSemanticAnalyzer(conf);
            }
            case 728: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 682: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 709: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 595: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 596: 
                    case 597: 
                    case 598: 
                    case 603: 
                    case 604: 
                    case 605: 
                    case 609: 
                    case 610: 
                    case 612: 
                    case 613: 
                    case 615: 
                    case 618: 
                    case 620: 
                    case 621: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                HiveOperation commandType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 623: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 624: 
                    case 625: 
                    case 626: 
                    case 627: 
                    case 628: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                assert (child.getType() == 782);
                SemanticAnalyzerFactory.setSessionCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(conf);
            }
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 601: 
            case 641: 
            case 643: 
            case 646: 
            case 663: 
            case 664: 
            case 665: 
            case 671: 
            case 673: 
            case 675: 
            case 676: 
            case 677: 
            case 692: 
            case 694: 
            case 729: 
            case 730: 
            case 733: 
            case 791: 
            case 792: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 810: 
            case 811: 
            case 812: 
            case 813: 
            case 814: 
            case 815: 
            case 816: 
            case 817: 
            case 818: 
            case 819: 
            case 820: 
            case 821: 
            case 822: 
            case 823: 
            case 840: 
            case 882: 
            case 886: 
            case 887: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 642: 
            case 672: 
            case 786: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 629: {
                return new ColumnStatsSemanticAnalyzer(conf);
            }
            case 645: 
            case 674: {
                return new MacroSemanticAnalyzer(conf);
            }
            case 662: 
            case 888: {
                return new UpdateDeleteSemanticAnalyzer(conf);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(conf) : new SemanticAnalyzer(conf);
        return semAnalyzer;
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(679, HiveOperation.EXPLAIN);
        commandType.put(728, HiveOperation.LOAD);
        commandType.put(682, HiveOperation.EXPORT);
        commandType.put(709, HiveOperation.IMPORT);
        commandType.put(641, HiveOperation.CREATEDATABASE);
        commandType.put(671, HiveOperation.DROPDATABASE);
        commandType.put(840, HiveOperation.SWITCHDATABASE);
        commandType.put(647, HiveOperation.CREATETABLE);
        commandType.put(882, HiveOperation.TRUNCATETABLE);
        commandType.put(676, HiveOperation.DROPTABLE);
        commandType.put(665, HiveOperation.DESCTABLE);
        commandType.put(664, HiveOperation.DESCFUNCTION);
        commandType.put(733, HiveOperation.MSCK);
        commandType.put(596, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(615, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(613, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(612, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(603, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(597, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(620, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(598, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(621, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(610, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(604, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(605, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(807, HiveOperation.SHOWDATABASES);
        commandType.put(813, HiveOperation.SHOWTABLES);
        commandType.put(805, HiveOperation.SHOWCOLUMNS);
        commandType.put(821, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(822, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(815, HiveOperation.SHOW_CREATETABLE);
        commandType.put(809, HiveOperation.SHOWFUNCTIONS);
        commandType.put(810, HiveOperation.SHOWINDEXES);
        commandType.put(812, HiveOperation.SHOWPARTITIONS);
        commandType.put(811, HiveOperation.SHOWLOCKS);
        commandType.put(808, HiveOperation.SHOWLOCKS);
        commandType.put(806, HiveOperation.SHOWCONF);
        commandType.put(642, HiveOperation.CREATEFUNCTION);
        commandType.put(672, HiveOperation.DROPFUNCTION);
        commandType.put(645, HiveOperation.CREATEMACRO);
        commandType.put(674, HiveOperation.DROPMACRO);
        commandType.put(648, HiveOperation.CREATEVIEW);
        commandType.put(677, HiveOperation.DROPVIEW);
        commandType.put(643, HiveOperation.CREATEINDEX);
        commandType.put(673, HiveOperation.DROPINDEX);
        commandType.put(594, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(593, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(627, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(626, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(624, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(625, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(628, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(623, HiveOperation.ALTERVIEW_AS);
        commandType.put(782, HiveOperation.QUERY);
        commandType.put(730, HiveOperation.LOCKTABLE);
        commandType.put(887, HiveOperation.UNLOCKTABLE);
        commandType.put(729, HiveOperation.LOCKDB);
        commandType.put(886, HiveOperation.UNLOCKDB);
        commandType.put(646, HiveOperation.CREATEROLE);
        commandType.put(675, HiveOperation.DROPROLE);
        commandType.put(692, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(791, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(816, HiveOperation.SHOW_GRANT);
        commandType.put(694, HiveOperation.GRANT_ROLE);
        commandType.put(792, HiveOperation.REVOKE_ROLE);
        commandType.put(817, HiveOperation.SHOW_ROLES);
        commandType.put(820, HiveOperation.SHOW_ROLES);
        commandType.put(819, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(818, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(592, HiveOperation.ALTERDATABASE);
        commandType.put(591, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(663, HiveOperation.DESCDATABASE);
        commandType.put(618, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(629, HiveOperation.ANALYZE_TABLE);
        commandType.put(609, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(814, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(823, HiveOperation.SHOW_TRANSACTIONS);
        tablePartitionCommandType.put(611, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(606, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(607, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(608, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(617, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(616, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(614, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(602, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(619, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(599, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(601, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(622, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

