/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ValidationUtility;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.OutputFormat;

@Explain(displayName="Create Table")
public class CreateTableDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log LOG = LogFactory.getLog(CreateTableDesc.class);
    String databaseName;
    String tableName;
    boolean isExternal;
    List<FieldSchema> cols;
    List<FieldSchema> partCols;
    List<String> bucketCols;
    List<Order> sortCols;
    int numBuckets;
    String fieldDelim;
    String fieldEscape;
    String collItemDelim;
    String mapKeyDelim;
    String lineDelim;
    String nullFormat;
    String comment;
    String inputFormat;
    String outputFormat;
    String location;
    String serName;
    String storageHandler;
    Map<String, String> serdeProps;
    Map<String, String> tblProps;
    boolean ifNotExists;
    List<String> skewedColNames;
    List<List<String>> skewedColValues;
    boolean isStoredAsSubDirectories = false;
    boolean isTemporary = false;

    public CreateTableDesc() {
    }

    public CreateTableDesc(String databaseName, String tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues) {
        this(tableName, isExternal, isTemporary, cols, partCols, bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serName, storageHandler, serdeProps, tblProps, ifNotExists, skewedColNames, skewedColValues);
        this.databaseName = databaseName;
    }

    public CreateTableDesc(String tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues) {
        this.tableName = tableName;
        this.isExternal = isExternal;
        this.isTemporary = isTemporary;
        this.bucketCols = new ArrayList<String>(bucketCols);
        this.sortCols = new ArrayList<Order>(sortCols);
        this.collItemDelim = collItemDelim;
        this.cols = new ArrayList<FieldSchema>(cols);
        this.comment = comment;
        this.fieldDelim = fieldDelim;
        this.fieldEscape = fieldEscape;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.lineDelim = lineDelim;
        this.location = location;
        this.mapKeyDelim = mapKeyDelim;
        this.numBuckets = numBuckets;
        this.partCols = new ArrayList<FieldSchema>(partCols);
        this.serName = serName;
        this.storageHandler = storageHandler;
        this.serdeProps = serdeProps;
        this.tblProps = tblProps;
        this.ifNotExists = ifNotExists;
        this.skewedColNames = CreateTableDesc.copyList(skewedColNames);
        this.skewedColValues = CreateTableDesc.copyList(skewedColValues);
    }

    private static <T> List<T> copyList(List<T> copy) {
        return copy == null ? null : new ArrayList<T>(copy);
    }

    @Explain(displayName="columns")
    public List<String> getColsString() {
        return Utilities.getFieldSchemaString(this.getCols());
    }

    @Explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.getPartCols());
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Explain(displayName="name")
    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<FieldSchema> getCols() {
        return this.cols;
    }

    public void setCols(ArrayList<FieldSchema> cols) {
        this.cols = cols;
    }

    public List<FieldSchema> getPartCols() {
        return this.partCols;
    }

    public void setPartCols(ArrayList<FieldSchema> partCols) {
        this.partCols = partCols;
    }

    @Explain(displayName="bucket columns")
    public List<String> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(ArrayList<String> bucketCols) {
        this.bucketCols = bucketCols;
    }

    @Explain(displayName="# buckets")
    public Integer getNumBucketsExplain() {
        if (this.numBuckets == -1) {
            return null;
        }
        return this.numBuckets;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    @Explain(displayName="field delimiter")
    public String getFieldDelim() {
        return this.fieldDelim;
    }

    public void setFieldDelim(String fieldDelim) {
        this.fieldDelim = fieldDelim;
    }

    @Explain(displayName="field escape")
    public String getFieldEscape() {
        return this.fieldEscape;
    }

    public void setFieldEscape(String fieldEscape) {
        this.fieldEscape = fieldEscape;
    }

    @Explain(displayName="collection delimiter")
    public String getCollItemDelim() {
        return this.collItemDelim;
    }

    public void setCollItemDelim(String collItemDelim) {
        this.collItemDelim = collItemDelim;
    }

    @Explain(displayName="map key delimiter")
    public String getMapKeyDelim() {
        return this.mapKeyDelim;
    }

    public void setMapKeyDelim(String mapKeyDelim) {
        this.mapKeyDelim = mapKeyDelim;
    }

    @Explain(displayName="line delimiter")
    public String getLineDelim() {
        return this.lineDelim;
    }

    public void setLineDelim(String lineDelim) {
        this.lineDelim = lineDelim;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Explain(displayName="input format")
    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Explain(displayName="output format")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Explain(displayName="storage handler")
    public String getStorageHandler() {
        return this.storageHandler;
    }

    public void setStorageHandler(String storageHandler) {
        this.storageHandler = storageHandler;
    }

    @Explain(displayName="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Explain(displayName="isExternal", displayOnlyOnTrue=true)
    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    @Explain(displayName="sort columns")
    public List<Order> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(ArrayList<Order> sortCols) {
        this.sortCols = sortCols;
    }

    @Explain(displayName="serde name")
    public String getSerName() {
        return this.serName;
    }

    public void setSerName(String serName) {
        this.serName = serName;
    }

    @Explain(displayName="serde properties")
    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public void setSerdeProps(Map<String, String> serdeProps) {
        this.serdeProps = serdeProps;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    public void setTblProps(Map<String, String> tblProps) {
        this.tblProps = tblProps;
    }

    public List<String> getSkewedColNames() {
        return this.skewedColNames;
    }

    public void setSkewedColNames(ArrayList<String> skewedColNames) {
        this.skewedColNames = skewedColNames;
    }

    public List<List<String>> getSkewedColValues() {
        return this.skewedColValues;
    }

    public void setSkewedColValues(ArrayList<List<String>> skewedColValues) {
        this.skewedColValues = skewedColValues;
    }

    public void validate(HiveConf conf) throws SemanticException {
        boolean found;
        if (this.getCols() == null || this.getCols().size() == 0) {
            if (Table.hasMetastoreBasedSchema(conf, this.getSerName())) {
                throw new SemanticException(ErrorMsg.INVALID_TBL_DDL_SERDE.getMsg());
            }
            return;
        }
        if (this.getStorageHandler() == null) {
            try {
                Class<?> origin = Class.forName(this.getOutputFormat(), true, Utilities.getSessionSpecifiedClassLoader());
                Class<? extends OutputFormat> replaced = HiveFileFormatUtils.getOutputFormatSubstitute(origin);
                if (!HiveOutputFormat.class.isAssignableFrom(replaced)) {
                    throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
                }
            }
            catch (ClassNotFoundException e) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg(), e);
            }
        }
        List<String> colNames = ParseUtils.validateColumnNameUniqueness(this.getCols());
        if (this.getBucketCols() != null) {
            for (String bucketCol : this.getBucketCols()) {
                found = false;
                for (String colName : colNames) {
                    if (!bucketCol.equalsIgnoreCase(colName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg());
            }
        }
        if (this.getSortCols() != null) {
            Iterator<Order> sortCols = this.getSortCols().iterator();
            while (sortCols.hasNext()) {
                String sortCol = sortCols.next().getCol();
                found = false;
                for (String colName : colNames) {
                    if (!sortCol.equalsIgnoreCase(colName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg());
            }
        }
        if (this.getPartCols() != null) {
            for (FieldSchema fs : this.getPartCols()) {
                String partCol = fs.getName();
                PrimitiveTypeInfo pti = null;
                try {
                    pti = TypeInfoFactory.getPrimitiveTypeInfo((String)fs.getType());
                }
                catch (Exception err) {
                    LOG.error((Object)err);
                }
                if (null == pti) {
                    throw new SemanticException(ErrorMsg.PARTITION_COLUMN_NON_PRIMITIVE.getMsg() + " Found " + partCol + " of type: " + fs.getType());
                }
                Iterator<String> colNamesIter = colNames.iterator();
                while (colNamesIter.hasNext()) {
                    String colName = BaseSemanticAnalyzer.unescapeIdentifier(colNamesIter.next());
                    if (!partCol.equalsIgnoreCase(colName)) continue;
                    throw new SemanticException(ErrorMsg.COLUMN_REPEATED_IN_PARTITIONING_COLS.getMsg());
                }
            }
        }
        ValidationUtility.validateSkewedInformation(colNames, this.getSkewedColNames(), this.getSkewedColValues());
    }

    public boolean isStoredAsSubDirectories() {
        return this.isStoredAsSubDirectories;
    }

    public void setStoredAsSubDirectories(boolean isStoredAsSubDirectories) {
        this.isStoredAsSubDirectories = isStoredAsSubDirectories;
    }

    public String getNullFormat() {
        return this.nullFormat;
    }

    public void setNullFormat(String nullFormat) {
        this.nullFormat = nullFormat;
    }

    @Explain(displayName="isTemporary", displayOnlyOnTrue=true)
    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }
}

