/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.spark_project.guava.base.Joiner;

class CommandUtil {
    public static final Log LOG = LogFactory.getLog(CommandUtil.class);

    CommandUtil() {
    }

    static CommandProcessorResponse authorizeCommand(SessionState ss, HiveOperationType type, List<String> command) {
        if (ss == null) {
            return null;
        }
        if (ss.isAuthorizationModeV2() && HiveConf.getBoolVar(ss.getConf(), HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            String errMsg = "Error authorizing command " + command;
            try {
                CommandUtil.authorizeCommandThrowEx(ss, type, command);
                return null;
            }
            catch (HiveAuthzPluginException e) {
                LOG.error((Object)errMsg, (Throwable)e);
                return CommandProcessorResponse.create(e);
            }
            catch (HiveAccessControlException e) {
                LOG.error((Object)errMsg, (Throwable)e);
                return CommandProcessorResponse.create(e);
            }
        }
        return null;
    }

    static void authorizeCommandThrowEx(SessionState ss, HiveOperationType type, List<String> command) throws HiveAuthzPluginException, HiveAccessControlException {
        HivePrivilegeObject commandObj = HivePrivilegeObject.createHivePrivilegeObject(command);
        HiveAuthzContext.Builder ctxBuilder = new HiveAuthzContext.Builder();
        ctxBuilder.setCommandString(Joiner.on((char)' ').join(command));
        ctxBuilder.setUserIpAddress(ss.getUserIpAddress());
        ss.getAuthorizerV2().checkPrivileges(type, Arrays.asList(commandObj), null, ctxBuilder.build());
    }
}

