/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

public class NumericHistogram {
    private int nbins = 0;
    private int nusedbins = 0;
    private ArrayList<Coord> bins = null;
    private Random prng = new Random(31183L);

    public void reset() {
        this.bins = null;
        this.nusedbins = 0;
        this.nbins = 0;
    }

    public int getUsedBins() {
        return this.nusedbins;
    }

    public boolean isReady() {
        return this.nbins != 0;
    }

    public Coord getBin(int b) {
        return this.bins.get(b);
    }

    public void allocate(int num_bins) {
        this.nbins = num_bins;
        this.bins = new ArrayList();
        this.nusedbins = 0;
    }

    public void merge(List<DoubleWritable> other) {
        if (other == null) {
            return;
        }
        if (this.nbins == 0 || this.nusedbins == 0) {
            this.nbins = (int)other.get(0).get();
            this.nusedbins = (other.size() - 1) / 2;
            this.bins = new ArrayList(this.nusedbins);
            for (int i = 1; i < other.size(); i += 2) {
                Coord bin = new Coord();
                bin.x = other.get(i).get();
                bin.y = other.get(i + 1).get();
                this.bins.add(bin);
            }
        } else {
            Coord bin;
            ArrayList<Coord> tmp_bins = new ArrayList<Coord>(this.nusedbins + (other.size() - 1) / 2);
            for (int i = 0; i < this.nusedbins; ++i) {
                bin = new Coord();
                bin.x = this.bins.get((int)i).x;
                bin.y = this.bins.get((int)i).y;
                tmp_bins.add(bin);
            }
            for (int j = 1; j < other.size(); j += 2) {
                bin = new Coord();
                bin.x = other.get(j).get();
                bin.y = other.get(j + 1).get();
                tmp_bins.add(bin);
            }
            Collections.sort(tmp_bins);
            this.bins = tmp_bins;
            this.nusedbins += (other.size() - 1) / 2;
            this.trim();
        }
    }

    public void add(double v) {
        int bin = 0;
        int l = 0;
        int r = this.nusedbins;
        while (l < r) {
            bin = (l + r) / 2;
            if (this.bins.get((int)bin).x > v) {
                r = bin;
                continue;
            }
            if (!(this.bins.get((int)bin).x < v)) break;
            l = ++bin;
        }
        if (bin < this.nusedbins && this.bins.get((int)bin).x == v) {
            this.bins.get((int)bin).y += 1.0;
        } else {
            Coord newBin = new Coord();
            newBin.x = v;
            newBin.y = 1.0;
            this.bins.add(bin, newBin);
            if (++this.nusedbins > this.nbins) {
                this.trim();
            }
        }
    }

    private void trim() {
        while (this.nusedbins > this.nbins) {
            double smallestdiff = this.bins.get((int)1).x - this.bins.get((int)0).x;
            int smallestdiffloc = 0;
            int smallestdiffcount = 1;
            for (int i = 1; i < this.nusedbins - 1; ++i) {
                double diff = this.bins.get((int)(i + 1)).x - this.bins.get((int)i).x;
                if (diff < smallestdiff) {
                    smallestdiff = diff;
                    smallestdiffloc = i;
                    smallestdiffcount = 1;
                    continue;
                }
                if (diff != smallestdiff) continue;
                ++smallestdiffcount;
                if (!(this.prng.nextDouble() <= 1.0 / (double)smallestdiffcount)) continue;
                smallestdiffloc = i;
            }
            double d = this.bins.get((int)smallestdiffloc).y + this.bins.get((int)(smallestdiffloc + 1)).y;
            Coord smallestdiffbin = this.bins.get(smallestdiffloc);
            smallestdiffbin.x *= smallestdiffbin.y / d;
            smallestdiffbin.x += this.bins.get((int)(smallestdiffloc + 1)).x / d * this.bins.get((int)(smallestdiffloc + 1)).y;
            smallestdiffbin.y = d;
            this.bins.remove(smallestdiffloc + 1);
            --this.nusedbins;
        }
    }

    public double quantile(double q) {
        int b;
        assert (this.bins != null && this.nusedbins > 0 && this.nbins > 0);
        double sum = 0.0;
        double csum = 0.0;
        for (b = 0; b < this.nusedbins; ++b) {
            sum += this.bins.get((int)b).y;
        }
        for (b = 0; b < this.nusedbins; ++b) {
            if (!((csum += this.bins.get((int)b).y) / sum >= q)) continue;
            if (b == 0) {
                return this.bins.get((int)b).x;
            }
            double r = this.bins.get((int)(b - 1)).x + (q * sum - (csum -= this.bins.get((int)b).y)) * (this.bins.get((int)b).x - this.bins.get((int)(b - 1)).x) / this.bins.get((int)b).y;
            return r;
        }
        return -1.0;
    }

    public ArrayList<DoubleWritable> serialize() {
        ArrayList<DoubleWritable> result = new ArrayList<DoubleWritable>();
        result.add(new DoubleWritable((double)this.nbins));
        if (this.bins != null) {
            for (int i = 0; i < this.nusedbins; ++i) {
                result.add(new DoubleWritable(this.bins.get((int)i).x));
                result.add(new DoubleWritable(this.bins.get((int)i).y));
            }
        }
        return result;
    }

    public int getNumBins() {
        return this.bins == null ? 0 : this.bins.size();
    }

    static class Coord
    implements Comparable {
        double x;
        double y;

        Coord() {
        }

        public int compareTo(Object other) {
            return Double.compare(this.x, ((Coord)other).x);
        }
    }
}

