/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;

public class HiveServer2
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(HiveServer2.class);
    private CLIService cliService;
    private ThriftCLIService thriftCLIService;

    public HiveServer2() {
        super(HiveServer2.class.getSimpleName());
        HiveConf.setLoadHiveServer2Config((boolean)true);
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.cliService = new CLIService(this);
        this.addService(this.cliService);
        this.thriftCLIService = HiveServer2.isHTTPTransportMode(hiveConf) ? new ThriftHttpCLIService(this.cliService) : new ThriftBinaryCLIService(this.cliService);
        this.addService(this.thriftCLIService);
        super.init(hiveConf);
        final HiveServer2 hiveServer2 = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                hiveServer2.stop();
            }
        });
    }

    public static boolean isHTTPTransportMode(HiveConf hiveConf) {
        String transportMode = System.getenv("HIVE_SERVER2_TRANSPORT_MODE");
        if (transportMode == null) {
            transportMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        }
        return transportMode != null && transportMode.equalsIgnoreCase("http");
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        LOG.info((Object)"Shutting down HiveServer2");
        HiveConf hiveConf = this.getHiveConf();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startHiveServer2() throws Throwable {
        long attempts = 0L;
        long maxAttempts = 1L;
        while (true) {
            LOG.info((Object)"Starting HiveServer2");
            HiveConf hiveConf = new HiveConf();
            maxAttempts = hiveConf.getLongVar(HiveConf.ConfVars.HIVE_SERVER2_MAX_START_ATTEMPTS);
            HiveServer2 server = null;
            try {
                server = new HiveServer2();
                server.init(hiveConf);
                server.start();
                ShimLoader.getHadoopShims().startPauseMonitor((Configuration)hiveConf);
            }
            catch (Throwable throwable) {
                if (server != null) {
                    try {
                        server.stop();
                    }
                    catch (Throwable t) {
                        LOG.info((Object)"Exception caught when calling stop of HiveServer2 before retrying start", t);
                    }
                    finally {
                        server = null;
                    }
                }
                if (++attempts >= maxAttempts) {
                    throw new Error("Max start attempts " + maxAttempts + " exhausted", throwable);
                }
                LOG.warn((Object)("Error starting HiveServer2 on attempt " + attempts + ", will retry in 60 seconds"), throwable);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        HiveConf.setLoadHiveServer2Config((boolean)true);
        try {
            ServerOptionsProcessor oproc = new ServerOptionsProcessor("hiveserver2");
            ServerOptionsProcessorResponse oprocResponse = oproc.parse(args);
            String initLog4jMessage = LogUtils.initHiveLog4j();
            LOG.debug((Object)initLog4jMessage);
            HiveStringUtils.startupShutdownMessage(HiveServer2.class, (String[])args, (Log)LOG);
            LOG.debug((Object)oproc.getDebugMessage().toString());
            oprocResponse.getServerOptionsExecutor().execute();
        }
        catch (LogUtils.LogInitializationException e) {
            LOG.error((Object)("Error initializing log: " + e.getMessage()), (Throwable)e);
            System.exit(-1);
        }
    }

    static class StartOptionExecutor
    implements ServerOptionsExecutor {
        StartOptionExecutor() {
        }

        @Override
        public void execute() {
            try {
                HiveServer2.startHiveServer2();
            }
            catch (Throwable t) {
                LOG.fatal((Object)"Error starting HiveServer2", t);
                System.exit(-1);
            }
        }
    }

    static class HelpOptionExecutor
    implements ServerOptionsExecutor {
        private final Options options;
        private final String serverName;

        HelpOptionExecutor(String serverName, Options options) {
            this.options = options;
            this.serverName = serverName;
        }

        @Override
        public void execute() {
            new HelpFormatter().printHelp(this.serverName, this.options);
            System.exit(0);
        }
    }

    static interface ServerOptionsExecutor {
        public void execute();
    }

    static class ServerOptionsProcessorResponse {
        private final ServerOptionsExecutor serverOptionsExecutor;

        ServerOptionsProcessorResponse(ServerOptionsExecutor serverOptionsExecutor) {
            this.serverOptionsExecutor = serverOptionsExecutor;
        }

        ServerOptionsExecutor getServerOptionsExecutor() {
            return this.serverOptionsExecutor;
        }
    }

    public static class ServerOptionsProcessor {
        private final Options options = new Options();
        private CommandLine commandLine;
        private final String serverName;
        private final StringBuilder debugMessage = new StringBuilder();

        public ServerOptionsProcessor(String serverName) {
            this.serverName = serverName;
            OptionBuilder.withValueSeparator();
            OptionBuilder.hasArgs((int)2);
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.withLongOpt((String)"hiveconf");
            OptionBuilder.withDescription((String)"Use value for given property");
            this.options.addOption(OptionBuilder.create());
            this.options.addOption(new Option("H", "help", false, "Print help information"));
        }

        public ServerOptionsProcessorResponse parse(String[] argv) {
            try {
                this.commandLine = new GnuParser().parse(this.options, argv);
                Properties confProps = this.commandLine.getOptionProperties("hiveconf");
                for (String propKey : confProps.stringPropertyNames()) {
                    this.debugMessage.append("Setting " + propKey + "=" + confProps.getProperty(propKey) + ";\n");
                    System.setProperty(propKey, confProps.getProperty(propKey));
                }
                if (this.commandLine.hasOption('H')) {
                    return new ServerOptionsProcessorResponse(new HelpOptionExecutor(this.serverName, this.options));
                }
            }
            catch (ParseException e) {
                System.err.println("Error starting HiveServer2 with given arguments: ");
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            return new ServerOptionsProcessorResponse(new StartOptionExecutor());
        }

        StringBuilder getDebugMessage() {
            return this.debugMessage;
        }
    }
}

