/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.hive.orc.OrcSerializer;
import org.apache.spark.sql.types.StructType;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4Q!\u0001\u0002\u0001\u00059\u0011qb\u0014:d\u001fV$\b/\u001e;Xe&$XM\u001d\u0006\u0003\u0007\u0011\t1a\u001c:d\u0015\t)a!\u0001\u0003iSZ,'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0011\u0001a\u0004\t\u0003!Ui\u0011!\u0005\u0006\u0003%M\t1\u0002Z1uCN|WO]2fg*\u0011ACB\u0001\nKb,7-\u001e;j_:L!AF\t\u0003\u0019=+H\u000f];u/JLG/\u001a:\t\u0011a\u0001!\u0011!Q\u0001\ni\tA\u0001]1uQ\u000e\u0001\u0001CA\u000e\"\u001d\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011!e\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001j\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017\r\u0005\u0002(U5\t\u0001F\u0003\u0002*\r\u0005)A/\u001f9fg&\u00111\u0006\u000b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u000f\r|g\u000e^3yiB\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!a\r\u0006\u0002\r!\fGm\\8q\u0013\t)\u0004G\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\b\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\b\u0006\u0003:wqj\u0004C\u0001\u001e\u0001\u001b\u0005\u0011\u0001\"\u0002\r7\u0001\u0004Q\u0002\"B\u00137\u0001\u00041\u0003\"B\u00177\u0001\u0004q\u0003BB \u0001A\u0003%\u0001)\u0001\u0006tKJL\u0017\r\\5{KJ\u0004\"AO!\n\u0005\t\u0013!!D(sGN+'/[1mSj,'\u000fC\u0004E\u0001\u0001\u0007I\u0011B#\u00021I,7m\u001c:e/JLG/\u001a:J]N$\u0018M\u001c;jCR,G-F\u0001G!\tar)\u0003\u0002I;\t9!i\\8mK\u0006t\u0007b\u0002&\u0001\u0001\u0004%IaS\u0001\u001de\u0016\u001cwN\u001d3Xe&$XM]%ogR\fg\u000e^5bi\u0016$w\fJ3r)\tau\n\u0005\u0002\u001d\u001b&\u0011a*\b\u0002\u0005+:LG\u000fC\u0004Q\u0013\u0006\u0005\t\u0019\u0001$\u0002\u0007a$\u0013\u0007\u0003\u0004S\u0001\u0001\u0006KAR\u0001\u001ae\u0016\u001cwN\u001d3Xe&$XM]%ogR\fg\u000e^5bi\u0016$\u0007\u0005\u0003\u0005U\u0001!\u0015\r\u0011\"\u0003V\u00031\u0011XmY8sI^\u0013\u0018\u000e^3s+\u00051\u0006\u0003B,[9\nl\u0011\u0001\u0017\u0006\u00033J\na!\\1qe\u0016$\u0017BA.Y\u00051\u0011VmY8sI^\u0013\u0018\u000e^3s!\ti\u0006-D\u0001_\u0015\ty&'\u0001\u0002j_&\u0011\u0011M\u0018\u0002\r\u001dVdGn\u0016:ji\u0006\u0014G.\u001a\t\u0003;\u000eL!\u0001\u001a0\u0003\u0011]\u0013\u0018\u000e^1cY\u0016D\u0001B\u001a\u0001\t\u0002\u0003\u0006KAV\u0001\u000ee\u0016\u001cwN\u001d3Xe&$XM\u001d\u0011\t\u000b!\u0004A\u0011I5\u0002\u000b]\u0014\u0018\u000e^3\u0015\u00051S\u0007\"B6h\u0001\u0004a\u0017a\u0001:poB\u0011QN\\\u0007\u0002\r%\u0011qN\u0002\u0002\u0004%><\bBB9\u0001\t#2!/A\u0007xe&$X-\u00138uKJt\u0017\r\u001c\u000b\u0003\u0019NDQa\u001b9A\u0002Q\u0004\"!\u001e=\u000e\u0003YT!a\u001e\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u001f<\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006w\u0002!\t\u0005`\u0001\u0006G2|7/\u001a\u000b\u0002\u0019\u0002")
public class OrcOutputWriter
extends OutputWriter {
    private final String path;
    private final TaskAttemptContext context;
    private final OrcSerializer serializer;
    private boolean recordWriterInstantiated;
    private RecordWriter<NullWritable, Writable> recordWriter;
    private volatile boolean bitmap$0;

    private RecordWriter recordWriter$lzycompute() {
        OrcOutputWriter orcOutputWriter = this;
        synchronized (orcOutputWriter) {
            if (!this.bitmap$0) {
                this.recordWriterInstantiated_$eq(true);
                this.recordWriter = new OrcOutputFormat().getRecordWriter(new Path(this.path).getFileSystem(this.context.getConfiguration()), (JobConf)this.context.getConfiguration(), this.path, (Progressable)Reporter.NULL);
                this.bitmap$0 = true;
            }
            return this.recordWriter;
        }
    }

    private boolean recordWriterInstantiated() {
        return this.recordWriterInstantiated;
    }

    private void recordWriterInstantiated_$eq(boolean x$1) {
        this.recordWriterInstantiated = x$1;
    }

    private RecordWriter<NullWritable, Writable> recordWriter() {
        return this.bitmap$0 ? this.recordWriter : this.recordWriter$lzycompute();
    }

    public void write(Row row) {
        throw new UnsupportedOperationException("call writeInternal");
    }

    public void writeInternal(InternalRow row) {
        this.recordWriter().write((Object)NullWritable.get(), (Object)this.serializer.serialize(row));
    }

    public void close() {
        if (this.recordWriterInstantiated()) {
            this.recordWriter().close(Reporter.NULL);
        }
    }

    public OrcOutputWriter(String path, StructType dataSchema, TaskAttemptContext context) {
        this.path = path;
        this.context = context;
        this.serializer = new OrcSerializer(dataSchema, context.getConfiguration());
        this.recordWriterInstantiated = false;
    }
}

