/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rUd\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dea\u0002\u0003B\b\u0011%ai\u0011AA\u0005\u0003#\t\u0011\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0007Y&t\u0017\r\\4\n\u0005]!\"A\u0002,fGR|'\u000f\u0005\u0002\u0010\u0001A\u0011qBG\u0005\u00037\t\u0011\u0001\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u000b'/Y7t!\ti\u0002%D\u0001\u001f\u0015\tyB!\u0001\u0003vi&d\u0017BA\u0011\u001f\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\tG\u0001\u0011)\u0019!C!I\u0005\u0019Q/\u001b3\u0016\u0003\u0015\u0002\"A\n\u0017\u000f\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003W!B3A\t\u00197!\t\tD'D\u00013\u0015\t\u0019d!\u0001\u0006b]:|G/\u0019;j_:L!!\u000e\u001a\u0003\u000bMKgnY3\"\u0003]\nQ!\r\u00185]AB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0005k&$\u0007\u0005K\u00029aYB\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!P\u0001\rG>,gMZ5dS\u0016tGo]\u000b\u0002%!\u001a1\bM \"\u0003\u0001\u000bQA\r\u00181]AB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAE\u0001\u000eG>,gMZ5dS\u0016tGo\u001d\u0011)\u0007\u0005\u0003t\b\u0003\u0005F\u0001\t\u0015\r\u0011\"\u0001G\u0003%Ig\u000e^3sG\u0016\u0004H/F\u0001H!\t9\u0003*\u0003\u0002JQ\t1Ai\\;cY\u0016D3\u0001\u0012\u0019LC\u0005a\u0015!B\u0019/g9\u0002\u0004\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B$\u0002\u0015%tG/\u001a:dKB$\b\u0005K\u0002Na-Ca!\u0015\u0001\u0005\u0002\u0019\u0011\u0016A\u0002\u001fj]&$h\b\u0006\u0003\u0019'V;\u0006\"B\u0012Q\u0001\u0004)\u0003fA*1m!)A\b\u0015a\u0001%!\u001aQ\u000bM \t\u000b\u0015\u0003\u0006\u0019A$)\u0007]\u00034\nC\u0003[\u0001\u0011\u00053,\u0001\u0007tKR$\u0006N]3tQ>dG\r\u0006\u0002];6\t\u0001\u0001C\u0003_3\u0002\u0007q)A\u0003wC2,X\rK\u0002Za\u0001\f\u0013!Y\u0001\u0006c9*d\u0006\r\u0005\u0006G\u0002!\tER\u0001\rO\u0016$H\u000b\u001b:fg\"|G\u000e\u001a\u0015\u0004EB\u0002\u0007\"\u00024\u0001\t\u0003:\u0017!D:fiRC'/Z:i_2$7\u000f\u0006\u0002]Q\")a,\u001aa\u0001SB\u0019qE[$\n\u0005-D#!B!se\u0006L\bfA31A\")a\u000e\u0001C!_\u0006iq-\u001a;UQJ,7\u000f[8mIN,\u0012!\u001b\u0015\u0004[B\u0002\u0007b\u0002:\u0001\u0005\u0004%Ia]\u0001\u0007[\u0006\u0014x-\u001b8\u0016\u0003Q\u0004BaJ;\u0013\u000f&\u0011a\u000f\u000b\u0002\n\rVt7\r^5p]FBa\u0001\u001f\u0001!\u0002\u0013!\u0018aB7be\u001eLg\u000e\t\u0005\bu\u0002\u0011\r\u0011\"\u0003t\u0003\u0015\u00198m\u001c:f\u0011\u0019a\b\u0001)A\u0005i\u000611oY8sK\u0002BqA \u0001C\u0002\u0013\u0005s0A\u0006ok64U-\u0019;ve\u0016\u001cXCAA\u0001!\r9\u00131A\u0005\u0004\u0003\u000bA#aA%oi\"\"Q\u0010MA\u0005C\t\tY!A\u00032]Yr\u0003\u0007\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0001\u00031qW/\u001c$fCR,(/Z:!Q\u0015\ti\u0001MA\u0005\u0011!\t)\u0002\u0001b\u0001\n\u0003z\u0018A\u00038v[\u000ec\u0017m]:fg\"\"\u00111\u0003\u0019L\u0011!\tY\u0002\u0001Q\u0001\n\u0005\u0005\u0011a\u00038v[\u000ec\u0017m]:fg\u0002BC!!\u00071\u0017\"I\u0011\u0011\u0005\u0001A\u0002\u0013%\u00111E\u0001\u0010iJ\f\u0017N\\5oON+X.\\1ssV\u0011\u0011Q\u0005\t\u0006O\u0005\u001d\u00121F\u0005\u0004\u0003SA#AB(qi&|g\u000eE\u0002\u0010\u0003[I1!a\f\u0003\u0005\u0005bunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Ue\u0006Lg.\u001b8h'VlW.\u0019:z\u0011%\t\u0019\u0004\u0001a\u0001\n\u0013\t)$A\nue\u0006Lg.\u001b8h'VlW.\u0019:z?\u0012*\u0017\u000f\u0006\u0003\u00028\u0005u\u0002cA\u0014\u0002:%\u0019\u00111\b\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003\u007f\t\t$!AA\u0002\u0005\u0015\u0012a\u0001=%c!A\u00111\t\u0001!B\u0013\t)#\u0001\tue\u0006Lg.\u001b8h'VlW.\u0019:zA!9\u0011q\t\u0001\u0005\u0002\u0005%\u0013aB:v[6\f'/_\u000b\u0003\u0003WAC!!\u00121A\"A\u0011q\n\u0001\u0005\u0002\t\t\t&A\u0011gS:$7+^7nCJLXj\u001c3fY\u0006sG\r\u0015:pE\u0006\u0014\u0017\u000e\\5us\u000e{G\u000e\u0006\u0002\u0002TA)q%!\u0016\u0019K%\u0019\u0011q\u000b\u0015\u0003\rQ+\b\u000f\\33\u0011!\tY\u0006\u0001C\u0001\u0005\u0005u\u0013AC:fiN+X.\\1ssR\u0019A,a\u0018\t\u0011\u0005\u001d\u0013\u0011\fa\u0001\u0003WAq!a\u0019\u0001\t\u0003\t)'\u0001\u0006iCN\u001cV/\\7bef,\"!a\u001a\u0011\u0007\u001d\nI'C\u0002\u0002l!\u0012qAQ8pY\u0016\fg\u000e\u000b\u0003\u0002bA\u0002\u0007bBA9\u0001\u0011\u0005\u00111O\u0001\tKZ\fG.^1uKR!\u0011QOA>!\ry\u0011qO\u0005\u0004\u0003s\u0012!!\u0007'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u001cV/\\7befD\u0001\"! \u0002p\u0001\u0007\u0011qP\u0001\bI\u0006$\u0018m]3ua\u0011\t\t)!%\u0011\r\u0005\r\u0015\u0011RAG\u001b\t\t)IC\u0002\u0002\b\u001a\t1a]9m\u0013\u0011\tY)!\"\u0003\u000f\u0011\u000bG/Y:fiB!\u0011qRAI\u0019\u0001!A\"a%\u0002|\u0005\u0005\t\u0011!B\u0001\u0003+\u00131a\u0018\u00134#\u0011\t9*!(\u0011\u0007\u001d\nI*C\u0002\u0002\u001c\"\u0012qAT8uQ&tw\rE\u0002(\u0003?K1!!))\u0005\r\te.\u001f\u0015\u0005\u0003_\u0002t\bC\u0004\u0002(\u0002!\t&!+\u0002\u000fA\u0014X\rZ5diR\u0019q)a+\t\u000f\u00055\u0016Q\u0015a\u0001%\u0005Aa-Z1ukJ,7\u000fC\u0004\u00022\u0002!\t&a-\u0002-I\fwO\r9s_\n\f'-\u001b7jifLe\u000e\u00157bG\u0016$2AEA[\u0011\u001d\t9,a,A\u0002I\tQB]1x!J,G-[2uS>t\u0007bBA^\u0001\u0011E\u0013QX\u0001\u000baJ,G-[2u%\u0006<Hc\u0001\n\u0002@\"9\u0011QVA]\u0001\u0004\u0011\u0002bBAb\u0001\u0011\u0005\u0013QY\u0001\u0005G>\u0004\u0018\u0010F\u0002\u0019\u0003\u000fD\u0001\"!3\u0002B\u0002\u0007\u00111Z\u0001\u0006Kb$(/\u0019\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*\u0019\u0011\u0011\u001b\u0003\u0002\u000bA\f'/Y7\n\t\u0005U\u0017q\u001a\u0002\t!\u0006\u0014\u0018-\\'ba\"\"\u0011\u0011\u0019\u00197\u0011\u001d\tY\u000e\u0001C)\u0003;\faB]1xeA\u0014X\rZ5di&|g\u000eF\u0002H\u0003?Dq!a.\u0002Z\u0002\u0007!\u0003C\u0004\u0002d\u0002!\t&!:\u0002-A\u0014xNY1cS2LG/\u001f\u001aqe\u0016$\u0017n\u0019;j_:$2aRAt\u0011\u001d\tI/!9A\u0002I\t1\u0002\u001d:pE\u0006\u0014\u0017\u000e\\5us\"9\u0011Q\u001e\u0001\u0005B\u0005=\u0018!B<sSR,WCAAy!\ri\u00121_\u0005\u0004\u0003kt\"\u0001C'M/JLG/\u001a:)\u000b\u0005-\b'!\u0003)\u0007\u0001\u0001dgB\u0004\u0002~\nA\t!a@\u0002/1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007cA\b\u0003\u0002\u00191\u0011A\u0001E\u0001\u0005\u0007\u0019\u0002B!\u0001\u0003\u0006\t-!\u0011\u0003\t\u0004O\t\u001d\u0011b\u0001B\u0005Q\t1\u0011I\\=SK\u001a\u0004B!\bB\u00071%\u0019!q\u0002\u0010\u0003\u00155c%+Z1eC\ndW\rE\u0002(\u0005'I1A!\u0006)\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001d\t&\u0011\u0001C\u0001\u00053!\"!a@\t\u0011\tu!\u0011\u0001C!\u0005?\tAA]3bIV\u0011!\u0011\u0005\t\u0005;\t\r\u0002$C\u0002\u0003&y\u0011\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u0006\u00057\u0001\u0014\u0011\u0002\u0005\t\u0005W\u0011\t\u0001\"\u0011\u0003.\u0005!An\\1e)\rA\"q\u0006\u0005\b\u0005c\u0011I\u00031\u0001&\u0003\u0011\u0001\u0018\r\u001e5)\u000b\t%\u0002'!\u0003\u0007\u0013\t]\"\u0011\u0001\u0001\u0003\u0002\te\"!\b'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m/JLG/\u001a:\u0014\r\tU\u0012\u0011\u001fB\u001e!\u0011\u0011iDa\u0011\u000e\u0005\t}\"b\u0001B!\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0003\u0003F\t}\"a\u0002'pO\u001eLgn\u001a\u0005\u000b\u0005\u0013\u0012)D!A!\u0002\u0013A\u0012\u0001C5ogR\fgnY3\t\u000fE\u0013)\u0004\"\u0001\u0003NQ!!q\nB*!\u0011\u0011\tF!\u000e\u000e\u0005\t\u0005\u0001b\u0002B%\u0005\u0017\u0002\r\u0001\u0007\u0004\b\u0005/\u0012)\u0004\u0012B-\u0005\u0011!\u0015\r^1\u0014\u0011\tU#Q\u0001B.\u0005#\u00012a\nB/\u0013\r\u0011y\u0006\u000b\u0002\b!J|G-^2u\u0011)\t)B!\u0016\u0003\u0016\u0004%\ta \u0005\f\u00037\u0011)F!E!\u0002\u0013\t\t\u0001C\u0005\u007f\u0005+\u0012)\u001a!C\u0001\u007f\"Y\u0011q\u0002B+\u0005#\u0005\u000b\u0011BA\u0001\u0011%)%Q\u000bBK\u0002\u0013\u0005a\tC\u0005O\u0005+\u0012\t\u0012)A\u0005\u000f\"IAH!\u0016\u0003\u0016\u0004%\t!\u0010\u0005\n\u0005\nU#\u0011#Q\u0001\nIAq!\u0015B+\t\u0003\u0011\u0019\b\u0006\u0006\u0003v\te$1\u0010B?\u0005\u007f\u0002BAa\u001e\u0003V5\u0011!Q\u0007\u0005\t\u0003+\u0011\t\b1\u0001\u0002\u0002!9aP!\u001dA\u0002\u0005\u0005\u0001BB#\u0003r\u0001\u0007q\t\u0003\u0004=\u0005c\u0002\rA\u0005\u0005\u000b\u0003\u0007\u0014)&!A\u0005\u0002\t\rEC\u0003B;\u0005\u000b\u00139I!#\u0003\f\"Q\u0011Q\u0003BA!\u0003\u0005\r!!\u0001\t\u0013y\u0014\t\t%AA\u0002\u0005\u0005\u0001\u0002C#\u0003\u0002B\u0005\t\u0019A$\t\u0011q\u0012\t\t%AA\u0002IA!Ba$\u0003VE\u0005I\u0011\u0001BI\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa%+\t\u0005\u0005!QS\u0016\u0003\u0005/\u0003BA!'\u0003\"6\u0011!1\u0014\u0006\u0005\u0005;\u0013y*A\u0005v]\u000eDWmY6fI*\u00111\u0007K\u0005\u0005\u0005G\u0013YJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!Ba*\u0003VE\u0005I\u0011\u0001BI\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB!Ba+\u0003VE\u0005I\u0011\u0001BW\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa,+\u0007\u001d\u0013)\n\u0003\u0006\u00034\nU\u0013\u0013!C\u0001\u0005k\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u00038*\u001a!C!&\t\u0015\tm&QKA\u0001\n\u0003\u0012i,A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u007f\u0003BA!1\u0003L6\u0011!1\u0019\u0006\u0005\u0005\u000b\u00149-\u0001\u0003mC:<'B\u0001Be\u0003\u0011Q\u0017M^1\n\u00075\u0012\u0019\rC\u0005\u0003P\nU\u0013\u0011!C\u0001\u007f\u0006a\u0001O]8ek\u000e$\u0018I]5us\"Q!1\u001bB+\u0003\u0003%\tA!6\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u0014Bl\u0011)\tyD!5\u0002\u0002\u0003\u0007\u0011\u0011\u0001\u0005\u000b\u00057\u0014)&!A\u0005B\tu\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t}\u0007C\u0002Bq\u0005O\fi*\u0004\u0002\u0003d*\u0019!Q\u001d\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003j\n\r(\u0001C%uKJ\fGo\u001c:\t\u0015\t5(QKA\u0001\n\u0003\u0011y/\u0001\u0005dC:,\u0015/^1m)\u0011\t9G!=\t\u0015\u0005}\"1^A\u0001\u0002\u0004\ti\n\u0003\u0006\u0003v\nU\u0013\u0011!C!\u0005o\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0003A!Ba?\u0003V\u0005\u0005I\u0011\tB\u007f\u0003!!xn\u0015;sS:<GC\u0001B`\u0011)\u0019\tA!\u0016\u0002\u0002\u0013\u000531A\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d4Q\u0001\u0005\u000b\u0003\u007f\u0011y0!AA\u0002\u0005uuACB\u0005\u0005k\t\t\u0011#\u0003\u0004\f\u0005!A)\u0019;b!\u0011\u00119h!\u0004\u0007\u0015\t]#QGA\u0001\u0012\u0013\u0019ya\u0005\u0004\u0004\u000e\rE!\u0011\u0003\t\r\u0007'\u0019I\"!\u0001\u0002\u0002\u001d\u0013\"QO\u0007\u0003\u0007+Q1aa\u0006)\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\u0007\u0004\u0016\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\t\u000fE\u001bi\u0001\"\u0001\u0004 Q\u001111\u0002\u0005\u000b\u0005w\u001ci!!A\u0005F\tu\bBCB\u0013\u0007\u001b\t\t\u0011\"!\u0004(\u0005)\u0011\r\u001d9msRQ!QOB\u0015\u0007W\u0019ica\f\t\u0011\u0005U11\u0005a\u0001\u0003\u0003AqA`B\u0012\u0001\u0004\t\t\u0001\u0003\u0004F\u0007G\u0001\ra\u0012\u0005\u0007y\r\r\u0002\u0019\u0001\n\t\u0015\rM2QBA\u0001\n\u0003\u001b)$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r]2q\b\t\u0006O\u0005\u001d2\u0011\b\t\nO\rm\u0012\u0011AA\u0001\u000fJI1a!\u0010)\u0005\u0019!V\u000f\u001d7fi!Q1\u0011IB\u0019\u0003\u0003\u0005\rA!\u001e\u0002\u0007a$\u0003\u0007\u0003\u0005\u0004F\tUB\u0011KB$\u0003!\u0019\u0018M^3J[BdG\u0003BA\u001c\u0007\u0013BqA!\r\u0004D\u0001\u0007QEB\u0004\u0004N\t\u0005Aaa\u0014\u0003;1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d'+Z1eKJ\u001cBaa\u0013\u0003\"!9\u0011ka\u0013\u0005\u0002\rMCCAB+!\u0011\u0011\tfa\u0013\t\u0015\re31\nb\u0001\n\u0013\u0011i,A\u0005dY\u0006\u001c8OT1nK\"I1QLB&A\u0003%!qX\u0001\u000bG2\f7o\u001d(b[\u0016\u0004\u0003\u0002\u0003B\u0016\u0007\u0017\"\te!\u0019\u0015\u0007a\u0019\u0019\u0007C\u0004\u00032\r}\u0003\u0019A\u0013\t\u0015\r\u001d$\u0011AA\u0001\n\u0013\u0019I'A\u0006sK\u0006$'+Z:pYZ,GCAB6!\u0011\u0011\tm!\u001c\n\t\r=$1\u0019\u0002\u0007\u001f\nTWm\u0019;)\u000b\t\u0005\u0001'!\u0003)\u000b\u0005m\b'!\u0003")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements LogisticRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private final int numClasses;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public void validateParams() {
        LogisticRegressionParams$class.validateParams(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    public Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    private Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("No training summary available for this LogisticRegressionModel");
            }
        });
    }

    public Tuple2<LogisticRegressionModel, String> findSummaryModelAndProbabilityCol() {
        Tuple2 tuple2;
        String string = this.$(this.probabilityCol());
        if ("".equals(string)) {
            String probabilityColName = new StringBuilder().append((Object)"probability_").append((Object)UUID.randomUUID().toString()).toString();
            tuple2 = new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(probabilityColName), (Object)probabilityColName);
        } else {
            tuple2 = new Tuple2((Object)this, (Object)string);
        }
        return tuple2;
    }

    public LogisticRegressionModel setSummary(LogisticRegressionTrainingSummary summary2) {
        this.trainingSummary_$eq((Option<LogisticRegressionTrainingSummary>)new Some((Object)summary2));
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple2<LogisticRegressionModel, String> tuple2 = this.findSummaryModelAndProbabilityCol();
        if (tuple2 != null) {
            Tuple2 tuple22;
            LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple2._1();
            String probabilityColName = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summaryModel, (Object)probabilityColName);
            LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple23._1();
            String probabilityColName2 = (String)tuple23._2();
            return new BinaryLogisticRegressionSummary(summaryModel2.transform(dataset), probabilityColName2, this.$(this.labelCol()), this.$(this.featuresCol()));
        }
        throw new MatchError(tuple2);
    }

    @Override
    public double predict(Vector features) {
        return BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0;
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            int size = denseVector.size();
            for (int i = 0; i < size; ++i) {
                denseVector.values()[i] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-denseVector.values()[i]));
            }
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        Object object = this.trainingSummary().isDefined() ? newModel.setSummary((LogisticRegressionTrainingSummary)this.trainingSummary().get()) : BoxedUnit.UNIT;
        return (LogisticRegressionModel)newModel.setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double t = this.getThreshold();
        double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : scala.math.package$.MODULE$.log(t / (1.0 - t)));
        return rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return probability.apply(1) > this.getThreshold() ? 1.0 : 0.0;
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    public LogisticRegressionModel(String uid, Vector coefficients2, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients2;
        this.intercept = intercept;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;

            public final double apply(Vector features) {
                return BLAS$.MODULE$.dot(features, this.$outer.coefficients()) + this.$outer.intercept();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.score = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;

            public final double apply(Vector features) {
                double m = BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
                return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.numFeatures = coefficients2.size();
        this.numClasses = 2;
        this.trainingSummary = None$.MODULE$;
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private final LogisticRegressionModel instance;
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$lzycompute() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module != null) return this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module;
                this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                return this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module;
            }
        }

        public LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data() {
            return this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module == null ? this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$lzycompute() : this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data().apply(this.instance.numClasses(), this.instance.numFeatures(), this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(this))).repartition(1).write().parquet(dataPath);
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(int numClasses, int numFeatures, double intercept, Vector coefficients2) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, intercept, coefficients2);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public double copy$default$3() {
                return this.intercept();
            }

            public Vector copy$default$4() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 4;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 3: {
                        object = this.coefficients();
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)4);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, double intercept, Vector coefficients2) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.intercept = intercept;
                this.coefficients = coefficients2;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Dataset data = this.sparkSession().read().format("parquet").load(dataPath);
            Row row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
            Some some = Row$.MODULE$.unapplySeq(row);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(4) == 0) {
                Object numClasses = ((SeqLike)some.get()).apply(0);
                Object numFeatures = ((SeqLike)some.get()).apply(1);
                Object intercept = ((SeqLike)some.get()).apply(2);
                Object coefficients2 = ((SeqLike)some.get()).apply(3);
                if (numClasses instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)numClasses);
                    if (numFeatures instanceof Integer) {
                        int n2 = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (intercept instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)intercept);
                            if (coefficients2 instanceof Vector) {
                                Tuple4 tuple4;
                                Vector vector = (Vector)coefficients2;
                                Tuple4 tuple42 = tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector);
                                int numClasses2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
                                int numFeatures2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
                                double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                                Vector coefficients3 = (Vector)tuple42._4();
                                LogisticRegressionModel model = new LogisticRegressionModel(metadata.uid(), coefficients3, intercept2);
                                DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
                                return model;
                            }
                        }
                    }
                }
            }
            throw new MatchError((Object)row);
        }
    }
}

