/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.ml.feature.QuantileDiscretizer$;
import org.apache.spark.ml.feature.QuantileDiscretizerBase;
import org.apache.spark.ml.feature.QuantileDiscretizerBase$class;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u00055\u00111#U;b]RLG.\u001a#jg\u000e\u0014X\r^5{KJT!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aBF\r\u0011\u0007=\u0001\"#D\u0001\u0005\u0013\t\tBAA\u0005FgRLW.\u0019;peB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u000b\u0005V\u001c7.\u001a;ju\u0016\u0014\bCA\n\u0018\u0013\tA\"AA\fRk\u0006tG/\u001b7f\t&\u001c8M]3uSj,'OQ1tKB\u0011!$H\u0007\u00027)\u0011A\u0004B\u0001\u0005kRLG.\u0003\u0002\u001f7\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011I\u0011\u0002\u0007ULG-F\u0001#!\t\u0019\u0013F\u0004\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tAS%\u0001\u0004Qe\u0016$WMZ\u0005\u0003U-\u0012aa\u0015;sS:<'B\u0001\u0015&Q\ryRf\r\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\t!\"\u00198o_R\fG/[8o\u0013\t\u0011tFA\u0003TS:\u001cW-I\u00015\u0003\u0015\tdF\u000e\u00181\u0011!1\u0004A!A!\u0002\u0013\u0011\u0013\u0001B;jI\u0002B3!N\u00174\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0019a\u0014N\\5u}Q\u00111\b\u0010\t\u0003'\u0001AQ\u0001\t\u001dA\u0002\tB3\u0001P\u00174Q\rATf\r\u0005\u0006s\u0001!\t\u0001\u0011\u000b\u0002w!\u001aq(L\u001a\t\u000b\r\u0003A\u0011\u0001#\u0002!M,GOU3mCRLg/Z#se>\u0014HCA#G\u001b\u0005\u0001\u0001\"B$C\u0001\u0004A\u0015!\u0002<bYV,\u0007C\u0001\u0013J\u0013\tQUE\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u00056b\u0015%A'\u0002\u000bIr\u0003G\f\u0019\t\u000b=\u0003A\u0011\u0001)\u0002\u001bM,GOT;n\u0005V\u001c7.\u001a;t)\t)\u0015\u000bC\u0003H\u001d\u0002\u0007!\u000b\u0005\u0002%'&\u0011A+\n\u0002\u0004\u0013:$\bf\u0001(.g!)q\u000b\u0001C\u00011\u0006Y1/\u001a;J]B,HoQ8m)\t)\u0015\fC\u0003H-\u0002\u0007!\u0005K\u0002W[MBQ\u0001\u0018\u0001\u0005\u0002u\u000bAb]3u\u001fV$\b/\u001e;D_2$\"!\u00120\t\u000b\u001d[\u0006\u0019\u0001\u0012)\u0007mk3\u0007C\u0003b\u0001\u0011\u0005#-A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\t\u00197\u000e\u0005\u0002eS6\tQM\u0003\u0002gO\u0006)A/\u001f9fg*\u0011\u0001NB\u0001\u0004gFd\u0017B\u00016f\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006Y\u0002\u0004\raY\u0001\u0007g\u000eDW-\\1)\u0007\u0001l3\u0007C\u0003p\u0001\u0011\u0005\u0003/A\u0002gSR$\"AE9\t\u000bIt\u0007\u0019A:\u0002\u000f\u0011\fG/Y:fiB\u0012AO\u001f\t\u0004kZDX\"A4\n\u0005]<'a\u0002#bi\u0006\u001cX\r\u001e\t\u0003sjd\u0001\u0001B\u0005|c\u0006\u0005\t\u0011!B\u0001y\n\u0019q\fJ\u0019\u0012\u0007u\f\t\u0001\u0005\u0002%}&\u0011q0\n\u0002\b\u001d>$\b.\u001b8h!\r!\u00131A\u0005\u0004\u0003\u000b)#aA!os\"\u001aa.\f'\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e\u0005!1m\u001c9z)\rY\u0014q\u0002\u0005\t\u0003#\tI\u00011\u0001\u0002\u0014\u0005)Q\r\u001f;sCB!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0011\tQ\u0001]1sC6LA!!\b\u0002\u0018\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002\n5\u001a\u0004f\u0001\u0001.g\u001d9\u0011Q\u0005\u0002\t\u0002\u0005\u001d\u0012aE)vC:$\u0018\u000e\\3ESN\u001c'/\u001a;ju\u0016\u0014\bcA\n\u0002*\u00191\u0011A\u0001E\u0001\u0003W\u0019\"\"!\u000b\u0002.\u0005M\u0012\u0011HA#!\r!\u0013qF\u0005\u0004\u0003c)#AB!osJ+g\r\u0005\u0003\u001b\u0003kY\u0014bAA\u001c7\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}b!\u0001\u0005j]R,'O\\1m\u0013\u0011\t\u0019%!\u0010\u0003\u000f1{wmZ5oOB\u0019A%a\u0012\n\u0007\u0005%SE\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004:\u0003S!\t!!\u0014\u0015\u0005\u0005\u001d\u0002\u0002CA)\u0003S!\t%a\u0015\u0002\t1|\u0017\r\u001a\u000b\u0004w\u0005U\u0003bBA,\u0003\u001f\u0002\rAI\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u0002P5\u001a\u0004BCA/\u0003S\t\t\u0011\"\u0003\u0002`\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\u0007\u0005\u0003\u0002d\u00055TBAA3\u0015\u0011\t9'!\u001b\u0002\t1\fgn\u001a\u0006\u0003\u0003W\nAA[1wC&!\u0011qNA3\u0005\u0019y%M[3di\"\"\u0011\u0011F\u00174Q\u0011\t\u0019#L\u001a")
public final class QuantileDiscretizer
extends Estimator<Bucketizer>
implements QuantileDiscretizerBase,
DefaultParamsWritable {
    private final String uid;
    private final IntParam numBuckets;
    private final DoubleParam relativeError;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public static MLReader<QuantileDiscretizer> read() {
        return QuantileDiscretizer$.MODULE$.read();
    }

    public static QuantileDiscretizer load(String string) {
        return QuantileDiscretizer$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public IntParam numBuckets() {
        return this.numBuckets;
    }

    @Override
    public DoubleParam relativeError() {
        return this.relativeError;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$numBuckets_$eq(IntParam x$1) {
        this.numBuckets = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$relativeError_$eq(DoubleParam x$1) {
        this.relativeError = x$1;
    }

    @Override
    public int getNumBuckets() {
        return QuantileDiscretizerBase$class.getNumBuckets(this);
    }

    @Override
    public double getRelativeError() {
        return QuantileDiscretizerBase$class.getRelativeError(this);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public QuantileDiscretizer setRelativeError(double value) {
        return (QuantileDiscretizer)this.set(this.relativeError(), BoxesRunTime.boxToDouble((double)value));
    }

    public QuantileDiscretizer setNumBuckets(int value) {
        return (QuantileDiscretizer)this.set(this.numBuckets(), BoxesRunTime.boxToInteger((int)value));
    }

    public QuantileDiscretizer setInputCol(String value) {
        return (QuantileDiscretizer)this.set(this.inputCol(), value);
    }

    public QuantileDiscretizer setOutputCol(String value) {
        return (QuantileDiscretizer)this.set(this.outputCol(), value);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.inputCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        StructField[] inputFields = schema.fields();
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])inputFields).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuantileDiscretizer $outer;

            public final boolean apply(StructField x$1) {
                String string = x$1.name();
                String string2 = this.$outer.$(this.$outer.outputCol());
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuantileDiscretizer $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.$(this.$outer.outputCol())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        NominalAttribute attr = NominalAttribute$.MODULE$.defaultAttr().withName(this.$(this.outputCol()));
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])inputFields).$colon$plus((Object)attr.toStructField(), ClassTag$.MODULE$.apply(StructField.class));
        return new StructType(outputFields);
    }

    @Override
    public Bucketizer fit(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        double[] splits = dataset.stat().approxQuantile(this.$(this.inputCol()), (double[])((TraversableOnce)new RichDouble(Predef$.MODULE$.doubleWrapper(0.0)).to((Object)BoxesRunTime.boxToDouble((double)1.0)).by((Object)BoxesRunTime.boxToDouble((double)(1.0 / (double)BoxesRunTime.unboxToInt((Object)this.$(this.numBuckets())))))).toArray(ClassTag$.MODULE$.Double()), BoxesRunTime.unboxToDouble((Object)this.$(this.relativeError())));
        splits[0] = Double.NEGATIVE_INFINITY;
        splits[splits.length - 1] = Double.POSITIVE_INFINITY;
        double[] distinctSplits = (double[])Predef$.MODULE$.doubleArrayOps(splits).distinct();
        if (splits.length != distinctSplits.length) {
            this.log().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some quantiles were identical. Bucketing to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(distinctSplits.length - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" buckets as a result."})).s((Seq)Nil$.MODULE$)).toString());
        }
        Bucketizer bucketizer = new Bucketizer(this.uid()).setSplits((double[])Predef$.MODULE$.doubleArrayOps(distinctSplits).sorted((Ordering)Ordering.Double$.MODULE$));
        return this.copyValues(bucketizer.setParent(this), this.copyValues$default$2());
    }

    @Override
    public QuantileDiscretizer copy(ParamMap extra) {
        return (QuantileDiscretizer)this.defaultCopy(extra);
    }

    public QuantileDiscretizer(String uid) {
        this.uid = uid;
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        QuantileDiscretizerBase$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
    }

    public QuantileDiscretizer() {
        this(Identifiable$.MODULE$.randomUID("quantileDiscretizer"));
    }
}

