/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams$class;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$Family$;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$Link$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase$class;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r]c\u0001B\u0001\u0003\u00015\u0011\u0001eR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fY*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u001a9A!q\u0002\u0005\n\u0019\u001b\u0005\u0011\u0011BA\t\u0003\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0003\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001b\u0013\tY\"AA\u0010HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c\"bg\u0016\u0004\"!\b\u0011\u000e\u0003yQ!a\b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003Cy\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!\u0019\u0003A!b\u0001\n\u0003\"\u0013aA;jIV\tQ\u0005\u0005\u0002'Y9\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tY\u0003\u0006K\u0002#aY\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00026e\t)1+\u001b8dK\u0006\nq'A\u00033]Ar\u0003\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003&\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007a\u0002d\u0007\u0003\u0005=\u0001\t\u0015\r\u0011\"\u0001>\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t+\u0005\u0011\u0002fA\u001e1m!A\u0001\t\u0001B\u0001B\u0003%!#A\u0007d_\u00164g-[2jK:$8\u000f\t\u0015\u0004\u007fA2\u0004\u0002C\"\u0001\u0005\u000b\u0007I\u0011\u0001#\u0002\u0013%tG/\u001a:dKB$X#A#\u0011\u0005\u001d2\u0015BA$)\u0005\u0019!u.\u001e2mK\"\u001a!\t\r\u001c\t\u0011)\u0003!\u0011!Q\u0001\n\u0015\u000b!\"\u001b8uKJ\u001cW\r\u001d;!Q\rI\u0005G\u000e\u0005\u0007\u001b\u0002!\t\u0001\u0002(\u0002\rqJg.\u001b;?)\u0011Ar*U*\t\u000b\rb\u0005\u0019A\u0013)\u0007=\u0003d\u0007C\u0003=\u0019\u0002\u0007!\u0003K\u0002RaYBQa\u0011'A\u0002\u0015C3a\u0015\u00197\u0011\u00151\u0006\u0001\"\u0001X\u0003Q\u0019X\r\u001e'j].\u0004&/\u001a3jGRLwN\\\"pYR\u0011\u0001,W\u0007\u0002\u0001!)!,\u0016a\u0001K\u0005)a/\u00197vK\"\u001aQ\u000b\r\u001c\t\u0011u\u0003\u0001R1A\u0005\ny\u000b\u0011BZ1nS2LxJ\u00196\u0016\u0003}\u0003\"\u0001Y2\u000f\u0005=\t\u0017B\u00012\u0003\u0003m9UM\\3sC2L'0\u001a3MS:,\u0017M\u001d*fOJ,7o]5p]&\u0011A-\u001a\u0002\u0007\r\u0006l\u0017\u000e\\=\u000b\u0005\t\u0014\u0001\u0002C4\u0001\u0011\u0003\u0005\u000b\u0015B0\u0002\u0015\u0019\fW.\u001b7z\u001f\nT\u0007\u0005\u0003\u0005j\u0001!\u0015\r\u0011\"\u0003k\u0003\u001da\u0017N\\6PE*,\u0012a\u001b\t\u0003A2L!!\\3\u0003\t1Kgn\u001b\u0005\t_\u0002A\t\u0011)Q\u0005W\u0006AA.\u001b8l\u001f\nT\u0007\u0005\u0003\u0005r\u0001!\u0015\r\u0011\"\u0003s\u000351\u0017-\\5ms\u0006sG\rT5oWV\t1\u000f\u0005\u0002ai&\u0011Q/\u001a\u0002\u000e\r\u0006l\u0017\u000e\\=B]\u0012d\u0015N\\6\t\u0011]\u0004\u0001\u0012!Q!\nM\faBZ1nS2L\u0018I\u001c3MS:\\\u0007\u0005C\u0003z\u0001\u0011E#0A\u0004qe\u0016$\u0017n\u0019;\u0015\u0005\u0015[\b\"\u0002?y\u0001\u0004\u0011\u0012\u0001\u00034fCR,(/Z:\t\u000by\u0004A\u0011B@\u0002\u0017A\u0014X\rZ5di2Kgn\u001b\u000b\u0004\u000b\u0006\u0005\u0001\"\u0002?~\u0001\u0004\u0011\u0002bBA\u0003\u0001\u0011\u0005\u0013qA\u0001\niJ\fgn\u001d4pe6$B!!\u0003\u00022A!\u00111BA\u0016\u001d\u0011\ti!!\n\u000f\t\u0005=\u0011\u0011\u0005\b\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005ua\u0002BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eA\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I1!a\t\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003O\tI#A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005\rb!\u0003\u0003\u0002.\u0005=\"!\u0003#bi\u00064%/Y7f\u0015\u0011\t9#!\u000b\t\u0011\u0005M\u00121\u0001a\u0001\u0003k\tq\u0001Z1uCN,G\u000f\r\u0003\u00028\u0005\r\u0003CBA\u001d\u0003w\ty$\u0004\u0002\u0002*%!\u0011QHA\u0015\u0005\u001d!\u0015\r^1tKR\u0004B!!\u0011\u0002D1\u0001A\u0001DA#\u0003c\t\t\u0011!A\u0003\u0002\u0005\u001d#aA0%eE!\u0011\u0011JA(!\r9\u00131J\u0005\u0004\u0003\u001bB#a\u0002(pi\"Lgn\u001a\t\u0004O\u0005E\u0013bAA*Q\t\u0019\u0011I\\=\t\u000f\u0005]\u0003\u0001\"\u0015\u0002Z\u0005iAO]1og\u001a|'/\\%na2$B!!\u0003\u0002\\!A\u00111GA+\u0001\u0004\ti\u0006\r\u0003\u0002`\u0005\r\u0004CBA\u001d\u0003w\t\t\u0007\u0005\u0003\u0002B\u0005\rD\u0001DA3\u00037\n\t\u0011!A\u0003\u0002\u0005\u001d#aA0%g!I\u0011\u0011\u000e\u0001A\u0002\u0013%\u00111N\u0001\u0010iJ\f\u0017N\\5oON+X.\\1ssV\u0011\u0011Q\u000e\t\u0006O\u0005=\u00141O\u0005\u0004\u0003cB#AB(qi&|g\u000eE\u0002\u0010\u0003kJ1!a\u001e\u0003\u0005):UM\\3sC2L'0\u001a3MS:,\u0017M\u001d*fOJ,7o]5p]R\u0013\u0018-\u001b8j]\u001e\u001cV/\\7befD\u0011\"a\u001f\u0001\u0001\u0004%I!! \u0002'Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef|F%Z9\u0015\t\u0005}\u0014Q\u0011\t\u0004O\u0005\u0005\u0015bAABQ\t!QK\\5u\u0011)\t9)!\u001f\u0002\u0002\u0003\u0007\u0011QN\u0001\u0004q\u0012\n\u0004\u0002CAF\u0001\u0001\u0006K!!\u001c\u0002!Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef\u0004\u0003bBAH\u0001\u0011\u0005\u0011\u0011S\u0001\bgVlW.\u0019:z+\t\t\u0019\b\u000b\u0003\u0002\u000eB2\u0004bBAL\u0001\u0011\u0005\u0011\u0011T\u0001\u000bQ\u0006\u001c8+^7nCJLXCAAN!\r9\u0013QT\u0005\u0004\u0003?C#a\u0002\"p_2,\u0017M\u001c\u0015\u0005\u0003+\u0003d\u0007\u0003\u0005\u0002&\u0002!\tAAAT\u0003)\u0019X\r^*v[6\f'/\u001f\u000b\u00041\u0006%\u0006\u0002CAH\u0003G\u0003\r!a\u001d\t\u000f\u00055\u0006\u0001\"\u0001\u00020\u0006AQM^1mk\u0006$X\r\u0006\u0003\u00022\u0006]\u0006cA\b\u00024&\u0019\u0011Q\u0017\u0002\u0003E\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o'VlW.\u0019:z\u0011!\t\u0019$a+A\u0002\u0005e\u0006\u0007BA^\u0003\u007f\u0003b!!\u000f\u0002<\u0005u\u0006\u0003BA!\u0003\u007f#A\"!1\u00028\u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00121a\u0018\u00135Q\u0011\tY\u000b\r\u001c\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\u0006!1m\u001c9z)\rA\u00121\u001a\u0005\t\u0003\u001b\f)\r1\u0001\u0002P\u0006)Q\r\u001f;sCB!\u0011\u0011[Al\u001b\t\t\u0019NC\u0002\u0002V\u0012\tQ\u0001]1sC6LA!!7\u0002T\nA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002FB2\u0004bBAp\u0001\u0011\u0005\u0013\u0011]\u0001\u0006oJLG/Z\u000b\u0003\u0003G\u00042!HAs\u0013\r\t9O\b\u0002\t\u001b2;&/\u001b;fe\"\"\u0011Q\u001c\u00197Q\r\u0001\u0001G\u000e\u0015\u0004\u0001\u0005=\bcA\u0019\u0002r&\u0019\u00111\u001f\u001a\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u000f\u0005](\u0001#\u0001\u0002z\u0006\u0001s)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\ry\u00111 \u0004\u0007\u0003\tA\t!!@\u0014\u0011\u0005m\u0018q B\u0003\u0005\u0017\u00012a\nB\u0001\u0013\r\u0011\u0019\u0001\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\tu\u00119\u0001G\u0005\u0004\u0005\u0013q\"AC'M%\u0016\fG-\u00192mKB\u0019qE!\u0004\n\u0007\t=\u0001F\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004N\u0003w$\tAa\u0005\u0015\u0005\u0005e\b\u0002\u0003B\f\u0003w$\tE!\u0007\u0002\tI,\u0017\rZ\u000b\u0003\u00057\u0001B!\bB\u000f1%\u0019!q\u0004\u0010\u0003\u00115c%+Z1eKJDCA!\u00061m!A!QEA~\t\u0003\u00129#\u0001\u0003m_\u0006$Gc\u0001\r\u0003*!9!1\u0006B\u0012\u0001\u0004)\u0013\u0001\u00029bi\"DCAa\t1m\u0019I!\u0011GA~\u0001\u0005m(1\u0007\u0002'\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,Gn\u0016:ji\u0016\u00148C\u0002B\u0018\u0003G\u0014)\u0004\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\r\u0011YDB\u0001\tS:$XM\u001d8bY&!!q\bB\u001d\u0005\u001daunZ4j]\u001eD!Ba\u0011\u00030\t\u0005\t\u0015!\u0003\u0019\u0003!Ign\u001d;b]\u000e,\u0007bB'\u00030\u0011\u0005!q\t\u000b\u0005\u0005\u0013\u0012i\u0005\u0005\u0003\u0003L\t=RBAA~\u0011\u001d\u0011\u0019E!\u0012A\u0002a1qA!\u0015\u00030\u0011\u0013\u0019F\u0001\u0003ECR\f7\u0003\u0003B(\u0003\u007f\u0014)Fa\u0003\u0011\u0007\u001d\u00129&C\u0002\u0003Z!\u0012q\u0001\u0015:pIV\u001cG\u000fC\u0005D\u0005\u001f\u0012)\u001a!C\u0001\t\"I!Ja\u0014\u0003\u0012\u0003\u0006I!\u0012\u0005\ny\t=#Q3A\u0005\u0002uB\u0011\u0002\u0011B(\u0005#\u0005\u000b\u0011\u0002\n\t\u000f5\u0013y\u0005\"\u0001\u0003fQ1!q\rB6\u0005[\u0002BA!\u001b\u0003P5\u0011!q\u0006\u0005\u0007\u0007\n\r\u0004\u0019A#\t\rq\u0012\u0019\u00071\u0001\u0013\u0011)\t9Ma\u0014\u0002\u0002\u0013\u0005!\u0011\u000f\u000b\u0007\u0005O\u0012\u0019H!\u001e\t\u0011\r\u0013y\u0007%AA\u0002\u0015C\u0001\u0002\u0010B8!\u0003\u0005\rA\u0005\u0005\u000b\u0005s\u0012y%%A\u0005\u0002\tm\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005{R3!\u0012B@W\t\u0011\t\t\u0005\u0003\u0003\u0004\n-UB\u0001BC\u0015\u0011\u00119I!#\u0002\u0013Ut7\r[3dW\u0016$'BA\u001a)\u0013\u0011\u0011iI!\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0003\u0012\n=\u0013\u0013!C\u0001\u0005'\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0016*\u001a!Ca \t\u0015\te%qJA\u0001\n\u0003\u0012Y*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005;\u0003BAa(\u0003*6\u0011!\u0011\u0015\u0006\u0005\u0005G\u0013)+\u0001\u0003mC:<'B\u0001BT\u0003\u0011Q\u0017M^1\n\u00075\u0012\t\u000b\u0003\u0006\u0003.\n=\u0013\u0011!C\u0001\u0005_\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!-\u0011\u0007\u001d\u0012\u0019,C\u0002\u00036\"\u00121!\u00138u\u0011)\u0011ILa\u0014\u0002\u0002\u0013\u0005!1X\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tyE!0\t\u0015\u0005\u001d%qWA\u0001\u0002\u0004\u0011\t\f\u0003\u0006\u0003B\n=\u0013\u0011!C!\u0005\u0007\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u000b\u0004bAa2\u0003N\u0006=SB\u0001Be\u0015\r\u0011Y\rK\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bh\u0005\u0013\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0005'\u0014y%!A\u0005\u0002\tU\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m%q\u001b\u0005\u000b\u0003\u000f\u0013\t.!AA\u0002\u0005=\u0003B\u0003Bn\u0005\u001f\n\t\u0011\"\u0011\u0003^\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00032\"Q!\u0011\u001dB(\u0003\u0003%\tEa9\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!(\t\u0015\t\u001d(qJA\u0001\n\u0003\u0012I/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00037\u0013Y\u000f\u0003\u0006\u0002\b\n\u0015\u0018\u0011!a\u0001\u0003\u001f:!Ba<\u00030\u0005\u0005\t\u0012\u0002By\u0003\u0011!\u0015\r^1\u0011\t\t%$1\u001f\u0004\u000b\u0005#\u0012y#!A\t\n\tU8C\u0002Bz\u0005o\u0014Y\u0001\u0005\u0005\u0003z\n}XI\u0005B4\u001b\t\u0011YPC\u0002\u0003~\"\nqA];oi&lW-\u0003\u0003\u0004\u0002\tm(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9QJa=\u0005\u0002\r\u0015AC\u0001By\u0011)\u0011\tOa=\u0002\u0002\u0013\u0015#1\u001d\u0005\u000b\u0007\u0017\u0011\u00190!A\u0005\u0002\u000e5\u0011!B1qa2LHC\u0002B4\u0007\u001f\u0019\t\u0002\u0003\u0004D\u0007\u0013\u0001\r!\u0012\u0005\u0007y\r%\u0001\u0019\u0001\n\t\u0015\rU!1_A\u0001\n\u0003\u001b9\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\re1\u0011\u0005\t\u0006O\u0005=41\u0004\t\u0006O\ruQIE\u0005\u0004\u0007?A#A\u0002+va2,'\u0007\u0003\u0006\u0004$\rM\u0011\u0011!a\u0001\u0005O\n1\u0001\u001f\u00131\u0011!\u00199Ca\f\u0005R\r%\u0012\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\u0005}41\u0006\u0005\b\u0005W\u0019)\u00031\u0001&\r\u001d\u0019y#a?\u0005\u0007c\u0011aeR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fYJ+\u0017\rZ3s'\u0011\u0019iCa\u0007\t\u000f5\u001bi\u0003\"\u0001\u00046Q\u00111q\u0007\t\u0005\u0005\u0017\u001ai\u0003\u0003\u0006\u0004<\r5\"\u0019!C\u0005\u00057\u000b\u0011b\u00197bgNt\u0015-\\3\t\u0013\r}2Q\u0006Q\u0001\n\tu\u0015AC2mCN\u001ch*Y7fA!A!QEB\u0017\t\u0003\u001a\u0019\u0005F\u0002\u0019\u0007\u000bBqAa\u000b\u0004B\u0001\u0007Q\u0005\u0003\u0006\u0004J\u0005m\u0018\u0011!C\u0005\u0007\u0017\n1B]3bIJ+7o\u001c7wKR\u00111Q\n\t\u0005\u0005?\u001by%\u0003\u0003\u0004R\t\u0005&AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002|B2\u0004\u0006BA{aY\u0002")
public class GeneralizedLinearRegressionModel
extends RegressionModel<Vector, GeneralizedLinearRegressionModel>
implements GeneralizedLinearRegressionBase,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private GeneralizedLinearRegression.Family familyObj;
    private GeneralizedLinearRegression.Link linkObj;
    private GeneralizedLinearRegression.FamilyAndLink familyAndLink;
    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary;
    private final Param<String> family;
    private final Param<String> link;
    private final Param<String> linkPredictionCol;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final DoubleParam regParam;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final BooleanParam fitIntercept;
    private volatile byte bitmap$0;

    public static GeneralizedLinearRegressionModel load(String string) {
        return GeneralizedLinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GeneralizedLinearRegressionModel> read() {
        return GeneralizedLinearRegressionModel$.MODULE$.read();
    }

    private GeneralizedLinearRegression.Family familyObj$lzycompute() {
        GeneralizedLinearRegressionModel generalizedLinearRegressionModel = this;
        synchronized (generalizedLinearRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.familyObj = GeneralizedLinearRegression$Family$.MODULE$.fromName(this.$(this.family()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.familyObj;
        }
    }

    private GeneralizedLinearRegression.Link linkObj$lzycompute() {
        GeneralizedLinearRegressionModel generalizedLinearRegressionModel = this;
        synchronized (generalizedLinearRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.linkObj = this.isDefined(this.link()) ? GeneralizedLinearRegression$Link$.MODULE$.fromName(this.$(this.link())) : this.familyObj().defaultLink();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.linkObj;
        }
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink$lzycompute() {
        GeneralizedLinearRegressionModel generalizedLinearRegressionModel = this;
        synchronized (generalizedLinearRegressionModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.familyAndLink = new GeneralizedLinearRegression.FamilyAndLink(this.familyObj(), this.linkObj());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.familyAndLink;
        }
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public final Param<String> link() {
        return this.link;
    }

    @Override
    public final Param<String> linkPredictionCol() {
        return this.linkPredictionCol;
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$family_$eq(Param x$1) {
        this.family = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$link_$eq(Param x$1) {
        this.link = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPredictionCol_$eq(Param x$1) {
        this.linkPredictionCol = x$1;
    }

    @Override
    public String getFamily() {
        return GeneralizedLinearRegressionBase$class.getFamily(this);
    }

    @Override
    public String getLink() {
        return GeneralizedLinearRegressionBase$class.getLink(this);
    }

    @Override
    public String getLinkPredictionCol() {
        return GeneralizedLinearRegressionBase$class.getLinkPredictionCol(this);
    }

    @Override
    public boolean hasLinkPredictionCol() {
        return GeneralizedLinearRegressionBase$class.hasLinkPredictionCol(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return GeneralizedLinearRegressionBase$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public GeneralizedLinearRegressionModel setLinkPredictionCol(String value) {
        return (GeneralizedLinearRegressionModel)this.set(this.linkPredictionCol(), value);
    }

    private GeneralizedLinearRegression.Family familyObj() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.familyObj$lzycompute() : this.familyObj;
    }

    private GeneralizedLinearRegression.Link linkObj() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.linkObj$lzycompute() : this.linkObj;
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.familyAndLink$lzycompute() : this.familyAndLink;
    }

    @Override
    public double predict(Vector features) {
        double eta = this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predictLink(features);
        return this.familyAndLink().fitted(eta);
    }

    public double org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predictLink(Vector features) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept();
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        return this.transformImpl(dataset);
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(GeneralizedLinearRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneralizedLinearRegressionModel $outer;

            public final double apply(Vector features) {
                return this.$outer.predict(features);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(this)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(GeneralizedLinearRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictLinkUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneralizedLinearRegressionModel $outer;

            public final double apply(Vector features) {
                return this.$outer.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predictLink(features);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(this)));
        Dataset output = dataset;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            output = output.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
        }
        if (this.hasLinkPredictionCol()) {
            output = output.withColumn(this.$(this.linkPredictionCol()), predictLinkUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
        }
        return output.toDF();
    }

    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<GeneralizedLinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public GeneralizedLinearRegressionTrainingSummary summary() {
        return (GeneralizedLinearRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("No training summary available for this GeneralizedLinearRegressionModel");
            }
        });
    }

    public boolean hasSummary() {
        return this.trainingSummary().nonEmpty();
    }

    public GeneralizedLinearRegressionModel setSummary(GeneralizedLinearRegressionTrainingSummary summary2) {
        this.trainingSummary_$eq((Option<GeneralizedLinearRegressionTrainingSummary>)new Some((Object)summary2));
        return this;
    }

    public GeneralizedLinearRegressionSummary evaluate(Dataset<?> dataset) {
        return new GeneralizedLinearRegressionSummary(dataset, this);
    }

    @Override
    public GeneralizedLinearRegressionModel copy(ParamMap extra) {
        return (GeneralizedLinearRegressionModel)((Model)this.copyValues(new GeneralizedLinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new GeneralizedLinearRegressionModelWriter(this);
    }

    public GeneralizedLinearRegressionModel(String uid, Vector coefficients2, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients2;
        this.intercept = intercept;
        HasFitIntercept$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasRegParam$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        GeneralizedLinearRegressionBase$class.$init$(this);
        MLWritable$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
    }

    public static class GeneralizedLinearRegressionModelWriter
    extends MLWriter {
        private final GeneralizedLinearRegressionModel instance;
        private volatile GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$lzycompute() {
            GeneralizedLinearRegressionModelWriter generalizedLinearRegressionModelWriter = this;
            synchronized (generalizedLinearRegressionModelWriter) {
                if (this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module != null) return this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module;
                this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module = new GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$(this);
                return this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module;
            }
        }

        public GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data() {
            return this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module == null ? this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$lzycompute() : this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data().apply(this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1(GeneralizedLinearRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1(this))).repartition(1).write().parquet(dataPath);
        }

        public GeneralizedLinearRegressionModelWriter(GeneralizedLinearRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ GeneralizedLinearRegressionModelWriter $outer;

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(double intercept, Vector coefficients2) {
                return new Data(this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer(), intercept, coefficients2);
            }

            public double copy$default$1() {
                return this.intercept();
            }

            public Vector copy$default$2() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 1: {
                        object = this.coefficients();
                        break;
                    }
                    case 0: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GeneralizedLinearRegressionModelWriter org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GeneralizedLinearRegressionModelWriter $outer, double intercept, Vector coefficients2) {
                this.intercept = intercept;
                this.coefficients = coefficients2;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class GeneralizedLinearRegressionModelReader
    extends MLReader<GeneralizedLinearRegressionModel> {
        private final String className = GeneralizedLinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GeneralizedLinearRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = (Row)this.sparkSession().read().parquet(dataPath).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
            double intercept = data.getDouble(0);
            Vector coefficients2 = (Vector)data.getAs(1);
            GeneralizedLinearRegressionModel model = new GeneralizedLinearRegressionModel(metadata.uid(), coefficients2, intercept);
            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
            return model;
        }
    }
}

