/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Vector$;
import breeze.linalg.argmax$;
import breeze.linalg.argtopk$;
import breeze.linalg.normalize$;
import breeze.linalg.sum$;
import breeze.storage.Zero;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaPairRDD$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.mllib.clustering.DistributedLDAModel$;
import org.apache.spark.mllib.clustering.DistributedLDAModel$SaveLoadV1_0$;
import org.apache.spark.mllib.clustering.LDA$;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.BoundedPriorityQueue;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0011%e\u0001B\u0001\u0003\u00015\u00111\u0003R5tiJL'-\u001e;fI2#\u0015)T8eK2T!a\u0001\u0003\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005!aE)Q'pI\u0016d\u0007\"C\n\u0001\u0005\u000b\u0007I\u0011\u0001\u0002\u0015\u0003\u00159'/\u00199i+\u0005)\u0002\u0003\u0002\f\u001a7\tj\u0011a\u0006\u0006\u00031\u0019\taa\u001a:ba\"D\u0018B\u0001\u000e\u0018\u0005\u00159%/\u00199i!\tarD\u0004\u0002\u0010;%\u0011aDA\u0001\u0004\u0019\u0012\u000b\u0015B\u0001\u0011\"\u0005-!v\u000e]5d\u0007>,h\u000e^:\u000b\u0005y\u0011\u0001C\u0001\u000f$\u0013\t!\u0013E\u0001\u0006U_.,gnQ8v]RD\u0001B\n\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0007OJ\f\u0007\u000f\u001b\u0011\t\u0013!\u0002!Q1A\u0005\u0002\tI\u0013!E4m_\n\fG\u000eV8qS\u000e$v\u000e^1mgV\t1\u0004\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003\u001c\u0003I9Gn\u001c2bYR{\u0007/[2U_R\fGn\u001d\u0011\t\u00115\u0002!Q1A\u0005\u00029\n\u0011a[\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t\u0019\u0011J\u001c;)\u000712D\b\u0005\u00028u5\t\u0001H\u0003\u0002:\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005mB$!B*j]\u000e,\u0017%A\u001f\u0002\u000bEr3G\f\u0019\t\u0011}\u0002!\u0011!Q\u0001\n=\n!a\u001b\u0011)\u0007y2D\b\u0003\u0005C\u0001\t\u0015\r\u0011\"\u0001/\u0003%1xnY1c'&TX\rK\u0002BmqB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IaL\u0001\u000bm>\u001c\u0017MY*ju\u0016\u0004\u0003f\u0001#7y!A\u0001\n\u0001BC\u0002\u0013\u0005\u0013*\u0001\te_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]V\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N\t\u00051A.\u001b8bY\u001eL!a\u0014'\u0003\rY+7\r^8sQ\r9e'U\u0011\u0002%\u0006)\u0011GL\u001b/a!AA\u000b\u0001B\u0001B\u0003%!*A\te_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\u0002B3a\u0015\u001cR\u0011!9\u0006A!b\u0001\n\u0003B\u0016A\u0005;pa&\u001c7i\u001c8dK:$(/\u0019;j_:,\u0012!\u0017\t\u0003aiK!aW\u0019\u0003\r\u0011{WO\u00197fQ\r1f'\u0015\u0005\t=\u0002\u0011\t\u0011)A\u00053\u0006\u0019Bo\u001c9jG\u000e{gnY3oiJ\fG/[8oA!\u001aQLN)\t\u0013\u0005\u0004!Q1A\u0005\u0002\u0019\u0011\u0017AD5uKJ\fG/[8o)&lWm]\u000b\u0002GB\u0019\u0001\u0007Z-\n\u0005\u0015\f$!B!se\u0006L\b\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011B2\u0002\u001f%$XM]1uS>tG+[7fg\u0002B\u0011\"\u001b\u0001\u0003\u0006\u0004%\tF\u0001-\u0002\u0015\u001d\fW.\\1TQ\u0006\u0004X\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003Z\u0003-9\u0017-\\7b'\"\f\u0007/\u001a\u0011\t\u00135\u0004!Q1A\u0005\u0002\u0019q\u0017aD2iK\u000e\\\u0007o\\5oi\u001aKG.Z:\u0016\u0003=\u00042\u0001\r3q!\t\tHO\u0004\u00021e&\u00111/M\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002tc!A\u0001\u0010\u0001B\u0001B\u0003%q.\u0001\tdQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3tA!1!\u0010\u0001C\u0001\u0005m\fa\u0001P5oSRtD\u0003\u0005?~}~\f\u0019!a\u0002\u0002\f\u0005=\u0011\u0011CA\n!\ty\u0001\u0001C\u0003\u0014s\u0002\u0007Q\u0003C\u0003)s\u0002\u00071\u0004C\u0003.s\u0002\u0007q\u0006K\u0002\u0000mqBQAQ=A\u0002=BC!a\u00017y!)\u0001*\u001fa\u0001\u0015\"\"\u0011q\u0001\u001cR\u0011\u00159\u0016\u00101\u0001ZQ\u0011\tYAN)\t\u000b\u0005L\b\u0019A2\t\u000f%L\b\u0013!a\u00013\"9Q.\u001fI\u0001\u0002\u0004y\u0007bBA\f\u0001\u0011\u0005\u0011\u0011D\u0001\bi>dunY1m+\t\tY\u0002E\u0002\u0010\u0003;I1!a\b\u0003\u00055aunY1m\u0019\u0012\u000bUj\u001c3fY\"\"\u0011Q\u0003\u001c=\u0011)\t)\u0003\u0001EC\u0002\u0013\u0005\u0013qE\u0001\ri>\u0004\u0018nY:NCR\u0014\u0018\u000e_\u000b\u0003\u0003S\u00012aSA\u0016\u0013\r\ti\u0003\u0014\u0002\u0007\u001b\u0006$(/\u001b=)\t\u0005\rb\u0007\u0010\u0005\u000b\u0003g\u0001\u0001\u0012!Q!\n\u0005%\u0012!\u0004;pa&\u001c7/T1ue&D\b\u0005\u000b\u0003\u00022Yb\u0004bBA\u001d\u0001\u0011\u0005\u00131H\u0001\u000fI\u0016\u001c8M]5cKR{\u0007/[2t)\u0011\ti$a\u0012\u0011\tA\"\u0017q\b\t\u0007a\u0005\u0005\u0013QI2\n\u0007\u0005\r\u0013G\u0001\u0004UkBdWM\r\t\u0004a\u0011|\u0003bBA%\u0003o\u0001\raL\u0001\u0011[\u0006DH+\u001a:ngB+'\u000fV8qS\u000eDC!a\u000e7y!9\u0011q\n\u0001\u0005\u0002\u0005E\u0013\u0001\u0006;pa\u0012{7-^7f]R\u001c\b+\u001a:U_BL7\r\u0006\u0003\u0002T\u0005}\u0003\u0003\u0002\u0019e\u0003+\u0002b\u0001MA!\u0003/\u001a\u0007\u0003\u0002\u0019e\u00033\u00022\u0001MA.\u0013\r\ti&\r\u0002\u0005\u0019>tw\rC\u0004\u0002b\u00055\u0003\u0019A\u0018\u0002)5\f\u0007\u0010R8dk6,g\u000e^:QKJ$v\u000e]5dQ\u0011\tiEN)\t\u0015\u0005\u001d\u0004\u0001#b\u0001\n\u0003\tI'\u0001\tu_BL7-Q:tS\u001etW.\u001a8ugV\u0011\u00111\u000e\t\u0007\u0003[\n\u0019(a\u001e\u000e\u0005\u0005=$bAA9\r\u0005\u0019!\u000f\u001a3\n\t\u0005U\u0014q\u000e\u0002\u0004%\u0012#\u0005#\u0003\u0019\u0002z\u0005e\u0013QIA#\u0013\r\tY(\r\u0002\u0007)V\u0004H.Z\u001a)\t\u0005\u0015d'\u0015\u0005\u000b\u0003\u0003\u0003\u0001\u0012!Q!\n\u0005-\u0014!\u0005;pa&\u001c\u0017i]:jO:lWM\u001c;tA!\"\u0011q\u0010\u001cR\u0011)\t9\t\u0001EC\u0002\u0013\u0005\u0011\u0011R\u0001\u0015U\u00064\u0018\rV8qS\u000e\f5o]5h]6,g\u000e^:\u0016\u0005\u0005-\u0005CBAG\u0003/\u000bY*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003\u0011Q\u0017M^1\u000b\u0007\u0005Ue!A\u0002ba&LA!!'\u0002\u0010\n9!*\u0019<b%\u0012#\u0005#\u0003\u0019\u0002z\u0005u\u0015QIA#!\u0011\ty*a*\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000bA\u0001\\1oO*\u0011\u0011\u0011S\u0005\u0005\u0003;\n\t\u000b\u000b\u0003\u0002\u0006Z\n\u0006BCAW\u0001!\u0005\t\u0015)\u0003\u0002\f\u0006)\".\u0019<b)>\u0004\u0018nY!tg&<g.\\3oiN\u0004\u0003\u0006BAVmEC\u0011\"a-\u0001\u0011\u000b\u0007I\u0011\u0001-\u0002\u001b1|w\rT5lK2L\u0007n\\8eQ\u0011\t\tL\u000e\u001f\t\u0013\u0005e\u0006\u0001#A!B\u0013I\u0016A\u00047pO2K7.\u001a7jQ>|G\r\t\u0015\u0005\u0003o3D\bC\u0005\u0002@\u0002A)\u0019!C\u00011\u0006AAn\\4Qe&|'\u000f\u000b\u0003\u0002>Zb\u0004\"CAc\u0001!\u0005\t\u0015)\u0003Z\u0003%awn\u001a)sS>\u0014\b\u0005\u000b\u0003\u0002DZb\u0004bBAf\u0001\u0011\u0005\u0011QZ\u0001\u0013i>\u0004\u0018n\u0019#jgR\u0014\u0018NY;uS>t7/\u0006\u0002\u0002PB1\u0011QNA:\u0003#\u0004b\u0001MA!\u00033R\u0005\u0006BAemqBq!a6\u0001\t\u0003\tI.\u0001\fkCZ\fGk\u001c9jG\u0012K7\u000f\u001e:jEV$\u0018n\u001c8t+\t\tY\u000eE\u0004\u0002\u000e\u0006u\u0017Q\u0014&\n\t\u0005}\u0017q\u0012\u0002\f\u0015\u00064\u0018\rU1jeJ#E\tK\u0003\u0002VZ\n\u0019/\t\u0002\u0002f\u0006)\u0011G\f\u001b/c!9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\u0018\u0001\u0006;paR{\u0007/[2t!\u0016\u0014Hi\\2v[\u0016tG\u000f\u0006\u0003\u0002n\u0006E\bCBA7\u0003g\ny\u000f\u0005\u00051\u0003s\nI&!\u0012d\u0011\u0019i\u0013q\u001da\u0001_!\"\u0011q\u001d\u001cR\u0011\u001d\t9\u0010\u0001C\u0001\u0003s\f\u0001D[1wCR{\u0007\u000fV8qS\u000e\u001c\b+\u001a:E_\u000e,X.\u001a8u)\u0011\tY0a@\u0011\r\u00055\u0015qSA\u007f!!\u0001\u0014\u0011PAO\u0003\u000b\u001a\u0007BB\u0017\u0002v\u0002\u0007q\u0006\u000b\u0003\u0002vZ\n\u0006b\u0002B\u0003\u0001\u0011E#qA\u0001\u000eM>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0005\t%\u0001\u0003BAP\u0005\u0017I1!^AQ\u0011\u001d\u0011y\u0001\u0001C!\u0005#\tAa]1wKR1!1\u0003B\r\u0005K\u00012\u0001\rB\u000b\u0013\r\u00119\"\r\u0002\u0005+:LG\u000f\u0003\u0005\u0003\u001c\t5\u0001\u0019\u0001B\u000f\u0003\t\u00198\r\u0005\u0003\u0003 \t\u0005R\"\u0001\u0004\n\u0007\t\rbA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0004\u0003(\t5\u0001\u0019\u00019\u0002\tA\fG\u000f\u001b\u0015\u0005\u0005\u001b1\u0014\u000bK\u0002\u0001mq:qAa\f\u0003\u0011\u0003\u0011\t$A\nESN$(/\u001b2vi\u0016$G\nR!N_\u0012,G\u000eE\u0002\u0010\u0005g1a!\u0001\u0002\t\u0002\tU2C\u0002B\u001a\u0005o\u0011i\u0004E\u00021\u0005sI1Aa\u000f2\u0005\u0019\te.\u001f*fMB)!q\bB#y6\u0011!\u0011\t\u0006\u0004\u0005\u0007\"\u0011\u0001B;uS2LAAa\u0012\u0003B\t1Aj\\1eKJDqA\u001fB\u001a\t\u0003\u0011Y\u0005\u0006\u0002\u00032!Q!q\nB\u001a\u0005\u0004%\tA\u0001-\u0002#\u0011,g-Y;mi\u001e\u000bW.\\1TQ\u0006\u0004X\r\u0003\u0005\u0003T\tM\u0002\u0015!\u0003Z\u0003I!WMZ1vYR<\u0015-\\7b'\"\f\u0007/\u001a\u0011\b\u0011\t]#1\u0007E\u0005\u00053\nAbU1wK2{\u0017\r\u001a,2?B\u0002BAa\u0017\u0003^5\u0011!1\u0007\u0004\t\u0005?\u0012\u0019\u0004#\u0003\u0003b\ta1+\u0019<f\u0019>\fGMV\u0019`aM!!Q\fB\u001c\u0011\u001dQ(Q\fC\u0001\u0005K\"\"A!\u0017\t\u0015\t%$Q\fb\u0001\n\u0003\u00119!A\tuQ&\u001chi\u001c:nCR4VM]:j_:D\u0011B!\u001c\u0003^\u0001\u0006IA!\u0003\u0002%QD\u0017n\u001d$pe6\fGOV3sg&|g\u000e\t\u0005\u000b\u0005c\u0012iF1A\u0005\u0002\t\u001d\u0011!\u0004;iSN\u001cE.Y:t\u001d\u0006lW\rC\u0005\u0003v\tu\u0003\u0015!\u0003\u0003\n\u0005qA\u000f[5t\u00072\f7o\u001d(b[\u0016\u0004ca\u0002B=\u0005;\u0002%1\u0010\u0002\u0005\t\u0006$\u0018m\u0005\u0005\u0003x\t]\"Q\u0010BB!\r\u0001$qP\u0005\u0004\u0005\u0003\u000b$a\u0002)s_\u0012,8\r\u001e\t\u0004a\t\u0015\u0015b\u0001BDc\ta1+\u001a:jC2L'0\u00192mK\"I\u0001Fa\u001e\u0003\u0016\u0004%\t!\u0013\u0005\nW\t]$\u0011#Q\u0001\n)CqA\u001fB<\t\u0003\u0011y\t\u0006\u0003\u0003\u0012\nU\u0005\u0003\u0002BJ\u0005oj!A!\u0018\t\r!\u0012i\t1\u0001K\u0011)\u0011IJa\u001e\u0002\u0002\u0013\u0005!1T\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0003\u0012\nu\u0005\u0002\u0003\u0015\u0003\u0018B\u0005\t\u0019\u0001&\t\u0015\t\u0005&qOI\u0001\n\u0003\u0011\u0019+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u0015&f\u0001&\u0003(.\u0012!\u0011\u0016\t\u0005\u0005W\u0013\u0019,\u0004\u0002\u0003.*!!q\u0016BY\u0003%)hn\u00195fG.,GM\u0003\u0002:c%!!Q\u0017BW\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005s\u00139(!A\u0005B\t\u001d\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u0007\u0010C\u0005\u0003>\n]\u0014\u0011!C\u0001]\u0005a\u0001O]8ek\u000e$\u0018I]5us\"Q!\u0011\u0019B<\u0003\u0003%\tAa1\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u0019Bf!\r\u0001$qY\u0005\u0004\u0005\u0013\f$aA!os\"I!Q\u001aB`\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0004B\u0003Bi\u0005o\n\t\u0011\"\u0011\u0003T\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003VB1!q\u001bBo\u0005\u000bl!A!7\u000b\u0007\tm\u0017'\u0001\u0006d_2dWm\u0019;j_:LAAa8\u0003Z\nA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003d\n]\u0014\u0011!C\u0001\u0005K\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005O\u0014i\u000fE\u00021\u0005SL1Aa;2\u0005\u001d\u0011un\u001c7fC:D!B!4\u0003b\u0006\u0005\t\u0019\u0001Bc\u0011)\u0011\tPa\u001e\u0002\u0002\u0013\u0005#1_\u0001\tQ\u0006\u001c\bnQ8eKR\tq\u0006\u0003\u0006\u0003x\n]\u0014\u0011!C!\u0005s\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0013A!B!@\u0003x\u0005\u0005I\u0011\tB\u0000\u0003\u0019)\u0017/^1mgR!!q]B\u0001\u0011)\u0011iMa?\u0002\u0002\u0003\u0007!QY\u0004\u000b\u0007\u000b\u0011i&!A\t\u0002\r\u001d\u0011\u0001\u0002#bi\u0006\u0004BAa%\u0004\n\u0019Q!\u0011\u0010B/\u0003\u0003E\taa\u0003\u0014\r\r%1Q\u0002BB!\u001d\u0019ya!\u0006K\u0005#k!a!\u0005\u000b\u0007\rM\u0011'A\u0004sk:$\u0018.\\3\n\t\r]1\u0011\u0003\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004b\u0002>\u0004\n\u0011\u000511\u0004\u000b\u0003\u0007\u000fA!Ba>\u0004\n\u0005\u0005IQ\tB}\u0011)\u0019\tc!\u0003\u0002\u0002\u0013\u000551E\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005#\u001b)\u0003\u0003\u0004)\u0007?\u0001\rA\u0013\u0005\u000b\u0007S\u0019I!!A\u0005\u0002\u000e-\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0007[\u0019\u0019\u0004\u0005\u00031\u0007_Q\u0015bAB\u0019c\t1q\n\u001d;j_:D!b!\u000e\u0004(\u0005\u0005\t\u0019\u0001BI\u0003\rAH\u0005\r\u0005\u000b\u0007s\u0019I!!A\u0005\n\rm\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\u0010\u0011\t\u0005}5qH\u0005\u0005\u0007\u0003\n\tK\u0001\u0004PE*,7\r\u001e\u0004\b\u0007\u000b\u0012i\u0006QB$\u0005)1VM\u001d;fq\u0012\u000bG/Y\n\t\u0007\u0007\u00129D! \u0003\u0004\"Y11JB\"\u0005+\u0007I\u0011AB'\u0003\tIG-\u0006\u0002\u0002Z!Y1\u0011KB\"\u0005#\u0005\u000b\u0011BA-\u0003\rIG\r\t\u0005\u000b\u0007+\u001a\u0019E!f\u0001\n\u0003I\u0015\u0001\u0004;pa&\u001cw+Z5hQR\u001c\bBCB-\u0007\u0007\u0012\t\u0012)A\u0005\u0015\u0006iAo\u001c9jG^+\u0017n\u001a5ug\u0002BqA_B\"\t\u0003\u0019i\u0006\u0006\u0004\u0004`\r\u000541\r\t\u0005\u0005'\u001b\u0019\u0005\u0003\u0005\u0004L\rm\u0003\u0019AA-\u0011\u001d\u0019)fa\u0017A\u0002)C!B!'\u0004D\u0005\u0005I\u0011AB4)\u0019\u0019yf!\u001b\u0004l!Q11JB3!\u0003\u0005\r!!\u0017\t\u0013\rU3Q\rI\u0001\u0002\u0004Q\u0005B\u0003BQ\u0007\u0007\n\n\u0011\"\u0001\u0004pU\u00111\u0011\u000f\u0016\u0005\u00033\u00129\u000b\u0003\u0006\u0004v\r\r\u0013\u0013!C\u0001\u0005G\u000babY8qs\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0003:\u000e\r\u0013\u0011!C!\u0005\u000fA\u0011B!0\u0004D\u0005\u0005I\u0011\u0001\u0018\t\u0015\t\u000571IA\u0001\n\u0003\u0019i\b\u0006\u0003\u0003F\u000e}\u0004\"\u0003Bg\u0007w\n\t\u00111\u00010\u0011)\u0011\tna\u0011\u0002\u0002\u0013\u0005#1\u001b\u0005\u000b\u0005G\u001c\u0019%!A\u0005\u0002\r\u0015E\u0003\u0002Bt\u0007\u000fC!B!4\u0004\u0004\u0006\u0005\t\u0019\u0001Bc\u0011)\u0011\tpa\u0011\u0002\u0002\u0013\u0005#1\u001f\u0005\u000b\u0005o\u001c\u0019%!A\u0005B\te\bB\u0003B\u007f\u0007\u0007\n\t\u0011\"\u0011\u0004\u0010R!!q]BI\u0011)\u0011im!$\u0002\u0002\u0003\u0007!QY\u0004\u000b\u0007+\u0013i&!A\t\u0002\r]\u0015A\u0003,feR,\u0007\u0010R1uCB!!1SBM\r)\u0019)E!\u0018\u0002\u0002#\u000511T\n\u0007\u00073\u001biJa!\u0011\u0013\r=1qTA-\u0015\u000e}\u0013\u0002BBQ\u0007#\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001dQ8\u0011\u0014C\u0001\u0007K#\"aa&\t\u0015\t]8\u0011TA\u0001\n\u000b\u0012I\u0010\u0003\u0006\u0004\"\re\u0015\u0011!CA\u0007W#baa\u0018\u0004.\u000e=\u0006\u0002CB&\u0007S\u0003\r!!\u0017\t\u000f\rU3\u0011\u0016a\u0001\u0015\"Q1\u0011FBM\u0003\u0003%\tia-\u0015\t\rU6q\u0017\t\u0006a\r=\u0012\u0011\u001b\u0005\u000b\u0007k\u0019\t,!AA\u0002\r}\u0003BCB\u001d\u00073\u000b\t\u0011\"\u0003\u0004<\u001991Q\u0018B/\u0001\u000e}&\u0001C#eO\u0016$\u0015\r^1\u0014\u0011\rm&q\u0007B?\u0005\u0007C1ba1\u0004<\nU\r\u0011\"\u0001\u0004N\u0005)1O]2JI\"Y1qYB^\u0005#\u0005\u000b\u0011BA-\u0003\u0019\u0019(oY%eA!Y11ZB^\u0005+\u0007I\u0011AB'\u0003\u0015!7\u000f^%e\u0011-\u0019yma/\u0003\u0012\u0003\u0006I!!\u0017\u0002\r\u0011\u001cH/\u00133!\u0011)\u0019\u0019na/\u0003\u0016\u0004%\t\u0001W\u0001\fi>\\WM\\\"pk:$8\u000f\u0003\u0006\u0004X\u000em&\u0011#Q\u0001\ne\u000bA\u0002^8lK:\u001cu.\u001e8ug\u0002BqA_B^\t\u0003\u0019Y\u000e\u0006\u0005\u0004^\u000e}7\u0011]Br!\u0011\u0011\u0019ja/\t\u0011\r\r7\u0011\u001ca\u0001\u00033B\u0001ba3\u0004Z\u0002\u0007\u0011\u0011\f\u0005\b\u0007'\u001cI\u000e1\u0001Z\u0011)\u0011Ija/\u0002\u0002\u0013\u00051q\u001d\u000b\t\u0007;\u001cIoa;\u0004n\"Q11YBs!\u0003\u0005\r!!\u0017\t\u0015\r-7Q\u001dI\u0001\u0002\u0004\tI\u0006C\u0005\u0004T\u000e\u0015\b\u0013!a\u00013\"Q!\u0011UB^#\u0003%\taa\u001c\t\u0015\rU41XI\u0001\n\u0003\u0019y\u0007\u0003\u0006\u0004v\u000em\u0016\u0013!C\u0001\u0007o\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0004z*\u001a\u0011La*\t\u0015\te61XA\u0001\n\u0003\u00129\u0001C\u0005\u0003>\u000em\u0016\u0011!C\u0001]!Q!\u0011YB^\u0003\u0003%\t\u0001\"\u0001\u0015\t\t\u0015G1\u0001\u0005\n\u0005\u001b\u001cy0!AA\u0002=B!B!5\u0004<\u0006\u0005I\u0011\tBj\u0011)\u0011\u0019oa/\u0002\u0002\u0013\u0005A\u0011\u0002\u000b\u0005\u0005O$Y\u0001\u0003\u0006\u0003N\u0012\u001d\u0011\u0011!a\u0001\u0005\u000bD!B!=\u0004<\u0006\u0005I\u0011\tBz\u0011)\u00119pa/\u0002\u0002\u0013\u0005#\u0011 \u0005\u000b\u0005{\u001cY,!A\u0005B\u0011MA\u0003\u0002Bt\t+A!B!4\u0005\u0012\u0005\u0005\t\u0019\u0001Bc\u000f)!IB!\u0018\u0002\u0002#\u0005A1D\u0001\t\u000b\u0012<W\rR1uCB!!1\u0013C\u000f\r)\u0019iL!\u0018\u0002\u0002#\u0005AqD\n\u0007\t;!\tCa!\u0011\u0017\r=A1EA-\u00033J6Q\\\u0005\u0005\tK\u0019\tBA\tBEN$(/Y2u\rVt7\r^5p]NBqA\u001fC\u000f\t\u0003!I\u0003\u0006\u0002\u0005\u001c!Q!q\u001fC\u000f\u0003\u0003%)E!?\t\u0015\r\u0005BQDA\u0001\n\u0003#y\u0003\u0006\u0005\u0004^\u0012EB1\u0007C\u001b\u0011!\u0019\u0019\r\"\fA\u0002\u0005e\u0003\u0002CBf\t[\u0001\r!!\u0017\t\u000f\rMGQ\u0006a\u00013\"Q1\u0011\u0006C\u000f\u0003\u0003%\t\t\"\u000f\u0015\t\u0011mBq\b\t\u0006a\r=BQ\b\t\ta\u0005e\u0014\u0011LA-3\"Q1Q\u0007C\u001c\u0003\u0003\u0005\ra!8\t\u0015\reBQDA\u0001\n\u0013\u0019Y\u0004\u0003\u0005\u0003\u0010\tuC\u0011\u0001C#)Y\u0011\u0019\u0002b\u0012\u0005J\u0011-CQ\nC(\t#\"\u0019\u0006\"\u0016\u0005X\u0011e\u0003\u0002\u0003B\u000e\t\u0007\u0002\rA!\b\t\u000f\t\u001dB1\ta\u0001a\"11\u0003b\u0011A\u0002UAa\u0001\u000bC\"\u0001\u0004Y\u0002BB\u0017\u0005D\u0001\u0007q\u0006\u0003\u0004C\t\u0007\u0002\ra\f\u0005\u0007\u0011\u0012\r\u0003\u0019\u0001&\t\r]#\u0019\u00051\u0001Z\u0011\u0019\tG1\ta\u0001G\"1\u0011\u000eb\u0011A\u0002eC\u0001\u0002\"\u0018\u0003^\u0011\u0005AqL\u0001\u0005Y>\fG\rF\b}\tC\"\u0019\u0007\"\u001a\u0005h\u0011%D1\u000eC7\u0011!\u0011Y\u0002b\u0017A\u0002\tu\u0001b\u0002B\u0014\t7\u0002\r\u0001\u001d\u0005\u0007\u0005\u0012m\u0003\u0019A\u0018\t\r!#Y\u00061\u0001K\u0011\u00199F1\fa\u00013\"1\u0011\rb\u0017A\u0002\rDa!\u001bC.\u0001\u0004I\u0006\u0002\u0003C/\u0005g!\t\u0005\"\u001d\u0015\u000bq$\u0019\b\"\u001e\t\u0011\tmAq\u000ea\u0001\u0005;AqAa\n\u0005p\u0001\u0007\u0001\u000f\u000b\u0003\u0005pY\n\u0006B\u0003C>\u0005g\t\n\u0011\"\u0001\u0004x\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIaB!\u0002b \u00034E\u0005I\u0011\u0001CA\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u0011A1\u0011\u0016\u0004_\n\u001d\u0006\u0006\u0002B\u001amECCA!\f7#\u0002")
public class DistributedLDAModel
extends LDAModel {
    private final Graph<DenseVector<Object>, Object> graph;
    private final DenseVector<Object> globalTopicTotals;
    private final int k;
    private final int vocabSize;
    private final Vector docConcentration;
    private final double topicConcentration;
    private final double[] iterationTimes;
    private final double gammaShape;
    private final String[] checkpointFiles;
    private org.apache.spark.mllib.linalg.Matrix topicsMatrix;
    private RDD<Tuple3<Object, int[], int[]>> topicAssignments;
    private JavaRDD<Tuple3<Long, int[], int[]>> javaTopicAssignments;
    private double logLikelihood;
    private double logPrior;
    private volatile byte bitmap$0;

    public static String[] $lessinit$greater$default$9() {
        return DistributedLDAModel$.MODULE$.$lessinit$greater$default$9();
    }

    public static double $lessinit$greater$default$8() {
        return DistributedLDAModel$.MODULE$.$lessinit$greater$default$8();
    }

    public static DistributedLDAModel load(SparkContext sparkContext, String string) {
        return DistributedLDAModel$.MODULE$.load(sparkContext, string);
    }

    private org.apache.spark.mllib.linalg.Matrix topicsMatrix$lzycompute() {
        DistributedLDAModel distributedLDAModel = this;
        synchronized (distributedLDAModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2[] termTopicCounts = (Tuple2[])this.graph().vertices().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, DenseVector<Object>> x$5) {
                        return x$5._1$mcJ$sp() < 0L;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, DenseVector<Object>> apply(Tuple2<Object, DenseVector<Object>> x0$6) {
                        Tuple2<Object, DenseVector<Object>> tuple2 = x0$6;
                        if (tuple2 != null) {
                            long termIndex = tuple2._1$mcJ$sp();
                            DenseVector cnts = (DenseVector)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)LDA$.MODULE$.index2term(termIndex)), (Object)cnts);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
                DenseMatrix brzTopics = DenseMatrix$.MODULE$.zeros$mDc$sp(this.vocabSize(), this.k(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                Predef$.MODULE$.refArrayOps((Object[])termTopicCounts).foreach((Function1)new Serializable(this, brzTopics){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DistributedLDAModel $outer;
                    private final DenseMatrix brzTopics$3;

                    public final void apply(Tuple2<Object, DenseVector<Object>> x0$7) {
                        Tuple2<Object, DenseVector<Object>> tuple2 = x0$7;
                        if (tuple2 != null) {
                            int term = tuple2._1$mcI$sp();
                            DenseVector cnts = (DenseVector)tuple2._2();
                            for (int j = 0; j < this.$outer.k(); ++j) {
                                this.brzTopics$3.update$mcD$sp(term, j, cnts.apply$mcD$sp(j));
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.brzTopics$3 = brzTopics$3;
                    }
                });
                this.topicsMatrix = Matrices$.MODULE$.fromBreeze((Matrix<Object>)brzTopics);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.topicsMatrix;
        }
    }

    private RDD topicAssignments$lzycompute() {
        DistributedLDAModel distributedLDAModel = this;
        synchronized (distributedLDAModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                double eta = this.topicConcentration();
                int W = this.vocabSize();
                double alpha = this.docConcentration().apply(0);
                DenseVector<Object> N_k = this.globalTopicTotals();
                Serializable sendMsg = new Serializable(this, eta, W, alpha, N_k){
                    public static final long serialVersionUID = 0L;
                    private final double eta$1;
                    private final int W$1;
                    private final double alpha$1;
                    private final DenseVector N_k$2;

                    public final void apply(EdgeContext<DenseVector<Object>, Object, Tuple2<int[], int[]>> edgeContext) {
                        DenseVector<Object> scaledTopicDistribution = LDA$.MODULE$.computePTopic((DenseVector<Object>)((DenseVector)edgeContext.srcAttr()), (DenseVector<Object>)((DenseVector)edgeContext.dstAttr()), (DenseVector<Object>)this.N_k$2, this.W$1, this.eta$1, this.alpha$1);
                        int topTopic = BoxesRunTime.unboxToInt((Object)argmax$.MODULE$.apply(scaledTopicDistribution, argmax$.MODULE$.reduce_Double(DenseVector$.MODULE$.canTraverseKeyValuePairs())));
                        int term = LDA$.MODULE$.index2term(edgeContext.dstId());
                        edgeContext.sendToSrc((Object)new Tuple2((Object)new int[]{term}, (Object)new int[]{topTopic}));
                    }
                    {
                        this.eta$1 = eta$1;
                        this.W$1 = W$1;
                        this.alpha$1 = alpha$1;
                        this.N_k$2 = N_k$2;
                    }
                };
                Serializable mergeMsg = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<int[], int[]> apply(Tuple2<int[], int[]> terms_topics0, Tuple2<int[], int[]> terms_topics1) {
                        return new Tuple2(Predef$.MODULE$.intArrayOps((int[])terms_topics0._1()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps((int[])terms_topics1._1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), Predef$.MODULE$.intArrayOps((int[])terms_topics0._2()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps((int[])terms_topics1._2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                    }
                };
                VertexRDD perDocAssignments = this.graph().aggregateMessages((Function1)sendMsg, (Function2)mergeMsg, this.graph().aggregateMessages$default$3(), ClassTag$.MODULE$.apply(Tuple2.class)).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, ?> v) {
                        return LDA$.MODULE$.isDocumentVertex(v);
                    }
                });
                this.topicAssignments = perDocAssignments.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, int[], int[]> apply(Tuple2<Object, Tuple2<int[], int[]>> x0$10) {
                        Tuple2<Object, Tuple2<int[], int[]>> tuple2 = x0$10;
                        if (tuple2 != null) {
                            long docID = tuple2._1$mcJ$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            long l = docID;
                            if (tuple22 != null) {
                                int[] terms = (int[])tuple22._1();
                                int[] topics = (int[])tuple22._2();
                                if (terms != null) {
                                    int[] nArray = terms;
                                    if (topics != null) {
                                        int[] nArray2 = topics;
                                        Tuple2 tuple23 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(nArray).zip((GenIterable)Predef$.MODULE$.wrapIntArray(nArray2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).sortBy((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final int apply(Tuple2<Object, Object> x$12) {
                                                return x$12._1$mcI$sp();
                                            }
                                        }, (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
                                        if (tuple23 != null) {
                                            Tuple2 tuple24;
                                            int[] sortedTerms = (int[])tuple23._1();
                                            int[] sortedTopics = (int[])tuple23._2();
                                            Tuple2 tuple25 = tuple24 = new Tuple2((Object)sortedTerms, (Object)sortedTopics);
                                            int[] sortedTerms2 = (int[])tuple25._1();
                                            int[] sortedTopics2 = (int[])tuple25._2();
                                            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)l), Predef$.MODULE$.intArrayOps(sortedTerms2).toArray(ClassTag$.MODULE$.Int()), Predef$.MODULE$.intArrayOps(sortedTopics2).toArray(ClassTag$.MODULE$.Int()));
                                            return tuple3;
                                        }
                                        throw new MatchError((Object)tuple23);
                                    }
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Tuple3.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.topicAssignments;
        }
    }

    private JavaRDD javaTopicAssignments$lzycompute() {
        DistributedLDAModel distributedLDAModel = this;
        synchronized (distributedLDAModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.javaTopicAssignments = this.topicAssignments().toJavaRDD();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.javaTopicAssignments;
        }
    }

    private double logLikelihood$lzycompute() {
        DistributedLDAModel distributedLDAModel = this;
        synchronized (distributedLDAModel) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                double alpha = this.docConcentration().apply(0);
                double eta = this.topicConcentration();
                Predef$.MODULE$.assert(eta > 1.0);
                Predef$.MODULE$.assert(alpha > 1.0);
                DenseVector<Object> N_k = this.globalTopicTotals();
                DenseVector smoothed_N_k = (DenseVector)N_k.$plus((Object)BoxesRunTime.boxToDouble((double)((double)this.vocabSize() * (eta - 1.0))), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                Serializable sendMsg = new Serializable(this, alpha, eta, smoothed_N_k){
                    public static final long serialVersionUID = 0L;
                    private final double alpha$2;
                    private final double eta$2;
                    private final DenseVector smoothed_N_k$1;

                    public final void apply(EdgeContext<DenseVector<Object>, Object, Object> edgeContext) {
                        double N_wj = BoxesRunTime.unboxToDouble((Object)edgeContext.attr());
                        DenseVector smoothed_N_wk = (DenseVector)((NumericOps)edgeContext.dstAttr()).$plus((Object)BoxesRunTime.boxToDouble((double)(this.eta$2 - 1.0)), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                        DenseVector smoothed_N_kj = (DenseVector)((NumericOps)edgeContext.srcAttr()).$plus((Object)BoxesRunTime.boxToDouble((double)(this.alpha$2 - 1.0)), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                        DenseVector phi_wk = (DenseVector)smoothed_N_wk.$colon$div((Object)this.smoothed_N_k$1, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv());
                        DenseVector theta_kj = (DenseVector)normalize$.MODULE$.apply((Object)smoothed_N_kj, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
                        double tokenLogLikelihood = N_wj * scala.math.package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)phi_wk.dot((Object)theta_kj, DenseVector$.MODULE$.canDotD())));
                        edgeContext.sendToDst((Object)BoxesRunTime.boxToDouble((double)tokenLogLikelihood));
                    }
                    {
                        this.alpha$2 = alpha$2;
                        this.eta$2 = eta$2;
                        this.smoothed_N_k$1 = smoothed_N_k$1;
                    }
                };
                this.logLikelihood = BoxesRunTime.unboxToDouble((Object)this.graph().aggregateMessages((Function1)sendMsg, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$14, double x$15) {
                        return this.apply$mcDDD$sp(x$14, x$15);
                    }

                    public double apply$mcDDD$sp(double x$14, double x$15) {
                        return x$14 + x$15;
                    }
                }, this.graph().aggregateMessages$default$3(), ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$16) {
                        return x$16._2$mcD$sp();
                    }
                }, ClassTag$.MODULE$.Double()).fold((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$17, double x$18) {
                        return this.apply$mcDDD$sp(x$17, x$18);
                    }

                    public double apply$mcDDD$sp(double x$17, double x$18) {
                        return x$17 + x$18;
                    }
                }));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logLikelihood;
        }
    }

    private double logPrior$lzycompute() {
        DistributedLDAModel distributedLDAModel = this;
        synchronized (distributedLDAModel) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                double alpha = this.docConcentration().apply(0);
                double eta = this.topicConcentration();
                DenseVector<Object> N_k = this.globalTopicTotals();
                DenseVector smoothed_N_k = (DenseVector)N_k.$plus((Object)BoxesRunTime.boxToDouble((double)((double)this.vocabSize() * (eta - 1.0))), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                Serializable seqOp = new Serializable(this, alpha, eta, smoothed_N_k){
                    public static final long serialVersionUID = 0L;
                    private final double alpha$3;
                    private final double eta$3;
                    private final DenseVector smoothed_N_k$2;

                    public final double apply(double x0$11, Tuple2<Object, DenseVector<Object>> x1$2) {
                        Tuple2 vertex;
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$11), x1$2);
                        if (tuple2 != null && (vertex = (Tuple2)tuple2._2()) != null) {
                            double d;
                            Tuple2 tuple22 = vertex;
                            if (LDA$.MODULE$.isTermVertex(tuple22)) {
                                DenseVector N_wk = (DenseVector)tuple22._2();
                                DenseVector smoothed_N_wk = (DenseVector)N_wk.$plus((Object)BoxesRunTime.boxToDouble((double)(this.eta$3 - 1.0)), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                                DenseVector phi_wk = (DenseVector)smoothed_N_wk.$colon$div((Object)this.smoothed_N_k$2, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv());
                                d = (this.eta$3 - 1.0) * BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(phi_wk.map$mcD$sp((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(double x) {
                                        return this.apply$mcDD$sp(x);
                                    }

                                    public double apply$mcDD$sp(double x) {
                                        return scala.math.package$.MODULE$.log(x);
                                    }
                                }, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
                            } else {
                                DenseVector N_kj = (DenseVector)tuple22._2();
                                DenseVector smoothed_N_kj = (DenseVector)N_kj.$plus((Object)BoxesRunTime.boxToDouble((double)(this.alpha$3 - 1.0)), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd());
                                DenseVector theta_kj = (DenseVector)normalize$.MODULE$.apply((Object)smoothed_N_kj, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
                                d = (this.alpha$3 - 1.0) * BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(theta_kj.map$mcD$sp((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(double x) {
                                        return this.apply$mcDD$sp(x);
                                    }

                                    public double apply$mcDD$sp(double x) {
                                        return scala.math.package$.MODULE$.log(x);
                                    }
                                }, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
                            }
                            double d2 = d;
                            return d2;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.alpha$3 = alpha$3;
                        this.eta$3 = eta$3;
                        this.smoothed_N_k$2 = smoothed_N_k$2;
                    }
                };
                this.logPrior = BoxesRunTime.unboxToDouble((Object)this.graph().vertices().aggregate((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)seqOp, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$19, double x$20) {
                        return this.apply$mcDDD$sp(x$19, x$20);
                    }

                    public double apply$mcDDD$sp(double x$19, double x$20) {
                        return x$19 + x$20;
                    }
                }, ClassTag$.MODULE$.Double()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.logPrior;
        }
    }

    public Graph<DenseVector<Object>, Object> graph() {
        return this.graph;
    }

    public DenseVector<Object> globalTopicTotals() {
        return this.globalTopicTotals;
    }

    @Override
    public int k() {
        return this.k;
    }

    @Override
    public int vocabSize() {
        return this.vocabSize;
    }

    @Override
    public Vector docConcentration() {
        return this.docConcentration;
    }

    @Override
    public double topicConcentration() {
        return this.topicConcentration;
    }

    public double[] iterationTimes() {
        return this.iterationTimes;
    }

    @Override
    public double gammaShape() {
        return this.gammaShape;
    }

    public String[] checkpointFiles() {
        return this.checkpointFiles;
    }

    public LocalLDAModel toLocal() {
        return new LocalLDAModel(this.topicsMatrix(), this.docConcentration(), this.topicConcentration(), this.gammaShape());
    }

    @Override
    public org.apache.spark.mllib.linalg.Matrix topicsMatrix() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.topicsMatrix$lzycompute() : this.topicsMatrix;
    }

    @Override
    public Tuple2<int[], double[]>[] describeTopics(int maxTermsPerTopic) {
        int numTopics = this.k();
        DenseVector<Object> N_k = this.globalTopicTotals();
        VertexRDD qual$1 = this.graph().vertices().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, ?> v) {
                return LDA$.MODULE$.isTermVertex(v);
            }
        });
        Serializable x$24 = new Serializable(this, maxTermsPerTopic, numTopics, N_k){
            public static final long serialVersionUID = 0L;
            public final int maxTermsPerTopic$2;
            public final int numTopics$1;
            public final DenseVector N_k$1;

            public final Iterator<BoundedPriorityQueue<Tuple2<Object, Object>>[]> apply(Iterator<Tuple2<Object, DenseVector<Object>>> termVertices) {
                BoundedPriorityQueue[] queues = (BoundedPriorityQueue[])Array$.MODULE$.fill(this.numTopics$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final BoundedPriorityQueue<Tuple2<Object, Object>> apply() {
                        return new BoundedPriorityQueue(this.$outer.maxTermsPerTopic$2, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(BoundedPriorityQueue.class));
                termVertices.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, DenseVector<Object>> check$ifrefutable$1) {
                        Tuple2<Object, DenseVector<Object>> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, queues){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;
                    private final BoundedPriorityQueue[] queues$1;

                    public final void apply(Tuple2<Object, DenseVector<Object>> x$6) {
                        Tuple2<Object, DenseVector<Object>> tuple2 = x$6;
                        if (tuple2 != null) {
                            long termId = tuple2._1$mcJ$sp();
                            DenseVector n_wk = (DenseVector)tuple2._2();
                            for (int topic = 0; topic < this.$outer.numTopics$1; ++topic) {
                                this.queues$1[topic].$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)(n_wk.apply$mcD$sp(topic) / this.$outer.N_k$1.apply$mcD$sp(topic)))), (Object)BoxesRunTime.boxToInteger((int)LDA$.MODULE$.index2term((int)termId))));
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.queues$1 = queues$1;
                    }
                });
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BoundedPriorityQueue[][]{queues}));
            }
            {
                this.maxTermsPerTopic$2 = maxTermsPerTopic$2;
                this.numTopics$1 = numTopics$1;
                this.N_k$1 = N_k$1;
            }
        };
        boolean x$25 = qual$1.mapPartitions$default$2();
        BoundedPriorityQueue[] topicsInQueues = (BoundedPriorityQueue[])qual$1.mapPartitions((Function1)x$24, x$25, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(BoundedPriorityQueue.class))).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BoundedPriorityQueue<Tuple2<Object, Object>>[] apply(BoundedPriorityQueue<Tuple2<Object, Object>>[] q1, BoundedPriorityQueue<Tuple2<Object, Object>>[] q2) {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])q1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])q2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BoundedPriorityQueue<Tuple2<Object, Object>> apply(Tuple2<BoundedPriorityQueue<Tuple2<Object, Object>>, BoundedPriorityQueue<Tuple2<Object, Object>>> x0$8) {
                        Tuple2<BoundedPriorityQueue<Tuple2<Object, Object>>, BoundedPriorityQueue<Tuple2<Object, Object>>> tuple2 = x0$8;
                        if (tuple2 != null) {
                            BoundedPriorityQueue a = (BoundedPriorityQueue)tuple2._1();
                            BoundedPriorityQueue b = (BoundedPriorityQueue)tuple2._2();
                            BoundedPriorityQueue boundedPriorityQueue = a.$plus$plus$eq((TraversableOnce)b);
                            return boundedPriorityQueue;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                return q1;
            }
        });
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])topicsInQueues).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<int[], double[]> apply(BoundedPriorityQueue<Tuple2<Object, Object>> q) {
                Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])q.toArray(ClassTag$.MODULE$.apply(Tuple2.class))).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$7) {
                        return -x$7._1$mcD$sp();
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    double[] termWeights = (double[])tuple2._1();
                    int[] terms = (int[])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)termWeights, (Object)terms);
                    double[] termWeights2 = (double[])tuple23._1();
                    int[] terms2 = (int[])tuple23._2();
                    return new Tuple2(Predef$.MODULE$.intArrayOps(terms2).toArray(ClassTag$.MODULE$.Int()), Predef$.MODULE$.doubleArrayOps(termWeights2).toArray(ClassTag$.MODULE$.Double()));
                }
                throw new MatchError((Object)tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public Tuple2<long[], double[]>[] topDocumentsPerTopic(int maxDocumentsPerTopic) {
        int numTopics = this.k();
        RDD<Tuple2<Object, Vector>> qual$2 = this.topicDistributions();
        Serializable x$26 = new Serializable(this, maxDocumentsPerTopic, numTopics){
            public static final long serialVersionUID = 0L;
            public final int maxDocumentsPerTopic$1;
            public final int numTopics$2;

            public final Iterator<BoundedPriorityQueue<Tuple2<Object, Object>>[]> apply(Iterator<Tuple2<Object, Vector>> docVertices) {
                BoundedPriorityQueue[] queues = (BoundedPriorityQueue[])Array$.MODULE$.fill(this.numTopics$2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final BoundedPriorityQueue<Tuple2<Object, Object>> apply() {
                        return new BoundedPriorityQueue(this.$outer.maxDocumentsPerTopic$1, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Long$.MODULE$));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(BoundedPriorityQueue.class));
                docVertices.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Vector> check$ifrefutable$2) {
                        Tuple2<Object, Vector> tuple2 = check$ifrefutable$2;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, queues){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;
                    private final BoundedPriorityQueue[] queues$2;

                    public final void apply(Tuple2<Object, Vector> x$9) {
                        Tuple2<Object, Vector> tuple2 = x$9;
                        if (tuple2 != null) {
                            long docId = tuple2._1$mcJ$sp();
                            Vector docTopics = (Vector)tuple2._2();
                            for (int topic = 0; topic < this.$outer.numTopics$2; ++topic) {
                                this.queues$2[topic].$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)docTopics.apply(topic))), (Object)BoxesRunTime.boxToLong((long)docId)));
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.queues$2 = queues$2;
                    }
                });
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BoundedPriorityQueue[][]{queues}));
            }
            {
                this.maxDocumentsPerTopic$1 = maxDocumentsPerTopic$1;
                this.numTopics$2 = numTopics$2;
            }
        };
        boolean x$27 = qual$2.mapPartitions$default$2();
        RDD qual$3 = qual$2.mapPartitions((Function1)x$26, x$27, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(BoundedPriorityQueue.class)));
        Serializable x$28 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BoundedPriorityQueue<Tuple2<Object, Object>>[] apply(BoundedPriorityQueue<Tuple2<Object, Object>>[] q1, BoundedPriorityQueue<Tuple2<Object, Object>>[] q2) {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])q1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])q2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BoundedPriorityQueue<Tuple2<Object, Object>> apply(Tuple2<BoundedPriorityQueue<Tuple2<Object, Object>>, BoundedPriorityQueue<Tuple2<Object, Object>>> x0$9) {
                        Tuple2<BoundedPriorityQueue<Tuple2<Object, Object>>, BoundedPriorityQueue<Tuple2<Object, Object>>> tuple2 = x0$9;
                        if (tuple2 != null) {
                            BoundedPriorityQueue a = (BoundedPriorityQueue)tuple2._1();
                            BoundedPriorityQueue b = (BoundedPriorityQueue)tuple2._2();
                            BoundedPriorityQueue boundedPriorityQueue = a.$plus$plus$eq((TraversableOnce)b);
                            return boundedPriorityQueue;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                return q1;
            }
        };
        int x$29 = qual$3.treeReduce$default$2();
        BoundedPriorityQueue[] topicsInQueues = (BoundedPriorityQueue[])qual$3.treeReduce((Function2)x$28, x$29);
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])topicsInQueues).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<long[], double[]> apply(BoundedPriorityQueue<Tuple2<Object, Object>> q) {
                Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])q.toArray(ClassTag$.MODULE$.apply(Tuple2.class))).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$10) {
                        return -x$10._1$mcD$sp();
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Long());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    double[] docTopics = (double[])tuple2._1();
                    long[] docs = (long[])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)docTopics, (Object)docs);
                    double[] docTopics2 = (double[])tuple23._1();
                    long[] docs2 = (long[])tuple23._2();
                    return new Tuple2(Predef$.MODULE$.longArrayOps(docs2).toArray(ClassTag$.MODULE$.Long()), Predef$.MODULE$.doubleArrayOps(docTopics2).toArray(ClassTag$.MODULE$.Double()));
                }
                throw new MatchError((Object)tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public RDD<Tuple3<Object, int[], int[]>> topicAssignments() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.topicAssignments$lzycompute() : this.topicAssignments;
    }

    public JavaRDD<Tuple3<Long, int[], int[]>> javaTopicAssignments() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.javaTopicAssignments$lzycompute() : this.javaTopicAssignments;
    }

    public double logLikelihood() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logLikelihood$lzycompute() : this.logLikelihood;
    }

    public double logPrior() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.logPrior$lzycompute() : this.logPrior;
    }

    public RDD<Tuple2<Object, Vector>> topicDistributions() {
        return this.graph().vertices().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, ?> v) {
                return LDA$.MODULE$.isDocumentVertex(v);
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(Tuple2<Object, DenseVector<Object>> x0$12) {
                Tuple2<Object, DenseVector<Object>> tuple2 = x0$12;
                if (tuple2 != null) {
                    long docID = tuple2._1$mcJ$sp();
                    DenseVector topicCounts = (DenseVector)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docID), (Object)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)((breeze.linalg.Vector)normalize$.MODULE$.apply((Object)topicCounts, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double())))));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public JavaPairRDD<Long, Vector> javaTopicDistributions() {
        return JavaPairRDD$.MODULE$.fromRDD(this.topicDistributions(), ClassTag$.MODULE$.apply(Long.class), ClassTag$.MODULE$.apply(Vector.class));
    }

    public RDD<Tuple3<Object, int[], double[]>> topTopicsPerDocument(int k) {
        return this.graph().vertices().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, ?> v) {
                return LDA$.MODULE$.isDocumentVertex(v);
            }
        }).map((Function1)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$4;

            public final Tuple3<Object, int[], double[]> apply(Tuple2<Object, DenseVector<Object>> x0$13) {
                Tuple2<Object, DenseVector<Object>> tuple2 = x0$13;
                if (tuple2 != null) {
                    long docID = tuple2._1$mcJ$sp();
                    DenseVector topicCounts = (DenseVector)tuple2._2();
                    IndexedSeq topIndices = (IndexedSeq)argtopk$.MODULE$.apply((Object)topicCounts, (Object)BoxesRunTime.boxToInteger((int)this.k$4), argtopk$.MODULE$.argtopkWithQT(Predef$.MODULE$.$conforms(), (Ordering)Ordering.Double$.MODULE$));
                    double sumCounts = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)topicCounts, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
                    breeze.linalg.Vector weights = sumCounts != 0.0 ? (breeze.linalg.Vector)((ImmutableNumericOps)topicCounts.apply((Object)topIndices, Tensor$.MODULE$.canSliceTensor(ClassTag$.MODULE$.Double()))).$div((Object)BoxesRunTime.boxToDouble((double)sumCounts), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv()) : (breeze.linalg.Vector)topicCounts.apply((Object)topIndices, Tensor$.MODULE$.canSliceTensor(ClassTag$.MODULE$.Double()));
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)docID), topIndices.toArray(ClassTag$.MODULE$.Int()), (Object)weights.toArray$mcD$sp(ClassTag$.MODULE$.Double()));
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }
            {
                this.k$4 = k$4;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public JavaRDD<Tuple3<Long, int[], double[]>> javaTopTopicsPerDocument(int k) {
        RDD<Tuple3<Object, int[], double[]>> topics = this.topTopicsPerDocument(k);
        return topics.toJavaRDD();
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        DistributedLDAModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.graph(), this.globalTopicTotals(), this.k(), this.vocabSize(), this.docConcentration(), this.topicConcentration(), this.iterationTimes(), this.gammaShape());
    }

    public DistributedLDAModel(Graph<DenseVector<Object>, Object> graph, DenseVector<Object> globalTopicTotals, int k, int vocabSize, Vector docConcentration, double topicConcentration, double[] iterationTimes, double gammaShape, String[] checkpointFiles) {
        this.graph = graph;
        this.globalTopicTotals = globalTopicTotals;
        this.k = k;
        this.vocabSize = vocabSize;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.iterationTimes = iterationTimes;
        this.gammaShape = gammaShape;
        this.checkpointFiles = checkpointFiles;
    }
}

