/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.evaluation.AreaUnderCurve$;
import org.apache.spark.mllib.evaluation.binary.BinaryClassificationMetricComputer;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrix;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrixImpl;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter$;
import org.apache.spark.mllib.evaluation.binary.FMeasure;
import org.apache.spark.mllib.evaluation.binary.FalsePositiveRate$;
import org.apache.spark.mllib.evaluation.binary.Precision$;
import org.apache.spark.mllib.evaluation.binary.Recall$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u00015\u00111DQ5oCJL8\t\\1tg&4\u0017nY1uS>tW*\u001a;sS\u000e\u001c(BA\u0002\u0005\u0003))g/\u00197vCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005q1oY8sK\u0006sG\rT1cK2\u001cX#A\u000f\u0011\u0007y\t3%D\u0001 \u0015\t\u0001c!A\u0002sI\u0012L!AI\u0010\u0003\u0007I#E\t\u0005\u0003\u0010I\u00192\u0013BA\u0013\u0011\u0005\u0019!V\u000f\u001d7feA\u0011qbJ\u0005\u0003QA\u0011a\u0001R8vE2,\u0007f\u0001\u000e+aA\u00111FL\u0007\u0002Y)\u0011QFB\u0001\u000bC:tw\u000e^1uS>t\u0017BA\u0018-\u0005\u0015\u0019\u0016N\\2fC\u0005\t\u0014!B\u0019/g9\u0002\u0004\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u001fM\u001cwN]3B]\u0012d\u0015MY3mg\u0002B3A\r\u00161\u0011!1\u0004A!b\u0001\n\u00039\u0014a\u00028v[\nKgn]\u000b\u0002qA\u0011q\"O\u0005\u0003uA\u00111!\u00138uQ\r)$\u0006\r\u0005\t{\u0001\u0011\t\u0011)A\u0005q\u0005Aa.^7CS:\u001c\b\u0005K\u0002=UABQ\u0001\u0011\u0001\u0005\u0002\u0005\u000ba\u0001P5oSRtDc\u0001\"E\rB\u00111\tA\u0007\u0002\u0005!)1d\u0010a\u0001;!\u001aAI\u000b\u0019\t\u000bYz\u0004\u0019\u0001\u001d)\u0007\u0019S\u0003\u0007K\u0002@UABQ\u0001\u0011\u0001\u0005\u0002)#\"AQ&\t\u000bmI\u0005\u0019A\u000f)\u0007%SS*I\u0001O\u0003\u0015\td\u0006\r\u00181\u0011\u0019\u0001\u0005\u0001\"\u0001\u0005!R\u0011!)\u0015\u0005\u00067=\u0003\rA\u0015\t\u0003'\u000et!\u0001\u00161\u000f\u0005UsfB\u0001,^\u001d\t9FL\u0004\u0002Y76\t\u0011L\u0003\u0002[\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005}3\u0011aA:rY&\u0011\u0011MY\u0001\ba\u0006\u001c7.Y4f\u0015\tyf!\u0003\u0002eK\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003C\nDQa\u001a\u0001\u0005\u0002!\f\u0011\"\u001e8qKJ\u001c\u0018n\u001d;\u0015\u0003%\u0004\"a\u00046\n\u0005-\u0004\"\u0001B+oSRD3A\u001a\u0016N\u0011\u0015q\u0007\u0001\"\u0001p\u0003)!\bN]3tQ>dGm\u001d\u000b\u0002aB\u0019a$\t\u0014)\u00075TS\nC\u0003t\u0001\u0011\u0005A/A\u0002s_\u000e$\u0012!\b\u0015\u0004e*j\u0005\"B<\u0001\t\u0003A\u0018\u0001D1sK\u0006,f\u000eZ3s%>\u001bE#\u0001\u0014)\u0007YTS\nC\u0003|\u0001\u0011\u0005A/\u0001\u0002qe\"\u001a!PK'\t\u000by\u0004A\u0011\u0001=\u0002\u0017\u0005\u0014X-Y+oI\u0016\u0014\bK\u0015\u0015\u0004{*j\u0005bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0014M6+\u0017m];sK\nKH\u000b\u001b:fg\"|G\u000e\u001a\u000b\u0004;\u0005\u001d\u0001bBA\u0005\u0003\u0003\u0001\rAJ\u0001\u0005E\u0016$\u0018\r\u000b\u0003\u0002\u0002)j\u0005BBA\u0002\u0001\u0011\u0005A\u000f\u000b\u0003\u0002\u000e)j\u0005BBA\n\u0001\u0011\u0005A/\u0001\u000bqe\u0016\u001c\u0017n]5p]\nKH\u000b\u001b:fg\"|G\u000e\u001a\u0015\u0005\u0003#QS\n\u0003\u0004\u0002\u001a\u0001!\t\u0001^\u0001\u0012e\u0016\u001c\u0017\r\u001c7CsRC'/Z:i_2$\u0007\u0006BA\fU5CA\"a\b\u0001!\u0003E9\u0019)C\u0005\u0003C\t1\u0001\u001f\u00135+\t\t\u0019\u0003\u0005\u0004\u0010I\u0005\u0015\u0012Q\u0007\t\u0005=\u0005\n9\u0003E\u0003\u0010I\u0019\nI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\tyCA\u0001\u0007E&t\u0017M]=\n\t\u0005M\u0012Q\u0006\u0002\u0013\u0005&t\u0017M]=MC\n,GnQ8v]R,'\u000f\u0005\u0003\u001fC\u0005]\u0002#B\b%M\u0005e\u0002\u0003BA\u0016\u0003wIA!!\u0010\u0002.\t)\")\u001b8bef\u001cuN\u001c4vg&|g.T1ue&D\bBCA!\u0001!\u0005\t\u0015)\u0003\u0002$\u0005!\u0001\u0010\n\u001b!\u0011)\t)\u0005\u0001EC\u0002\u0013%\u0011qI\u0001\u0011GVlW\u000f\\1uSZ,7i\\;oiN,\"!!\n\t\u0015\u0005-\u0003\u0001#A!B\u0013\t)#A\tdk6,H.\u0019;jm\u0016\u001cu.\u001e8ug\u0002B!\"a\u0014\u0001\u0011\u000b\u0007I\u0011BA)\u0003)\u0019wN\u001c4vg&|gn]\u000b\u0003\u0003kA!\"!\u0016\u0001\u0011\u0003\u0005\u000b\u0015BA\u001b\u0003-\u0019wN\u001c4vg&|gn\u001d\u0011\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\\u0005Y1M]3bi\u0016\u001cUO\u001d<f)\ri\u0012Q\f\u0005\t\u0003?\n9\u00061\u0001\u0002b\u0005\t\u0011\u0010\u0005\u0003\u0002,\u0005\r\u0014\u0002BA3\u0003[\u0011!EQ5oCJL8\t\\1tg&4\u0017nY1uS>tW*\u001a;sS\u000e\u001cu.\u001c9vi\u0016\u0014\bbBA-\u0001\u0011%\u0011\u0011\u000e\u000b\u0006;\u0005-\u0014q\u000e\u0005\t\u0003[\n9\u00071\u0001\u0002b\u0005\t\u0001\u0010\u0003\u0005\u0002`\u0005\u001d\u0004\u0019AA1Q\r\u0001!&\u0014")
public class BinaryClassificationMetrics
implements Logging {
    private final RDD<Tuple2<Object, Object>> scoreAndLabels;
    private final int numBins;
    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$4;
    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts;
    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$4$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2 tuple2;
                RDD rDD;
                OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(this.scoreAndLabels(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).combineByKey((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryLabelCounter apply(double label) {
                        return new BinaryLabelCounter(0L, 0L).$plus$eq(label);
                    }
                }, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryLabelCounter apply(BinaryLabelCounter c, double label) {
                        return c.$plus$eq(label);
                    }
                }, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryLabelCounter apply(BinaryLabelCounter c1, BinaryLabelCounter c2) {
                        return c1.$plus$eq(c2);
                    }
                }), (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class));
                boolean x$5 = false;
                int x$6 = qual$1.sortByKey$default$2();
                RDD counts = qual$1.sortByKey(x$5, x$6);
                if (this.numBins() == 0) {
                    rDD = counts;
                } else {
                    long countsSize = counts.count();
                    LongRef grouping = LongRef.create((long)(countsSize / (long)this.numBins()));
                    if (grouping.elem < 2L) {
                        this.logInfo((Function0<String>)new Serializable(this, countsSize){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ BinaryClassificationMetrics $outer;
                            private final long countsSize$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Curve is too small (", ") for ", " bins to be useful"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.countsSize$1), BoxesRunTime.boxToInteger((int)this.$outer.numBins())}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.countsSize$1 = countsSize$1;
                            }
                        });
                        rDD = counts;
                    } else {
                        if (grouping.elem >= Integer.MAX_VALUE) {
                            this.logWarning((Function0<String>)new Serializable(this, countsSize){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ BinaryClassificationMetrics $outer;
                                private final long countsSize$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Curve too large (", ") for ", " bins; capping at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.countsSize$1), BoxesRunTime.boxToInteger((int)this.$outer.numBins()), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.countsSize$1 = countsSize$1;
                                }
                            });
                            grouping.elem = Integer.MAX_VALUE;
                        }
                        rDD = counts.mapPartitions((Function1)new Serializable(this, grouping){
                            public static final long serialVersionUID = 0L;
                            private final LongRef grouping$1;

                            public final Iterator<Tuple2<Object, BinaryLabelCounter>> apply(Iterator<Tuple2<Object, BinaryLabelCounter>> x$2) {
                                return x$2.grouped((int)this.grouping$1.elem).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<Object, BinaryLabelCounter> apply(Seq<Tuple2<Object, BinaryLabelCounter>> pairs) {
                                        double firstScore = ((Tuple2)pairs.head())._1$mcD$sp();
                                        BinaryLabelCounter agg = new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2());
                                        pairs.foreach((Function1)new Serializable(this, agg){
                                            public static final long serialVersionUID = 0L;
                                            private final BinaryLabelCounter agg$1;

                                            public final BinaryLabelCounter apply(Tuple2<Object, BinaryLabelCounter> pair) {
                                                return this.agg$1.$plus$eq((BinaryLabelCounter)pair._2());
                                            }
                                            {
                                                this.agg$1 = agg$1;
                                            }
                                        });
                                        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)firstScore), (Object)agg);
                                    }
                                });
                            }
                            {
                                this.grouping$1 = grouping$1;
                            }
                        }, counts.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                    }
                }
                RDD binnedCounts = rDD;
                RDD qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(binnedCounts, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class), (Ordering)Ordering.Double$.MODULE$).values();
                Serializable x$7 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<BinaryLabelCounter> apply(Iterator<BinaryLabelCounter> iter) {
                        BinaryLabelCounter agg = new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2());
                        iter.foreach((Function1)new Serializable(this, agg){
                            public static final long serialVersionUID = 0L;
                            private final BinaryLabelCounter agg$2;

                            public final BinaryLabelCounter apply(BinaryLabelCounter x$3) {
                                return this.agg$2.$plus$eq(x$3);
                            }
                            {
                                this.agg$2 = agg$2;
                            }
                        });
                        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryLabelCounter[]{agg}));
                    }
                };
                boolean x$8 = qual$2.mapPartitions$default$2();
                BinaryLabelCounter[] agg = (BinaryLabelCounter[])qual$2.mapPartitions((Function1)x$7, x$8, ClassTag$.MODULE$.apply(BinaryLabelCounter.class)).collect();
                BinaryLabelCounter[] partitionwiseCumulativeCounts = (BinaryLabelCounter[])Predef$.MODULE$.refArrayOps((Object[])agg).scanLeft((Object)new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2()), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BinaryLabelCounter apply(BinaryLabelCounter agg, BinaryLabelCounter c) {
                        return agg.clone().$plus$eq(c);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryLabelCounter.class)));
                BinaryLabelCounter totalCount = (BinaryLabelCounter)Predef$.MODULE$.refArrayOps((Object[])partitionwiseCumulativeCounts).last();
                this.logInfo((Function0<String>)new Serializable(this, totalCount){
                    public static final long serialVersionUID = 0L;
                    private final BinaryLabelCounter totalCount$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total counts: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.totalCount$1}));
                    }
                    {
                        this.totalCount$1 = totalCount$1;
                    }
                });
                RDD cumulativeCounts = binnedCounts.mapPartitionsWithIndex((Function2)new Serializable(this, partitionwiseCumulativeCounts){
                    public static final long serialVersionUID = 0L;
                    private final BinaryLabelCounter[] partitionwiseCumulativeCounts$1;

                    public final Iterator<Tuple2<Object, BinaryLabelCounter>> apply(int index2, Iterator<Tuple2<Object, BinaryLabelCounter>> iter) {
                        BinaryLabelCounter cumCount = this.partitionwiseCumulativeCounts$1[index2];
                        return iter.map((Function1)new Serializable(this, cumCount){
                            public static final long serialVersionUID = 0L;
                            private final BinaryLabelCounter cumCount$1;

                            public final Tuple2<Object, BinaryLabelCounter> apply(Tuple2<Object, BinaryLabelCounter> x0$1) {
                                Tuple2<Object, BinaryLabelCounter> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    double score = tuple2._1$mcD$sp();
                                    BinaryLabelCounter c = (BinaryLabelCounter)tuple2._2();
                                    this.cumCount$1.$plus$eq(c);
                                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)this.cumCount$1.clone());
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.cumCount$1 = cumCount$1;
                            }
                        });
                    }
                    {
                        this.partitionwiseCumulativeCounts$1 = partitionwiseCumulativeCounts$1;
                    }
                }, true, ClassTag$.MODULE$.apply(Tuple2.class));
                cumulativeCounts.persist();
                RDD confusions2 = cumulativeCounts.map((Function1)new Serializable(this, totalCount){
                    public static final long serialVersionUID = 0L;
                    private final BinaryLabelCounter totalCount$1;

                    public final Tuple2<Object, BinaryConfusionMatrix> apply(Tuple2<Object, BinaryLabelCounter> x0$2) {
                        Tuple2<Object, BinaryLabelCounter> tuple2 = x0$2;
                        if (tuple2 != null) {
                            double score = tuple2._1$mcD$sp();
                            BinaryLabelCounter cumCount = (BinaryLabelCounter)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)new BinaryConfusionMatrixImpl(cumCount, this.totalCount$1));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.totalCount$1 = totalCount$1;
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                Tuple2 tuple22 = new Tuple2((Object)cumulativeCounts, (Object)confusions2);
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                RDD cumulativeCounts2 = (RDD)tuple22._1();
                RDD confusions3 = (RDD)tuple22._2();
                if (cumulativeCounts2 == null) throw new MatchError((Object)tuple22);
                RDD rDD2 = cumulativeCounts2;
                if (confusions3 == null) throw new MatchError((Object)tuple22);
                RDD rDD3 = confusions3;
                this.x$4 = tuple2 = new Tuple2((Object)rDD2, (Object)rDD3);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.x$4;
        }
    }

    private RDD cumulativeCounts$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cumulativeCounts = (RDD)this.x$4()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.cumulativeCounts;
        }
    }

    private RDD confusions$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.confusions = (RDD)this.x$4()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.confusions;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public RDD<Tuple2<Object, Object>> scoreAndLabels() {
        return this.scoreAndLabels;
    }

    public int numBins() {
        return this.numBins;
    }

    public void unpersist() {
        this.cumulativeCounts().unpersist(this.cumulativeCounts().unpersist$default$1());
    }

    public RDD<Object> thresholds() {
        return this.cumulativeCounts().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, BinaryLabelCounter> x$1) {
                return x$1._1$mcD$sp();
            }
        }, ClassTag$.MODULE$.Double());
    }

    public RDD<Tuple2<Object, Object>> roc() {
        RDD<Tuple2<Object, Object>> rocCurve = this.createCurve(FalsePositiveRate$.MODULE$, Recall$.MODULE$);
        SparkContext sc = this.confusions().context();
        RDD first = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD last = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        return new UnionRDD(sc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{first, rocCurve, last})), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double areaUnderROC() {
        return AreaUnderCurve$.MODULE$.of(this.roc());
    }

    public RDD<Tuple2<Object, Object>> pr() {
        RDD<Tuple2<Object, Object>> prCurve = this.createCurve(Recall$.MODULE$, Precision$.MODULE$);
        SparkContext sc = this.confusions().context();
        RDD first = sc.makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0)})), 1, ClassTag$.MODULE$.apply(Tuple2.class));
        return first.union(prCurve);
    }

    public double areaUnderPR() {
        return AreaUnderCurve$.MODULE$.of(this.pr());
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold(double beta) {
        return this.createCurve(new FMeasure(beta));
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold() {
        return this.fMeasureByThreshold(1.0);
    }

    public RDD<Tuple2<Object, Object>> precisionByThreshold() {
        return this.createCurve(Precision$.MODULE$);
    }

    public RDD<Tuple2<Object, Object>> recallByThreshold() {
        return this.createCurve(Recall$.MODULE$);
    }

    private /* synthetic */ Tuple2 x$4() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$4$lzycompute() : this.x$4;
    }

    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.cumulativeCounts$lzycompute() : this.cumulativeCounts;
    }

    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.confusions$lzycompute() : this.confusions;
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1)new Serializable(this, y){
            public static final long serialVersionUID = 0L;
            private final BinaryClassificationMetricComputer y$2;

            public final Tuple2<Object, Object> apply(Tuple2<Object, BinaryConfusionMatrix> x0$3) {
                Tuple2<Object, BinaryConfusionMatrix> tuple2 = x0$3;
                if (tuple2 != null) {
                    double s = tuple2._1$mcD$sp();
                    BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(s, this.y$2.apply(c));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.y$2 = y$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer x, BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1)new Serializable(this, x, y){
            public static final long serialVersionUID = 0L;
            private final BinaryClassificationMetricComputer x$9;
            private final BinaryClassificationMetricComputer y$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, BinaryConfusionMatrix> x0$4) {
                Tuple2<Object, BinaryConfusionMatrix> tuple2 = x0$4;
                if (tuple2 != null) {
                    BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(this.x$9.apply(c), this.y$1.apply(c));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.x$9 = x$9;
                this.y$1 = y$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public BinaryClassificationMetrics(RDD<Tuple2<Object, Object>> scoreAndLabels, int numBins) {
        this.scoreAndLabels = scoreAndLabels;
        this.numBins = numBins;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(numBins >= 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "numBins must be nonnegative";
            }
        });
    }

    public BinaryClassificationMetrics(RDD<Tuple2<Object, Object>> scoreAndLabels) {
        this(scoreAndLabels, 0);
    }

    public BinaryClassificationMetrics(Dataset<Row> scoreAndLabels) {
        this((RDD<Tuple2<Object, Object>>)scoreAndLabels.rdd().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row r) {
                return new Tuple2.mcDD.sp(r.getDouble(0), r.getDouble(1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

