/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.VectorTransformer;
import org.apache.spark.mllib.feature.VectorTransformer$class;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u00111c\u0015;b]\u0012\f'\u000fZ*dC2,'/T8eK2T!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003#Y+7\r^8s)J\fgn\u001d4pe6,'\u000f\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\r\u0019H\u000fZ\u000b\u00027A\u0011AdH\u0007\u0002;)\u0011a\u0004B\u0001\u0007Y&t\u0017\r\\4\n\u0005\u0001j\"A\u0002,fGR|'\u000fK\u0002\u0019E!\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002(I\t)1+\u001b8dK\u0006\n\u0011&A\u00032]Mr\u0003\u0007\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\u0011\u0019H\u000f\u001a\u0011)\u0007)\u0012\u0003\u0006\u0003\u0005/\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\u0011iW-\u00198)\u00075\u0012\u0003'I\u00012\u0003\u0015\td&\r\u00181\u0011!\u0019\u0004A!A!\u0002\u0013Y\u0012!B7fC:\u0004\u0003f\u0001\u001a#a!Aa\u0007\u0001BA\u0002\u0013\u0005q'A\u0004xSRD7\u000b\u001e3\u0016\u0003a\u0002\"aD\u001d\n\u0005i\u0002\"a\u0002\"p_2,\u0017M\u001c\u0015\u0004k\tB\u0003\u0002C\u001f\u0001\u0005\u0003\u0007I\u0011\u0001 \u0002\u0017]LG\u000f[*uI~#S-\u001d\u000b\u0003\u007f\t\u0003\"a\u0004!\n\u0005\u0005\u0003\"\u0001B+oSRDqa\u0011\u001f\u0002\u0002\u0003\u0007\u0001(A\u0002yIEB3\u0001\u0010\u0012)\u0011!1\u0005A!A!B\u0013A\u0014\u0001C<ji\"\u001cF\u000f\u001a\u0011)\u0007\u0015\u0013\u0003\u0006\u0003\u0005J\u0001\t\u0005\r\u0011\"\u00018\u0003!9\u0018\u000e\u001e5NK\u0006t\u0007f\u0001%#Q!AA\n\u0001BA\u0002\u0013\u0005Q*\u0001\u0007xSRDW*Z1o?\u0012*\u0017\u000f\u0006\u0002@\u001d\"91iSA\u0001\u0002\u0004A\u0004fA&#Q!A\u0011\u000b\u0001B\u0001B\u0003&\u0001(A\u0005xSRDW*Z1oA!\u001a\u0001K\t\u0015\t\u000bQ\u0003A\u0011A+\u0002\rqJg.\u001b;?)\u00151v+W.^!\t)\u0002\u0001C\u0003\u001a'\u0002\u00071\u0004K\u0002XE!BQAL*A\u0002mA3!\u0017\u00121\u0011\u001514\u000b1\u00019Q\rY&\u0005\u000b\u0005\u0006\u0013N\u0003\r\u0001\u000f\u0015\u0004;\nB\u0003fA*#Q!)A\u000b\u0001C\u0001CR\u0019aKY2\t\u000be\u0001\u0007\u0019A\u000e\t\u000b9\u0002\u0007\u0019A\u000e)\u0007\u0001\u0014\u0003\u0006C\u0003U\u0001\u0011\u0005a\r\u0006\u0002WO\")\u0011$\u001aa\u00017!\u001aQM\t\u0015\t\u000b)\u0004A\u0011A6\u0002\u0017M,GoV5uQ6+\u0017M\u001c\u000b\u0003Y6l\u0011\u0001\u0001\u0005\u0006\u0013&\u0004\r\u0001\u000f\u0015\u0003S>\u0004\"a\t9\n\u0005E$#\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007fA5#Q!)A\u000f\u0001C\u0001k\u0006Q1/\u001a;XSRD7\u000b\u001e3\u0015\u000514\b\"\u0002\u001ct\u0001\u0004A\u0004FA:pQ\r\u0019(\u0005\u000b\u0005\tu\u0002A)\u0019!C\u0005w\u0006)1\u000f[5giV\tA\u0010E\u0002\u0010{~L!A \t\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\t\t!C\u0002\u0002\u0004A\u0011a\u0001R8vE2,\u0007\"CA\u0004\u0001!\u0005\t\u0015)\u0003}\u0003\u0019\u0019\b.\u001b4uA!9\u00111\u0002\u0001\u0005B\u00055\u0011!\u0003;sC:\u001chm\u001c:n)\rY\u0012q\u0002\u0005\b\u0003#\tI\u00011\u0001\u001c\u0003\u00191Xm\u0019;pe\"\"\u0011\u0011\u0002\u00121Q\r\u0001!\u0005\r")
public class StandardScalerModel
implements VectorTransformer {
    private final Vector std;
    private final Vector mean;
    private boolean withStd;
    private boolean withMean;
    private double[] shift;
    private volatile boolean bitmap$0;

    private double[] shift$lzycompute() {
        StandardScalerModel standardScalerModel = this;
        synchronized (standardScalerModel) {
            if (!this.bitmap$0) {
                this.shift = this.mean().toArray();
                this.bitmap$0 = true;
            }
            return this.shift;
        }
    }

    @Override
    public RDD<Vector> transform(RDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    @Override
    public JavaRDD<Vector> transform(JavaRDD<Vector> data) {
        return VectorTransformer$class.transform((VectorTransformer)this, data);
    }

    public Vector std() {
        return this.std;
    }

    public Vector mean() {
        return this.mean;
    }

    public boolean withStd() {
        return this.withStd;
    }

    public void withStd_$eq(boolean x$1) {
        this.withStd = x$1;
    }

    public boolean withMean() {
        return this.withMean;
    }

    public void withMean_$eq(boolean x$1) {
        this.withMean = x$1;
    }

    @DeveloperApi
    public StandardScalerModel setWithMean(boolean withMean) {
        Predef$.MODULE$.require(!withMean || this.mean() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "cannot set withMean to true while mean is null";
            }
        });
        this.withMean_$eq(withMean);
        return this;
    }

    @DeveloperApi
    public StandardScalerModel setWithStd(boolean withStd) {
        Predef$.MODULE$.require(!withStd || this.std() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "cannot set withStd to true while std is null";
            }
        });
        this.withStd_$eq(withStd);
        return this;
    }

    private double[] shift() {
        return this.bitmap$0 ? this.shift : this.shift$lzycompute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Vector transform(Vector vector) {
        Vector vector2;
        Predef$.MODULE$.require(this.mean().size() == vector.size());
        if (this.withMean()) {
            Vector vector3;
            DenseVector denseVector;
            Option<double[]> option;
            double[] localShift = this.shift();
            Vector vector4 = vector;
            if (!(vector4 instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector4)).isEmpty()) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector4.getClass()).toString());
            double[] vs = (double[])option.get();
            double[] values = (double[])vs.clone();
            int size = values.length;
            if (this.withStd()) {
                for (int i = 0; i < size; ++i) {
                    values[i] = this.std().apply(i) != 0.0 ? (values[i] - localShift[i]) * (1.0 / this.std().apply(i)) : 0.0;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    int n = i;
                    values[n] = values[n] - localShift[i];
                }
            }
            vector2 = vector3 = Vectors$.MODULE$.dense(values);
            return vector2;
        }
        if (this.withStd()) {
            Vector vector5;
            DenseVector denseVector;
            Option<double[]> option;
            Vector vector6 = vector;
            if (vector6 instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector6)).isEmpty()) {
                double[] vs = (double[])option.get();
                double[] values = (double[])vs.clone();
                int size = values.length;
                for (int i = 0; i < size; ++i) {
                    int n = i;
                    values[n] = values[n] * (this.std().apply(i) != 0.0 ? 1.0 / this.std().apply(i) : 0.0);
                }
                vector5 = Vectors$.MODULE$.dense(values);
            } else {
                SparseVector sparseVector;
                Option<Tuple3<Object, int[], double[]>> option2;
                if (!(vector6 instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector6)).isEmpty()) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector6.getClass()).toString());
                int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
                int[] indices = (int[])((Tuple3)option2.get())._2();
                double[] vs = (double[])((Tuple3)option2.get())._3();
                double[] values = (double[])vs.clone();
                int nnz = values.length;
                for (int i = 0; i < nnz; ++i) {
                    int n = i;
                    values[n] = values[n] * (this.std().apply(indices[i]) != 0.0 ? 1.0 / this.std().apply(indices[i]) : 0.0);
                }
                vector5 = Vectors$.MODULE$.sparse(size, indices, values);
            }
            vector2 = vector5;
            return vector2;
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public StandardScalerModel(Vector std, Vector mean2, boolean withStd, boolean withMean) {
        this.std = std;
        this.mean = mean2;
        this.withStd = withStd;
        this.withMean = withMean;
        VectorTransformer$class.$init$(this);
    }

    public StandardScalerModel(Vector std, Vector mean2) {
        this(std, mean2, std != null, mean2 != null);
        Predef$.MODULE$.require(this.withStd() || this.withMean(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "at least one of std or mean vectors must be provided";
            }
        });
        if (this.withStd() && this.withMean()) {
            Predef$.MODULE$.require(mean2.size() == std.size(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "mean and std vectors must have equal size if both are provided";
                }
            });
        }
    }

    public StandardScalerModel(Vector std) {
        this(std, null);
    }
}

