/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.storage.Zero;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix$;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u0001=\u0011\u0001#\u00138eKb,GMU8x\u001b\u0006$(/\u001b=\u000b\u0005\r!\u0011a\u00033jgR\u0014\u0018NY;uK\u0012T!!\u0002\u0004\u0002\r1Lg.\u00197h\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0012\t&\u001cHO]5ckR,G-T1ue&D\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\tI|wo]\u000b\u0002;A\u0019a$I\u0012\u000e\u0003}Q!\u0001\t\u0005\u0002\u0007I$G-\u0003\u0002#?\t\u0019!\u000b\u0012#\u0011\u0005]!\u0013BA\u0013\u0003\u0005)Ie\u000eZ3yK\u0012\u0014vn\u001e\u0015\u00045\u001dj\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\t\u0003)\tgN\\8uCRLwN\\\u0005\u0003Y%\u0012QaU5oG\u0016\f\u0013AL\u0001\u0006c9\u0002d\u0006\r\u0005\ta\u0001\u0011\t\u0011)A\u0005;\u0005)!o\\<tA!\u001aqfJ\u0017\t\u0011M\u0002!\u00111A\u0005\nQ\nQA\u001c*poN,\u0012!\u000e\t\u0003#YJ!a\u000e\n\u0003\t1{gn\u001a\u0005\ts\u0001\u0011\t\u0019!C\u0005u\u0005IaNU8xg~#S-\u001d\u000b\u0003wy\u0002\"!\u0005\u001f\n\u0005u\u0012\"\u0001B+oSRDqa\u0010\u001d\u0002\u0002\u0003\u0007Q'A\u0002yIEB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006K!N\u0001\u0007]J{wo\u001d\u0011\t\u0011\r\u0003!\u00111A\u0005\n\u0011\u000bQA\\\"pYN,\u0012!\u0012\t\u0003#\u0019K!a\u0012\n\u0003\u0007%sG\u000f\u0003\u0005J\u0001\t\u0005\r\u0011\"\u0003K\u0003%q7i\u001c7t?\u0012*\u0017\u000f\u0006\u0002<\u0017\"9q\bSA\u0001\u0002\u0004)\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0015B#\u0002\r9\u001cu\u000e\\:!\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u0019a\u0014N\\5u}Q!\u0011K\u0015+V!\t9\u0002\u0001C\u0003\u001c\u001d\u0002\u0007Q\u0004K\u0002SO5BQa\r(A\u0002UBQa\u0011(A\u0002\u0015C3AT\u0014.\u0011\u0015y\u0005\u0001\"\u0001Y)\t\t\u0016\fC\u0003\u001c/\u0002\u0007Q\u0004K\u0002XO5BQ\u0001\u0018\u0001\u0005Bu\u000bqA\\;n\u0007>d7\u000fF\u00016Q\rYv%\f\u0005\u0006A\u0002!\t%X\u0001\b]Vl'k\\<tQ\ryv%\f\u0005\u0006G\u0002!\t\u0001Z\u0001\u0013G>dW/\u001c8TS6LG.\u0019:ji&,7\u000fF\u0001f!\t9b-\u0003\u0002h\u0005\t\u00012i\\8sI&t\u0017\r^3NCR\u0014\u0018\u000e\u001f\u0015\u0004E\u001eJ\u0017%\u00016\u0002\u000bErcG\f\u0019\t\u000b1\u0004A\u0011A7\u0002\u0017Q|'k\\<NCR\u0014\u0018\u000e\u001f\u000b\u0002]B\u0011qc\\\u0005\u0003a\n\u0011\u0011BU8x\u001b\u0006$(/\u001b=)\u0007-<S\u0006C\u0003t\u0001\u0011\u0005A/A\u0007u_\ncwnY6NCR\u0014\u0018\u000e\u001f\u000b\u0002kB\u0011qC^\u0005\u0003o\n\u00111B\u00117pG.l\u0015\r\u001e:jq\"\u001a!oJ=\"\u0003i\fQ!\r\u00184]ABQa\u001d\u0001\u0005\u0002q$2!^?\u0000\u0011\u0015q8\u00101\u0001F\u00031\u0011xn^:QKJ\u0014En\\2l\u0011\u0019\t\ta\u001fa\u0001\u000b\u0006a1m\u001c7t!\u0016\u0014(\t\\8dW\"\u001a1pJ=\t\r\u0005\u001d\u0001\u0001\"\u0001e\u0003I!xnQ8pe\u0012Lg.\u0019;f\u001b\u0006$(/\u001b=)\t\u0005\u0015q%\u001f\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003)\u0019w.\u001c9vi\u0016\u001cf\u000b\u0012\u000b\t\u0003#\ty\"a\t\u0002.A9\u00111CA\u000b#\u0006eQ\"\u0001\u0003\n\u0007\u0005]AA\u0001\u000eTS:<W\u000f\\1s-\u0006dW/\u001a#fG>l\u0007o\\:ji&|g\u000e\u0005\u0003\u0002\u0014\u0005m\u0011bAA\u000f\t\t1Q*\u0019;sSbDq!!\t\u0002\f\u0001\u0007Q)A\u0001l\u0011)\t)#a\u0003\u0011\u0002\u0003\u0007\u0011qE\u0001\tG>l\u0007/\u001e;f+B\u0019\u0011#!\u000b\n\u0007\u0005-\"CA\u0004C_>dW-\u00198\t\u0015\u0005=\u00121\u0002I\u0001\u0002\u0004\t\t$A\u0003s\u0007>tG\rE\u0002\u0012\u0003gI1!!\u000e\u0013\u0005\u0019!u.\u001e2mK\"\"\u00111B\u0014.\u0011\u001d\tY\u0004\u0001C\u0001\u0003{\t\u0001\"\\;mi&\u0004H.\u001f\u000b\u0004#\u0006}\u0002\u0002CA!\u0003s\u0001\r!!\u0007\u0002\u0003\tCC!!\u000f([!9\u0011q\t\u0001\u0005\u0002\u0005%\u0013\u0001F2p[B,H/Z$sC6L\u0017M\\'biJL\u0007\u0010\u0006\u0002\u0002\u001a!\"\u0011QI\u0014.\u0011!\ty\u0005\u0001C!\r\u0005E\u0013\u0001\u0003;p\u0005J,WM_3\u0015\u0005\u0005M\u0003CBA+\u0003;\n\t$\u0004\u0002\u0002X)\u0019Q!!\u0017\u000b\u0005\u0005m\u0013A\u00022sK\u0016TX-\u0003\u0003\u0002`\u0005]#a\u0003#f]N,W*\u0019;sSbD\u0011\"a\u0019\u0001#\u0003%\t!!\u001a\u0002)\r|W\u000e];uKN3F\t\n3fM\u0006,H\u000e\u001e\u00133+\t\t9G\u000b\u0003\u0002(\u0005%4FAA6!\u0011\ti'!\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005)\u0012\u0012\u0002BA<\u0003_\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tY\bAI\u0001\n\u0003\ti(\u0001\u000bd_6\u0004X\u000f^3T-\u0012#C-\u001a4bk2$HeM\u000b\u0003\u0003\u007fRC!!\r\u0002j!\u001a\u0001aJ\u0017")
public class IndexedRowMatrix
implements DistributedMatrix {
    private final RDD<IndexedRow> rows;
    private long nRows;
    private int nCols;

    public RDD<IndexedRow> rows() {
        return this.rows;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        if (this.nCols() <= 0) {
            this.nCols_$eq(((IndexedRow)this.rows().first()).vector().size());
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.nRows() <= 0L) {
            this.nRows_$eq(BoxesRunTime.unboxToLong((Object)this.rows().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(IndexedRow x$1) {
                    return x$1.index();
                }
            }, ClassTag$.MODULE$.Long()).reduce((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(long x, long y) {
                    return this.apply$mcJJJ$sp(x, y);
                }

                public long apply$mcJJJ$sp(long x, long y) {
                    return package$.MODULE$.max(x, y);
                }
            })) + 1L);
        }
        return this.nRows();
    }

    public CoordinateMatrix columnSimilarities() {
        return this.toRowMatrix().columnSimilarities();
    }

    public RowMatrix toRowMatrix() {
        return new RowMatrix((RDD<Vector>)this.rows().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(IndexedRow x$2) {
                return x$2.vector();
            }
        }, ClassTag$.MODULE$.apply(Vector.class)), 0L, this.nCols());
    }

    public BlockMatrix toBlockMatrix() {
        return this.toBlockMatrix(1024, 1024);
    }

    public BlockMatrix toBlockMatrix(int rowsPerBlock, int colsPerBlock) {
        return this.toCoordinateMatrix().toBlockMatrix(rowsPerBlock, colsPerBlock);
    }

    public CoordinateMatrix toCoordinateMatrix() {
        RDD entries = this.rows().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterator<MatrixEntry> apply(IndexedRow row) {
                Vector vector;
                block4: {
                    Iterator iterator;
                    block3: {
                        DenseVector denseVector;
                        Option<double[]> option;
                        long rowIndex;
                        block2: {
                            SparseVector sparseVector;
                            Option<Tuple3<Object, int[], double[]>> option2;
                            rowIndex = row.index();
                            vector = row.vector();
                            if (!(vector instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) break block2;
                            int[] indices = (int[])((Tuple3)option2.get())._2();
                            double[] values = (double[])((Tuple3)option2.get())._3();
                            iterator = scala.package$.MODULE$.Iterator().tabulate(indices.length, (Function1)new Serializable(this, rowIndex, indices, values){
                                public static final long serialVersionUID = 0L;
                                private final long rowIndex$1;
                                private final int[] indices$1;
                                private final double[] values$1;

                                public final MatrixEntry apply(int i) {
                                    return new MatrixEntry(this.rowIndex$1, this.indices$1[i], this.values$1[i]);
                                }
                                {
                                    this.rowIndex$1 = rowIndex$1;
                                    this.indices$1 = indices$1;
                                    this.values$1 = values$1;
                                }
                            });
                            break block3;
                        }
                        if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block4;
                        double[] values = (double[])option.get();
                        iterator = scala.package$.MODULE$.Iterator().tabulate(values.length, (Function1)new Serializable(this, rowIndex, values){
                            public static final long serialVersionUID = 0L;
                            private final long rowIndex$1;
                            private final double[] values$2;

                            public final MatrixEntry apply(int i) {
                                return new MatrixEntry(this.rowIndex$1, i, this.values$2[i]);
                            }
                            {
                                this.rowIndex$1 = rowIndex$1;
                                this.values$2 = values$2;
                            }
                        });
                    }
                    return iterator;
                }
                throw new MatchError((Object)vector);
            }
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)entries, this.numRows(), this.numCols());
    }

    public SingularValueDecomposition<IndexedRowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        IndexedRowMatrix indexedRowMatrix;
        int n = (int)this.numCols();
        Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
            public static final long serialVersionUID = 0L;
            private final int k$1;
            private final int n$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested k singular values but got k=", " and numCols=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.n$1)}));
            }
            {
                this.k$1 = k$1;
                this.n$1 = n$1;
            }
        });
        RDD indices = this.rows().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(IndexedRow x$3) {
                return x$3.index();
            }
        }, ClassTag$.MODULE$.Long());
        SingularValueDecomposition<RowMatrix, Matrix> svd2 = this.toRowMatrix().computeSVD(k, computeU, rCond);
        if (computeU) {
            RDD indexedRows = indices.zip(svd2.U().rows(), ClassTag$.MODULE$.apply(Vector.class)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final IndexedRow apply(Tuple2<Object, Vector> x0$1) {
                    Tuple2<Object, Vector> tuple2 = x0$1;
                    if (tuple2 != null) {
                        long i = tuple2._1$mcJ$sp();
                        Vector v = (Vector)tuple2._2();
                        IndexedRow indexedRow = new IndexedRow(i, v);
                        return indexedRow;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.apply(IndexedRow.class));
            indexedRowMatrix = new IndexedRowMatrix((RDD<IndexedRow>)indexedRows, this.nRows(), (int)svd2.U().numCols());
        } else {
            indexedRowMatrix = null;
        }
        IndexedRowMatrix U = indexedRowMatrix;
        return new SingularValueDecomposition<Object, Matrix>(U, svd2.s(), svd2.V());
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    public IndexedRowMatrix multiply(Matrix B) {
        RowMatrix mat = this.toRowMatrix().multiply(B);
        RDD indexedRows = this.rows().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(IndexedRow x$4) {
                return x$4.index();
            }
        }, ClassTag$.MODULE$.Long()).zip(mat.rows(), ClassTag$.MODULE$.apply(Vector.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndexedRow apply(Tuple2<Object, Vector> x0$2) {
                Tuple2<Object, Vector> tuple2 = x0$2;
                if (tuple2 != null) {
                    long i = tuple2._1$mcJ$sp();
                    Vector v = (Vector)tuple2._2();
                    IndexedRow indexedRow = new IndexedRow(i, v);
                    return indexedRow;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(IndexedRow.class));
        return new IndexedRowMatrix((RDD<IndexedRow>)indexedRows, this.nRows(), B.numCols());
    }

    public Matrix computeGramianMatrix() {
        return this.toRowMatrix().computeGramianMatrix();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])this.rows().collect()).foreach((Function1)new Serializable(this, mat){
            public static final long serialVersionUID = 0L;
            public final DenseMatrix mat$1;

            public final void apply(IndexedRow x0$3) {
                IndexedRow indexedRow = x0$3;
                if (indexedRow != null) {
                    long rowIndex = indexedRow.index();
                    Vector vector = indexedRow.vector();
                    int i = (int)rowIndex;
                    vector.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$toBreeze$1 $outer;
                        private final int i$1;

                        public final void apply(int x0$4, double x1$1) {
                            this.apply$mcVID$sp(x0$4, x1$1);
                        }

                        public void apply$mcVID$sp(int x0$4, double x1$1) {
                            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$4, x1$1);
                            if (sp2 != null) {
                                int j = sp2._1$mcI$sp();
                                double v = sp2._2$mcD$sp();
                                this.$outer.mat$1.update$mcD$sp(this.i$1, j, v);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)sp2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.i$1 = i$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)indexedRow);
            }
            {
                this.mat$1 = mat$1;
            }
        });
        return var3_3;
    }

    public IndexedRowMatrix(RDD<IndexedRow> rows, long nRows, int nCols) {
        this.rows = rows;
        this.nRows = nRows;
        this.nCols = nCols;
    }

    public IndexedRowMatrix(RDD<IndexedRow> rows) {
        this(rows, 0L, 0);
    }
}

