/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.StochasticDiffFunction;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@DeveloperApi
public final class LBFGS$
implements Logging,
Serializable {
    public static final LBFGS$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new LBFGS$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Tuple2<Vector, double[]> runLBFGS(RDD<Tuple2<Object, Vector>> data, Gradient gradient2, Updater updater, int numCorrections, double convergenceTol, int maxNumIterations, double regParam, Vector initialWeights) {
        ArrayBuilder lossHistory = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        long numExamples = data.count();
        LBFGS.CostFun costFun = new LBFGS.CostFun(data, gradient2, updater, regParam, numExamples);
        LBFGS lbfgs = new LBFGS(maxNumIterations, numCorrections, convergenceTol, (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
        Iterator states = lbfgs.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialWeights.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
        ObjectRef state = ObjectRef.create((Object)((FirstOrderMinimizer.State)states.next()));
        while (states.hasNext()) {
            lossHistory.$plus$eq((Object)BoxesRunTime.boxToDouble((double)((FirstOrderMinimizer.State)state.elem).value()));
            state.elem = (FirstOrderMinimizer.State)states.next();
        }
        lossHistory.$plus$eq((Object)BoxesRunTime.boxToDouble((double)((FirstOrderMinimizer.State)state.elem).value()));
        if (!((FirstOrderMinimizer.State)state.elem).actuallyConverged()) {
            this.logWarning((Function0<String>)new Serializable(state){
                public static final long serialVersionUID = 0L;
                private final ObjectRef state$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"LBFGS training finished but the result ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not converged because: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((FirstOrderMinimizer.ConvergenceReason)((FirstOrderMinimizer.State)this.state$1.elem).convergedReason().get()).reason()}))).toString();
                }
                {
                    this.state$1 = state$1;
                }
            });
        }
        Vector weights = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)((breeze.linalg.Vector)((FirstOrderMinimizer.State)state.elem).x()));
        double[] lossHistoryArray = (double[])lossHistory.result();
        this.logInfo((Function0<String>)new Serializable(lossHistoryArray){
            public static final long serialVersionUID = 0L;
            private final double[] lossHistoryArray$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("LBFGS.runLBFGS finished. Last 10 losses %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(this.lossHistoryArray$1).takeRight(10)).mkString(", ")}));
            }
            {
                this.lossHistoryArray$1 = lossHistoryArray$1;
            }
        });
        return new Tuple2((Object)weights, (Object)lossHistoryArray);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LBFGS$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

