/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.serialization;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.Configurable;
import org.apache.flume.serialization.EventSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAvroEventSerializer<T>
implements EventSerializer,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAvroEventSerializer.class);
    private DatumWriter<T> writer = null;
    private DataFileWriter<T> dataFileWriter = null;

    protected abstract OutputStream getOutputStream();

    protected abstract Schema getSchema();

    protected abstract T convert(Event var1);

    @Override
    public void configure(Context context) {
        int syncIntervalBytes = context.getInteger("syncIntervalBytes", 2048000);
        String compressionCodec = context.getString("compressionCodec", "null");
        this.writer = new ReflectDatumWriter(this.getSchema());
        this.dataFileWriter = new DataFileWriter(this.writer);
        this.dataFileWriter.setSyncInterval(syncIntervalBytes);
        try {
            CodecFactory codecFactory = CodecFactory.fromString((String)compressionCodec);
            this.dataFileWriter.setCodec(codecFactory);
        }
        catch (AvroRuntimeException e) {
            logger.warn("Unable to instantiate avro codec with name (" + compressionCodec + "). Compression disabled. Exception follows.", (Throwable)e);
        }
    }

    @Override
    public void afterCreate() throws IOException {
        this.dataFileWriter.create(this.getSchema(), this.getOutputStream());
    }

    @Override
    public void afterReopen() throws IOException {
        throw new UnsupportedOperationException("Avro API doesn't support append");
    }

    @Override
    public void write(Event event) throws IOException {
        T destType = this.convert(event);
        this.dataFileWriter.append(destType);
    }

    @Override
    public void flush() throws IOException {
        this.dataFileWriter.flush();
    }

    @Override
    public void beforeClose() throws IOException {
    }

    @Override
    public boolean supportsReopen() {
        return false;
    }
}

