/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.serialization;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.serialization.EventDeserializer;
import org.apache.flume.serialization.ResettableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.collect.Lists;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LineDeserializer
implements EventDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(LineDeserializer.class);
    private final ResettableInputStream in;
    private final Charset outputCharset;
    private final int maxLineLength;
    private volatile boolean isOpen;
    public static final String OUT_CHARSET_KEY = "outputCharset";
    public static final String CHARSET_DFLT = "UTF-8";
    public static final String MAXLINE_KEY = "maxLineLength";
    public static final int MAXLINE_DFLT = 2048;

    LineDeserializer(Context context, ResettableInputStream in) {
        this.in = in;
        this.outputCharset = Charset.forName(context.getString(OUT_CHARSET_KEY, CHARSET_DFLT));
        this.maxLineLength = context.getInteger(MAXLINE_KEY, 2048);
        this.isOpen = true;
    }

    @Override
    public Event readEvent() throws IOException {
        this.ensureOpen();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        return EventBuilder.withBody(line, this.outputCharset);
    }

    @Override
    public List<Event> readEvents(int numEvents) throws IOException {
        Event event;
        this.ensureOpen();
        LinkedList events = Lists.newLinkedList();
        for (int i = 0; i < numEvents && (event = this.readEvent()) != null; ++i) {
            events.add(event);
        }
        return events;
    }

    @Override
    public void mark() throws IOException {
        this.ensureOpen();
        this.in.mark();
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.in.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen) {
            this.reset();
            this.in.close();
            this.isOpen = false;
        }
    }

    private void ensureOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException("Serializer has been closed");
        }
    }

    private String readLine() throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        int readChars = 0;
        while ((c = this.in.readChar()) != -1) {
            ++readChars;
            if (c == 10) break;
            sb.append((char)c);
            if (readChars < this.maxLineLength) continue;
            logger.warn("Line length exceeds max ({}), truncating line!", (Object)this.maxLineLength);
            break;
        }
        if (readChars > 0) {
            return sb.toString();
        }
        return null;
    }

    public static class Builder
    implements EventDeserializer.Builder {
        @Override
        public EventDeserializer build(Context context, ResettableInputStream in) {
            return new LineDeserializer(context, in);
        }
    }
}

