/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.serialization;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.serialization.DecodeErrorPolicy;
import org.apache.flume.serialization.LengthMeasurable;
import org.apache.flume.serialization.PositionTracker;
import org.apache.flume.serialization.RemoteMarkable;
import org.apache.flume.serialization.ResettableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.base.Charsets;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ResettableFileInputStream
extends ResettableInputStream
implements RemoteMarkable,
LengthMeasurable {
    Logger logger = LoggerFactory.getLogger(ResettableFileInputStream.class);
    public static final int DEFAULT_BUF_SIZE = 16384;
    private final File file;
    private final PositionTracker tracker;
    private final FileInputStream in;
    private final FileChannel chan;
    private final ByteBuffer buf;
    private final CharBuffer charBuf;
    private final byte[] byteBuf;
    private final long fileSize;
    private final CharsetDecoder decoder;
    private long position;
    private long syncPosition;
    private int maxCharWidth;

    public ResettableFileInputStream(File file, PositionTracker tracker) throws IOException {
        this(file, tracker, 16384, Charsets.UTF_8, DecodeErrorPolicy.FAIL);
    }

    public ResettableFileInputStream(File file, PositionTracker tracker, int bufSize, Charset charset, DecodeErrorPolicy decodeErrorPolicy) throws IOException {
        CodingErrorAction errorAction;
        this.file = file;
        this.tracker = tracker;
        this.in = new FileInputStream(file);
        this.chan = this.in.getChannel();
        this.buf = ByteBuffer.allocateDirect(bufSize);
        this.buf.flip();
        this.byteBuf = new byte[1];
        this.charBuf = CharBuffer.allocate(1);
        this.charBuf.flip();
        this.fileSize = file.length();
        this.decoder = charset.newDecoder();
        this.position = 0L;
        this.syncPosition = 0L;
        this.maxCharWidth = (int)Math.ceil(charset.newEncoder().maxBytesPerChar());
        switch (decodeErrorPolicy) {
            case FAIL: {
                errorAction = CodingErrorAction.REPORT;
                break;
            }
            case REPLACE: {
                errorAction = CodingErrorAction.REPLACE;
                break;
            }
            case IGNORE: {
                errorAction = CodingErrorAction.IGNORE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value for decode error policy: " + (Object)((Object)decodeErrorPolicy));
            }
        }
        this.decoder.onMalformedInput(errorAction);
        this.decoder.onUnmappableCharacter(errorAction);
        this.seek(tracker.getPosition());
    }

    @Override
    public synchronized int read() throws IOException {
        int len = this.read(this.byteBuf, 0, 1);
        if (len == -1) {
            return -1;
        }
        if (len == 0) {
            return -1;
        }
        return this.byteBuf[0];
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int rem;
        this.logger.trace("read(buf, {}, {})", (Object)off, (Object)len);
        if (this.position >= this.fileSize) {
            return -1;
        }
        if (!this.buf.hasRemaining()) {
            this.refillBuf();
        }
        if (len > (rem = this.buf.remaining())) {
            len = rem;
        }
        this.buf.get(b, off, len);
        this.incrPosition(len, true);
        return len;
    }

    @Override
    public synchronized int readChar() throws IOException {
        CoderResult res;
        if (this.buf.remaining() < this.maxCharWidth) {
            this.buf.clear();
            this.buf.flip();
            this.refillBuf();
        }
        int start2 = this.buf.position();
        this.charBuf.clear();
        boolean isEndOfInput = false;
        if (this.position >= this.fileSize) {
            isEndOfInput = true;
        }
        if ((res = this.decoder.decode(this.buf, this.charBuf, isEndOfInput)).isMalformed() || res.isUnmappable()) {
            res.throwException();
        }
        int delta = this.buf.position() - start2;
        this.charBuf.flip();
        if (this.charBuf.hasRemaining()) {
            char c = this.charBuf.get();
            this.incrPosition(delta, !Character.isHighSurrogate(c));
            return c;
        }
        this.incrPosition(delta, false);
        return -1;
    }

    private void refillBuf() throws IOException {
        this.buf.compact();
        this.chan.position(this.position);
        this.chan.read(this.buf);
        this.buf.flip();
    }

    @Override
    public void mark() throws IOException {
        this.tracker.storePosition(this.tell());
    }

    @Override
    public void markPosition(long position) throws IOException {
        this.tracker.storePosition(position);
    }

    @Override
    public long getMarkPosition() throws IOException {
        return this.tracker.getPosition();
    }

    @Override
    public void reset() throws IOException {
        this.seek(this.tracker.getPosition());
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public long tell() throws IOException {
        this.logger.trace("Tell position: {}", (Object)this.syncPosition);
        return this.syncPosition;
    }

    @Override
    public synchronized void seek(long newPos) throws IOException {
        this.logger.trace("Seek to position: {}", (Object)newPos);
        long relativeChange = newPos - this.position;
        if (relativeChange == 0L) {
            return;
        }
        long newBufPos = (long)this.buf.position() + relativeChange;
        if (newBufPos >= 0L && newBufPos < (long)this.buf.limit()) {
            this.buf.position((int)newBufPos);
        } else {
            this.buf.clear();
            this.buf.flip();
        }
        this.decoder.reset();
        this.chan.position(newPos);
        this.position = this.syncPosition = newPos;
    }

    private void incrPosition(int incr, boolean updateSyncPosition) {
        this.position += (long)incr;
        if (updateSyncPosition) {
            this.syncPosition = this.position;
        }
    }

    @Override
    public void close() throws IOException {
        this.tracker.close();
        this.in.close();
    }
}

