/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.Configurables;
import org.apache.flume.source.AbstractSource;
import org.apache.flume.source.SyslogUtils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.annotations.VisibleForTesting;

public class SyslogTcpSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(SyslogTcpSource.class);
    private int port;
    private String host = null;
    private Channel nettyChannel;
    private Integer eventSize;
    private Map<String, String> formaterProp;
    private CounterGroup counterGroup = new CounterGroup();
    private Set<String> keepFields;

    @Override
    public void start() {
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ServerBootstrap serverBootstrap = new ServerBootstrap((ChannelFactory)factory);
        serverBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                syslogTcpHandler handler = new syslogTcpHandler();
                handler.setEventSize(SyslogTcpSource.this.eventSize);
                handler.setFormater(SyslogTcpSource.this.formaterProp);
                handler.setKeepFields(SyslogTcpSource.this.keepFields);
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{handler});
            }
        });
        logger.info("Syslog TCP Source starting...");
        this.nettyChannel = this.host == null ? serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.port)) : serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.host, this.port));
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        logger.info("Syslog TCP Source stopping...");
        logger.info("Metrics:{}", (Object)this.counterGroup);
        if (this.nettyChannel != null) {
            this.nettyChannel.close();
            try {
                this.nettyChannel.getCloseFuture().await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("netty server stop interrupted", (Throwable)e);
            }
            finally {
                this.nettyChannel = null;
            }
        }
        super.stop();
    }

    @Override
    public void configure(Context context) {
        Configurables.ensureRequiredNonNull(context, "port");
        this.port = context.getInteger("port");
        this.host = context.getString("host");
        this.eventSize = context.getInteger("eventSize", SyslogUtils.DEFAULT_SIZE);
        this.formaterProp = context.getSubProperties("format.");
        this.keepFields = SyslogUtils.chooseFieldsToKeep(context.getString("keepFields", "none"));
    }

    @VisibleForTesting
    public int getSourcePort() {
        SocketAddress localAddress = this.nettyChannel.getLocalAddress();
        if (localAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)localAddress;
            return addr.getPort();
        }
        return 0;
    }

    public class syslogTcpHandler
    extends SimpleChannelHandler {
        private SyslogUtils syslogUtils = new SyslogUtils();

        public void setEventSize(int eventSize) {
            this.syslogUtils.setEventSize(eventSize);
        }

        public void setKeepFields(Set<String> keepFields) {
            this.syslogUtils.setKeepFields(keepFields);
        }

        public void setFormater(Map<String, String> prop) {
            this.syslogUtils.addFormats(prop);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent mEvent) {
            ChannelBuffer buff = (ChannelBuffer)mEvent.getMessage();
            while (buff.readable()) {
                Event e = this.syslogUtils.extractEvent(buff);
                if (e == null) {
                    logger.debug("Parsed partial event, event will be generated when rest of the event is received.");
                    continue;
                }
                try {
                    SyslogTcpSource.this.getChannelProcessor().processEvent(e);
                    SyslogTcpSource.this.counterGroup.incrementAndGet("events.success");
                }
                catch (ChannelException ex) {
                    SyslogTcpSource.this.counterGroup.incrementAndGet("events.dropped");
                    logger.error("Error writting to channel, event dropped", (Throwable)ex);
                }
            }
        }
    }
}

