/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.http;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLServerSocket;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractSource;
import org.apache.flume.source.http.HTTPBadRequestException;
import org.apache.flume.source.http.HTTPSourceHandler;
import org.apache.flume.tools.HTTPServerConstraintUtil;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.base.Preconditions;
import org.spark-project.guava.base.Throwables;
import org.spark-project.guava.collect.ImmutableMap;

public class HTTPSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPSource.class);
    private volatile Integer port;
    private volatile Server srv;
    private volatile String host;
    private HTTPSourceHandler handler;
    private SourceCounter sourceCounter;
    private volatile String keyStorePath;
    private volatile String keyStorePassword;
    private volatile Boolean sslEnabled;
    private final List<String> excludedProtocols = new LinkedList<String>();

    @Override
    public void configure(Context context) {
        try {
            this.sslEnabled = context.getBoolean("enableSSL", false);
            this.port = context.getInteger("port");
            this.host = context.getString("bind", "0.0.0.0");
            Preconditions.checkState((this.host != null && !this.host.isEmpty() ? 1 : 0) != 0, (Object)"HTTPSource hostname specified is empty");
            Preconditions.checkNotNull((Object)this.port, (Object)"HTTPSource requires a port number to be specified");
            String handlerClassName = context.getString("handler", "org.apache.flume.source.http.JSONHandler").trim();
            if (this.sslEnabled.booleanValue()) {
                LOG.debug("SSL configuration enabled");
                this.keyStorePath = context.getString("keystore");
                Preconditions.checkArgument((this.keyStorePath != null && !this.keyStorePath.isEmpty() ? 1 : 0) != 0, (Object)"Keystore is required for SSL Conifguration");
                this.keyStorePassword = context.getString("keystorePassword");
                Preconditions.checkArgument((this.keyStorePassword != null ? 1 : 0) != 0, (Object)"Keystore password is required for SSL Configuration");
                String excludeProtocolsStr = context.getString("excludeProtocols");
                if (excludeProtocolsStr == null) {
                    this.excludedProtocols.add("SSLv3");
                } else {
                    this.excludedProtocols.addAll(Arrays.asList(excludeProtocolsStr.split(" ")));
                    if (!this.excludedProtocols.contains("SSLv3")) {
                        this.excludedProtocols.add("SSLv3");
                    }
                }
            }
            Class<?> clazz = Class.forName(handlerClassName);
            this.handler = (HTTPSourceHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ImmutableMap<String, String> subProps = context.getSubProperties("handler.");
            this.handler.configure(new Context((Map<String, String>)subProps));
        }
        catch (ClassNotFoundException ex) {
            LOG.error("Error while configuring HTTPSource. Exception follows.", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
        catch (ClassCastException ex) {
            LOG.error("Deserializer is not an instance of HTTPSourceHandler.Deserializer must implement HTTPSourceHandler.");
            Throwables.propagate((Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Error configuring HTTPSource!", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    private void checkHostAndPort() {
        Preconditions.checkState((this.host != null && !this.host.isEmpty() ? 1 : 0) != 0, (Object)"HTTPSource hostname specified is empty");
        Preconditions.checkNotNull((Object)this.port, (Object)"HTTPSource requires a port number to be specified");
    }

    @Override
    public void start() {
        Preconditions.checkState((this.srv == null ? 1 : 0) != 0, (Object)("Running HTTP Server found in source: " + this.getName() + " before I started one." + "Will not attempt to start."));
        this.srv = new Server();
        Connector[] connectors = new Connector[1];
        if (this.sslEnabled.booleanValue()) {
            HTTPSourceSocketConnector sslSocketConnector = new HTTPSourceSocketConnector(this.excludedProtocols);
            sslSocketConnector.setKeystore(this.keyStorePath);
            sslSocketConnector.setKeyPassword(this.keyStorePassword);
            sslSocketConnector.setReuseAddress(true);
            connectors[0] = sslSocketConnector;
        } else {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setReuseAddress(true);
            connectors[0] = connector;
        }
        connectors[0].setHost(this.host);
        connectors[0].setPort(this.port.intValue());
        this.srv.setConnectors(connectors);
        try {
            org.mortbay.jetty.servlet.Context root = new org.mortbay.jetty.servlet.Context((HandlerContainer)this.srv, "/", 1);
            root.addServlet(new ServletHolder((Servlet)new FlumeHTTPServlet()), "/");
            HTTPServerConstraintUtil.enforceConstraints(root);
            this.srv.start();
            Preconditions.checkArgument((boolean)this.srv.getHandler().equals(root));
        }
        catch (Exception ex) {
            LOG.error("Error while starting HTTPSource. Exception follows.", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
        Preconditions.checkArgument((boolean)this.srv.isRunning());
        this.sourceCounter.start();
        super.start();
    }

    @Override
    public void stop() {
        try {
            this.srv.stop();
            this.srv.join();
            this.srv = null;
        }
        catch (Exception ex) {
            LOG.error("Error while stopping HTTPSource. Exception follows.", (Throwable)ex);
        }
        this.sourceCounter.stop();
        LOG.info("Http source {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.sourceCounter);
    }

    private static class HTTPSourceSocketConnector
    extends SslSocketConnector {
        private final List<String> excludedProtocols;

        HTTPSourceSocketConnector(List<String> excludedProtocols) {
            this.excludedProtocols = excludedProtocols;
        }

        public ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
            SSLServerSocket socket = (SSLServerSocket)super.newServerSocket(host, port, backlog);
            String[] protocols = socket.getEnabledProtocols();
            ArrayList<String> newProtocols = new ArrayList<String>(protocols.length);
            for (String protocol : protocols) {
                if (this.excludedProtocols.contains(protocol)) continue;
                newProtocols.add(protocol);
            }
            socket.setEnabledProtocols(newProtocols.toArray(new String[newProtocols.size()]));
            return socket;
        }
    }

    private class FlumeHTTPServlet
    extends HttpServlet {
        private static final long serialVersionUID = 4891924863218790344L;

        private FlumeHTTPServlet() {
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            List<Object> events = Collections.emptyList();
            try {
                events = HTTPSource.this.handler.getEvents(request);
            }
            catch (HTTPBadRequestException ex) {
                LOG.warn("Received bad request from client. ", (Throwable)ex);
                response.sendError(400, "Bad request from client. " + ex.getMessage());
                return;
            }
            catch (Exception ex) {
                LOG.warn("Deserializer threw unexpected exception. ", (Throwable)ex);
                response.sendError(500, "Deserializer threw unexpected exception. " + ex.getMessage());
                return;
            }
            HTTPSource.this.sourceCounter.incrementAppendBatchReceivedCount();
            HTTPSource.this.sourceCounter.addToEventReceivedCount(events.size());
            try {
                HTTPSource.this.getChannelProcessor().processEventBatch(events);
            }
            catch (ChannelException ex) {
                LOG.warn("Error appending event to channel. Channel might be full. Consider increasing the channel capacity or make sure the sinks perform faster.", (Throwable)ex);
                response.sendError(503, "Error appending event to channel. Channel might be full." + ex.getMessage());
                return;
            }
            catch (Exception ex) {
                LOG.warn("Unexpected error appending event to channel. ", (Throwable)ex);
                response.sendError(500, "Unexpected error while appending event to channel. " + ex.getMessage());
                return;
            }
            response.setCharacterEncoding(request.getCharacterEncoding());
            response.setStatus(200);
            response.flushBuffer();
            HTTPSource.this.sourceCounter.incrementAppendBatchAcceptedCount();
            HTTPSource.this.sourceCounter.addToEventAcceptedCount(events.size());
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.doPost(request, response);
        }
    }
}

