/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.ThrottledResponse;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001\u001d\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\taaY8oM&<W#A\f\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\"AA\u0004\u0001B\u0001B\u0003%q#A\u0004d_:4\u0017n\u001a\u0011\t\u0011y\u0001!Q1A\u0005\n}\tq!\\3ue&\u001c7/F\u0001!!\t\t#&D\u0001#\u0015\tq2E\u0003\u0002%K\u000511m\\7n_:T!!\u0002\u0014\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003!\u0003!iW\r\u001e:jGN\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\u0002\r\u0005\u0004\u0018nS3z+\u0005\t\u0004C\u0001\u001a6\u001d\tI1'\u0003\u00025\u0015\u00051\u0001K]3eK\u001aL!AN\u001c\u0003\rM#(/\u001b8h\u0015\t!$\u0002\u0003\u0005:\u0001\t\u0005\t\u0015!\u00032\u0003\u001d\t\u0007/[&fs\u0002B\u0001b\u000f\u0001\u0003\u0006\u0004%I\u0001P\u0001\u0005i&lW-F\u0001>!\tq\u0004)D\u0001@\u0015\t\t2%\u0003\u0002B\u007f\t!A+[7f\u0011!\u0019\u0005A!A!\u0002\u0013i\u0014!\u0002;j[\u0016\u0004\u0003\"B#\u0001\t\u00031\u0015A\u0002\u001fj]&$h\bF\u0003H\u0011&S5\n\u0005\u0002\u0019\u0001!)Q\u0003\u0012a\u0001/!)a\u0004\u0012a\u0001A!)q\u0006\u0012a\u0001c!)1\b\u0012a\u0001{!9Q\n\u0001b\u0001\n\u0013q\u0015aD8wKJ\u0014\u0018\u000e\u001a3f]F+x\u000e^1\u0016\u0003=\u0003B\u0001U,236\t\u0011K\u0003\u0002S'\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Q+\u0016\u0001B;uS2T\u0011AV\u0001\u0005U\u00064\u0018-\u0003\u0002Y#\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005\u0005R\u0016BA.#\u0005\u0015\tVo\u001c;b\u0011\u0019i\u0006\u0001)A\u0005\u001f\u0006\u0001rN^3se&$G-\u001a8Rk>$\u0018\r\t\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u00031!WMZ1vYR\fVo\u001c;b+\u0005I\u0006B\u00022\u0001A\u0003%\u0011,A\u0007eK\u001a\fW\u000f\u001c;Rk>$\u0018\r\t\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0003\u0011awnY6\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!![)\u0002\u000b1|7m[:\n\u0005-D'A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\r5\u0004\u0001\u0015!\u0003g\u0003\u0015awnY6!\u0011\u001dy\u0007A1A\u0005\nA\f!\u0002Z3mCf\fV/Z;f+\u0005\t\bc\u0001)si&\u00111/\u0015\u0002\u000b\t\u0016d\u0017-_)vKV,\u0007C\u0001\rv\u0013\t1(AA\tUQJ|G\u000f\u001e7fIJ+7\u000f]8og\u0016Da\u0001\u001f\u0001!\u0002\u0013\t\u0018a\u00033fY\u0006L\u0018+^3vK\u0002BqA\u001f\u0001C\u0002\u0013\u000510\u0001\fuQJ|G\u000f\u001e7fIJ+\u0017/^3tiJ+\u0017\r]3s+\u0005a\bCA?\u007f\u001b\u0005\u0001a!B@\u0001\u0001\u0005\u0005!A\u0006+ie>$H\u000f\\3e%\u0016\fX/Z:u%\u0016\f\u0007/\u001a:\u0014\u0007y\f\u0019\u0001E\u0002\u0010\u0003\u000bI1!a\u0002\u0011\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u0011=t(\u0011!Q\u0001\nEDa!\u0012@\u0005\u0002\u00055Ac\u0001?\u0002\u0010!1q.a\u0003A\u0002EDq!a\u0005\u007f\t\u0003\n)\"\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003/\u00012!CA\r\u0013\r\tYB\u0003\u0002\u0005+:LG\u000fC\u0004\u0002 \u0001\u0001\u000b\u0011\u0002?\u0002/QD'o\u001c;uY\u0016$'+Z9vKN$(+Z1qKJ\u0004\u0003\"CA\u0012\u0001\t\u0007I\u0011BA\u0013\u0003A!W\r\\1z#V,W/Z*f]N|'/\u0006\u0002\u0002(A\u0019\u0011%!\u000b\n\u0007\u0005-\"E\u0001\u0004TK:\u001cxN\u001d\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002(\u0005\tB-\u001a7bsF+X-^3TK:\u001cxN\u001d\u0011\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u00051\"/Z2pe\u0012\fe\u000eZ'bs\n,G\u000b\u001b:piRdW\r\u0006\u0005\u00028\u0005u\u0012\u0011IA#!\rI\u0011\u0011H\u0005\u0004\u0003wQ!aA%oi\"9\u0011qHA\u0019\u0001\u0004\t\u0014\u0001C2mS\u0016tG/\u00133\t\u0011\u0005\r\u0013\u0011\u0007a\u0001\u0003o\tQA^1mk\u0016D\u0001\"a\u0012\u00022\u0001\u0007\u0011\u0011J\u0001\tG\u0006dGNY1dWB9\u0011\"a\u0013\u00028\u0005]\u0011bAA'\u0015\tIa)\u001e8di&|g.\r\u0005\b\u0003#\u0002A\u0011BA*\u00031!\bN]8ui2,G+[7f)\u0019\t9$!\u0016\u0002`!A\u0011qKA(\u0001\u0004\tI&\u0001\u0007dY&,g\u000e^'fiJL7\rE\u0002\"\u00037J1!!\u0018#\u0005-Y\u0015MZ6b\u001b\u0016$(/[2\t\u000fU\ty\u00051\u0001\u0002bA\u0019\u0011%a\u0019\n\u0007\u0005\u0015$E\u0001\u0007NKR\u0014\u0018nY\"p]\u001aLw\rC\u0004\u0002j\u0001!I!a\u001b\u0002!5,\u0017m];sC\ndW-Q:SCR,GCBA7\u0003s\n)\t\u0005\u0003\u0002p\u0005UTBAA9\u0015\r\t\u0019HI\u0001\u0006gR\fGo]\u0005\u0005\u0003o\n\tH\u0001\u0003SCR,\u0007\u0002CA>\u0003O\u0002\r!! \u0002\t9\fW.\u001a\t\u0005\u0003\u007f\n\t)D\u0001$\u0013\r\t\u0019i\t\u0002\u000b\u001b\u0016$(/[2OC6,\u0007\u0002CAD\u0003O\u0002\r!!#\u0002\u00155,\u0017m];sC\ndW\rE\u0002\"\u0003\u0017K1!!$#\u0005)iU-Y:ve\u0006\u0014G.\u001a\u0005\b\u0003#\u0003A\u0011AAJ\u0003\u0015\tXo\u001c;b)\rI\u0016Q\u0013\u0005\b\u0003\u007f\ty\t1\u00012\u0011\u001d\tI\n\u0001C\u0005\u00037\u000bqcZ3u\u001fJ\u001c%/Z1uKF+x\u000e^1TK:\u001cxN]:\u0015\t\u0005u\u00151\u0015\t\u00041\u0005}\u0015bAAQ\u0005\ti1\t\\5f]R\u001cVM\\:peNDq!a\u0010\u0002\u0018\u0002\u0007\u0011\u0007C\u0004\u0002(\u0002!I!!+\u00023\u001d,G\u000f\u00165s_R$H.\u001a+j[\u0016\u001cVM\\:pe:\u000bW.\u001a\u000b\u0004c\u0005-\u0006bBA \u0003K\u0003\r!\r\u0005\b\u0003_\u0003A\u0011BAY\u0003I9W\r^)v_R\f7+\u001a8t_Jt\u0015-\\3\u0015\u0007E\n\u0019\fC\u0004\u0002@\u00055\u0006\u0019A\u0019\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\u0006!r-\u001a;Rk>$\u0018-T3ue&\u001c7i\u001c8gS\u001e$B!!\u0019\u0002<\"9\u0011\u0011SA[\u0001\u0004I\u0006bBA`\u0001\u0011\u0005\u0011\u0011Y\u0001\fkB$\u0017\r^3Rk>$\u0018\r\u0006\u0004\u0002\u0018\u0005\r\u0017Q\u0019\u0005\b\u0003\u007f\ti\f1\u00012\u0011\u001d\t\t*!0A\u0002eCq!!3\u0001\t\u0013\tY-\u0001\u000bdY&,g\u000e\u001e*bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u000b\u0005\u0003{\ni\rC\u0004\u0002@\u0005\u001d\u0007\u0019A\u0019\t\u000f\u0005E\u0007\u0001\"\u0001\u0002\u0016\u0005A1\u000f[;uI><h\u000e")
public class ClientQuotaManager
implements Logging {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String kafka$server$ClientQuotaManager$$apiKey;
    private final Time time;
    private final ConcurrentHashMap<String, Quota> overriddenQuota;
    private final Quota defaultQuota;
    private final ReentrantReadWriteLock lock;
    private final DelayQueue<ThrottledResponse> delayQueue;
    private final ThrottledRequestReaper throttledRequestReaper;
    private final Sensor kafka$server$ClientQuotaManager$$delayQueueSensor;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientQuotaManager clientQuotaManager = this;
        synchronized (clientQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public String kafka$server$ClientQuotaManager$$apiKey() {
        return this.kafka$server$ClientQuotaManager$$apiKey;
    }

    private Time time() {
        return this.time;
    }

    private ConcurrentHashMap<String, Quota> overriddenQuota() {
        return this.overriddenQuota;
    }

    private Quota defaultQuota() {
        return this.defaultQuota;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private DelayQueue<ThrottledResponse> delayQueue() {
        return this.delayQueue;
    }

    public ThrottledRequestReaper throttledRequestReaper() {
        return this.throttledRequestReaper;
    }

    public Sensor kafka$server$ClientQuotaManager$$delayQueueSensor() {
        return this.kafka$server$ClientQuotaManager$$delayQueueSensor;
    }

    public int recordAndMaybeThrottle(String clientId, int value2, Function1<Object, BoxedUnit> callback) {
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(clientId);
        int throttleTimeMs = 0;
        try {
            clientSensors.quotaSensor().record(value2);
            callback.apply$mcVI$sp(0);
        }
        catch (QuotaViolationException quotaViolationException) {
            KafkaMetric clientMetric = this.metrics().metrics().get(this.clientRateMetricName(clientId));
            throttleTimeMs = this.throttleTime(clientMetric, this.getQuotaMetricConfig(this.quota(clientId)));
            clientSensors.throttleTimeSensor().record(throttleTimeMs);
            this.delayQueue().add(new ThrottledResponse(this.time(), throttleTimeMs, callback));
            this.kafka$server$ClientQuotaManager$$delayQueueSensor().record();
            this.logger().debug((Object)new StringOps(Predef$.MODULE$.augmentString("Quota violated for sensor (%s). Delay time: (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientSensors.quotaSensor().name(), BoxesRunTime.boxToInteger((int)throttleTimeMs)})));
        }
        return throttleTimeMs;
    }

    private int throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        Rate rateMetric = this.measurableAsRate(clientMetric.metricName(), clientMetric.measurable());
        Quota quota = config.quota();
        double difference = clientMetric.value() - quota.bound();
        double throttleTimeMs = difference / quota.bound() * (double)rateMetric.windowSize(config, this.time().milliseconds());
        return (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(throttleTimeMs));
    }

    private Rate measurableAsRate(MetricName name, Measurable measurable) {
        Measurable measurable2 = measurable;
        if (measurable2 instanceof Rate) {
            Rate rate;
            Rate rate2 = rate = (Rate)measurable2;
            return rate2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric ", " is not a Rate metric, value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, measurable})));
    }

    public Quota quota(String clientId) {
        return this.overriddenQuota().containsKey(clientId) ? this.overriddenQuota().get(clientId) : this.defaultQuota();
    }

    private ClientSensors getOrCreateQuotaSensors(String clientId) {
        Sensor throttleTimeSensor;
        Sensor quotaSensor;
        block7: {
            String quotaSensorName = this.getQuotaSensorName(clientId);
            String throttleTimeSensorName = this.getThrottleTimeSensorName(clientId);
            quotaSensor = null;
            throttleTimeSensor = null;
            this.lock().readLock().lock();
            quotaSensor = this.metrics().getSensor(quotaSensorName);
            throttleTimeSensor = this.metrics().getSensor(throttleTimeSensorName);
            if (quotaSensor != null && throttleTimeSensor != null) break block7;
            this.lock().writeLock().lock();
            quotaSensor = this.metrics().getSensor(quotaSensorName);
            throttleTimeSensor = this.metrics().getSensor(throttleTimeSensorName);
            if (throttleTimeSensor == null) {
                throttleTimeSensor = this.metrics().sensor(throttleTimeSensorName, null, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), new Sensor[0]);
                throttleTimeSensor.add(this.metrics().metricName("throttle-time", this.kafka$server$ClientQuotaManager$$apiKey(), "Tracking average throttle-time per client", "client-id", clientId), new Avg());
            }
            if (quotaSensor != null) break block7;
            quotaSensor = this.metrics().sensor(quotaSensorName, this.getQuotaMetricConfig(this.quota(clientId)), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), new Sensor[0]);
            quotaSensor.add(this.clientRateMetricName(clientId), new Rate());
        }
        return new ClientSensors(quotaSensor, throttleTimeSensor);
        finally {
            this.lock().readLock().unlock();
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    private String getThrottleTimeSensorName(String clientId) {
        return new StringBuilder().append((Object)this.kafka$server$ClientQuotaManager$$apiKey()).append((Object)"ThrottleTime-").append((Object)clientId).toString();
    }

    private String getQuotaSensorName(String clientId) {
        return new StringBuilder().append((Object)this.kafka$server$ClientQuotaManager$$apiKey()).append((Object)"-").append((Object)clientId).toString();
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow(this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public void updateQuota(String clientId, Quota quota) {
        this.lock().writeLock().lock();
        try {
            this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changing quota for clientId ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientId, BoxesRunTime.boxToDouble((double)quota.bound())})));
            Quota quota2 = quota.equals(this.defaultQuota()) ? this.overriddenQuota().remove(clientId) : this.overriddenQuota().put(clientId, quota);
            Map<MetricName, KafkaMetric> allMetrics = this.metrics().metrics();
            MetricName quotaMetricName = this.clientRateMetricName(clientId);
            if (allMetrics.containsKey(quotaMetricName)) {
                this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for clientId ", " already exists. Changing quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientId, BoxesRunTime.boxToDouble((double)quota.bound())})));
                allMetrics.get(quotaMetricName).config(this.getQuotaMetricConfig(quota));
            }
            return;
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    private MetricName clientRateMetricName(String clientId) {
        return this.metrics().metricName("byte-rate", this.kafka$server$ClientQuotaManager$$apiKey(), "Tracking byte-rate per client", "client-id", clientId);
    }

    public void shutdown() {
        this.throttledRequestReaper().shutdown();
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, String apiKey, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.kafka$server$ClientQuotaManager$$apiKey = apiKey;
        this.time = time;
        Logging$class.$init$(this);
        this.overriddenQuota = new ConcurrentHashMap();
        this.defaultQuota = Quota.upperBound(config.quotaBytesPerSecondDefault());
        this.lock = new ReentrantReadWriteLock();
        this.delayQueue = new DelayQueue();
        this.throttledRequestReaper = new ThrottledRequestReaper(this, this.delayQueue());
        this.throttledRequestReaper().start();
        this.kafka$server$ClientQuotaManager$$delayQueueSensor = metrics.sensor(new StringBuilder().append((Object)apiKey).append((Object)"-delayQueue").toString());
        this.kafka$server$ClientQuotaManager$$delayQueueSensor().add(metrics.metricName("queue-size", apiKey, "Tracks the size of the delay queue"), new Total());
    }

    public class ThrottledRequestReaper
    extends ShutdownableThread {
        private final DelayQueue<ThrottledResponse> delayQueue;
        public final /* synthetic */ ClientQuotaManager $outer;

        @Override
        public void doWork() {
            ThrottledResponse response = (ThrottledResponse)this.delayQueue.poll(1L, TimeUnit.SECONDS);
            if (response != null) {
                this.kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer().kafka$server$ClientQuotaManager$$delayQueueSensor().record(-1.0);
                this.trace((Function0<String>)new Serializable(this, response){
                    public static final long serialVersionUID = 0L;
                    private final ThrottledResponse response$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Response throttled for: ").append((Object)BoxesRunTime.boxToInteger((int)this.response$1.throttleTimeMs())).append((Object)" ms").toString();
                    }
                    {
                        this.response$1 = response$1;
                    }
                });
                response.execute();
            }
        }

        public /* synthetic */ ClientQuotaManager kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer() {
            return this.$outer;
        }

        public ThrottledRequestReaper(ClientQuotaManager $outer, DelayQueue<ThrottledResponse> delayQueue) {
            this.delayQueue = delayQueue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(new StringOps(Predef$.MODULE$.augmentString("ThrottledRequestReaper-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.kafka$server$ClientQuotaManager$$apiKey()})), false);
        }
    }
}

