/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.api.LeaderAndIsr;
import kafka.common.TopicAndPartition;
import kafka.controller.IsrChangeNotificationListener$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$$anonfun$kafka$utils$ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReplicationUtils$
implements Logging {
    public static final ReplicationUtils$ MODULE$;
    private final String IsrChangeNotificationPrefix;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReplicationUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicationUtils$ replicationUtils$ = this;
        synchronized (replicationUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private String IsrChangeNotificationPrefix() {
        return this.IsrChangeNotificationPrefix;
    }

    public Tuple2<Object, Object> updateLeaderAndIsr(ZkUtils zkUtils, String topic, int partitionId, LeaderAndIsr newLeaderAndIsr, int controllerEpoch, int zkVersion) {
        this.debug((Function0<String>)new Serializable(topic, partitionId, newLeaderAndIsr){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final int partitionId$1;
            private final LeaderAndIsr newLeaderAndIsr$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Updated ISR for partition [%s,%d] to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1), this.newLeaderAndIsr$1.isr().mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.partitionId$1 = partitionId$1;
                this.newLeaderAndIsr$1 = newLeaderAndIsr$1;
            }
        });
        String path = ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partitionId);
        String newLeaderData = zkUtils.leaderAndIsrZkData(newLeaderAndIsr, controllerEpoch);
        Tuple2<Object, Object> updatePersistentPath = zkUtils.conditionalUpdatePersistentPath(path, newLeaderData, zkVersion, (Option<Function3<ZkUtils, String, String, Tuple2<Object, Object>>>)new Some((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(ZkUtils zkUtils, String path, String expectedLeaderAndIsrInfo) {
                return ReplicationUtils$.MODULE$.checkLeaderAndIsrZkData(zkUtils, path, expectedLeaderAndIsrInfo);
            }
        }));
        return updatePersistentPath;
    }

    public void propagateIsrChanges(ZkUtils zkUtils, Set<TopicAndPartition> isrChangeSet) {
        String isrChangeNotificationPath = zkUtils.createSequentialPersistentPath(new StringBuilder().append((Object)ZkUtils$.MODULE$.IsrChangeNotificationPath()).append((Object)"/").append((Object)this.IsrChangeNotificationPrefix()).toString(), this.generateIsrChangeJson(isrChangeSet), zkUtils.createSequentialPersistentPath$default$3());
        this.debug((Function0<String>)new Serializable(isrChangeSet, isrChangeNotificationPath){
            public static final long serialVersionUID = 0L;
            private final Set isrChangeSet$1;
            private final String isrChangeNotificationPath$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Added ").append((Object)this.isrChangeNotificationPath$1).append((Object)" for ").append((Object)this.isrChangeSet$1).toString();
            }
            {
                this.isrChangeSet$1 = isrChangeSet$1;
                this.isrChangeNotificationPath$1 = isrChangeNotificationPath$1;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public Tuple2<Object, Object> checkLeaderAndIsrZkData(ZkUtils zkUtils, String path, String expectedLeaderAndIsrInfo) {
        block6: {
            try {
                block7: {
                    writtenLeaderAndIsrInfo = zkUtils.readDataMaybeNull(path);
                    writtenLeaderOpt = (Option)writtenLeaderAndIsrInfo._1();
                    writtenStat = (Stat)writtenLeaderAndIsrInfo._2();
                    expectedLeader = this.kafka$utils$ReplicationUtils$$parseLeaderAndIsr(expectedLeaderAndIsrInfo, path, writtenStat);
                    var8_8 = writtenLeaderOpt;
                    if (!(var8_8 instanceof Some)) break block7;
                    var9_9 = (Some)var8_8;
                    writtenData = (String)var9_9.x();
                    writtenLeader = this.kafka$utils$ReplicationUtils$$parseLeaderAndIsr(writtenData, path, writtenStat);
                    var12_12 = new Tuple2(expectedLeader, writtenLeader);
                    if (var12_12 == null) ** GOTO lbl-1000
                    var13_13 = (Option)var12_12._1();
                    var14_14 = (Option)var12_12._2();
                    if (!(var13_13 instanceof Some)) ** GOTO lbl-1000
                    var15_15 = (Some)var13_13;
                    expectedLeader = (LeaderIsrAndControllerEpoch)var15_15.x();
                    if (var14_14 instanceof Some) {
                        var17_17 = (Some)var14_14;
                        writtenLeader = (LeaderIsrAndControllerEpoch)var17_17.x();
                        v0 = expectedLeader;
                        var19_19 = writtenLeader;
                        if (!(v0 != null ? v0.equals(var19_19) == false : var19_19 != null)) {
                            return new Tuple2.mcZI.sp(true, writtenStat.getVersion());
                        }
                        var20_20 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 3 sources

                    {
                        var20_21 = BoxedUnit.UNIT;
                    }
                    var21_22 = BoxedUnit.UNIT;
                    break block6;
                }
                if (None$.MODULE$.equals(var8_8)) {
                    var21_23 = BoxedUnit.UNIT;
                    break block6;
                }
                throw new MatchError((Object)var8_8);
            }
            catch (Exception var22_24) {
                // empty catch block
            }
        }
        return new Tuple2.mcZI.sp(false, -1);
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkUtils zkUtils, String topic, int partition) {
        String leaderAndIsrPath = ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition);
        Tuple2<Option<String>, Stat> tuple2 = zkUtils.readDataMaybeNull(leaderAndIsrPath);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option leaderAndIsrOpt = (Option)tuple2._1();
            Stat stat = (Stat)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)leaderAndIsrOpt, (Object)stat);
            Option leaderAndIsrOpt2 = (Option)tuple23._1();
            Stat stat2 = (Stat)tuple23._2();
            return leaderAndIsrOpt2.flatMap((Function1)new Serializable(leaderAndIsrPath, stat2){
                public static final long serialVersionUID = 0L;
                private final String leaderAndIsrPath$1;
                private final Stat stat$2;

                public final Option<LeaderIsrAndControllerEpoch> apply(String leaderAndIsrStr) {
                    return ReplicationUtils$.MODULE$.kafka$utils$ReplicationUtils$$parseLeaderAndIsr(leaderAndIsrStr, this.leaderAndIsrPath$1, this.stat$2);
                }
                {
                    this.leaderAndIsrPath$1 = leaderAndIsrPath$1;
                    this.stat$2 = stat$2;
                }
            });
        }
        throw new MatchError(tuple2);
    }

    public Option<LeaderIsrAndControllerEpoch> kafka$utils$ReplicationUtils$$parseLeaderAndIsr(String leaderAndIsrStr, String path, Stat stat) {
        return Json$.MODULE$.parseFull(leaderAndIsrStr).flatMap((Function1)new Serializable(path, stat){
            public static final long serialVersionUID = 0L;
            public final String path$1;
            private final Stat stat$1;

            public final Some<LeaderIsrAndControllerEpoch> apply(Object m) {
                Map leaderIsrAndEpochInfo = (Map)m;
                int leader = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader").get());
                int epoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader_epoch").get());
                List isr = (List)leaderIsrAndEpochInfo.get((Object)"isr").get();
                int controllerEpoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"controller_epoch").get());
                int zkPathVersion = this.stat$1.getVersion();
                ReplicationUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leader, epoch, isr, zkPathVersion){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$kafka$utils$ReplicationUtils$$parseLeaderAndIsr$1 $outer;
                    private final int leader$1;
                    private final int epoch$1;
                    private final List isr$1;
                    private final int zkPathVersion$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Leader %d, Epoch %d, Isr %s, Zk path version %d for leaderAndIsrPath %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader$1), BoxesRunTime.boxToInteger((int)this.epoch$1), this.isr$1.toString(), BoxesRunTime.boxToInteger((int)this.zkPathVersion$1), this.$outer.path$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.leader$1 = leader$1;
                        this.epoch$1 = epoch$1;
                        this.isr$1 = isr$1;
                        this.zkPathVersion$1 = zkPathVersion$1;
                    }
                });
                return new Some((Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, epoch, (List<Object>)isr, zkPathVersion), controllerEpoch));
            }
            {
                this.path$1 = path$1;
                this.stat$1 = stat$1;
            }
        });
    }

    private String generateIsrChangeJson(Set<TopicAndPartition> isrChanges) {
        Map[] partitions = (Map[])((TraversableOnce)isrChanges.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(TopicAndPartition tp) {
                return (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition()))}));
            }
        }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Map.class));
        return Json$.MODULE$.encode(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToLong((long)IsrChangeNotificationListener$.MODULE$.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)partitions)})));
    }

    private ReplicationUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.IsrChangeNotificationPrefix = "isr_change_";
    }
}

