/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.SerializedExceptionPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetContainerStatusesResponsePBImpl
extends GetContainerStatusesResponse {
    YarnServiceProtos.GetContainerStatusesResponseProto proto = YarnServiceProtos.GetContainerStatusesResponseProto.getDefaultInstance();
    YarnServiceProtos.GetContainerStatusesResponseProto.Builder builder = null;
    boolean viaProto = false;
    private List<ContainerStatus> containerStatuses = null;
    private Map<ContainerId, SerializedException> failedRequests = null;

    public GetContainerStatusesResponsePBImpl() {
        this.builder = YarnServiceProtos.GetContainerStatusesResponseProto.newBuilder();
    }

    public GetContainerStatusesResponsePBImpl(YarnServiceProtos.GetContainerStatusesResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.GetContainerStatusesResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetContainerStatusesResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.containerStatuses != null) {
            this.addLocalContainerStatusesToProto();
        }
        if (this.failedRequests != null) {
            this.addFailedRequestsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetContainerStatusesResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addLocalContainerStatusesToProto() {
        this.maybeInitBuilder();
        this.builder.clearStatus();
        if (this.containerStatuses == null) {
            return;
        }
        ArrayList<YarnProtos.ContainerStatusProto> protoList = new ArrayList<YarnProtos.ContainerStatusProto>();
        for (ContainerStatus status : this.containerStatuses) {
            protoList.add(this.convertToProtoFormat(status));
        }
        this.builder.addAllStatus(protoList);
    }

    private void addFailedRequestsToProto() {
        this.maybeInitBuilder();
        this.builder.clearFailedRequests();
        if (this.failedRequests == null) {
            return;
        }
        ArrayList<YarnServiceProtos.ContainerExceptionMapProto> protoList = new ArrayList<YarnServiceProtos.ContainerExceptionMapProto>();
        for (Map.Entry<ContainerId, SerializedException> entry2 : this.failedRequests.entrySet()) {
            protoList.add(YarnServiceProtos.ContainerExceptionMapProto.newBuilder().setContainerId(this.convertToProtoFormat(entry2.getKey())).setException(this.convertToProtoFormat(entry2.getValue())).build());
        }
        this.builder.addAllFailedRequests(protoList);
    }

    private void initLocalContainerStatuses() {
        if (this.containerStatuses != null) {
            return;
        }
        YarnServiceProtos.GetContainerStatusesResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerStatusProto> statuses = p.getStatusList();
        this.containerStatuses = new ArrayList<ContainerStatus>();
        for (YarnProtos.ContainerStatusProto status : statuses) {
            this.containerStatuses.add(this.convertFromProtoFormat(status));
        }
    }

    private void initFailedRequests() {
        if (this.failedRequests != null) {
            return;
        }
        YarnServiceProtos.GetContainerStatusesResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServiceProtos.ContainerExceptionMapProto> protoList = p.getFailedRequestsList();
        this.failedRequests = new HashMap<ContainerId, SerializedException>();
        for (YarnServiceProtos.ContainerExceptionMapProto ce : protoList) {
            this.failedRequests.put(this.convertFromProtoFormat(ce.getContainerId()), this.convertFromProtoFormat(ce.getException()));
        }
    }

    @Override
    public List<ContainerStatus> getContainerStatuses() {
        this.initLocalContainerStatuses();
        return this.containerStatuses;
    }

    @Override
    public void setContainerStatuses(List<ContainerStatus> statuses) {
        this.maybeInitBuilder();
        if (statuses == null) {
            this.builder.clearStatus();
        }
        this.containerStatuses = statuses;
    }

    @Override
    public Map<ContainerId, SerializedException> getFailedRequests() {
        this.initFailedRequests();
        return this.failedRequests;
    }

    @Override
    public void setFailedRequests(Map<ContainerId, SerializedException> failedRequests) {
        this.maybeInitBuilder();
        if (failedRequests == null) {
            this.builder.clearFailedRequests();
        }
        this.failedRequests = failedRequests;
    }

    private ContainerStatusPBImpl convertFromProtoFormat(YarnProtos.ContainerStatusProto p) {
        return new ContainerStatusPBImpl(p);
    }

    private YarnProtos.ContainerStatusProto convertToProtoFormat(ContainerStatus t) {
        return ((ContainerStatusPBImpl)t).getProto();
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private SerializedExceptionPBImpl convertFromProtoFormat(YarnProtos.SerializedExceptionProto p) {
        return new SerializedExceptionPBImpl(p);
    }

    private YarnProtos.SerializedExceptionProto convertToProtoFormat(SerializedException t) {
        return ((SerializedExceptionPBImpl)t).getProto();
    }
}

