/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeLabelPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class GetNodesToLabelsResponsePBImpl
extends GetNodesToLabelsResponse {
    YarnServiceProtos.GetNodesToLabelsResponseProto proto = YarnServiceProtos.GetNodesToLabelsResponseProto.getDefaultInstance();
    YarnServiceProtos.GetNodesToLabelsResponseProto.Builder builder = null;
    boolean viaProto = false;
    private Map<NodeId, Set<NodeLabel>> nodeToLabels;

    public GetNodesToLabelsResponsePBImpl() {
        this.builder = YarnServiceProtos.GetNodesToLabelsResponseProto.newBuilder();
    }

    public GetNodesToLabelsResponsePBImpl(YarnServiceProtos.GetNodesToLabelsResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private void initNodeToLabels() {
        if (this.nodeToLabels != null) {
            return;
        }
        YarnServiceProtos.GetNodesToLabelsResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.NodeIdToLabelsInfoProto> list2 = p.getNodeToLabelsList();
        this.nodeToLabels = new HashMap<NodeId, Set<NodeLabel>>();
        for (YarnProtos.NodeIdToLabelsInfoProto c : list2) {
            HashSet<NodeLabelPBImpl> labels = new HashSet<NodeLabelPBImpl>();
            for (YarnProtos.NodeLabelProto l : c.getNodeLabelsList()) {
                labels.add(new NodeLabelPBImpl(l));
            }
            this.nodeToLabels.put(new NodeIdPBImpl(c.getNodeId()), labels);
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetNodesToLabelsResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addNodeToLabelsToProto() {
        this.maybeInitBuilder();
        this.builder.clearNodeToLabels();
        if (this.nodeToLabels == null) {
            return;
        }
        Iterable<YarnProtos.NodeIdToLabelsInfoProto> iterable = new Iterable<YarnProtos.NodeIdToLabelsInfoProto>(){

            @Override
            public Iterator<YarnProtos.NodeIdToLabelsInfoProto> iterator() {
                return new Iterator<YarnProtos.NodeIdToLabelsInfoProto>(){
                    Iterator<Map.Entry<NodeId, Set<NodeLabel>>> iter;
                    {
                        this.iter = GetNodesToLabelsResponsePBImpl.this.nodeToLabels.entrySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnProtos.NodeIdToLabelsInfoProto next() {
                        Map.Entry<NodeId, Set<NodeLabel>> now = this.iter.next();
                        HashSet<YarnProtos.NodeLabelProto> labelProtoList = new HashSet<YarnProtos.NodeLabelProto>();
                        for (NodeLabel l : now.getValue()) {
                            labelProtoList.add(GetNodesToLabelsResponsePBImpl.this.convertToProtoFormat(l));
                        }
                        return YarnProtos.NodeIdToLabelsInfoProto.newBuilder().setNodeId(GetNodesToLabelsResponsePBImpl.this.convertToProtoFormat(now.getKey())).addAllNodeLabels(labelProtoList).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllNodeToLabels((Iterable<? extends YarnProtos.NodeIdToLabelsInfoProto>)iterable);
    }

    private void mergeLocalToBuilder() {
        if (this.nodeToLabels != null) {
            this.addNodeToLabelsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public YarnServiceProtos.GetNodesToLabelsResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    @Override
    public Map<NodeId, Set<NodeLabel>> getNodeToLabels() {
        this.initNodeToLabels();
        return this.nodeToLabels;
    }

    @Override
    public void setNodeToLabels(Map<NodeId, Set<NodeLabel>> map2) {
        this.initNodeToLabels();
        this.nodeToLabels.clear();
        this.nodeToLabels.putAll(map2);
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    private YarnProtos.NodeLabelProto convertToProtoFormat(NodeLabel t) {
        return ((NodeLabelPBImpl)t).getProto();
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetNodesToLabelsResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }
}

