/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RMDelegationTokenSelector
implements TokenSelector<RMDelegationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(RMDelegationTokenSelector.class);

    private boolean checkService(Text service, Token<? extends TokenIdentifier> token2) {
        if (service == null || token2.getService() == null) {
            return false;
        }
        return token2.getService().toString().contains(service.toString());
    }

    public Token<RMDelegationTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        LOG.debug((Object)("Looking for a token with service " + service.toString()));
        for (Token<? extends TokenIdentifier> token2 : tokens) {
            LOG.debug((Object)("Token kind is " + token2.getKind().toString() + " and the token's service name is " + token2.getService()));
            if (!RMDelegationTokenIdentifier.KIND_NAME.equals((Object)token2.getKind()) || !this.checkService(service, token2)) continue;
            return token2;
        }
        return null;
    }
}

