/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AdHocLogDumper {
    private static final Log LOG = LogFactory.getLog(AdHocLogDumper.class);
    private String name;
    private String targetFilename;
    private Map<String, Priority> appenderLevels;
    private Level currentLogLevel;
    public static final String AD_HOC_DUMPER_APPENDER = "ad-hoc-dumper-appender";
    private static boolean logFlag = false;
    private static final Object lock = new Object();

    public AdHocLogDumper(String name, String targetFilename) {
        this.name = name;
        this.targetFilename = targetFilename;
        this.appenderLevels = new HashMap<String, Priority>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpLogs(String level, int timePeriod) throws YarnRuntimeException, IOException {
        Object object = lock;
        synchronized (object) {
            if (logFlag) {
                LOG.info((Object)"Attempt to dump logs when appender is already running");
                throw new YarnRuntimeException("Appender is already dumping logs");
            }
            Level targetLevel = Level.toLevel((String)level);
            Log log2 = LogFactory.getLog((String)this.name);
            this.appenderLevels.clear();
            if (log2 instanceof Log4JLogger) {
                FileAppender fApp;
                Logger packageLogger = ((Log4JLogger)log2).getLogger();
                this.currentLogLevel = packageLogger.getLevel();
                Level currentEffectiveLevel = packageLogger.getEffectiveLevel();
                PatternLayout layout = new PatternLayout("%d{ISO8601} %p %c: %m%n");
                File file = new File(System.getProperty("yarn.log.dir"), this.targetFilename);
                try {
                    fApp = new FileAppender((Layout)layout, file.getAbsolutePath(), false);
                }
                catch (IOException ie) {
                    LOG.warn((Object)("Error creating file, can't dump logs to " + file.getAbsolutePath()), (Throwable)ie);
                    throw ie;
                }
                fApp.setName(AD_HOC_DUMPER_APPENDER);
                fApp.setThreshold((Priority)targetLevel);
                Enumeration appenders = Logger.getRootLogger().getAllAppenders();
                while (appenders.hasMoreElements()) {
                    Object obj = appenders.nextElement();
                    if (!(obj instanceof AppenderSkeleton)) continue;
                    AppenderSkeleton appender = (AppenderSkeleton)obj;
                    this.appenderLevels.put(appender.getName(), appender.getThreshold());
                    appender.setThreshold((Priority)currentEffectiveLevel);
                }
                packageLogger.addAppender((Appender)fApp);
                LOG.info((Object)("Dumping adhoc logs for " + this.name + " to " + file.getAbsolutePath() + " for " + timePeriod + " milliseconds"));
                packageLogger.setLevel(targetLevel);
                logFlag = true;
                RestoreLogLevel restoreLogLevel = new RestoreLogLevel();
                Timer restoreLogLevelTimer = new Timer();
                restoreLogLevelTimer.schedule((TimerTask)restoreLogLevel, timePeriod);
            }
        }
    }

    class RestoreLogLevel
    extends TimerTask {
        RestoreLogLevel() {
        }

        @Override
        public void run() {
            Log log2 = LogFactory.getLog((String)AdHocLogDumper.this.name);
            if (log2 instanceof Log4JLogger) {
                Logger logger = ((Log4JLogger)log2).getLogger();
                logger.removeAppender(AdHocLogDumper.AD_HOC_DUMPER_APPENDER);
                logger.setLevel(AdHocLogDumper.this.currentLogLevel);
                Enumeration appenders = Logger.getRootLogger().getAllAppenders();
                while (appenders.hasMoreElements()) {
                    Object obj = appenders.nextElement();
                    if (!(obj instanceof AppenderSkeleton)) continue;
                    AppenderSkeleton appender = (AppenderSkeleton)obj;
                    appender.setThreshold((Priority)AdHocLogDumper.this.appenderLevels.get(appender.getName()));
                }
                logFlag = false;
                LOG.info((Object)("Done dumping adhoc logs for " + AdHocLogDumper.this.name));
            }
        }
    }
}

