/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.clients.consumer.internals.NoAvailableBrokersException;
import org.apache.kafka.clients.consumer.internals.RequestFutureAdapter;
import org.apache.kafka.clients.consumer.internals.RequestFutureListener;
import org.apache.kafka.clients.consumer.internals.StaleMetadataException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.protocol.Errors;

public class RequestFuture<T> {
    private boolean isDone = false;
    private T value;
    private RuntimeException exception;
    private List<RequestFutureListener<T>> listeners = new ArrayList<RequestFutureListener<T>>();

    public boolean isDone() {
        return this.isDone;
    }

    public T value() {
        return this.value;
    }

    public boolean succeeded() {
        return this.isDone && this.exception == null;
    }

    public boolean failed() {
        return this.isDone && this.exception != null;
    }

    public boolean isRetriable() {
        return this.exception instanceof RetriableException;
    }

    public RuntimeException exception() {
        return this.exception;
    }

    public void complete(T value2) {
        if (this.isDone) {
            throw new IllegalStateException("Invalid attempt to complete a request future which is already complete");
        }
        this.value = value2;
        this.isDone = true;
        this.fireSuccess();
    }

    public void raise(RuntimeException e) {
        if (this.isDone) {
            throw new IllegalStateException("Invalid attempt to complete a request future which is already complete");
        }
        this.exception = e;
        this.isDone = true;
        this.fireFailure();
    }

    public void raise(Errors error) {
        this.raise(error.exception());
    }

    private void fireSuccess() {
        for (RequestFutureListener<T> listener : this.listeners) {
            listener.onSuccess(this.value);
        }
    }

    private void fireFailure() {
        for (RequestFutureListener<T> listener : this.listeners) {
            listener.onFailure(this.exception);
        }
    }

    public void addListener(RequestFutureListener<T> listener) {
        if (this.isDone) {
            if (this.exception != null) {
                listener.onFailure(this.exception);
            } else {
                listener.onSuccess(this.value);
            }
        } else {
            this.listeners.add(listener);
        }
    }

    public <S> RequestFuture<S> compose(final RequestFutureAdapter<T, S> adapter) {
        final RequestFuture<T> adapted = new RequestFuture<T>();
        this.addListener(new RequestFutureListener<T>(){

            @Override
            public void onSuccess(T value2) {
                adapter.onSuccess(value2, adapted);
            }

            @Override
            public void onFailure(RuntimeException e) {
                adapter.onFailure(e, adapted);
            }
        });
        return adapted;
    }

    public void chain(final RequestFuture<T> future) {
        this.addListener(new RequestFutureListener<T>(){

            @Override
            public void onSuccess(T value2) {
                future.complete(value2);
            }

            @Override
            public void onFailure(RuntimeException e) {
                future.raise(e);
            }
        });
    }

    public static <T> RequestFuture<T> failure(RuntimeException e) {
        RequestFuture<T> future = new RequestFuture<T>();
        future.raise(e);
        return future;
    }

    public static RequestFuture<Void> voidSuccess() {
        RequestFuture<Void> future = new RequestFuture<Void>();
        future.complete(null);
        return future;
    }

    public static <T> RequestFuture<T> coordinatorNotAvailable() {
        return RequestFuture.failure(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.exception());
    }

    public static <T> RequestFuture<T> leaderNotAvailable() {
        return RequestFuture.failure(Errors.LEADER_NOT_AVAILABLE.exception());
    }

    public static <T> RequestFuture<T> noBrokersAvailable() {
        return RequestFuture.failure(new NoAvailableBrokersException());
    }

    public static <T> RequestFuture<T> staleMetadata() {
        return RequestFuture.failure(new StaleMetadataException());
    }
}

