/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.record.ByteBufferInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Compressor;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.AbstractIterator;

public class MemoryRecords
implements Records {
    private static final int WRITE_LIMIT_FOR_READABLE_ONLY = -1;
    private final Compressor compressor;
    private final int writeLimit;
    private final int initialCapacity;
    private ByteBuffer buffer;
    private boolean writable;

    private MemoryRecords(ByteBuffer buffer, CompressionType type, boolean writable, int writeLimit) {
        this.writable = writable;
        this.writeLimit = writeLimit;
        this.initialCapacity = buffer.capacity();
        if (this.writable) {
            this.buffer = null;
            this.compressor = new Compressor(buffer, type);
        } else {
            this.buffer = buffer;
            this.compressor = null;
        }
    }

    public static MemoryRecords emptyRecords(ByteBuffer buffer, CompressionType type, int writeLimit) {
        return new MemoryRecords(buffer, type, true, writeLimit);
    }

    public static MemoryRecords emptyRecords(ByteBuffer buffer, CompressionType type) {
        return MemoryRecords.emptyRecords(buffer, type, buffer.capacity());
    }

    public static MemoryRecords readableRecords(ByteBuffer buffer) {
        return new MemoryRecords(buffer, CompressionType.NONE, false, -1);
    }

    public void append(long offset, Record record) {
        if (!this.writable) {
            throw new IllegalStateException("Memory records is not writable");
        }
        int size2 = record.size();
        this.compressor.putLong(offset);
        this.compressor.putInt(size2);
        this.compressor.put(record.buffer());
        this.compressor.recordWritten(size2 + 12);
        record.buffer().rewind();
    }

    public long append(long offset, long timestamp2, byte[] key, byte[] value2) {
        if (!this.writable) {
            throw new IllegalStateException("Memory records is not writable");
        }
        int size2 = Record.recordSize(key, value2);
        this.compressor.putLong(offset);
        this.compressor.putInt(size2);
        long crc = this.compressor.putRecord(timestamp2, key, value2);
        this.compressor.recordWritten(size2 + 12);
        return crc;
    }

    public boolean hasRoomFor(byte[] key, byte[] value2) {
        if (!this.writable) {
            return false;
        }
        return this.compressor.numRecordsWritten() == 0L ? this.initialCapacity >= 12 + Record.recordSize(key, value2) : (long)this.writeLimit >= this.compressor.estimatedBytesWritten() + 12L + (long)Record.recordSize(key, value2);
    }

    public boolean isFull() {
        return !this.writable || (long)this.writeLimit <= this.compressor.estimatedBytesWritten();
    }

    public void close() {
        if (this.writable) {
            this.compressor.close();
            this.buffer = this.compressor.buffer();
            this.buffer.flip();
            this.writable = false;
        }
    }

    @Override
    public int sizeInBytes() {
        if (this.writable) {
            return this.compressor.buffer().position();
        }
        return this.buffer.limit();
    }

    public double compressionRate() {
        if (this.compressor == null) {
            return 1.0;
        }
        return this.compressor.compressionRate();
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public ByteBuffer buffer() {
        if (this.writable) {
            throw new IllegalStateException("The memory records must not be writable any more before getting its underlying buffer");
        }
        return this.buffer.duplicate();
    }

    @Override
    public Iterator<LogEntry> iterator() {
        if (this.writable) {
            return new RecordsIterator((ByteBuffer)this.buffer.duplicate().flip(), false);
        }
        return new RecordsIterator(this.buffer.duplicate(), false);
    }

    public String toString() {
        Iterator<LogEntry> iter = this.iterator();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        while (iter.hasNext()) {
            LogEntry entry2 = iter.next();
            builder.append('(');
            builder.append("offset=");
            builder.append(entry2.offset());
            builder.append(",");
            builder.append("record=");
            builder.append(entry2.record());
            builder.append(")");
        }
        builder.append(']');
        return builder.toString();
    }

    public boolean isWritable() {
        return this.writable;
    }

    public static class RecordsIterator
    extends AbstractIterator<LogEntry> {
        private final ByteBuffer buffer;
        private final DataInputStream stream;
        private final CompressionType type;
        private final boolean shallow;
        private RecordsIterator innerIter;
        private final ArrayDeque<LogEntry> logEntries;
        private final long absoluteBaseOffset;

        public RecordsIterator(ByteBuffer buffer, boolean shallow) {
            this.type = CompressionType.NONE;
            this.buffer = buffer;
            this.shallow = shallow;
            this.stream = new DataInputStream(new ByteBufferInputStream(buffer));
            this.logEntries = null;
            this.absoluteBaseOffset = -1L;
        }

        private RecordsIterator(LogEntry entry2) {
            this.type = entry2.record().compressionType();
            this.buffer = entry2.record().value();
            this.shallow = true;
            this.stream = Compressor.wrapForInput(new ByteBufferInputStream(this.buffer), this.type, entry2.record().magic());
            long wrapperRecordOffset = entry2.offset();
            if (entry2.record().magic() > 0) {
                this.logEntries = new ArrayDeque();
                long wrapperRecordTimestamp = entry2.record().timestamp();
                try {
                    while (true) {
                        LogEntry logEntry = this.getNextEntryFromStream();
                        Record recordWithTimestamp = new Record(logEntry.record().buffer(), wrapperRecordTimestamp, entry2.record().timestampType());
                        this.logEntries.add(new LogEntry(logEntry.offset(), recordWithTimestamp));
                    }
                }
                catch (EOFException e) {
                }
                catch (IOException e) {
                    throw new KafkaException(e);
                }
                this.absoluteBaseOffset = wrapperRecordOffset - this.logEntries.getLast().offset();
            } else {
                this.logEntries = null;
                this.absoluteBaseOffset = -1L;
            }
        }

        @Override
        protected LogEntry makeNext() {
            if (this.innerDone()) {
                try {
                    CompressionType compression;
                    LogEntry entry2 = this.getNextEntry();
                    if (entry2 == null) {
                        return (LogEntry)this.allDone();
                    }
                    if (this.absoluteBaseOffset >= 0L) {
                        long absoluteOffset = this.absoluteBaseOffset + entry2.offset();
                        entry2 = new LogEntry(absoluteOffset, entry2.record());
                    }
                    if ((compression = entry2.record().compressionType()) == CompressionType.NONE || this.shallow) {
                        return entry2;
                    }
                    this.innerIter = new RecordsIterator(entry2);
                    return (LogEntry)this.innerIter.next();
                }
                catch (EOFException e) {
                    return (LogEntry)this.allDone();
                }
                catch (IOException e) {
                    throw new KafkaException(e);
                }
            }
            return (LogEntry)this.innerIter.next();
        }

        private LogEntry getNextEntry() throws IOException {
            if (this.logEntries != null) {
                return this.getNextEntryFromEntryList();
            }
            return this.getNextEntryFromStream();
        }

        private LogEntry getNextEntryFromEntryList() {
            return this.logEntries.isEmpty() ? null : this.logEntries.remove();
        }

        private LogEntry getNextEntryFromStream() throws IOException {
            ByteBuffer rec;
            long offset = this.stream.readLong();
            int size2 = this.stream.readInt();
            if (size2 < 0) {
                throw new IllegalStateException("Record with size " + size2);
            }
            if (this.type == CompressionType.NONE) {
                rec = this.buffer.slice();
                int newPos = this.buffer.position() + size2;
                if (newPos > this.buffer.limit()) {
                    return null;
                }
                this.buffer.position(newPos);
                rec.limit(size2);
            } else {
                byte[] recordBuffer = new byte[size2];
                this.stream.readFully(recordBuffer, 0, size2);
                rec = ByteBuffer.wrap(recordBuffer);
            }
            return new LogEntry(offset, new Record(rec));
        }

        private boolean innerDone() {
            return this.innerIter == null || !this.innerIter.hasNext();
        }
    }
}

