/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

final class JSONTransformer {
    JSONTransformer() {
    }

    static <T> Map<String, T> asMap(String jsonObjectVal) throws JSONException {
        if (null == jsonObjectVal) {
            return null;
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        JSONObject sourceMap = new JSONObject(jsonObjectVal);
        Iterator keyIterator = sourceMap.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            result2.put(key, sourceMap.get(key));
        }
        return result2;
    }

    static <T> Collection<T> asCollection(String jsonArrayVal) throws JSONException {
        if (null == jsonArrayVal) {
            return null;
        }
        LinkedList<Object> result2 = new LinkedList<Object>();
        JSONArray arrayVal = new JSONArray(jsonArrayVal);
        for (int i = 0; i < arrayVal.length(); ++i) {
            result2.add(arrayVal.get(i));
        }
        return result2;
    }

    static String asJsonArray(Collection<? extends Object> collection) {
        return null == collection ? "[]" : new JSONArray(collection).toString();
    }

    static String asJsonObject(Map map2) {
        return null == map2 ? "{}" : new JSONObject(map2).toString();
    }
}

