/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.locale.BaseLocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringLocaleConverter
extends BaseLocaleConverter {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$locale$converters$StringLocaleConverter == null ? (class$org$apache$commons$beanutils$locale$converters$StringLocaleConverter = StringLocaleConverter.class$("org.apache.commons.beanutils.locale.converters.StringLocaleConverter")) : class$org$apache$commons$beanutils$locale$converters$StringLocaleConverter));
    static /* synthetic */ Class class$org$apache$commons$beanutils$locale$converters$StringLocaleConverter;

    public StringLocaleConverter() {
        this(false);
    }

    public StringLocaleConverter(boolean locPattern) {
        this(Locale.getDefault(), locPattern);
    }

    public StringLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public StringLocaleConverter(Locale locale, boolean locPattern) {
        this(locale, (String)null, locPattern);
    }

    public StringLocaleConverter(Locale locale, String pattern) {
        this(locale, pattern, false);
    }

    public StringLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        super(locale, pattern, locPattern);
    }

    public StringLocaleConverter(Object defaultValue) {
        this(defaultValue, false);
    }

    public StringLocaleConverter(Object defaultValue, boolean locPattern) {
        this(defaultValue, Locale.getDefault(), locPattern);
    }

    public StringLocaleConverter(Object defaultValue, Locale locale) {
        this(defaultValue, locale, false);
    }

    public StringLocaleConverter(Object defaultValue, Locale locale, boolean locPattern) {
        this(defaultValue, locale, null, locPattern);
    }

    public StringLocaleConverter(Object defaultValue, Locale locale, String pattern) {
        this(defaultValue, locale, pattern, false);
    }

    public StringLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean locPattern) {
        super(defaultValue, locale, pattern, locPattern);
    }

    protected Object parse(Object value2, String pattern) throws ParseException {
        String result2 = null;
        if (value2 instanceof Integer || value2 instanceof Long || value2 instanceof BigInteger || value2 instanceof Byte || value2 instanceof Short) {
            result2 = this.getDecimalFormat(this.locale, pattern).format(((Number)value2).longValue());
        } else if (value2 instanceof Double || value2 instanceof BigDecimal || value2 instanceof Float) {
            result2 = this.getDecimalFormat(this.locale, pattern).format(((Number)value2).doubleValue());
        } else if (value2 instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, this.locale);
            result2 = dateFormat.format(value2);
        } else {
            result2 = value2.toString();
        }
        return result2;
    }

    private DecimalFormat getDecimalFormat(Locale locale, String pattern) {
        DecimalFormat numberFormat = (DecimalFormat)NumberFormat.getInstance(locale);
        if (pattern != null) {
            if (this.locPattern) {
                numberFormat.applyLocalizedPattern(pattern);
            } else {
                numberFormat.applyPattern(pattern);
            }
        } else {
            log.warn((Object)"No pattern provided, using default.");
        }
        return numberFormat;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

