/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.set;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class MapBackedSet
implements Set,
Serializable {
    private static final long serialVersionUID = 6723912213766056587L;
    protected final Map map;
    protected final Object dummyValue;

    public static Set decorate(Map map2) {
        return MapBackedSet.decorate(map2, null);
    }

    public static Set decorate(Map map2, Object dummyValue) {
        if (map2 == null) {
            throw new IllegalArgumentException("The map must not be null");
        }
        return new MapBackedSet(map2, dummyValue);
    }

    private MapBackedSet(Map map2, Object dummyValue) {
        this.map = map2;
        this.dummyValue = dummyValue;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    public boolean containsAll(Collection coll) {
        return this.map.keySet().containsAll(coll);
    }

    public boolean add(Object obj) {
        int size2 = this.map.size();
        this.map.put(obj, this.dummyValue);
        return this.map.size() != size2;
    }

    public boolean addAll(Collection coll) {
        int size2 = this.map.size();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            this.map.put(obj, this.dummyValue);
        }
        return this.map.size() != size2;
    }

    public boolean remove(Object obj) {
        int size2 = this.map.size();
        this.map.remove(obj);
        return this.map.size() != size2;
    }

    public boolean removeAll(Collection coll) {
        return this.map.keySet().removeAll(coll);
    }

    public boolean retainAll(Collection coll) {
        return this.map.keySet().retainAll(coll);
    }

    public void clear() {
        this.map.clear();
    }

    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.map.keySet().toArray(array);
    }

    public boolean equals(Object obj) {
        return ((Object)this.map.keySet()).equals(obj);
    }

    public int hashCode() {
        return ((Object)this.map.keySet()).hashCode();
    }
}

