/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractDistribution;
import org.apache.commons.math.distribution.IntegerDistribution;

public abstract class AbstractIntegerDistribution
extends AbstractDistribution
implements IntegerDistribution,
Serializable {
    private static final String WRONG_ORDER_ENDPOINTS_MESSAGE = "lower endpoint ({0}) must be less than or equal to upper endpoint ({1})";
    private static final String OUT_OF_RANGE_POINT = "{0} out of [{1}, {2}] range";
    private static final long serialVersionUID = -1146319659338487221L;

    protected AbstractIntegerDistribution() {
    }

    public double cumulativeProbability(double x) throws MathException {
        return this.cumulativeProbability((int)Math.floor(x));
    }

    public double cumulativeProbability(double x0, double x1) throws MathException {
        if (x0 > x1) {
            throw MathRuntimeException.createIllegalArgumentException(WRONG_ORDER_ENDPOINTS_MESSAGE, x0, x1);
        }
        if (Math.floor(x0) < x0) {
            return this.cumulativeProbability((int)Math.floor(x0) + 1, (int)Math.floor(x1));
        }
        return this.cumulativeProbability((int)Math.floor(x0), (int)Math.floor(x1));
    }

    public abstract double cumulativeProbability(int var1) throws MathException;

    public double probability(double x) {
        double fl = Math.floor(x);
        if (fl == x) {
            return this.probability((int)x);
        }
        return 0.0;
    }

    public double cumulativeProbability(int x0, int x1) throws MathException {
        if (x0 > x1) {
            throw MathRuntimeException.createIllegalArgumentException(WRONG_ORDER_ENDPOINTS_MESSAGE, x0, x1);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0 - 1);
    }

    public int inverseCumulativeProbability(double p) throws MathException {
        double pm;
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(OUT_OF_RANGE_POINT, p, 0.0, 1.0);
        }
        int x0 = this.getDomainLowerBound(p);
        int x1 = this.getDomainUpperBound(p);
        while (x0 < x1) {
            int xm = x0 + (x1 - x0) / 2;
            pm = this.checkedCumulativeProbability(xm);
            if (pm > p) {
                if (xm == x1) {
                    --x1;
                    continue;
                }
                x1 = xm;
                continue;
            }
            if (xm == x0) {
                ++x0;
                continue;
            }
            x0 = xm;
        }
        pm = this.checkedCumulativeProbability(x0);
        while (pm > p) {
            pm = this.checkedCumulativeProbability(--x0);
        }
        return x0;
    }

    private double checkedCumulativeProbability(int argument) throws FunctionEvaluationException {
        double result2 = Double.NaN;
        try {
            result2 = this.cumulativeProbability(argument);
        }
        catch (MathException ex) {
            throw new FunctionEvaluationException((Throwable)ex, argument, ex.getPattern(), ex.getArguments());
        }
        if (Double.isNaN(result2)) {
            throw new FunctionEvaluationException(argument, "Discrete cumulative probability function returned NaN for argument {0}", argument);
        }
        return result2;
    }

    protected abstract int getDomainLowerBound(double var1);

    protected abstract int getDomainUpperBound(double var1);
}

