/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.atomic;

import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicInteger;
import org.apache.curator.framework.recipes.atomic.MutableAtomicValue;

public class CachedAtomicInteger {
    private final DistributedAtomicInteger number;
    private final int cacheFactor;
    private AtomicValue<Integer> currentValue = null;
    private int currentIndex = 0;

    public CachedAtomicInteger(DistributedAtomicInteger number2, int cacheFactor) {
        this.number = number2;
        this.cacheFactor = cacheFactor;
    }

    public AtomicValue<Integer> next() throws Exception {
        MutableAtomicValue<Integer> result2 = new MutableAtomicValue<Integer>(0, 0);
        if (this.currentValue == null) {
            this.currentValue = this.number.add(this.cacheFactor);
            if (!this.currentValue.succeeded()) {
                this.currentValue = null;
                result2.succeeded = false;
                return result2;
            }
            this.currentIndex = 0;
        }
        result2.succeeded = true;
        result2.preValue = this.currentValue.preValue() + this.currentIndex;
        result2.postValue = (Integer)result2.preValue + 1;
        if (++this.currentIndex >= this.cacheFactor) {
            this.currentValue = null;
        }
        return result2;
    }
}

