/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.nodes;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CreateModable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark-project.guava.base.Preconditions;

public class PersistentEphemeralNode
implements Closeable {
    private final AtomicReference<CountDownLatch> initialCreateLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final CreateModable<ACLBackgroundPathAndBytesable<String>> createMethod;
    private final AtomicReference<String> nodePath = new AtomicReference<Object>(null);
    private final String basePath;
    private final Mode mode;
    private final AtomicReference<byte[]> data = new AtomicReference();
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final BackgroundCallback backgroundCallback;
    private final Watcher watcher = new Watcher(){

        @Override
        public void process(WatchedEvent event) {
            PersistentEphemeralNode.this.createNode();
        }
    };
    private final BackgroundCallback checkExistsCallback = new BackgroundCallback(){

        @Override
        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                PersistentEphemeralNode.this.createNode();
            }
        }
    };

    public PersistentEphemeralNode(CuratorFramework client, Mode mode, String basePath, byte[] data2) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        this.basePath = (String)Preconditions.checkNotNull((Object)basePath, (Object)"basePath cannot be null");
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode cannot be null"));
        data2 = (byte[])Preconditions.checkNotNull((Object)data2, (Object)"data cannot be null");
        this.backgroundCallback = new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                String path = null;
                if (event.getResultCode() == KeeperException.Code.NODEEXISTS.intValue()) {
                    path = event.getPath();
                } else if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    path = event.getName();
                }
                if (path != null) {
                    PersistentEphemeralNode.this.nodePath.set(path);
                    PersistentEphemeralNode.this.watchNode();
                    CountDownLatch localLatch = PersistentEphemeralNode.this.initialCreateLatch.getAndSet(null);
                    if (localLatch != null) {
                        localLatch.countDown();
                    }
                } else {
                    PersistentEphemeralNode.this.createNode();
                }
            }
        };
        this.createMethod = mode.isProtected() ? client.create().creatingParentsIfNeeded().withProtection() : client.create().creatingParentsIfNeeded();
        this.data.set(Arrays.copyOf(data2, data2.length));
    }

    public void start() {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Already started");
        this.createNode();
    }

    public boolean waitForInitialCreate(long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"Not started");
        CountDownLatch localLatch = this.initialCreateLatch.get();
        return localLatch == null || localLatch.await(timeout, unit);
    }

    @Override
    public void close() throws IOException {
        if (!this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            return;
        }
        try {
            this.deleteNode();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getActualPath() {
        return this.nodePath.get();
    }

    public void setData(byte[] data2) throws Exception {
        data2 = (byte[])Preconditions.checkNotNull((Object)data2, (Object)"data cannot be null");
        this.data.set(Arrays.copyOf(data2, data2.length));
        if (this.isActive()) {
            ((PathAndBytesable)this.client.setData().inBackground()).forPath(this.basePath, this.data.get());
        }
    }

    private void deleteNode() throws Exception {
        String localNodePath = this.nodePath.getAndSet(null);
        if (localNodePath != null) {
            try {
                this.client.delete().guaranteed().forPath(localNodePath);
            }
            catch (KeeperException.NoNodeException ignore) {
            }
            catch (Exception e) {
                this.log.error("Deleting node: " + localNodePath, e);
                throw e;
            }
        }
    }

    private void createNode() {
        if (!this.isActive()) {
            return;
        }
        try {
            String existingPath = this.nodePath.get();
            String createPath = existingPath != null ? existingPath : this.basePath;
            ((PathAndBytesable)this.createMethod.withMode(this.mode.getCreateMode(existingPath != null)).inBackground(this.backgroundCallback)).forPath(createPath, this.data.get());
        }
        catch (Exception e) {
            this.log.error("Creating node. BasePath: " + this.basePath, e);
            throw new RuntimeException(e);
        }
    }

    private void watchNode() throws Exception {
        if (!this.isActive()) {
            return;
        }
        String localNodePath = this.nodePath.get();
        if (localNodePath != null) {
            try {
                ((Pathable)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).inBackground(this.checkExistsCallback)).forPath(localNodePath);
            }
            catch (Exception e) {
                this.log.error("Watching node: " + localNodePath, e);
                throw e;
            }
        }
    }

    private boolean isActive() {
        return this.state.get() == State.STARTED;
    }

    public static enum Mode {
        EPHEMERAL{

            @Override
            protected CreateMode getCreateMode(boolean pathIsSet) {
                return CreateMode.EPHEMERAL;
            }

            @Override
            protected boolean isProtected() {
                return false;
            }
        }
        ,
        EPHEMERAL_SEQUENTIAL{

            @Override
            protected CreateMode getCreateMode(boolean pathIsSet) {
                return pathIsSet ? CreateMode.EPHEMERAL : CreateMode.EPHEMERAL_SEQUENTIAL;
            }

            @Override
            protected boolean isProtected() {
                return false;
            }
        }
        ,
        PROTECTED_EPHEMERAL{

            @Override
            protected CreateMode getCreateMode(boolean pathIsSet) {
                return CreateMode.EPHEMERAL;
            }

            @Override
            protected boolean isProtected() {
                return true;
            }
        }
        ,
        PROTECTED_EPHEMERAL_SEQUENTIAL{

            @Override
            protected CreateMode getCreateMode(boolean pathIsSet) {
                return pathIsSet ? CreateMode.EPHEMERAL : CreateMode.EPHEMERAL_SEQUENTIAL;
            }

            @Override
            protected boolean isProtected() {
                return true;
            }
        };


        protected abstract CreateMode getCreateMode(boolean var1);

        protected abstract boolean isProtected();
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

