/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class ConfServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT_JSON = "json";
    private static final String FORMAT_XML = "xml";
    private static final String FORMAT_PARAM = "format";

    private Configuration getConfFromContext() {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("hadoop.conf");
        assert (conf != null);
        return conf;
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
            return;
        }
        String format2 = request.getParameter(FORMAT_PARAM);
        if (null == format2) {
            format2 = FORMAT_XML;
        }
        if (FORMAT_XML.equals(format2)) {
            response.setContentType("text/xml; charset=utf-8");
        } else if (FORMAT_JSON.equals(format2)) {
            response.setContentType("application/json; charset=utf-8");
        }
        PrintWriter out = response.getWriter();
        try {
            ConfServlet.writeResponse(this.getConfFromContext(), out, format2);
        }
        catch (BadFormatException bfe) {
            response.sendError(400, bfe.getMessage());
        }
        ((Writer)out).close();
    }

    static void writeResponse(Configuration conf, Writer out, String format2) throws IOException, BadFormatException {
        if (FORMAT_JSON.equals(format2)) {
            Configuration.dumpConfiguration(conf, out);
        } else if (FORMAT_XML.equals(format2)) {
            conf.writeXml(out);
        } else {
            throw new BadFormatException("Bad format: " + format2);
        }
    }

    public static class BadFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadFormatException(String msg) {
            super(msg);
        }
    }
}

