/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeID
implements Comparable<DatanodeID> {
    public static final DatanodeID[] EMPTY_ARRAY = new DatanodeID[0];
    private String ipAddr;
    private String hostName;
    private String peerHostName;
    private String storageID;
    private int xferPort;
    private int infoPort;
    private int infoSecurePort;
    private int ipcPort;

    public DatanodeID(DatanodeID from2) {
        this(from2.getIpAddr(), from2.getHostName(), from2.getStorageID(), from2.getXferPort(), from2.getInfoPort(), from2.getInfoSecurePort(), from2.getIpcPort());
        this.peerHostName = from2.getPeerHostName();
    }

    public DatanodeID(String ipAddr, String hostName, String storageID, int xferPort, int infoPort, int infoSecurePort, int ipcPort) {
        this.ipAddr = ipAddr;
        this.hostName = hostName;
        this.storageID = storageID;
        this.xferPort = xferPort;
        this.infoPort = infoPort;
        this.infoSecurePort = infoSecurePort;
        this.ipcPort = ipcPort;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public void setPeerHostName(String peerHostName) {
        this.peerHostName = peerHostName;
    }

    public void setStorageID(String storageID) {
        this.storageID = storageID;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPeerHostName() {
        return this.peerHostName;
    }

    public String getXferAddr() {
        return this.ipAddr + ":" + this.xferPort;
    }

    private String getIpcAddr() {
        return this.ipAddr + ":" + this.ipcPort;
    }

    public String getInfoAddr() {
        return this.ipAddr + ":" + this.infoPort;
    }

    public String getInfoSecureAddr() {
        return this.ipAddr + ":" + this.infoSecurePort;
    }

    public String getXferAddrWithHostname() {
        return this.hostName + ":" + this.xferPort;
    }

    private String getIpcAddrWithHostname() {
        return this.hostName + ":" + this.ipcPort;
    }

    public String getXferAddr(boolean useHostname) {
        return useHostname ? this.getXferAddrWithHostname() : this.getXferAddr();
    }

    public String getIpcAddr(boolean useHostname) {
        return useHostname ? this.getIpcAddrWithHostname() : this.getIpcAddr();
    }

    public String getStorageID() {
        return this.storageID;
    }

    public int getXferPort() {
        return this.xferPort;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public int getInfoSecurePort() {
        return this.infoSecurePort;
    }

    public int getIpcPort() {
        return this.ipcPort;
    }

    public boolean equals(Object to2) {
        if (this == to2) {
            return true;
        }
        if (!(to2 instanceof DatanodeID)) {
            return false;
        }
        return this.getXferAddr().equals(((DatanodeID)to2).getXferAddr()) && this.storageID.equals(((DatanodeID)to2).getStorageID());
    }

    public int hashCode() {
        return this.getXferAddr().hashCode() ^ this.storageID.hashCode();
    }

    public String toString() {
        return this.getXferAddr();
    }

    public void updateRegInfo(DatanodeID nodeReg) {
        this.ipAddr = nodeReg.getIpAddr();
        this.hostName = nodeReg.getHostName();
        this.peerHostName = nodeReg.getPeerHostName();
        this.xferPort = nodeReg.getXferPort();
        this.infoPort = nodeReg.getInfoPort();
        this.infoSecurePort = nodeReg.getInfoSecurePort();
        this.ipcPort = nodeReg.getIpcPort();
    }

    @Override
    public int compareTo(DatanodeID that) {
        return this.getXferAddr().compareTo(that.getXferAddr());
    }
}

