/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public class BlockInfo
extends Block
implements LightWeightGSet.LinkedElement {
    public static final BlockInfo[] EMPTY_ARRAY = new BlockInfo[0];
    private BlockCollection bc;
    private LightWeightGSet.LinkedElement nextLinkedElement;
    private Object[] triplets;

    public BlockInfo(int replication) {
        this.triplets = new Object[3 * replication];
        this.bc = null;
    }

    public BlockInfo(Block blk, int replication) {
        super(blk);
        this.triplets = new Object[3 * replication];
        this.bc = null;
    }

    protected BlockInfo(BlockInfo from2) {
        this(from2, from2.bc.getBlockReplication());
        this.bc = from2.bc;
    }

    public BlockCollection getBlockCollection() {
        return this.bc;
    }

    public void setBlockCollection(BlockCollection bc) {
        this.bc = bc;
    }

    DatanodeDescriptor getDatanode(int index2) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index2 >= 0 && index2 * 3 < this.triplets.length) : "Index is out of bound";
        return (DatanodeDescriptor)this.triplets[index2 * 3];
    }

    private BlockInfo getPrevious(int index2) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index2 >= 0 && index2 * 3 + 1 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)this.triplets[index2 * 3 + 1];
        assert (info == null || info.getClass().getName().startsWith(BlockInfo.class.getName())) : "BlockInfo is expected at " + index2 * 3;
        return info;
    }

    BlockInfo getNext(int index2) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index2 >= 0 && index2 * 3 + 2 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)this.triplets[index2 * 3 + 2];
        assert (info == null || info.getClass().getName().startsWith(BlockInfo.class.getName())) : "BlockInfo is expected at " + index2 * 3;
        return info;
    }

    private void setDatanode(int index2, DatanodeDescriptor node, BlockInfo previous, BlockInfo next2) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        int i = index2 * 3;
        assert (index2 >= 0 && i + 2 < this.triplets.length) : "Index is out of bound";
        this.triplets[i] = node;
        this.triplets[i + 1] = previous;
        this.triplets[i + 2] = next2;
    }

    private BlockInfo setPrevious(int index2, BlockInfo to2) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index2 >= 0 && index2 * 3 + 1 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)this.triplets[index2 * 3 + 1];
        this.triplets[index2 * 3 + 1] = to2;
        return info;
    }

    private BlockInfo setNext(int index2, BlockInfo to2) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index2 >= 0 && index2 * 3 + 2 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)this.triplets[index2 * 3 + 2];
        this.triplets[index2 * 3 + 2] = to2;
        return info;
    }

    int getCapacity() {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
        return this.triplets.length / 3;
    }

    private int ensureCapacity(int num) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        int last2 = this.numNodes();
        if (this.triplets.length >= (last2 + num) * 3) {
            return last2;
        }
        Object[] old = this.triplets;
        this.triplets = new Object[(last2 + num) * 3];
        System.arraycopy(old, 0, this.triplets, 0, last2 * 3);
        return last2;
    }

    public int numNodes() {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
        for (int idx = this.getCapacity() - 1; idx >= 0; --idx) {
            if (this.getDatanode(idx) == null) continue;
            return idx + 1;
        }
        return 0;
    }

    public boolean addNode(DatanodeDescriptor node) {
        if (this.findDatanode(node) >= 0) {
            return false;
        }
        int lastNode = this.ensureCapacity(1);
        this.setDatanode(lastNode, node, null, null);
        return true;
    }

    public boolean removeNode(DatanodeDescriptor node) {
        int dnIndex = this.findDatanode(node);
        if (dnIndex < 0) {
            return false;
        }
        assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is still in the list and must be removed first.";
        int lastNode = this.numNodes() - 1;
        this.setDatanode(dnIndex, this.getDatanode(lastNode), this.getPrevious(lastNode), this.getNext(lastNode));
        this.setDatanode(lastNode, null, null, null);
        return true;
    }

    int findDatanode(DatanodeDescriptor dn) {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            DatanodeDescriptor cur = this.getDatanode(idx);
            if (cur == dn) {
                return idx;
            }
            if (cur == null) break;
        }
        return -1;
    }

    public BlockInfo listInsert(BlockInfo head2, DatanodeDescriptor dn) {
        int dnIndex = this.findDatanode(dn);
        assert (dnIndex >= 0) : "Data node is not found: current";
        assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is already in the list and cannot be inserted.";
        this.setPrevious(dnIndex, null);
        this.setNext(dnIndex, head2);
        if (head2 != null) {
            head2.setPrevious(head2.findDatanode(dn), this);
        }
        return this;
    }

    public BlockInfo listRemove(BlockInfo head2, DatanodeDescriptor dn) {
        if (head2 == null) {
            return null;
        }
        int dnIndex = this.findDatanode(dn);
        if (dnIndex < 0) {
            return head2;
        }
        BlockInfo next2 = this.getNext(dnIndex);
        BlockInfo prev = this.getPrevious(dnIndex);
        this.setNext(dnIndex, null);
        this.setPrevious(dnIndex, null);
        if (prev != null) {
            prev.setNext(prev.findDatanode(dn), next2);
        }
        if (next2 != null) {
            next2.setPrevious(next2.findDatanode(dn), prev);
        }
        if (this == head2) {
            head2 = next2;
        }
        return head2;
    }

    public BlockInfo moveBlockToHead(BlockInfo head2, DatanodeDescriptor dn, int curIndex, int headIndex) {
        if (head2 == this) {
            return this;
        }
        BlockInfo next2 = this.setNext(curIndex, head2);
        BlockInfo prev = this.setPrevious(curIndex, null);
        head2.setPrevious(headIndex, this);
        prev.setNext(prev.findDatanode(dn), next2);
        if (next2 != null) {
            next2.setPrevious(next2.findDatanode(dn), prev);
        }
        return this;
    }

    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return HdfsServerConstants.BlockUCState.COMPLETE;
    }

    public boolean isComplete() {
        return this.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.COMPLETE);
    }

    public BlockInfoUnderConstruction convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState s2, DatanodeDescriptor[] targets) {
        if (this.isComplete()) {
            return new BlockInfoUnderConstruction(this, this.getBlockCollection().getBlockReplication(), s2, targets);
        }
        BlockInfoUnderConstruction ucBlock = (BlockInfoUnderConstruction)this;
        ucBlock.setBlockUCState(s2);
        ucBlock.setExpectedLocations(targets);
        return ucBlock;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    @Override
    public LightWeightGSet.LinkedElement getNext() {
        return this.nextLinkedElement;
    }

    @Override
    public void setNext(LightWeightGSet.LinkedElement next2) {
        this.nextLinkedElement = next2;
    }
}

