/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.MutableBlockCollection;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileUnderConstructionWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.spark-project.guava.base.Preconditions;

@InterfaceAudience.Private
public class INodeFileUnderConstruction
extends INodeFile
implements MutableBlockCollection {
    private String clientName;
    private final String clientMachine;
    private final DatanodeDescriptor clientNode;

    public static INodeFileUnderConstruction valueOf(INode inode, String path) throws FileNotFoundException {
        INodeFile file = INodeFile.valueOf(inode, path);
        if (!file.isUnderConstruction()) {
            throw new FileNotFoundException("File is not under construction: " + path);
        }
        return (INodeFileUnderConstruction)file;
    }

    INodeFileUnderConstruction(long id, PermissionStatus permissions, short replication, long preferredBlockSize, long modTime, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        this(id, null, replication, modTime, preferredBlockSize, BlockInfo.EMPTY_ARRAY, permissions, clientName, clientMachine, clientNode);
    }

    INodeFileUnderConstruction(long id, byte[] name, short blockReplication, long modificationTime, long preferredBlockSize, BlockInfo[] blocks, PermissionStatus perm, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(id, name, perm, modificationTime, modificationTime, blocks, blockReplication, preferredBlockSize);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    public INodeFileUnderConstruction(INodeFile that, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(that);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    public String getClientName() {
        return this.clientName;
    }

    void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientMachine() {
        return this.clientMachine;
    }

    public DatanodeDescriptor getClientNode() {
        return this.clientNode;
    }

    @Override
    public final boolean isUnderConstruction() {
        return true;
    }

    protected INodeFile toINodeFile(long mtime) {
        this.assertAllBlocksComplete();
        INodeFile f = new INodeFile(this.getId(), this.getLocalNameBytes(), this.getPermissionStatus(), mtime, this.getModificationTime(), this.getBlocks(), this.getFileReplication(), this.getPreferredBlockSize());
        f.setParent(this.getParent());
        return f;
    }

    @Override
    public INodeFileUnderConstruction recordModification(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        if (this.isInLatestSnapshot(latest)) {
            INodeFileUnderConstructionWithSnapshot newFile = this.getParent().replaceChild4INodeFileUcWithSnapshot(this, inodeMap).recordModification(latest, inodeMap);
            return newFile;
        }
        return this;
    }

    protected void assertAllBlocksComplete() {
        BlockInfo[] blocks = this.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            Preconditions.checkState((boolean)blocks[i].isComplete(), (String)"Failed to finalize %s %s since blocks[%s] is non-complete, where blocks=%s.", (Object[])new Object[]{this.getClass().getSimpleName(), this, i, Arrays.asList(this.getBlocks())});
        }
    }

    boolean removeLastBlock(Block oldblock) throws IOException {
        BlockInfo[] blocks = this.getBlocks();
        if (blocks == null || blocks.length == 0) {
            return false;
        }
        int size_1 = blocks.length - 1;
        if (!blocks[size_1].equals(oldblock)) {
            return false;
        }
        BlockInfo[] newlist = new BlockInfo[size_1];
        System.arraycopy(blocks, 0, newlist, 0, size_1);
        this.setBlocks(newlist);
        return true;
    }

    @Override
    public BlockInfoUnderConstruction setLastBlock(BlockInfo lastBlock, DatanodeDescriptor[] targets) throws IOException {
        if (this.numBlocks() == 0) {
            throw new IOException("Failed to set last block: File is empty.");
        }
        BlockInfoUnderConstruction ucBlock = lastBlock.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
        ucBlock.setBlockCollection(this);
        this.setBlock(this.numBlocks() - 1, ucBlock);
        return ucBlock;
    }

    void updateLengthOfLastBlock(long lastBlockLength) throws IOException {
        BlockInfo lastBlock = this.getLastBlock();
        assert (lastBlock != null) : "The last block for path " + this.getFullPathName() + " is null when updating its length";
        assert (lastBlock instanceof BlockInfoUnderConstruction) : "The last block for path " + this.getFullPathName() + " is not a BlockInfoUnderConstruction when updating its length";
        lastBlock.setNumBytes(lastBlockLength);
    }
}

