/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.HashMap;
import org.spark-project.guava.base.Preconditions;

public class EnumCounters<E extends Enum<E>> {
    private final E[] enumConstants;
    private final long[] counters;

    public EnumCounters(E[] enumConstants) {
        for (int i = 0; i < enumConstants.length; ++i) {
            Preconditions.checkArgument((((Enum)enumConstants[i]).ordinal() == i ? 1 : 0) != 0);
        }
        this.enumConstants = enumConstants;
        this.counters = new long[enumConstants.length];
    }

    public final long get(E e) {
        return this.counters[((Enum)e).ordinal()];
    }

    public final void negation() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = -this.counters[i];
        }
    }

    public final void set(E e, long value2) {
        this.counters[((Enum)e).ordinal()] = value2;
    }

    public final void add(E e, long value2) {
        int n = ((Enum)e).ordinal();
        this.counters[n] = this.counters[n] + value2;
    }

    public final void add(EnumCounters<E> that) {
        for (int i = 0; i < this.counters.length; ++i) {
            int n = i;
            this.counters[n] = this.counters[n] + that.counters[i];
        }
    }

    public final void subtract(E e, long value2) {
        int n = ((Enum)e).ordinal();
        this.counters[n] = this.counters[n] - value2;
    }

    public final void subtract(EnumCounters<E> that) {
        for (int i = 0; i < this.counters.length; ++i) {
            int n = i;
            this.counters[n] = this.counters[n] - that.counters[i];
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.counters.length; ++i) {
            String name = ((Enum)this.enumConstants[i]).name();
            b.append(name).append("=").append(this.counters[i]).append(", ");
        }
        return b.substring(0, b.length() - 2);
    }

    public static class Map<K, E extends Enum<E>, C extends EnumCounters<E>> {
        private final Factory<E, C> factory;
        private final java.util.Map<K, C> counts = new HashMap<K, C>();

        public Map(Factory<E, C> factory) {
            this.factory = factory;
        }

        public final C getCounts(K key) {
            EnumCounters<Object> c = (EnumCounters)this.counts.get(key);
            if (c == null) {
                c = this.factory.newInstance();
                this.counts.put(key, c);
            }
            return (C)c;
        }

        public final C sum() {
            C sum2 = this.factory.newInstance();
            for (EnumCounters c : this.counts.values()) {
                ((EnumCounters)sum2).add(c);
            }
            return sum2;
        }

        public final long sum(E e) {
            long sum2 = 0L;
            for (EnumCounters c : this.counts.values()) {
                sum2 += c.get(e);
            }
            return sum2;
        }

        public String toString() {
            return this.counts.toString();
        }
    }

    public static interface Factory<E extends Enum<E>, C extends EnumCounters<E>> {
        public C newInstance();
    }
}

