/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class DataInputBuffer
extends DataInputStream {
    private Buffer buffer;

    public DataInputBuffer() {
        this(new Buffer());
    }

    private DataInputBuffer(Buffer buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public void reset(byte[] input2, int length) {
        this.buffer.reset(input2, 0, length);
    }

    public void reset(byte[] input2, int start, int length) {
        this.buffer.reset(input2, start, length);
    }

    public byte[] getData() {
        return this.buffer.getData();
    }

    public int getPosition() {
        return this.buffer.getPosition();
    }

    public int getLength() {
        return this.buffer.getLength();
    }

    private static class Buffer
    extends ByteArrayInputStream {
        public Buffer() {
            super(new byte[0]);
        }

        public void reset(byte[] input2, int start, int length) {
            this.buf = input2;
            this.count = start + length;
            this.mark = start;
            this.pos = start;
        }

        public byte[] getData() {
            return this.buf;
        }

        public int getPosition() {
            return this.pos;
        }

        public int getLength() {
            return this.count;
        }
    }
}

