/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.lang.reflect.Method;
import java.net.UnknownHostException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.io.retry.RetryPolicy;

@InterfaceAudience.Private
public class LossyRetryInvocationHandler<T>
extends RetryInvocationHandler<T> {
    private final int numToDrop;
    private static final ThreadLocal<Integer> RetryCount = new ThreadLocal();

    public LossyRetryInvocationHandler(int numToDrop, FailoverProxyProvider<T> proxyProvider, RetryPolicy retryPolicy) {
        super(proxyProvider, retryPolicy);
        this.numToDrop = numToDrop;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RetryCount.set(0);
        return super.invoke(proxy, method, args);
    }

    @Override
    protected Object invokeMethod(Method method, Object[] args) throws Throwable {
        Object result2 = super.invokeMethod(method, args);
        int retryCount = RetryCount.get();
        if (retryCount < this.numToDrop) {
            RetryCount.set(++retryCount);
            LOG.info((Object)("Drop the response. Current retryCount == " + retryCount));
            throw new UnknownHostException("Fake Exception");
        }
        LOG.info((Object)("retryCount == " + retryCount + ". It's time to normally process the response"));
        return result2;
    }
}

