/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.PriorityQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.join.ComposableRecordReader;
import org.apache.hadoop.mapred.join.MultiFilterRecordReader;
import org.apache.hadoop.mapred.join.TupleWritable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class OverrideRecordReader<K extends WritableComparable, V extends Writable>
extends MultiFilterRecordReader<K, V> {
    OverrideRecordReader(int id, JobConf conf, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        super(id, conf, capacity, cmpcl);
    }

    @Override
    protected V emit(TupleWritable dst) {
        return (V)dst.iterator().next();
    }

    @Override
    protected void fillJoinCollector(K iterkey) throws IOException {
        PriorityQueue q = this.getRecordReaderQueue();
        if (!q.isEmpty()) {
            ComposableRecordReader t;
            int highpos = -1;
            ArrayList<ComposableRecordReader> list2 = new ArrayList<ComposableRecordReader>(this.kids.length);
            q.peek().key(iterkey);
            WritableComparator cmp = this.getComparator();
            while (0 == cmp.compare((WritableComparable)q.peek().key(), (WritableComparable)iterkey)) {
                t = q.poll();
                if (-1 == highpos || ((ComposableRecordReader)list2.get(highpos)).id() < t.id()) {
                    highpos = list2.size();
                }
                list2.add(t);
                if (!q.isEmpty()) continue;
                break;
            }
            t = (ComposableRecordReader)list2.remove(highpos);
            t.accept(this.jc, iterkey);
            for (ComposableRecordReader rr : list2) {
                rr.skip(iterkey);
            }
            list2.add(t);
            for (ComposableRecordReader rr : list2) {
                if (!rr.hasNext()) continue;
                q.add(rr);
            }
        }
    }
}

